/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.editor.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opencastproject.editor.api.SegmentData;
import org.opencastproject.editor.api.SeriesData;
import org.opencastproject.editor.api.TrackData;
import org.opencastproject.editor.api.WorkflowData;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;

public class EditingData {
    public static final String WORKFLOW_ACTIVE = "workflow_active";
    private final List<SegmentData> segments;
    private final List<WorkflowData> workflows;
    private final List<TrackData> tracks;
    private final String title;
    private final String date;
    private final Long duration;
    private final SeriesData series;
    @SerializedName(value="workflow_active")
    private final Boolean workflowActive;
    private final List<String> waveformURIs;
    private final List<Subtitle> subtitles;
    private final Boolean local;

    public EditingData(List<SegmentData> segments, List<TrackData> tracks, List<WorkflowData> workflows, Long duration, String title, String recordingStartDate, String seriesId, String seriesName, Boolean workflowActive, List<String> waveformURIs, List<Subtitle> subtitles, Boolean local) {
        this.segments = segments;
        this.tracks = tracks;
        this.workflows = workflows;
        this.duration = duration;
        this.title = title;
        this.date = recordingStartDate;
        this.series = new SeriesData(seriesId, seriesName);
        this.workflowActive = workflowActive;
        this.waveformURIs = waveformURIs;
        this.subtitles = subtitles;
        this.local = local;
    }

    public static EditingData parse(String json) {
        Objects.requireNonNull(json);
        Gson gson = new Gson();
        EditingData editingData = (EditingData)gson.fromJson(json, EditingData.class);
        Objects.requireNonNull(editingData.getTracks());
        Objects.requireNonNull(editingData.getSegments());
        return editingData;
    }

    public List<SegmentData> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public String getPostProcessingWorkflow() {
        return this.workflows != null && this.workflows.size() > 0 ? this.workflows.get(0).getId() : null;
    }

    public List<TrackData> getTracks() {
        return Collections.unmodifiableList(this.tracks);
    }

    public List<Subtitle> getSubtitles() {
        return this.subtitles;
    }

    public String toString() {
        Gson gson = new GsonBuilder().serializeNulls().create();
        return gson.toJson((Object)this);
    }

    public static final class Subtitle {
        private final MediaPackageElementFlavor flavor;
        private final String subtitle;

        public Subtitle(MediaPackageElementFlavor flavor, String subtitle) {
            this.flavor = flavor;
            this.subtitle = subtitle;
        }

        public MediaPackageElementFlavor getFlavor() {
            return this.flavor;
        }

        public String getSubtitle() {
            return this.subtitle;
        }
    }
}

