/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.editor.remote;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.opencastproject.editor.api.EditingData;
import org.opencastproject.editor.api.EditorService;
import org.opencastproject.editor.api.EditorServiceException;
import org.opencastproject.editor.api.ErrorStatus;
import org.opencastproject.editor.api.LockData;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Editor Service Remote Proxy"}, immediate=true, service={EditorService.class})
public class EditorServiceRemoteImpl
extends RemoteBase
implements EditorService {
    private static final Logger logger = LoggerFactory.getLogger(EditorServiceRemoteImpl.class);
    public static final String EDIT_SUFFIX = "/edit.json";
    public static final String LOCK_SUFFIX = "/lock";
    public static final String METADATA_SUFFIX = "/metadata.json";

    public EditorServiceRemoteImpl() {
        super("org.opencastproject.editor");
    }

    @Override
    public EditingData getEditData(String mediaPackageId) throws EditorServiceException {
        return EditingData.parse(this.doGetForMediaPackage(mediaPackageId, EDIT_SUFFIX));
    }

    @Override
    public void setEditData(String mediaPackageId, EditingData editingData) throws EditorServiceException {
        this.doPostForMediaPackage(mediaPackageId, EDIT_SUFFIX, editingData.toString());
    }

    @Override
    public String getMetadata(String mediaPackageId) throws EditorServiceException {
        return this.doGetForMediaPackage(mediaPackageId, METADATA_SUFFIX);
    }

    @Override
    public void setMetadata(String mediaPackageId, String metadata) throws EditorServiceException {
        this.doPostForMediaPackage(mediaPackageId, METADATA_SUFFIX, metadata);
    }

    @Override
    public void lockMediaPackage(String mediaPackageId, LockData lockData) throws EditorServiceException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", lockData.getUUID());
        params.put("user", lockData.getUser());
        this.doPostFormForMediaPackage(mediaPackageId, LOCK_SUFFIX, params);
    }

    @Override
    public void unlockMediaPackage(String mediaPackageId, LockData lockData) throws EditorServiceException {
        this.doDeleteForMediaPackage(mediaPackageId, "/lock/" + lockData.getUUID());
    }

    protected String doDeleteForMediaPackage(String mediaPackageId, String urlSuffix) throws EditorServiceException {
        String string;
        logger.debug("Editor Remote Lock POST Request for mediaPackage : '{}'", (Object)mediaPackageId);
        HttpDelete delete = new HttpDelete(mediaPackageId + urlSuffix);
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)delete, new Integer[]{200, 404, 409});
            if (response == null || response.getStatusLine() == null) {
                throw new EditorServiceException("Editor Remote call failed to respond", ErrorStatus.UNKNOWN);
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                this.evaluateResponseCode(response);
            }
            string = null;
        }
        catch (Exception e) {
            try {
                throw new EditorServiceException("Editor Remote call failed", ErrorStatus.UNKNOWN, e);
            }
            catch (Throwable throwable) {
                this.closeConnection(response);
                throw throwable;
            }
        }
        this.closeConnection(response);
        return string;
    }

    protected String doGetForMediaPackage(String mediaPackageId, String urlSuffix) throws EditorServiceException {
        HttpResponse response;
        block8: {
            block7: {
                logger.debug("Editor Remote GET Request for mediaPackage: '{}' to url: '{}'", (Object)mediaPackageId, (Object)urlSuffix);
                HttpGet get = new HttpGet(mediaPackageId + urlSuffix);
                response = null;
                response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 404, 409, 400});
                if (response == null || response.getStatusLine() == null) {
                    throw new EditorServiceException("HTTP Request failed", ErrorStatus.UNKNOWN);
                }
                if (response.getStatusLine().getStatusCode() == 200) break block7;
                this.evaluateResponseCode(response);
                String string = null;
                this.closeConnection(response);
                return string;
            }
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity == null) break block8;
            String string = EntityUtils.toString((HttpEntity)httpEntity);
            this.closeConnection(response);
            return string;
        }
        try {
            try {
                throw new EditorServiceException("Editor Remote call failed", ErrorStatus.UNKNOWN);
            }
            catch (IOException e) {
                throw new EditorServiceException("Editor Remote call failed", ErrorStatus.UNKNOWN, e);
            }
        }
        catch (Throwable throwable) {
            this.closeConnection(response);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPostForMediaPackage(String mediaPackageId, String urlSuffix, String data) throws EditorServiceException {
        logger.debug("Editor Remote POST Request for mediaPackage : '{}' to url: '{}'", (Object)mediaPackageId, (Object)urlSuffix);
        HttpPost post = new HttpPost(mediaPackageId + urlSuffix);
        HttpResponse response = null;
        try {
            StringEntity editJson = new StringEntity(data, StandardCharsets.UTF_8);
            post.setEntity((HttpEntity)editJson);
            post.setHeader("Content-type", "application/json");
            response = this.getResponse((HttpRequestBase)post, new Integer[]{200, 404, 400, 409});
            if (response == null || response.getStatusLine() == null) {
                throw new EditorServiceException("No response for setEditData", ErrorStatus.UNKNOWN);
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                this.evaluateResponseCode(response);
            }
        }
        catch (Throwable throwable) {
            this.closeConnection(response);
            throw throwable;
        }
        this.closeConnection(response);
    }

    protected void doPostFormForMediaPackage(String mediaPackageId, String urlSuffix, Map<String, String> params) throws EditorServiceException {
        logger.debug("Editor Remote POST Request for mediaPackage : '{}' to url: '{}'", (Object)mediaPackageId, (Object)urlSuffix);
        HttpPost post = new HttpPost(mediaPackageId + urlSuffix);
        HttpResponse response = null;
        try {
            ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
            for (String field : params.keySet()) {
                formParams.add(new BasicNameValuePair(field, params.get(field)));
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams, "UTF-8"));
            response = this.getResponse((HttpRequestBase)post, new Integer[]{200, 404, 400, 409});
            if (response == null || response.getStatusLine() == null) {
                throw new EditorServiceException("No response for setEditData", ErrorStatus.UNKNOWN);
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                this.evaluateResponseCode(response);
            }
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new EditorServiceException(e.getMessage(), ErrorStatus.UNKNOWN);
            }
            catch (Throwable throwable) {
                this.closeConnection(response);
                throw throwable;
            }
        }
        this.closeConnection(response);
    }

    protected void evaluateResponseCode(HttpResponse response) throws EditorServiceException {
        switch (response.getStatusLine().getStatusCode()) {
            case 404: {
                throw new EditorServiceException("MediaPackage not found", ErrorStatus.MEDIAPACKAGE_NOT_FOUND);
            }
            case 409: {
                throw new EditorServiceException(response.getEntity().toString(), ErrorStatus.MEDIAPACKAGE_LOCKED);
            }
            case 400: {
                throw new EditorServiceException("Request invalid", ErrorStatus.UNKNOWN);
            }
        }
        throw new EditorServiceException("Editor Remote call failed", ErrorStatus.UNKNOWN);
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient client) {
        this.client = client;
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry remoteServiceManager) {
        this.remoteServiceManager = remoteServiceManager;
    }
}

