/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.fileupload.service;

import java.io.IOException;
import java.util.Date;
import org.opencastproject.fileupload.api.FileUploadService;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadServiceCleaner {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadServiceCleaner.class);
    private static final String JOB_NAME = "mh-file-upload-cleaner-job";
    private static final String JOB_GROUP = "mh-file-upload-cleaner-job-group";
    private static final String TRIGGER_NAME = "mh-file-upload-cleaner-trigger";
    private static final String TRIGGER_GROUP = "mh-file-upload-cleaner-trigger-group";
    private static final String JOB_PARAM_PARENT = "parent";
    private final Scheduler quartz;
    private FileUploadService fileUploadService;

    protected FileUploadServiceCleaner(FileUploadService fileUploadService) {
        this.fileUploadService = fileUploadService;
        try {
            this.quartz = new StdSchedulerFactory().getScheduler();
            this.quartz.start();
            JobDetail job = new JobDetail(JOB_NAME, JOB_GROUP, Runner.class);
            job.setDurability(false);
            job.setVolatility(true);
            job.getJobDataMap().put((Object)JOB_PARAM_PARENT, (Object)this);
            this.quartz.addJob(job, true);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public FileUploadService getFileUploadService() {
        return this.fileUploadService;
    }

    public void schedule() {
        logger.debug("File upload job cleaner is run every hour.");
        try {
            Trigger trigger = TriggerUtils.makeHourlyTrigger();
            trigger.setStartTime(new Date());
            trigger.setName(TRIGGER_NAME);
            trigger.setGroup(TRIGGER_GROUP);
            trigger.setJobName(JOB_NAME);
            trigger.setJobGroup(JOB_GROUP);
            if (this.quartz.getTriggersOfJob(JOB_NAME, JOB_GROUP).length == 0) {
                this.quartz.scheduleJob(trigger);
            } else {
                this.quartz.rescheduleJob(TRIGGER_NAME, TRIGGER_GROUP, trigger);
            }
        }
        catch (Exception e) {
            logger.error("Error scheduling Quartz job", (Throwable)e);
        }
    }

    public void shutdown() {
        try {
            this.quartz.shutdown();
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutdown();
    }

    public static class Runner
    implements Job {
        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
            logger.info("Start file upload service cleaner");
            try {
                this.execute((FileUploadServiceCleaner)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)FileUploadServiceCleaner.JOB_PARAM_PARENT));
            }
            catch (Exception e) {
                throw new JobExecutionException("An error occurred while cleaning file upload jobs", (Throwable)e);
            }
            logger.info("Finished file upload service cleaner");
        }

        private void execute(FileUploadServiceCleaner fileUploadServiceCleaner) {
            try {
                fileUploadServiceCleaner.getFileUploadService().cleanOutdatedJobs();
            }
            catch (IOException e) {
                logger.warn("Unable to clean outdated jobs: {}", (Object)e.getMessage());
            }
        }
    }
}

