/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.message.broker.api.assetmanager;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Prelude;
import com.entwinemedia.fn.data.Opt;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.message.broker.api.MessageItem;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.opencastproject.util.RequireUtil;
import org.opencastproject.workspace.api.Workspace;

@ParametersAreNonnullByDefault
public abstract class AssetManagerItem
implements MessageItem,
Serializable {
    private static final long serialVersionUID = 5440420510139202434L;
    public static final String ASSETMANAGER_QUEUE_PREFIX = "ASSETMANAGER.";
    public static final String ASSETMANAGER_QUEUE = "ASSETMANAGER.QUEUE";
    private final String mediaPackageId;
    private final long date;

    private AssetManagerItem(String mediaPackageId, Date date) {
        this.mediaPackageId = (String)RequireUtil.notNull((Object)mediaPackageId, (String)"mediaPackageId");
        this.date = ((Date)RequireUtil.notNull((Object)date, (String)"date")).getTime();
    }

    public abstract Type getType();

    public abstract <A> A decompose(Fn<? super TakeSnapshot, ? extends A> var1, Fn<? super DeleteSnapshot, ? extends A> var2, Fn<? super DeleteEpisode, ? extends A> var3);

    public final Date getDate() {
        return new Date(this.date);
    }

    @Override
    public final String getId() {
        return this.mediaPackageId;
    }

    public static TakeSnapshot add(Workspace workspace, MediaPackage mp, AccessControlList acl, long version, Date date) {
        String dcXml = null;
        for (Catalog catalog : mp.getCatalogs(MediaPackageElements.EPISODE)) {
            try (InputStream in = workspace.read(catalog.getURI());){
                dcXml = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Unable to load dublin core catalog for event '%s'", mp.getIdentifier()), e);
            }
        }
        return new TakeSnapshot(mp.getIdentifier().compact(), MediaPackageParser.getAsXml((MediaPackage)mp), dcXml, AccessControlParser.toJsonSilent((AccessControlList)acl), version, date);
    }

    public static AssetManagerItem deleteSnapshot(String mediaPackageId, long version, Date date) {
        return new DeleteSnapshot(mediaPackageId, version, date);
    }

    public static AssetManagerItem deleteEpisode(String mediaPackageId, Date date) {
        return new DeleteEpisode(mediaPackageId, date);
    }

    public static final class DeleteEpisode
    extends AssetManagerItem {
        private static final long serialVersionUID = -4906056424740181256L;
        public static final Fn<DeleteEpisode, String> getMediaPackageId = new Fn<DeleteEpisode, String>(){

            public String apply(DeleteEpisode a) {
                return a.getMediaPackageId();
            }
        };

        private DeleteEpisode(String mediaPackageId, Date date) {
            super(mediaPackageId, date);
        }

        @Override
        public <A> A decompose(Fn<? super TakeSnapshot, ? extends A> takeSnapshot, Fn<? super DeleteSnapshot, ? extends A> deleteSnapshot, Fn<? super DeleteEpisode, ? extends A> deleteEpisode) {
            return (A)deleteEpisode.apply((Object)this);
        }

        @Override
        public Type getType() {
            return Type.Delete;
        }

        public String getMediaPackageId() {
            return this.getId();
        }
    }

    public static final class DeleteSnapshot
    extends AssetManagerItem {
        private static final long serialVersionUID = 4797196156230502250L;
        private final long version;
        public static final Fn<DeleteSnapshot, String> getMediaPackageId = new Fn<DeleteSnapshot, String>(){

            public String apply(DeleteSnapshot a) {
                return a.getMediaPackageId();
            }
        };
        public static final Fn<DeleteSnapshot, Long> getVersion = new Fn<DeleteSnapshot, Long>(){

            public Long apply(DeleteSnapshot a) {
                return a.getVersion();
            }
        };

        private DeleteSnapshot(String mediaPackageId, long version, Date date) {
            super(mediaPackageId, date);
            this.version = version;
        }

        @Override
        public <A> A decompose(Fn<? super TakeSnapshot, ? extends A> takeSnapshot, Fn<? super DeleteSnapshot, ? extends A> deleteSnapshot, Fn<? super DeleteEpisode, ? extends A> deleteEpisode) {
            return (A)deleteSnapshot.apply((Object)this);
        }

        @Override
        public Type getType() {
            return Type.Delete;
        }

        public String getMediaPackageId() {
            return this.getId();
        }

        public long getVersion() {
            return this.version;
        }
    }

    public static final class TakeSnapshot
    extends AssetManagerItem {
        private static final long serialVersionUID = 3530625835200867594L;
        private final String mediapackage;
        private final String acl;
        private final long version;
        private final String episodeDublincore;
        public static final Fn<TakeSnapshot, MediaPackage> getMediaPackage = new Fn<TakeSnapshot, MediaPackage>(){

            public MediaPackage apply(TakeSnapshot a) {
                return a.getMediapackage();
            }
        };
        public static final Fn<TakeSnapshot, Opt<DublinCoreCatalog>> getEpisodeDublincore = new Fn<TakeSnapshot, Opt<DublinCoreCatalog>>(){

            public Opt<DublinCoreCatalog> apply(TakeSnapshot a) {
                return a.getEpisodeDublincore();
            }
        };
        public static final Fn<TakeSnapshot, AccessControlList> getAcl = new Fn<TakeSnapshot, AccessControlList>(){

            public AccessControlList apply(TakeSnapshot a) {
                return a.getAcl();
            }
        };
        public static final Fn<TakeSnapshot, Long> getVersion = new Fn<TakeSnapshot, Long>(){

            public Long apply(TakeSnapshot a) {
                return a.getVersion();
            }
        };

        private TakeSnapshot(String mediaPackageId, String mediapackage, String episodeDublincore, String acl, long version, Date date) {
            super(mediaPackageId, date);
            this.mediapackage = mediapackage;
            this.episodeDublincore = episodeDublincore;
            this.acl = acl;
            this.version = version;
        }

        @Override
        public <A> A decompose(Fn<? super TakeSnapshot, ? extends A> takeSnapshot, Fn<? super DeleteSnapshot, ? extends A> deleteSnapshot, Fn<? super DeleteEpisode, ? extends A> deleteEpisode) {
            return (A)takeSnapshot.apply((Object)this);
        }

        @Override
        public Type getType() {
            return Type.Update;
        }

        public MediaPackage getMediapackage() {
            try {
                return MediaPackageParser.getFromXml((String)this.mediapackage);
            }
            catch (MediaPackageException e) {
                return (MediaPackage)Prelude.chuck((Throwable)e);
            }
        }

        public AccessControlList getAcl() {
            return AccessControlParser.parseAclSilent((String)this.acl);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Opt<DublinCoreCatalog> getEpisodeDublincore() {
            if (this.episodeDublincore == null) {
                return Opt.none();
            }
            try (InputStream is = IOUtils.toInputStream((String)this.episodeDublincore, (String)"UTF-8");){
                Opt opt = Opt.some((Object)DublinCores.read((InputStream)is));
                return opt;
            }
            catch (IOException e) {
                return (Opt)Prelude.chuck((Throwable)e);
            }
        }

        public long getVersion() {
            return this.version;
        }
    }

    public static enum Type {
        Update,
        Delete;

    }
}

