/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.message.broker.api.group;

import java.io.IOException;
import java.io.Serializable;
import org.opencastproject.message.broker.api.MessageItem;
import org.opencastproject.security.api.Group;
import org.opencastproject.security.api.GroupParser;
import org.opencastproject.security.api.JaxbGroup;

public class GroupItem
implements MessageItem,
Serializable {
    private static final long serialVersionUID = 6332696075634123068L;
    public static final String GROUP_QUEUE_PREFIX = "GROUP.";
    public static final String GROUP_QUEUE = "GROUP.QUEUE";
    private final String groupId;
    private final String group;
    private final Type type;

    public static GroupItem update(JaxbGroup group) {
        return new GroupItem(group, Type.Update);
    }

    public static GroupItem delete(String groupId) {
        return new GroupItem(groupId, Type.Delete);
    }

    public GroupItem(JaxbGroup group, Type type) {
        this.groupId = group.getGroupId();
        try {
            this.group = GroupParser.I.toXml(group);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.type = Type.Update;
    }

    public GroupItem(String groupId, Type type) {
        this.groupId = groupId;
        this.group = null;
        this.type = type;
    }

    @Override
    public String getId() {
        return this.groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Group getGroup() {
        try {
            return this.group == null ? null : GroupParser.I.parseGroupFromXml(this.group);
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        Update,
        Delete;

    }
}

