/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.message.broker.api.index;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.P1;
import com.entwinemedia.fn.Products;
import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.fns.Booleans;
import java.io.Serializable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.apache.commons.lang3.text.WordUtils;
import org.opencastproject.index.IndexProducer;
import org.opencastproject.message.broker.api.BaseMessage;
import org.opencastproject.message.broker.api.MessageReceiver;
import org.opencastproject.message.broker.api.MessageSender;
import org.opencastproject.message.broker.api.index.IndexRecreateObject;
import org.opencastproject.security.api.DefaultOrganization;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.util.RequireUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexProducer
implements IndexProducer {
    public static final P1<Serializable> IDENTITY_MSG = Products.E.p1((Object)new Serializable(){});
    private MessageWatcher messageWatcher;
    private final ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();

    public abstract String getClassName();

    public abstract MessageReceiver getMessageReceiver();

    public abstract MessageSender getMessageSender();

    public abstract SecurityService getSecurityService();

    public abstract IndexRecreateObject.Service getService();

    public abstract String getSystemUserName();

    public void activate() {
        this.messageWatcher = new MessageWatcher();
        this.singleThreadExecutor.execute(this.messageWatcher);
    }

    public void deactivate() {
        if (this.messageWatcher != null) {
            this.messageWatcher.stopListening();
        }
        this.singleThreadExecutor.shutdown();
    }

    public IndexRecreationBatch mkRecreationBatch(String indexName, String queuePrefix, int updatesTotal, Opt<Organization> endMessageOrg) {
        return new IndexRecreationBatch(indexName, queuePrefix, updatesTotal, endMessageOrg);
    }

    public IndexRecreationBatch mkRecreationBatch(String indexName, String queuePrefix, int updatesTotal) {
        return new IndexRecreationBatch(indexName, queuePrefix, updatesTotal, Opt.some((Object)new DefaultOrganization()));
    }

    private class MessageWatcher
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(MessageWatcher.class);
        private volatile boolean listening = true;
        private volatile FutureTask<Serializable> future;
        private final ExecutorService executor = Executors.newSingleThreadExecutor();

        private MessageWatcher() {
        }

        public void stopListening() {
            this.listening = false;
            if (this.future != null) {
                this.future.cancel(true);
            }
            this.executor.shutdown();
        }

        @Override
        public void run() {
            if (AbstractIndexProducer.this.getMessageReceiver() == null) {
                this.logger.warn("The message receiver for " + AbstractIndexProducer.this.getClassName() + " was null so unable to listen for repopulate index messages. Ignore this warning if this is a test.");
                this.listening = false;
                return;
            }
            this.logger.info("Starting to listen for {} Messages", (Object)AbstractIndexProducer.this.getClassName());
            while (this.listening) {
                try {
                    IndexRecreateObject indexObject;
                    this.future = AbstractIndexProducer.this.getMessageReceiver().receiveSerializable("INDEX_RECEIVER.QUEUE." + (Object)((Object)AbstractIndexProducer.this.getService()), MessageSender.DestinationType.Queue);
                    this.executor.execute(this.future);
                    BaseMessage message = (BaseMessage)this.future.get();
                    if (message == null || !(message.getObject() instanceof IndexRecreateObject) || !(indexObject = (IndexRecreateObject)message.getObject()).getService().equals((Object)AbstractIndexProducer.this.getService()) || !indexObject.getStatus().equals((Object)IndexRecreateObject.Status.Start)) continue;
                    this.logger.info("Index '{}' has received a start repopulating command for service '{}'.", (Object)indexObject.getIndexName(), (Object)AbstractIndexProducer.this.getService());
                    AbstractIndexProducer.this.repopulate(indexObject.getIndexName());
                    this.logger.info("Index '{}' has finished repopulating service '{}'.", (Object)indexObject.getIndexName(), (Object)AbstractIndexProducer.this.getService());
                }
                catch (InterruptedException e) {
                    this.logger.error("Problem while getting {} message events", (Object)AbstractIndexProducer.this.getClassName(), (Object)e);
                }
                catch (ExecutionException e) {
                    this.logger.error("Problem while getting {} message events", (Object)AbstractIndexProducer.this.getClassName(), (Object)e);
                }
                catch (CancellationException e) {
                    this.logger.trace("Listening for messages {} has been cancelled.", (Object)AbstractIndexProducer.this.getClassName());
                }
                catch (Throwable t) {
                    this.logger.error("Problem while getting {} message events", (Object)AbstractIndexProducer.this.getClassName(), (Object)t);
                }
            }
            this.logger.info("Stopping listening for {} Messages", (Object)AbstractIndexProducer.this.getClassName());
        }
    }

    public final class IndexRecreationBatch {
        private final Logger logger = LoggerFactory.getLogger(IndexRecreationBatch.class);
        private final String indexName;
        private final String destinationId;
        private final int updatesTotal;
        private final int responseInterval;
        private final Opt<Organization> endMessageOrg;
        private int updatesCurrent;

        private IndexRecreationBatch(String indexName, String queuePrefix, int updatesTotal, Opt<Organization> endMessageOrg) {
            this.indexName = indexName;
            this.destinationId = queuePrefix + WordUtils.capitalize((String)indexName);
            this.updatesTotal = RequireUtil.min((int)updatesTotal, (int)0);
            this.endMessageOrg = endMessageOrg;
            this.updatesCurrent = 0;
            this.responseInterval = updatesTotal < 100 ? 1 : updatesTotal / 100;
        }

        public int getUpdatesTotal() {
            return this.updatesTotal;
        }

        public void update(Organization org, Iterable<P1<? extends Serializable>> messages) {
            if (this.updatesCurrent >= this.updatesTotal) {
                throw new IllegalStateException(String.format("The number of allowed update messages (%d) has already been sent", this.updatesTotal));
            }
            User user = SecurityUtil.createSystemUser((String)AbstractIndexProducer.this.getSystemUserName(), (Organization)org);
            SecurityUtil.runAs((SecurityService)AbstractIndexProducer.this.getSecurityService(), (Organization)org, (User)user, () -> {
                for (P1 m : Stream.$((Iterable)messages).filter((Fn)Booleans.ne(IDENTITY_MSG))) {
                    AbstractIndexProducer.this.getMessageSender().sendObjectMessage(this.destinationId, MessageSender.DestinationType.Queue, (Serializable)m.get1());
                }
                ++this.updatesCurrent;
                if (this.updatesCurrent % this.responseInterval == 0 || this.updatesCurrent == this.updatesTotal) {
                    AbstractIndexProducer.this.getMessageSender().sendObjectMessage("INDEX_RESPONSE.QUEUE", MessageSender.DestinationType.Queue, IndexRecreateObject.update(this.indexName, AbstractIndexProducer.this.getService(), this.updatesTotal, this.updatesCurrent));
                }
                if (this.updatesCurrent >= this.updatesTotal) {
                    Organization emo = (Organization)this.endMessageOrg.getOr((Object)org);
                    User emu = SecurityUtil.createSystemUser((String)AbstractIndexProducer.this.getSystemUserName(), (Organization)emo);
                    SecurityUtil.runAs((SecurityService)AbstractIndexProducer.this.getSecurityService(), (Organization)emo, (User)emu, () -> AbstractIndexProducer.this.getMessageSender().sendObjectMessage(this.destinationId, MessageSender.DestinationType.Queue, IndexRecreateObject.end(this.indexName, AbstractIndexProducer.this.getService())));
                }
            });
        }

        public void update(Organization org, P1<? extends Serializable> ... messages) {
            this.update(org, (Iterable<P1<? extends Serializable>>)Stream.$((Object[])messages));
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.updatesCurrent < this.updatesTotal) {
                this.logger.warn(String.format("Only %d messages have been sent even though the batch has been initialized with %d", this.updatesCurrent, this.updatesTotal));
            }
        }
    }
}

