/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.message.broker.api.index;

import java.io.Serializable;

public final class IndexRecreateObject
implements Serializable {
    private static final long serialVersionUID = 6076737478411640536L;
    private String indexName;
    private String message;
    private int total;
    private int current;
    private Status status;
    private Service service;

    private IndexRecreateObject(String indexName, Service service, Status status) {
        this.indexName = indexName;
        this.service = service;
        this.status = status;
    }

    private IndexRecreateObject(String indexName, Service service, int total, int current) {
        this.indexName = indexName;
        this.service = service;
        this.status = Status.Update;
        this.total = total;
        this.current = current;
    }

    private IndexRecreateObject(String indexName, Service service, int total, int current, String message) {
        this.indexName = indexName;
        this.service = service;
        this.status = Status.Error;
        this.total = total;
        this.current = current;
        this.message = message;
    }

    public static IndexRecreateObject start(String indexName, Service service) {
        return new IndexRecreateObject(indexName, service, Status.Start);
    }

    public static IndexRecreateObject update(String indexName, Service service, int total, int current) {
        return new IndexRecreateObject(indexName, service, total, current);
    }

    public static IndexRecreateObject end(String indexName, Service service) {
        return new IndexRecreateObject(indexName, service, Status.End);
    }

    public static IndexRecreateObject error(String indexName, Service service, int total, int current, String message) {
        return new IndexRecreateObject(indexName, service, total, current);
    }

    public String getMessage() {
        return this.message;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public int getTotal() {
        return this.total;
    }

    public int getCurrent() {
        return this.current;
    }

    public Status getStatus() {
        return this.status;
    }

    public Service getService() {
        return this.service;
    }

    public static enum Service {
        Acl,
        AssetManager,
        Comments,
        Groups,
        Scheduler,
        Series,
        Themes,
        Workflow;

    }

    public static enum Status {
        Start,
        Update,
        End,
        Error;

    }
}

