/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.message.broker.api.scheduler;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreXmlFormat;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;

public class SchedulerItem
implements Serializable {
    private static final long serialVersionUID = 6061069989788904237L;
    private static final Gson gson = new Gson();
    public static final String SCHEDULER_QUEUE_PREFIX = "SCHEDULER.";
    public static final String SCHEDULER_QUEUE = "SCHEDULER.QUEUE";
    private final String event;
    private final String properties;
    private final String acl;
    private final String agentId;
    private final long end;
    private final String presenters;
    private final String recordingState;
    private final long start;
    private final Type type;

    public static SchedulerItem updateCatalog(DublinCoreCatalog event) {
        return new SchedulerItem(event);
    }

    public static SchedulerItem updateProperties(Map<String, String> properties) {
        return new SchedulerItem(properties);
    }

    public static SchedulerItem delete() {
        return new SchedulerItem(Type.Delete);
    }

    public static SchedulerItem updateAcl(AccessControlList accessControlList) {
        return new SchedulerItem(accessControlList);
    }

    public static SchedulerItem updateRecordingStatus(String state, Long lastHeardFrom) {
        return new SchedulerItem(state, lastHeardFrom);
    }

    public static SchedulerItem updateStart(Date start) {
        return new SchedulerItem(start, null, Type.UpdateStart);
    }

    public static SchedulerItem updateEnd(Date end) {
        return new SchedulerItem(null, end, Type.UpdateEnd);
    }

    public static SchedulerItem updatePresenters(Set<String> presenters) {
        return new SchedulerItem(presenters);
    }

    public static SchedulerItem updateAgent(String agentId) {
        return new SchedulerItem(agentId);
    }

    public static SchedulerItem deleteRecordingState() {
        return new SchedulerItem(Type.DeleteRecordingStatus);
    }

    public SchedulerItem(DublinCoreCatalog event) {
        try {
            this.event = event.toXmlString();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
        this.properties = null;
        this.acl = null;
        this.agentId = null;
        this.end = -1L;
        this.presenters = null;
        this.recordingState = null;
        this.start = -1L;
        this.type = Type.UpdateCatalog;
    }

    public SchedulerItem(Map<String, String> properties) {
        this.event = null;
        this.properties = this.serializeProperties(properties);
        this.acl = null;
        this.agentId = null;
        this.end = -1L;
        this.presenters = null;
        this.recordingState = null;
        this.start = -1L;
        this.type = Type.UpdateProperties;
    }

    public SchedulerItem(Type type) {
        this.event = null;
        this.properties = null;
        this.acl = null;
        this.agentId = null;
        this.end = -1L;
        this.presenters = null;
        this.recordingState = null;
        this.start = -1L;
        this.type = type;
    }

    public SchedulerItem(AccessControlList accessControlList) {
        this.event = null;
        this.properties = null;
        try {
            this.acl = AccessControlParser.toJson((AccessControlList)accessControlList);
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
        this.agentId = null;
        this.end = -1L;
        this.presenters = null;
        this.recordingState = null;
        this.start = -1L;
        this.type = Type.UpdateAcl;
    }

    public SchedulerItem(String state, Long lastHeardFrom) {
        this.event = null;
        this.properties = null;
        this.acl = null;
        this.agentId = null;
        this.end = -1L;
        this.presenters = null;
        this.recordingState = state;
        this.start = -1L;
        this.type = Type.UpdateRecordingStatus;
    }

    public SchedulerItem(Date start, Date end, Type type) {
        this.event = null;
        this.acl = null;
        this.agentId = null;
        this.end = end == null ? -1L : end.getTime();
        this.presenters = null;
        this.properties = null;
        this.recordingState = null;
        this.start = start == null ? -1L : start.getTime();
        this.type = type;
    }

    public SchedulerItem(String agentId) {
        this.event = null;
        this.acl = null;
        this.agentId = agentId;
        this.end = -1L;
        this.presenters = null;
        this.properties = null;
        this.recordingState = null;
        this.start = -1L;
        this.type = Type.UpdateAgentId;
    }

    public SchedulerItem(Set<String> presenters) {
        this.event = null;
        this.acl = null;
        this.agentId = null;
        this.end = -1L;
        this.presenters = gson.toJson(presenters);
        this.properties = null;
        this.recordingState = null;
        this.start = -1L;
        this.type = Type.UpdatePresenters;
    }

    public DublinCoreCatalog getEvent() {
        if (StringUtils.isBlank((CharSequence)this.event)) {
            return null;
        }
        return (DublinCoreCatalog)DublinCoreXmlFormat.readOpt((String)this.event).orNull();
    }

    public Map<String, String> getProperties() {
        try {
            return this.parseProperties(this.properties);
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    public AccessControlList getAcl() {
        try {
            return this.acl == null ? null : AccessControlParser.parseAcl((String)this.acl);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public String getAgentId() {
        return this.agentId;
    }

    public Date getEnd() {
        return this.end < 0L ? null : new Date(this.end);
    }

    public Set<String> getPresenters() {
        return (Set)gson.fromJson(this.presenters, Set.class);
    }

    public String getRecordingState() {
        return this.recordingState;
    }

    public Date getStart() {
        return this.start < 0L ? null : new Date(this.start);
    }

    public Type getType() {
        return this.type;
    }

    private String serializeProperties(Map<String, String> caProperties) {
        StringBuilder wfPropertiesString = new StringBuilder();
        for (Map.Entry<String, String> entry : caProperties.entrySet()) {
            wfPropertiesString.append(entry.getKey() + "=" + entry.getValue() + "\n");
        }
        return wfPropertiesString.toString();
    }

    private Map<String, String> parseProperties(String serializedProperties) throws IOException {
        Properties caProperties = new Properties();
        caProperties.load(new StringReader(serializedProperties));
        return new HashMap<Object, Object>(caProperties);
    }

    public static enum Type {
        UpdateCatalog,
        UpdateProperties,
        UpdateAcl,
        UpdateAgentId,
        UpdateEnd,
        UpdatePresenters,
        UpdateRecordingStatus,
        UpdateStart,
        DeleteRecordingStatus,
        Delete;

    }
}

