/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.message.broker.api.series;

import java.io.IOException;
import java.io.Serializable;
import org.opencastproject.message.broker.api.MessageItem;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreXmlFormat;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;

public final class SeriesItem
implements MessageItem,
Serializable {
    private static final long serialVersionUID = 3275142857854793612L;
    public static final String SERIES_QUEUE_PREFIX = "SERIES.";
    public static final String SERIES_QUEUE = "SERIES.QUEUE";
    private final Type type;
    private final String seriesId;
    private final String series;
    private final String acl;
    private final String propertyName;
    private final String propertyValue;
    private final String element;
    private final String elementType;
    private final String overrideEpisodeAcl;

    public static SeriesItem updateCatalog(DublinCoreCatalog series) {
        return new SeriesItem(Type.UpdateCatalog, null, series, null, null, null, null, null, null);
    }

    public static SeriesItem updateElement(String seriesId, String type, String data) {
        return new SeriesItem(Type.UpdateElement, seriesId, null, null, null, null, type, data, null);
    }

    public static SeriesItem updateAcl(String seriesId, AccessControlList acl, boolean overrideEpisodeAcl) {
        return new SeriesItem(Type.UpdateAcl, seriesId, null, AccessControlParser.toJsonSilent((AccessControlList)acl), null, null, null, null, overrideEpisodeAcl);
    }

    public static SeriesItem updateProperty(String seriesId, String propertyName, String propertyValue) {
        return new SeriesItem(Type.UpdateProperty, seriesId, null, null, propertyName, propertyValue, null, null, null);
    }

    public static SeriesItem delete(String seriesId) {
        return new SeriesItem(Type.Delete, seriesId, null, null, null, null, null, null, null);
    }

    private SeriesItem(Type type, String seriesId, DublinCoreCatalog series, String acl, String propertyName, String propertyValue, String elementType, String element, Boolean overrideEpisodeAcl) {
        if (seriesId != null && series != null && !seriesId.equals(series.getFirst(DublinCore.PROPERTY_IDENTIFIER))) {
            throw new IllegalStateException("Provided series ID and dublincore series ID does not match");
        }
        this.type = type;
        if (series != null) {
            try {
                this.series = series.toXmlString();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.series = null;
        }
        if (seriesId != null) {
            this.seriesId = seriesId;
        } else if (series != null) {
            this.seriesId = series.getFirst(DublinCore.PROPERTY_IDENTIFIER);
        } else {
            throw new IllegalStateException("Neither series nor series ID is provided");
        }
        this.acl = acl;
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.elementType = elementType;
        this.element = element;
        this.overrideEpisodeAcl = overrideEpisodeAcl == null ? null : overrideEpisodeAcl.toString();
    }

    @Override
    public String getId() {
        return this.seriesId;
    }

    public Type getType() {
        return this.type;
    }

    public String getSeriesId() {
        return this.seriesId;
    }

    public DublinCoreCatalog getMetadata() {
        return (DublinCoreCatalog)DublinCoreXmlFormat.readOpt((String)this.series).orNull();
    }

    public DublinCoreCatalog getExtendedMetadata() {
        try {
            return DublinCoreXmlFormat.read((String)this.element);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public AccessControlList getAcl() {
        try {
            return this.acl == null ? null : AccessControlParser.parseAcl((String)this.acl);
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public String getElement() {
        return this.element;
    }

    public String getElementType() {
        return this.elementType;
    }

    public Boolean getOverrideEpisodeAcl() {
        return this.overrideEpisodeAcl == null ? null : Boolean.valueOf(Boolean.parseBoolean(this.overrideEpisodeAcl));
    }

    public static enum Type {
        UpdateCatalog,
        UpdateElement,
        UpdateAcl,
        UpdateProperty,
        Delete;

    }
}

