/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.message.broker.api.theme;

import java.io.Serializable;
import org.opencastproject.message.broker.api.MessageItem;
import org.opencastproject.message.broker.api.theme.SerializableTheme;

public class ThemeItem
implements MessageItem,
Serializable {
    private static final long serialVersionUID = 3318918491810662792L;
    public static final String THEME_QUEUE_PREFIX = "THEME.";
    public static final String THEME_QUEUE = "THEME.QUEUE";
    private final long id;
    private final SerializableTheme theme;
    private final Type type;

    public static ThemeItem update(SerializableTheme theme) {
        return new ThemeItem(theme);
    }

    public static ThemeItem delete(Long themeId) {
        return new ThemeItem(themeId);
    }

    public ThemeItem(SerializableTheme theme) {
        this.id = theme.getId();
        this.theme = theme;
        this.type = Type.Update;
    }

    public ThemeItem(Long themeId) {
        this.id = themeId;
        this.theme = null;
        this.type = Type.Delete;
    }

    @Override
    public String getId() {
        return Long.toString(this.id);
    }

    public Long getThemeId() {
        return this.id;
    }

    public SerializableTheme getTheme() {
        return this.theme;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        Update,
        Delete;

    }
}

