/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.message.broker.api.workflow;

import java.io.IOException;
import java.io.Serializable;
import javax.xml.parsers.ParserConfigurationException;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.message.broker.api.MessageItem;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreXmlFormat;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.xml.sax.SAXException;

public class WorkflowItem
implements MessageItem,
Serializable {
    private static final long serialVersionUID = -202811055899495045L;
    public static final String WORKFLOW_QUEUE_PREFIX = "WORKFLOW.";
    public static final String WORKFLOW_QUEUE = "WORKFLOW.QUEUE";
    private final String id;
    private final String workflowDefinitionId;
    private final long workflowInstanceId;
    private final String episodeDublincoreCatalog;
    private final String mediaPackage;
    private final String state;
    private final String accessControlListJSON;
    private final Type type;

    public static WorkflowItem updateInstance(WorkflowInstance workflowInstance, String dublincoreXml, AccessControlList accessControlList) {
        return new WorkflowItem(workflowInstance, dublincoreXml, accessControlList);
    }

    public static WorkflowItem deleteInstance(long workflowInstanceId, WorkflowInstance workflowInstance) {
        return new WorkflowItem(workflowInstanceId, workflowInstance);
    }

    public WorkflowItem(WorkflowInstance workflowInstance, String dublincoreXml, AccessControlList accessControlList) {
        this.id = workflowInstance.getMediaPackage().getIdentifier().compact();
        this.workflowDefinitionId = workflowInstance.getTemplate();
        this.workflowInstanceId = workflowInstance.getId();
        this.episodeDublincoreCatalog = dublincoreXml;
        this.mediaPackage = MediaPackageParser.getAsXml((MediaPackage)workflowInstance.getMediaPackage());
        this.state = workflowInstance.getState().toString();
        this.accessControlListJSON = AccessControlParser.toJsonSilent((AccessControlList)accessControlList);
        this.type = Type.UpdateInstance;
    }

    public WorkflowItem(long workflowInstanceId, WorkflowInstance workflowInstance) {
        this.id = workflowInstance.getMediaPackage().getIdentifier().compact();
        this.workflowInstanceId = workflowInstanceId;
        this.workflowDefinitionId = null;
        this.episodeDublincoreCatalog = null;
        this.mediaPackage = null;
        this.state = null;
        this.accessControlListJSON = null;
        this.type = Type.DeleteInstance;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getWorkflowDefinitionId() {
        return this.workflowDefinitionId;
    }

    public long getWorkflowInstanceId() {
        return this.workflowInstanceId;
    }

    public Type getType() {
        return this.type;
    }

    public DublinCoreCatalog getEpisodeDublincoreCatalog() {
        if (this.episodeDublincoreCatalog == null) {
            return null;
        }
        try {
            return DublinCoreXmlFormat.read((String)this.episodeDublincoreCatalog);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IllegalStateException("Unable to parse dublincore catalog", e);
        }
    }

    public MediaPackage getMediaPackage() {
        if (this.mediaPackage == null) {
            return null;
        }
        try {
            return MediaPackageParser.getFromXml((String)this.mediaPackage);
        }
        catch (MediaPackageException e) {
            throw new IllegalStateException("Could not parse media package XML", e);
        }
    }

    public WorkflowInstance.WorkflowState getState() {
        return WorkflowInstance.WorkflowState.valueOf((String)this.state);
    }

    public String getAccessControlListJSON() {
        return this.accessControlListJSON;
    }

    public static enum Type {
        DeleteInstance,
        UpdateInstance;

    }
}

