/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.message.broker.endpoint;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.opencastproject.message.broker.api.MessageReceiver;
import org.opencastproject.message.broker.api.MessageSender;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Path(value="/")
@RestService(name="messagebrokerservice", title="Message Broker Service", abstractText="Handles publishers and subscribers connecting to message brokers", notes={})
@Component(property={"service.description=Message Broker REST Endpoint", "opencast.service.type=org.opencastproject.message.broker.endpoint", "opencast.service.path=/broker"}, immediate=true, service={MessageBrokerServiceEndpoint.class})
public class MessageBrokerServiceEndpoint {
    private MessageReceiver messageReceiver;
    private MessageSender messageSender;

    @Reference(name="messageReceiver")
    public void setMessageReceiver(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    @Reference(name="messageSender")
    public void setMessageSender(MessageSender messageSender) {
        this.messageSender = messageSender;
    }

    @GET
    @Path(value="status")
    @RestQuery(name="status", description="Return status of message broker", returnDescription="Return status of message broker", responses={@RestResponse(responseCode=204, description="Connection to message broker ok"), @RestResponse(responseCode=503, description="Not connected to message broker")})
    public Response getStatus() {
        if (this.messageReceiver.isConnected() && this.messageSender.isConnected()) {
            return Response.status((int)204).build();
        }
        return Response.status((int)503).build();
    }
}

