/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.message.broker.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.transport.TransportListener;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBaseFacility {
    protected static final String ACTIVEMQ_BROKER_URL_KEY = "activemq.broker.url";
    protected static final String ACTIVEMQ_BROKER_USERNAME_KEY = "activemq.broker.username";
    protected static final String ACTIVEMQ_BROKER_PASSWORD_KEY = "activemq.broker.password";
    private static final String ACTIVEMQ_DEFAULT_URL = "failover://(tcp://127.0.0.1:61616)?initialReconnectDelay=2000&maxReconnectDelay=60000";
    private static final Logger logger = LoggerFactory.getLogger(MessageBaseFacility.class);
    private Connection connection = null;
    private Session session = null;
    private MessageProducer producer = null;
    private final AtomicBoolean enabled = new AtomicBoolean(false);
    private String url = "failover://(tcp://127.0.0.1:61616)?initialReconnectDelay=2000&maxReconnectDelay=60000";
    private String username = null;
    private String password = null;

    public void activate(BundleContext bc) throws Exception {
        String name = this.getClass().getSimpleName();
        this.url = bc.getProperty(ACTIVEMQ_BROKER_URL_KEY);
        if (StringUtils.isBlank((CharSequence)this.url)) {
            logger.info("No valid URL found. Using default URL");
            this.url = ACTIVEMQ_DEFAULT_URL;
        }
        this.username = bc.getProperty(ACTIVEMQ_BROKER_USERNAME_KEY);
        this.password = bc.getProperty(ACTIVEMQ_BROKER_PASSWORD_KEY);
        logger.info("{} is configured to connect with URL {}", (Object)name, (Object)this.url);
        if (this.reconnect()) {
            logger.info("{} service successfully started", (Object)name);
        }
    }

    public void deactivate() {
        logger.info("{} service is stopping...", (Object)this.getClass().getSimpleName());
        this.disconnectMessageBroker();
        logger.info("{} service successfully stopped", (Object)this.getClass().getSimpleName());
    }

    public synchronized boolean reconnect() {
        this.disconnectMessageBroker(false);
        try {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.url);
            connectionFactory.setTrustedPackages(Collections.singletonList("org.opencastproject.message.broker.api"));
            if (StringUtils.isNotBlank((CharSequence)this.username) && StringUtils.isNotBlank((CharSequence)this.password)) {
                connectionFactory.setUserName(this.username);
                connectionFactory.setPassword(this.password);
            }
            connectionFactory.setTransportListener(new TransportListener(){

                @Override
                public void transportResumed() {
                    MessageBaseFacility.this.enable(true);
                    logger.info("Connection to ActiveMQ is working");
                }

                @Override
                public void transportInterupted() {
                    MessageBaseFacility.this.enable(false);
                    logger.error("Connection to ActiveMQ message broker interrupted ({}, username: {})", (Object)MessageBaseFacility.this.url, (Object)MessageBaseFacility.this.username);
                }

                @Override
                public void onException(IOException ex) {
                    MessageBaseFacility.this.enable(false);
                    logger.error("ActiveMQ transport exception: {}", (Object)ex.getMessage());
                }

                @Override
                public void onCommand(Object obj) {
                    logger.trace("ActiveMQ command: {}", obj);
                }
            });
            logger.info("Starting connection to ActiveMQ message broker, waiting until connection is established...");
            this.connection = connectionFactory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            this.producer = this.session.createProducer(null);
            this.producer.setDeliveryMode(1);
        }
        catch (JMSException e) {
            logger.error("Failed connecting to ActiveMQ message broker using url '{}'", (Object)this.url);
            this.disconnectMessageBroker(false);
            return false;
        }
        logger.info("Connection to ActiveMQ message broker successfully started");
        return true;
    }

    protected void disconnectMessageBroker() {
        this.disconnectMessageBroker(true);
    }

    protected synchronized void disconnectMessageBroker(boolean verbose) {
        if (this.producer != null || this.session != null || this.connection != null) {
            block14: {
                block13: {
                    block12: {
                        if (verbose) {
                            logger.info("Stopping connection to ActiveMQ message broker...");
                        }
                        try {
                            if (this.producer != null) {
                                this.producer.close();
                            }
                        }
                        catch (JMSException e) {
                            if (!verbose) break block12;
                            logger.error("Error while trying to close producer:", (Throwable)e);
                        }
                    }
                    this.producer = null;
                    try {
                        if (this.session != null) {
                            this.session.close();
                        }
                    }
                    catch (JMSException e) {
                        if (!verbose) break block13;
                        logger.error("Error while trying to close session:", (Throwable)e);
                    }
                }
                this.session = null;
                try {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                }
                catch (JMSException e) {
                    if (!verbose) break block14;
                    logger.error("Error while trying to close session:", (Throwable)e);
                }
            }
            this.connection = null;
            if (verbose) {
                logger.info("Connection to ActiveMQ message broker successfully stopped");
            }
        }
        this.enable(false);
    }

    protected Session getSession() {
        return this.session;
    }

    public boolean isConnected() {
        return this.enabled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable(boolean state) {
        AtomicBoolean atomicBoolean = this.enabled;
        synchronized (atomicBoolean) {
            this.enabled.set(state);
            this.enabled.notifyAll();
        }
    }

    protected MessageProducer getMessageProducer() {
        return this.producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForConnection() {
        AtomicBoolean atomicBoolean = this.enabled;
        synchronized (atomicBoolean) {
            while (!this.enabled.get()) {
                try {
                    this.enabled.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

