/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.message.broker.impl;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.opencastproject.message.broker.api.MessageReceiver;
import org.opencastproject.message.broker.api.MessageSender;
import org.opencastproject.message.broker.impl.MessageBaseFacility;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Message Broker Receiver", "service.pid=org.opencastproject.message.broker.impl.MessageReceiverImpl"}, immediate=true, service={MessageReceiver.class})
public class MessageReceiverImpl
extends MessageBaseFacility
implements MessageReceiver {
    private static final Logger logger = LoggerFactory.getLogger(MessageReceiverImpl.class);

    @Override
    @Activate
    public void activate(BundleContext bc) throws Exception {
        super.activate(bc);
    }

    @Override
    @Deactivate
    public void deactivate() {
        super.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageConsumer createConsumer(String destinationId, MessageSender.DestinationType type) throws JMSException {
        this.waitForConnection();
        MessageReceiverImpl messageReceiverImpl = this;
        synchronized (messageReceiverImpl) {
            Session session = this.getSession();
            if (session == null) {
                logger.warn("No session object, consumer could not be created.");
                return null;
            }
            Object destination = type.equals((Object)MessageSender.DestinationType.Queue) ? session.createQueue(destinationId) : session.createTopic(destinationId);
            return session.createConsumer((Destination)destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message waitForMessage(String destinationId, MessageSender.DestinationType type) throws JMSException {
        this.waitForConnection();
        MessageConsumer consumer = null;
        try {
            consumer = this.createConsumer(destinationId, type);
            if (consumer != null) {
                Message message = consumer.receive();
                return message;
            }
            logger.trace("Consumer could not be created.");
            Message message = null;
            return message;
        }
        finally {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException e) {
                    logger.error("Unable to close connections after receipt of message", (Throwable)e);
                }
            }
        }
    }

    protected Serializable getSerializable(String destinationId, MessageSender.DestinationType type) throws JMSException {
        while (true) {
            Message message;
            if ((message = this.waitForMessage(destinationId, type)) instanceof ObjectMessage) {
                ObjectMessage objectMessage = (ObjectMessage)message;
                return objectMessage.getObject();
            }
            logger.debug("Skipping invalid message: {}", (Object)message);
        }
    }

    public FutureTask<Serializable> receiveSerializable(final String destinationId, final MessageSender.DestinationType type) {
        return new FutureTask<Serializable>(new Callable<Serializable>(){

            @Override
            public Serializable call() throws JMSException {
                return MessageReceiverImpl.this.getSerializable(destinationId, type);
            }
        });
    }
}

