/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.message.broker.impl;

import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.opencastproject.message.broker.api.BaseMessage;
import org.opencastproject.message.broker.api.MessageSender;
import org.opencastproject.message.broker.impl.MessageBaseFacility;
import org.opencastproject.security.api.SecurityService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Message Broker Sender", "service.pid=org.opencastproject.message.broker.impl.MessageSenderImpl"}, immediate=true, service={MessageSender.class})
public class MessageSenderImpl
extends MessageBaseFacility
implements MessageSender {
    private static final Logger logger = LoggerFactory.getLogger(MessageSenderImpl.class);
    private static final String SERVICE_PID = "org.opencastproject.message.broker.impl.MessageSenderImpl";
    private SecurityService securityService;

    @Override
    @Activate
    public void activate(BundleContext bc) throws Exception {
        super.activate(bc);
    }

    @Override
    @Deactivate
    public void deactivate() {
        super.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendObjectMessage(String destinationId, MessageSender.DestinationType type, Serializable object) {
        if (!this.isConnected()) {
            logger.error("Could not send message. No connection to message broker.");
            return;
        }
        try {
            MessageSenderImpl messageSenderImpl = this;
            synchronized (messageSenderImpl) {
                Session session = this.getSession();
                if (session == null) {
                    return;
                }
                ObjectMessage message = session.createObjectMessage((Serializable)new BaseMessage(this.securityService.getOrganization(), this.securityService.getUser(), object));
                Object destination = type.equals((Object)MessageSender.DestinationType.Queue) ? session.createQueue(destinationId) : session.createTopic(destinationId);
                logger.trace("Sent message: " + message.hashCode() + " : " + Thread.currentThread().getName());
                this.getMessageProducer().send((Destination)destination, (Message)message);
            }
        }
        catch (JMSException e) {
            logger.error("Had an exception while trying to send a message", (Throwable)e);
        }
    }

    @Reference(name="security-service")
    void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

