/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.metadata.api.MetadataValue;
import org.opencastproject.metadata.api.StaticMetadata;
import org.opencastproject.metadata.api.StaticMetadataService;
import org.opencastproject.metadata.api.util.Interval;
import org.opencastproject.util.data.Collections;
import org.opencastproject.util.data.Function;
import org.opencastproject.util.data.NonEmptyList;
import org.opencastproject.util.data.Option;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticMetadataServiceMediaPackageImpl
implements StaticMetadataService {
    private static final Logger logger = LoggerFactory.getLogger(StaticMetadataServiceMediaPackageImpl.class);
    protected int priority = 99;
    protected Workspace workspace = null;

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void activate(Map properties) {
        String priorityString;
        logger.debug("activate()");
        if (properties != null && (priorityString = (String)properties.get("priority")) != null) {
            try {
                this.priority = Integer.parseInt(priorityString);
            }
            catch (NumberFormatException e) {
                logger.warn("Unable to set priority to {}", (Object)priorityString);
                throw e;
            }
        }
    }

    public StaticMetadata getMetadata(final MediaPackage mp) {
        return new StaticMetadata(){

            public Option<String> getId() {
                return Option.option((Object)mp.getIdentifier().toString());
            }

            public Option<Date> getCreated() {
                return Option.none();
            }

            public Option<Long> getExtent() {
                return Option.option((Object)mp.getDuration());
            }

            public Option<String> getLanguage() {
                return Option.none();
            }

            public Option<String> getIsPartOf() {
                return Option.option((Object)mp.getSeries());
            }

            public Option<String> getReplaces() {
                return Option.none();
            }

            public Option<String> getType() {
                return Option.none();
            }

            public Option<Interval> getAvailable() {
                return Option.none();
            }

            public Option<Date[]> getTemporalPeriod() {
                return Option.none();
            }

            public Option<Date> getTemporalInstant() {
                return Option.none();
            }

            public Option<Long> getTemporalDuration() {
                return Option.none();
            }

            public NonEmptyList<MetadataValue<String>> getTitles() {
                if (mp.getTitle() != null) {
                    return new NonEmptyList((Object)new MetadataValue((Object)mp.getTitle(), "title"), (Object[])new MetadataValue[0]);
                }
                throw new IllegalArgumentException("MediaPackage " + mp + " does not contain a title");
            }

            public List<MetadataValue<String>> getSubjects() {
                return java.util.Collections.emptyList();
            }

            public List<MetadataValue<String>> getCreators() {
                return StaticMetadataServiceMediaPackageImpl.strings2MetadataValues(mp.getCreators(), "creator");
            }

            public List<MetadataValue<String>> getPublishers() {
                return java.util.Collections.emptyList();
            }

            public List<MetadataValue<String>> getContributors() {
                return StaticMetadataServiceMediaPackageImpl.strings2MetadataValues(mp.getContributors(), "contributor");
            }

            public List<MetadataValue<String>> getDescription() {
                return java.util.Collections.emptyList();
            }

            public List<MetadataValue<String>> getRightsHolders() {
                return java.util.Collections.emptyList();
            }

            public List<MetadataValue<String>> getSpatials() {
                return java.util.Collections.emptyList();
            }

            public List<MetadataValue<String>> getAccessRights() {
                return java.util.Collections.emptyList();
            }

            public List<MetadataValue<String>> getLicenses() {
                if (mp.getLicense() != null) {
                    return Arrays.asList(new MetadataValue((Object)mp.getLicense(), "license"));
                }
                return java.util.Collections.emptyList();
            }
        };
    }

    public int getPriority() {
        return this.priority;
    }

    private static List<MetadataValue<String>> strings2MetadataValues(String[] values, final String valueName) {
        if (values != null) {
            return (List)Collections.map(Arrays.asList(values), new ArrayList(), (Function)new Function<String, MetadataValue<String>>(){

                public MetadataValue<String> apply(String s) {
                    return new MetadataValue((Object)s, valueName);
                }
            });
        }
        return java.util.Collections.emptyList();
    }
}

