/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metrics.impl;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.exporter.common.TextFormat;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.job.api.Job;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistration;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceState;
import org.opencastproject.serviceregistry.api.SystemLoad;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="")
@RestService(name="MetricsEndpoint", title="Metrics Endpoint", abstractText="Opencast metrics endpoint.", notes={"The endpoints supports the <a href=https://openmetrics.io>OpenMetrics format</a>", "This can be used by <a href=https://prometheus.io>Prometheus</a>"})
@Component(property={"service.description=Metrics Endpoint", "opencast.service.type=org.opencastproject.metrics", "opencast.service.path=/metrics", "opencast.service.jobproducer=false"}, immediate=true, service={MetricsExporter.class})
public class MetricsExporter {
    private static final Logger logger = LoggerFactory.getLogger(MetricsExporter.class);
    private final CollectorRegistry registry = CollectorRegistry.defaultRegistry;
    private final Counter requests = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("requests_total")).help("Total requests.")).register();
    private final Gauge jobLoadMax = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("opencast_job_load_max")).help("Maximum job load")).labelNames(new String[]{"host"})).register();
    private final Gauge jobLoadCurrent = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("opencast_job_load_current")).help("Maximum job load")).labelNames(new String[]{"host"})).register();
    private final Gauge jobsActive = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("opencast_job_active")).help("Active jobs")).labelNames(new String[]{"host", "organization"})).register();
    private final Gauge workflowsActive = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("opencast_workflow_active")).help("Active workflows")).labelNames(new String[]{"organization"})).register();
    private final Gauge servicesTotal = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("opencast_services_total")).help("Number of services in a cluster")).labelNames(new String[]{"state"})).register();
    private final Gauge version = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("opencast_version")).help("Version of Opencast (based on metrics module)")).labelNames(new String[]{"part"})).register();
    private Gauge eventsInAssetManager;
    private ServiceRegistry serviceRegistry;
    private OrganizationDirectoryService organizationDirectoryService;
    private AssetManager assetManager;

    @Activate
    public void activate(BundleContext bundleContext) {
        Version version = bundleContext.getBundle().getVersion();
        ((Gauge.Child)this.version.labels(new String[]{"major"})).set((double)version.getMajor());
        ((Gauge.Child)this.version.labels(new String[]{"minor"})).set((double)version.getMinor());
        DefaultExports.initialize();
    }

    @GET
    @Path(value="/")
    @Produces(value={"text/plain; version=0.0.4; charset=utf-8"})
    @RestQuery(name="metrics", description="Metrics about Opencast", responses={@RestResponse(description="Metrics", responseCode=200)}, returnDescription="OpenMetrics about Opencast.")
    public Response metrics() throws Exception {
        this.requests.inc();
        List serviceStates = this.serviceRegistry.getServiceRegistrations().parallelStream().map(ServiceRegistration::getServiceState).collect(Collectors.toList());
        long error = serviceStates.parallelStream().filter(arg_0 -> ServiceState.ERROR.equals(arg_0)).count();
        long warn = serviceStates.parallelStream().filter(arg_0 -> ServiceState.WARNING.equals(arg_0)).count();
        ((Gauge.Child)this.servicesTotal.labels(new String[]{ServiceState.NORMAL.name()})).set((double)((long)serviceStates.size() - error - warn));
        ((Gauge.Child)this.servicesTotal.labels(new String[]{ServiceState.WARNING.name()})).set((double)warn);
        ((Gauge.Child)this.servicesTotal.labels(new String[]{ServiceState.ERROR.name()})).set((double)error);
        HashMap<String, Integer> workflows = new HashMap<String, Integer>();
        HashMap jobs = new HashMap();
        for (Organization organization : this.organizationDirectoryService.getOrganizations()) {
            workflows.put(organization.getId(), 0);
            jobs.put(organization.getId(), new HashMap());
        }
        for (SystemLoad.NodeLoad nodeLoad : this.serviceRegistry.getCurrentHostLoads().getNodeLoads()) {
            ((Gauge.Child)this.jobLoadCurrent.labels(new String[]{nodeLoad.getHost()})).set((double)nodeLoad.getCurrentLoad());
            ((Gauge.Child)this.jobLoadMax.labels(new String[]{nodeLoad.getHost()})).set((double)nodeLoad.getMaxLoad());
            for (Map.Entry entry : jobs.entrySet()) {
                ((Map)entry.getValue()).put(nodeLoad.getHost(), 0);
            }
        }
        for (Job job : this.serviceRegistry.getActiveJobs()) {
            Map orgJobs = jobs.getOrDefault(job.getOrganization(), null);
            if (orgJobs != null) {
                orgJobs.computeIfPresent(job.getProcessingHost(), (k, v) -> v + 1);
            }
            if (!"START_WORKFLOW".equals(job.getOperation())) continue;
            workflows.computeIfPresent(job.getOrganization(), (k, v) -> v + 1);
        }
        for (Map.Entry entry : workflows.entrySet()) {
            ((Gauge.Child)this.workflowsActive.labels(new String[]{(String)entry.getKey()})).set((double)((Integer)entry.getValue()).intValue());
        }
        for (Map.Entry entry : jobs.entrySet()) {
            for (Map.Entry orgEntry : ((Map)entry.getValue()).entrySet()) {
                ((Gauge.Child)this.jobsActive.labels(new String[]{(String)orgEntry.getKey(), (String)entry.getKey()})).set((double)((Integer)orgEntry.getValue()).intValue());
            }
        }
        if (this.assetManager != null) {
            for (Organization organization : this.organizationDirectoryService.getOrganizations()) {
                ((Gauge.Child)this.eventsInAssetManager.labels(new String[]{organization.getId()})).set((double)this.assetManager.countEvents(organization.getId()));
            }
        }
        StringWriter writer = new StringWriter();
        TextFormat.write004((Writer)writer, (Enumeration)this.registry.metricFamilySamples());
        return Response.ok().entity((Object)writer.toString()).build();
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry service) {
        this.serviceRegistry = service;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, unbind="unsetAssetManager")
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
        this.eventsInAssetManager = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("opencast_asset_manager_events")).help("Events in Asset Manager")).labelNames(new String[]{"organization"})).register();
    }

    public void unsetAssetManager(AssetManager assetManager) {
        this.assetManager = null;
        this.registry.unregister((Collector)this.eventsInAssetManager);
    }
}

