/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.scheduler.endpoint;

import com.entwinemedia.fn.data.Opt;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.fortuna.ical4j.model.property.RRule;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.capture.admin.api.Agent;
import org.opencastproject.capture.admin.api.CaptureAgentStateService;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.metadata.dublincore.DCMIPeriod;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.metadata.dublincore.Precision;
import org.opencastproject.rest.ErrorCodeException;
import org.opencastproject.scheduler.api.Recording;
import org.opencastproject.scheduler.api.SchedulerConflictException;
import org.opencastproject.scheduler.api.SchedulerException;
import org.opencastproject.scheduler.api.SchedulerService;
import org.opencastproject.scheduler.api.TechnicalMetadata;
import org.opencastproject.scheduler.impl.CaptureNowProlongingService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.Jsons;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.data.Monadics;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="schedulerservice", title="Scheduler Service", abstractText="This service creates, edits and retrieves and helps managing scheduled capture events.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=true, service={SchedulerRestService.class}, property={"service.description=Scheduler REST Endpoint", "opencast.service.type=org.opencastproject.scheduler", "opencast.service.path=/recordings"})
public class SchedulerRestService {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerRestService.class);
    private static final String DEFAULT_WORKFLOW_DEFINITION = "org.opencastproject.workflow.default.definition";
    private SchedulerService service;
    private CaptureAgentStateService agentService;
    private CaptureNowProlongingService prolongingService;
    private Workspace workspace;
    private final Gson gson = new Gson();
    private String defaultWorkflowDefinitionId;
    protected String serverUrl = "http://localhost:8080";
    protected String serviceUrl = null;

    @Reference(policy=ReferencePolicy.DYNAMIC, unbind="unsetService")
    public void setService(SchedulerService service) {
        this.service = service;
    }

    public void unsetService(SchedulerService service) {
        this.service = null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, unbind="unsetProlongingService")
    public void setProlongingService(CaptureNowProlongingService prolongingService) {
        this.prolongingService = prolongingService;
    }

    public void unsetProlongingService(CaptureNowProlongingService prolongingService) {
        this.prolongingService = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetCaptureAgentStateService")
    public void setCaptureAgentStateService(CaptureAgentStateService agentService) {
        this.agentService = agentService;
    }

    public void unsetCaptureAgentStateService(CaptureAgentStateService agentService) {
        this.agentService = null;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Activate
    public void activate(ComponentContext cc) {
        if (cc != null) {
            String ccServerUrl = cc.getBundleContext().getProperty("org.opencastproject.server.url");
            logger.debug("configured server url is {}", (Object)ccServerUrl);
            this.serverUrl = ccServerUrl == null ? "http://localhost:8080" : ccServerUrl;
            this.serviceUrl = (String)cc.getProperties().get("opencast.service.path");
            this.defaultWorkflowDefinitionId = StringUtils.trimToNull((String)cc.getBundleContext().getProperty(DEFAULT_WORKFLOW_DEFINITION));
            if (this.defaultWorkflowDefinitionId == null) {
                this.defaultWorkflowDefinitionId = "schedule-and-upload";
            }
        }
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="{id:.+}/mediapackage.xml")
    @RestQuery(name="getmediapackagexml", description="Retrieves media package for specified event", returnDescription="media package in XML", pathParameters={@RestParameter(name="id", isRequired=true, description="ID of event for which media package will be retrieved", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="DublinCore of event is in the body of response"), @RestResponse(responseCode=404, description="Event with specified ID does not exist"), @RestResponse(responseCode=401, description="You do not have permission to remove the event. Maybe you need to authenticate.")})
    public Response getMediaPackageXml(@PathParam(value="id") String eventId) throws UnauthorizedException {
        try {
            MediaPackage result = this.service.getMediaPackage(eventId);
            return Response.ok((Object)MediaPackageParser.getAsXml((MediaPackage)result)).build();
        }
        catch (NotFoundException e) {
            logger.info("Event with id '{}' does not exist.", (Object)eventId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (SchedulerException e) {
            logger.error("Unable to retrieve event with id '{}': {}", (Object)eventId, (Object)ExceptionUtils.getMessage((Throwable)e));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="{id:.+}/dublincore.xml")
    @RestQuery(name="recordingsasxml", description="Retrieves DublinCore for specified event", returnDescription="DublinCore in XML", pathParameters={@RestParameter(name="id", isRequired=true, description="ID of event for which DublinCore will be retrieved", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="DublinCore of event is in the body of response"), @RestResponse(responseCode=404, description="Event with specified ID does not exist"), @RestResponse(responseCode=401, description="You do not have permission to remove the event. Maybe you need to authenticate.")})
    public Response getDublinCoreMetadataXml(@PathParam(value="id") String eventId) throws UnauthorizedException {
        try {
            DublinCoreCatalog result = this.service.getDublinCore(eventId);
            return Response.ok((Object)result.toXmlString()).build();
        }
        catch (NotFoundException e) {
            logger.info("Event with id '{}' does not exist.", (Object)eventId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to retrieve event with id '{}': {}", (Object)eventId, (Object)ExceptionUtils.getMessage((Throwable)e));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{id:.+}/dublincore.json")
    @RestQuery(name="recordingsasjson", description="Retrieves DublinCore for specified event", returnDescription="DublinCore in JSON", pathParameters={@RestParameter(name="id", isRequired=true, description="ID of event for which DublinCore will be retrieved", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="DublinCore of event is in the body of response"), @RestResponse(responseCode=404, description="Event with specified ID does not exist"), @RestResponse(responseCode=401, description="You do not have permission to remove the event. Maybe you need to authenticate.")})
    public Response getDublinCoreMetadataJSON(@PathParam(value="id") String eventId) throws UnauthorizedException {
        try {
            DublinCoreCatalog result = this.service.getDublinCore(eventId);
            return Response.ok((Object)result.toJson()).build();
        }
        catch (NotFoundException e) {
            logger.info("Event with id '{}' does not exist.", (Object)eventId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to retrieve event with id '{}': {}", (Object)eventId, (Object)ExceptionUtils.getMessage((Throwable)e));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="{id:.+}/technical.json")
    @RestQuery(name="gettechnicalmetadatajson", description="Retrieves the technical metadata for specified event", returnDescription="technical metadata as JSON", pathParameters={@RestParameter(name="id", isRequired=true, description="ID of event for which the technical metadata will be retrieved", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="technical metadata of event is in the body of response"), @RestResponse(responseCode=404, description="Event with specified ID does not exist"), @RestResponse(responseCode=401, description="You do not have permission to remove the event. Maybe you need to authenticate.")})
    public Response getTechnicalMetadataJSON(@PathParam(value="id") String eventId) throws UnauthorizedException {
        try {
            TechnicalMetadata metadata = this.service.getTechnicalMetadata(eventId);
            Jsons.Val state = Jsons.v((String)"");
            Jsons.Val lastHeard = Jsons.v((String)"");
            if (metadata.getRecording().isSome()) {
                state = Jsons.v((String)((Recording)metadata.getRecording().get()).getState());
                lastHeard = Jsons.v((String)DateTimeSupport.toUTC((long)((Recording)metadata.getRecording().get()).getLastCheckinTime()));
            }
            Jsons.Arr presenters = Jsons.arr((Monadics.ListMonadic)Monadics.mlist((Collection)metadata.getPresenters()).map(Jsons.stringVal));
            ArrayList<Jsons.Prop> wfProperties = new ArrayList<Jsons.Prop>();
            for (Map.Entry entry : metadata.getWorkflowProperties().entrySet()) {
                wfProperties.add(Jsons.p((String)((String)entry.getKey()), (String)((String)entry.getValue())));
            }
            ArrayList<Jsons.Prop> agentConfig = new ArrayList<Jsons.Prop>();
            for (Map.Entry entry : metadata.getCaptureAgentConfiguration().entrySet()) {
                agentConfig.add(Jsons.p((String)((String)entry.getKey()), (String)((String)entry.getValue())));
            }
            return RestUtil.R.ok((Jsons.Obj)Jsons.obj((Jsons.Prop[])new Jsons.Prop[]{Jsons.p((String)"id", (String)metadata.getEventId()), Jsons.p((String)"location", (String)metadata.getAgentId()), Jsons.p((String)"start", (String)DateTimeSupport.toUTC((long)metadata.getStartDate().getTime())), Jsons.p((String)"end", (String)DateTimeSupport.toUTC((long)metadata.getEndDate().getTime())), Jsons.p((String)"presenters", (Jsons.Val)presenters), Jsons.p((String)"wfProperties", (Jsons.Val)Jsons.obj((Jsons.Prop[])wfProperties.toArray(new Jsons.Prop[wfProperties.size()]))), Jsons.p((String)"agentConfig", (Jsons.Val)Jsons.obj((Jsons.Prop[])agentConfig.toArray(new Jsons.Prop[agentConfig.size()]))), Jsons.p((String)"state", (Jsons.Val)state), Jsons.p((String)"lastHeardFrom", (Jsons.Val)lastHeard)}));
        }
        catch (NotFoundException e) {
            logger.info("Event with id '{}' does not exist.", (Object)eventId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (SchedulerException e) {
            logger.error("Unable to retrieve event with id '{}': {}", (Object)eventId, (Object)ExceptionUtils.getMessage((Throwable)e));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="{id:.+}/workflow.properties")
    @RestQuery(name="recordingsagentproperties", description="Retrieves workflow configuration for specified event", returnDescription="workflow configuration in the form of key, value pairs", pathParameters={@RestParameter(name="id", isRequired=true, description="ID of event for which workflow configuration will be retrieved", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="workflow configuration of event is in the body of response"), @RestResponse(responseCode=404, description="Event with specified ID does not exist"), @RestResponse(responseCode=401, description="You do not have permission to remove the event. Maybe you need to authenticate.")})
    public Response getWorkflowConfiguration(@PathParam(value="id") String eventId) throws UnauthorizedException {
        try {
            Map result = this.service.getWorkflowConfig(eventId);
            String serializedProperties = this.serializeProperties(result);
            return Response.ok((Object)serializedProperties).build();
        }
        catch (NotFoundException e) {
            logger.info("Event with id '{}' does not exist.", (Object)eventId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (SchedulerException e) {
            logger.error("Unable to retrieve workflow configuration for event with id '{}': {}", (Object)eventId, (Object)ExceptionUtils.getMessage((Throwable)e));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="{id:.+}/agent.properties")
    @RestQuery(name="recordingsagentproperties", description="Retrieves Capture Agent properties for specified event", returnDescription="Capture Agent properties in the form of key, value pairs", pathParameters={@RestParameter(name="id", isRequired=true, description="ID of event for which agent properties will be retrieved", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Capture Agent properties of event is in the body of response"), @RestResponse(responseCode=404, description="Event with specified ID does not exist"), @RestResponse(responseCode=401, description="You do not have permission to remove the event. Maybe you need to authenticate.")})
    public Response getCaptureAgentMetadata(@PathParam(value="id") String eventId) throws UnauthorizedException {
        try {
            Map result = this.service.getCaptureAgentConfiguration(eventId);
            String serializedProperties = this.serializeProperties(result);
            return Response.ok((Object)serializedProperties).build();
        }
        catch (NotFoundException e) {
            logger.info("Event with id '{}' does not exist.", (Object)eventId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (SchedulerException e) {
            logger.error("Unable to retrieve event with id '{}': {}", (Object)eventId, (Object)ExceptionUtils.getMessage((Throwable)e));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="{id:.+}")
    @Produces(value={"text/plain"})
    @RestQuery(name="deleterecordings", description="Removes scheduled event with specified ID.", returnDescription="OK if event were successfully removed or NOT FOUND if event with specified ID does not exist", pathParameters={@RestParameter(name="id", isRequired=true, description="Event ID", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Event was successfully removed"), @RestResponse(responseCode=404, description="Event with specified ID does not exist"), @RestResponse(responseCode=401, description="You do not have permission to remove the event. Maybe you need to authenticate."), @RestResponse(responseCode=409, description="Event with specified ID is locked by a transaction, unable to delete event.")})
    public Response deleteEvent(@PathParam(value="id") String eventId) throws UnauthorizedException {
        try {
            this.service.removeEvent(eventId);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (NotFoundException e) {
            logger.info("Event with id '{}' does not exist.", (Object)eventId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to delete event with id '{}': {}", (Object)eventId, (Object)ExceptionUtils.getMessage((Throwable)e));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"text/calendar"})
    @Path(value="calendars")
    @RestQuery(name="getcalendar", description="Returns iCalendar for specified set of events", returnDescription="ICalendar for events", restParameters={@RestParameter(name="agentid", description="Filter events by capture agent", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="seriesid", description="Filter events by series", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="cutoff", description="A cutoff date in UNIX milliseconds to limit the number of events returned in the calendar.", isRequired=false, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=304, description="Events were not modified since last request"), @RestResponse(responseCode=200, description="Events were modified, new calendar is in the body")})
    public Response getCalendar(@QueryParam(value="agentid") String captureAgentId, @QueryParam(value="seriesid") String seriesId, @QueryParam(value="cutoff") Long cutoff, @Context HttpServletRequest request) {
        Date endDate = null;
        if (cutoff != null) {
            try {
                endDate = new Date(cutoff);
            }
            catch (NumberFormatException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        try {
            String lastModified = null;
            if (StringUtils.isNotBlank((CharSequence)captureAgentId)) {
                lastModified = this.service.getScheduleLastModified(captureAgentId);
                String ifNoneMatch = request.getHeader("If-None-Match");
                if (StringUtils.isNotBlank((CharSequence)ifNoneMatch) && ifNoneMatch.equals(lastModified)) {
                    return Response.notModified((String)lastModified).expires(null).build();
                }
            }
            String result = this.service.getCalendar(Opt.nul((Object)StringUtils.trimToNull((String)captureAgentId)), Opt.nul((Object)StringUtils.trimToNull((String)seriesId)), Opt.nul((Object)endDate));
            Response.ResponseBuilder response = Response.ok((Object)result).header("Content-Type", (Object)"text/calendar; charset=UTF-8");
            if (StringUtils.isNotBlank((CharSequence)lastModified)) {
                response.header("ETag", (Object)lastModified);
            }
            return response.build();
        }
        catch (Exception e) {
            logger.error("Unable to get calendar for capture agent '{}':", (Object)captureAgentId, (Object)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="calendar.json")
    @RestQuery(name="getCalendarJSON", description="Returns a calendar in JSON format for specified events. This endpoint is not yet stable and might change in the future with no priot notice.", returnDescription="Calendar for events in JSON format", restParameters={@RestParameter(name="agentid", description="Filter events by capture agent", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="cutoff", description="A cutoff date in UNIX milliseconds to limit the number of events returned in the calendar.", isRequired=false, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=304, description="Events were not modified since last request"), @RestResponse(responseCode=200, description="Events were modified, new calendar is in the body")})
    public Response getCalendarJson(@QueryParam(value="agentid") String captureAgentId, @QueryParam(value="cutoff") Long cutoff, @Context HttpServletRequest request) {
        try {
            Opt endDate = Optional.ofNullable(cutoff).map(Date::new).map(Opt::some).orElse(Opt.none());
            Opt agent = Optional.ofNullable(captureAgentId).map(String::trim).filter(id -> !id.isEmpty()).map(Opt::some).orElse(Opt.none());
            String lastModified = null;
            if (agent.isSome()) {
                lastModified = this.service.getScheduleLastModified((String)agent.get());
                String ifNoneMatch = request.getHeader("If-None-Match");
                if (StringUtils.isNotBlank((CharSequence)ifNoneMatch) && ifNoneMatch.equals(lastModified)) {
                    return Response.notModified((String)lastModified).expires(null).build();
                }
            }
            ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
            for (MediaPackage event : this.service.search(agent, Opt.none(), Opt.none(), Opt.some((Object)new Date()), endDate)) {
                String id2 = event.getIdentifier().toString();
                result.add(Map.of("data", this.service.getTechnicalMetadata(id2), "episode-dublincore", this.service.getDublinCore(id2).toXmlString()));
            }
            Response.ResponseBuilder response = Response.ok((Object)this.gson.toJson(result));
            if (StringUtils.isNotBlank((CharSequence)lastModified)) {
                response.header("ETag", (Object)lastModified);
            }
            return response.build();
        }
        catch (Exception e) {
            throw new WebApplicationException(String.format("Unable to get calendar for capture agent %s", captureAgentId), (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="{id}/lastmodified")
    @RestQuery(name="agentlastmodified", description="Retrieves the last modified hash for specified agent", returnDescription="The last modified hash", pathParameters={@RestParameter(name="id", isRequired=true, description="ID of capture agent for which the last modified hash will be retrieved", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The last modified hash of agent is in the body of response")})
    public Response getLastModified(@PathParam(value="id") String agentId) {
        try {
            String lastModified = this.service.getScheduleLastModified(agentId);
            return Response.ok((Object)lastModified).build();
        }
        catch (Exception e) {
            logger.error("Unable to retrieve agent last modified hash of agent id '{}': {}", (Object)agentId, (Object)ExceptionUtils.getMessage((Throwable)e));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="/removeOldScheduledRecordings")
    @RestQuery(name="removeOldScheduledRecordings", description="This will find and remove any scheduled events before the buffer time to keep performance in the scheduler optimum.", returnDescription="No return value", responses={@RestResponse(responseCode=200, description="Removed old scheduled recordings."), @RestResponse(responseCode=400, description="Unable to parse buffer."), @RestResponse(responseCode=401, description="You do not have permission to remove old schedulings. Maybe you need to authenticate.")}, restParameters={@RestParameter(name="buffer", type=RestParameter.Type.INTEGER, defaultValue="604800", isRequired=true, description="The amount of seconds before now that a capture has to have stopped capturing. It must be 0 or greater.")})
    public Response removeOldScheduledRecordings(@FormParam(value="buffer") long buffer) throws UnauthorizedException {
        if (buffer < 0L) {
            return Response.status((int)400).build();
        }
        try {
            this.service.removeScheduledRecordingsBeforeBuffer(buffer);
        }
        catch (SchedulerException e) {
            logger.error("Error while trying to remove old scheduled recordings", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/")
    @RestQuery(name="newrecording", description="Creates new event with specified parameters", returnDescription="If an event was successfully created", restParameters={@RestParameter(name="start", isRequired=true, type=RestParameter.Type.INTEGER, description="The start date of the event in milliseconds from 1970-01-01T00:00:00Z"), @RestParameter(name="end", isRequired=true, type=RestParameter.Type.INTEGER, description="The end date of the event in milliseconds from 1970-01-01T00:00:00Z"), @RestParameter(name="agent", isRequired=true, type=RestParameter.Type.STRING, description="The agent of the event"), @RestParameter(name="users", isRequired=false, type=RestParameter.Type.STRING, description="Comma separated list of user ids (speakers/lecturers) for the event"), @RestParameter(name="mediaPackage", isRequired=true, type=RestParameter.Type.TEXT, description="The media package of the event"), @RestParameter(name="wfproperties", isRequired=false, type=RestParameter.Type.TEXT, description="Workflow configuration keys for the event. Each key will be prefixed by 'org.opencastproject.workflow.config.' and added to the capture agent parameters."), @RestParameter(name="agentparameters", isRequired=false, type=RestParameter.Type.TEXT, description="The capture agent properties for the event"), @RestParameter(name="source", isRequired=false, type=RestParameter.Type.STRING, description="The scheduling source of the event")}, responses={@RestResponse(responseCode=201, description="Event is successfully created"), @RestResponse(responseCode=409, description="Unable to create event, conflicting events found (ConflicsFound)"), @RestResponse(responseCode=409, description="Unable to create event, event locked by a transaction  (TransactionLock)"), @RestResponse(responseCode=401, description="You do not have permission to create the event. Maybe you need to authenticate."), @RestResponse(responseCode=400, description="Missing or invalid information for this request")})
    public Response addEvent(@FormParam(value="start") long startTime, @FormParam(value="end") long endTime, @FormParam(value="agent") String agentId, @FormParam(value="users") String users, @FormParam(value="mediaPackage") String mediaPackageXml, @FormParam(value="wfproperties") String workflowProperties, @FormParam(value="agentparameters") String agentParameters, @FormParam(value="source") String schedulingSource) throws UnauthorizedException {
        MediaPackage mediaPackage;
        if (endTime <= startTime || startTime < 0L) {
            logger.debug("Cannot add event without proper start and end time");
            return RestUtil.R.badRequest((String)"Cannot add event without proper start and end time");
        }
        if (StringUtils.isBlank((CharSequence)agentId)) {
            logger.debug("Cannot add event without agent identifier");
            return RestUtil.R.badRequest((String)"Cannot add event without agent identifier");
        }
        if (StringUtils.isBlank((CharSequence)mediaPackageXml)) {
            logger.debug("Cannot add event without media package");
            return RestUtil.R.badRequest((String)"Cannot add event without media package");
        }
        try {
            mediaPackage = MediaPackageParser.getFromXml((String)mediaPackageXml);
        }
        catch (MediaPackageException e) {
            logger.debug("Could not parse media package", (Throwable)e);
            return RestUtil.R.badRequest((String)"Could not parse media package");
        }
        String eventId = mediaPackage.getIdentifier().toString();
        HashMap<Object, Object> caProperties = new HashMap<Object, Object>();
        if (StringUtils.isNotBlank((CharSequence)agentParameters)) {
            try {
                Properties prop = this.parseProperties(agentParameters);
                caProperties.putAll(prop);
            }
            catch (Exception e) {
                logger.info("Could not parse capture agent properties: {}", (Object)agentParameters);
                return RestUtil.R.badRequest((String)"Could not parse capture agent properties");
            }
        }
        HashMap<Object, Object> wfProperties = new HashMap<Object, Object>();
        if (StringUtils.isNotBlank((CharSequence)workflowProperties)) {
            try {
                Properties prop = this.parseProperties(workflowProperties);
                wfProperties.putAll(prop);
            }
            catch (IOException e) {
                logger.info("Could not parse workflow configuration properties: {}", (Object)workflowProperties);
                return RestUtil.R.badRequest((String)"Could not parse workflow configuration properties");
            }
        }
        HashSet<String> userIds = new HashSet<String>();
        String[] ids = StringUtils.split((String)users, (String)",");
        if (ids != null) {
            userIds.addAll(Arrays.asList(ids));
        }
        DateTime startDate = new DateTime(startTime).toDateTime(DateTimeZone.UTC);
        DateTime endDate = new DateTime(endTime).toDateTime(DateTimeZone.UTC);
        try {
            this.service.addEvent(startDate.toDate(), endDate.toDate(), agentId, userIds, mediaPackage, wfProperties, caProperties, Opt.nul((Object)schedulingSource));
            return Response.status((Response.Status)Response.Status.CREATED).header("Location", (Object)(this.serverUrl + this.serviceUrl + "/" + eventId + "/mediapackage.xml")).build();
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (SchedulerConflictException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)RestUtil.generateErrorResponse((ErrorCodeException)e)).type("application/json").build();
        }
        catch (Exception e) {
            logger.error("Unable to create new event with id '{}'", (Object)eventId, (Object)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/multiple")
    @RestQuery(name="newrecordings", description="Creates new event with specified parameters", returnDescription="If an event was successfully created", restParameters={@RestParameter(name="rrule", isRequired=true, type=RestParameter.Type.STRING, description="The recurrence rule for the events"), @RestParameter(name="start", isRequired=true, type=RestParameter.Type.INTEGER, description="The start date of the event in milliseconds from 1970-01-01T00:00:00Z"), @RestParameter(name="end", isRequired=true, type=RestParameter.Type.INTEGER, description="The end date of the event in milliseconds from 1970-01-01T00:00:00Z"), @RestParameter(name="duration", isRequired=true, type=RestParameter.Type.INTEGER, description="The duration of the events in milliseconds"), @RestParameter(name="tz", isRequired=true, type=RestParameter.Type.INTEGER, description="The timezone of the events"), @RestParameter(name="agent", isRequired=true, type=RestParameter.Type.STRING, description="The agent of the event"), @RestParameter(name="users", isRequired=false, type=RestParameter.Type.STRING, description="Comma separated list of user ids (speakers/lecturers) for the event"), @RestParameter(name="templateMp", isRequired=true, type=RestParameter.Type.TEXT, description="The template mediapackage for the events"), @RestParameter(name="wfproperties", isRequired=false, type=RestParameter.Type.TEXT, description="Workflow configuration keys for the event. Each key will be prefixed by 'org.opencastproject.workflow.config.' and added to the capture agent parameters."), @RestParameter(name="agentparameters", isRequired=false, type=RestParameter.Type.TEXT, description="The capture agent properties for the event"), @RestParameter(name="source", isRequired=false, type=RestParameter.Type.STRING, description="The scheduling source of the event")}, responses={@RestResponse(responseCode=201, description="Event is successfully created"), @RestResponse(responseCode=409, description="Unable to create event, conflicting events found (ConflicsFound)"), @RestResponse(responseCode=409, description="Unable to create event, event locked by a transaction  (TransactionLock)"), @RestResponse(responseCode=401, description="You do not have permission to create the event. Maybe you need to authenticate."), @RestResponse(responseCode=400, description="Missing or invalid information for this request")})
    public Response addMultipleEvents(@FormParam(value="rrule") String rruleString, @FormParam(value="start") long startTime, @FormParam(value="end") long endTime, @FormParam(value="duration") long duration, @FormParam(value="tz") String tzString, @FormParam(value="agent") String agentId, @FormParam(value="users") String users, @FormParam(value="templateMp") MediaPackage templateMp, @FormParam(value="wfproperties") String workflowProperties, @FormParam(value="agentparameters") String agentParameters, @FormParam(value="source") String schedulingSource) throws UnauthorizedException {
        RRule rrule;
        if (endTime <= startTime || startTime < 0L) {
            logger.debug("Cannot add event without proper start and end time");
            return RestUtil.R.badRequest((String)"Cannot add event without proper start and end time");
        }
        try {
            rrule = new RRule(rruleString);
        }
        catch (java.text.ParseException e) {
            logger.debug("Could not parse recurrence rule");
            return RestUtil.R.badRequest((String)"Could not parse recurrence rule");
        }
        if (duration < 1L) {
            logger.debug("Cannot schedule events with durations less than 1");
            return RestUtil.R.badRequest((String)"Cannot schedule events with durations less than 1");
        }
        if (StringUtils.isBlank((CharSequence)tzString)) {
            logger.debug("Cannot schedule events with blank timezone");
            return RestUtil.R.badRequest((String)"Cannot schedule events with blank timezone");
        }
        TimeZone tz = TimeZone.getTimeZone(tzString);
        if (StringUtils.isBlank((CharSequence)agentId)) {
            logger.debug("Cannot add event without agent identifier");
            return RestUtil.R.badRequest((String)"Cannot add event without agent identifier");
        }
        HashMap<Object, Object> caProperties = new HashMap<Object, Object>();
        if (StringUtils.isNotBlank((CharSequence)agentParameters)) {
            try {
                Properties prop = this.parseProperties(agentParameters);
                caProperties.putAll(prop);
            }
            catch (Exception e) {
                logger.info("Could not parse capture agent properties: {}", (Object)agentParameters);
                return RestUtil.R.badRequest((String)"Could not parse capture agent properties");
            }
        }
        HashMap<Object, Object> wfProperties = new HashMap<Object, Object>();
        if (StringUtils.isNotBlank((CharSequence)workflowProperties)) {
            try {
                Properties prop = this.parseProperties(workflowProperties);
                wfProperties.putAll(prop);
            }
            catch (IOException e) {
                logger.info("Could not parse workflow configuration properties: {}", (Object)workflowProperties);
                return RestUtil.R.badRequest((String)"Could not parse workflow configuration properties");
            }
        }
        HashSet<String> userIds = new HashSet<String>();
        String[] ids = StringUtils.split((String)users, (String)",");
        if (ids != null) {
            userIds.addAll(Arrays.asList(ids));
        }
        DateTime startDate = new DateTime(startTime).toDateTime(DateTimeZone.forTimeZone((TimeZone)tz));
        DateTime endDate = new DateTime(endTime).toDateTime(DateTimeZone.forTimeZone((TimeZone)tz));
        try {
            this.service.addMultipleEvents(rrule, startDate.toDate(), endDate.toDate(), Long.valueOf(duration), tz, agentId, userIds, templateMp, wfProperties, caProperties, Opt.nul((Object)schedulingSource));
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (SchedulerConflictException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)RestUtil.generateErrorResponse((ErrorCodeException)e)).type("application/json").build();
        }
        catch (Exception e) {
            logger.error("Unable to create new events", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @PUT
    @Path(value="{id}")
    @RestQuery(name="updaterecordings", description="Updates specified event", returnDescription="Status OK is returned if event was successfully updated, NOT FOUND if specified event does not exist or BAD REQUEST if data is missing or invalid", pathParameters={@RestParameter(name="id", description="ID of event to be updated", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="start", isRequired=false, description="Updated start date for event", type=RestParameter.Type.INTEGER), @RestParameter(name="end", isRequired=false, description="Updated end date for event", type=RestParameter.Type.INTEGER), @RestParameter(name="agent", isRequired=false, description="Updated agent for event", type=RestParameter.Type.STRING), @RestParameter(name="users", isRequired=false, type=RestParameter.Type.STRING, description="Updated comma separated list of user ids (speakers/lecturers) for the event"), @RestParameter(name="mediaPackage", isRequired=false, description="Updated media package for event", type=RestParameter.Type.TEXT), @RestParameter(name="wfproperties", isRequired=false, description="Workflow configuration properties", type=RestParameter.Type.TEXT), @RestParameter(name="agentparameters", isRequired=false, description="Updated Capture Agent properties", type=RestParameter.Type.TEXT)}, responses={@RestResponse(responseCode=200, description="Event was successfully updated"), @RestResponse(responseCode=404, description="Event with specified ID does not exist"), @RestResponse(responseCode=409, description="Unable to update event, conflicting events found (ConflicsFound)"), @RestResponse(responseCode=409, description="Unable to update event, event locked by a transaction (TransactionLock)"), @RestResponse(responseCode=403, description="Event with specified ID cannot be updated"), @RestResponse(responseCode=401, description="You do not have permission to update the event. Maybe you need to authenticate."), @RestResponse(responseCode=400, description="Data is missing or invalid")})
    public Response updateEvent(@PathParam(value="id") String eventID, @FormParam(value="start") Long startTime, @FormParam(value="end") Long endTime, @FormParam(value="agent") String agentId, @FormParam(value="users") String users, @FormParam(value="mediaPackage") String mediaPackageXml, @FormParam(value="wfproperties") String workflowProperties, @FormParam(value="agentparameters") String agentParameters) throws UnauthorizedException {
        if (startTime != null) {
            if (startTime < 0L) {
                logger.debug("Cannot add event with negative start time ({} < 0)", (Object)startTime);
                return RestUtil.R.badRequest((String)"Cannot add event with negative start time");
            }
            if (endTime != null && endTime <= startTime) {
                logger.debug("Cannot add event without proper end time ({} <= {})", (Object)startTime, (Object)endTime);
                return RestUtil.R.badRequest((String)"Cannot add event without proper end time");
            }
        }
        MediaPackage mediaPackage = null;
        if (StringUtils.isNotBlank((CharSequence)mediaPackageXml)) {
            try {
                mediaPackage = MediaPackageParser.getFromXml((String)mediaPackageXml);
            }
            catch (Exception e) {
                logger.debug("Could not parse media packagey", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        HashMap<Object, Object> caProperties = null;
        if (StringUtils.isNotBlank((CharSequence)agentParameters)) {
            try {
                Properties prop = this.parseProperties(agentParameters);
                caProperties = new HashMap<Object, Object>();
                caProperties.putAll(prop);
            }
            catch (Exception e) {
                logger.debug("Could not parse capture agent properties: {}", (Object)agentParameters, (Object)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        HashMap<Object, Object> wfProperties = null;
        if (StringUtils.isNotBlank((CharSequence)workflowProperties)) {
            try {
                Properties prop = this.parseProperties(workflowProperties);
                wfProperties = new HashMap<Object, Object>();
                wfProperties.putAll(prop);
            }
            catch (IOException e) {
                logger.debug("Could not parse workflow configuration properties: {}", (Object)workflowProperties, (Object)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        HashSet<String> userIds = null;
        String[] ids = StringUtils.split((String)StringUtils.trimToNull((String)users), (String)",");
        if (ids != null) {
            userIds = new HashSet<String>(Arrays.asList(ids));
        }
        Date startDate = null;
        if (startTime != null) {
            startDate = new DateTime((Object)startTime).toDateTime(DateTimeZone.UTC).toDate();
        }
        Date endDate = null;
        if (endTime != null) {
            endDate = new DateTime((Object)endTime).toDateTime(DateTimeZone.UTC).toDate();
        }
        try {
            this.service.updateEvent(eventID, Opt.nul((Object)startDate), Opt.nul((Object)endDate), Opt.nul((Object)StringUtils.trimToNull((String)agentId)), Opt.nul(userIds), Opt.nul((Object)mediaPackage), Opt.nul(wfProperties), Opt.nul(caProperties));
            return Response.ok().build();
        }
        catch (SchedulerConflictException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)RestUtil.generateErrorResponse((ErrorCodeException)e)).type("application/json").build();
        }
        catch (SchedulerException e) {
            logger.warn("Error updating event with id '{}'", (Object)eventID, (Object)e);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (NotFoundException e) {
            logger.info("Event with id '{}' does not exist.", (Object)eventID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to update event with id '{}'", (Object)eventID, (Object)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="currentRecording/{agent}")
    @Produces(value={"text/xml"})
    @RestQuery(name="currentrecording", description="Get the current capture event as XML", returnDescription="The current capture event as XML", pathParameters={@RestParameter(name="agent", isRequired=true, type=RestParameter.Type.STRING, description="The agent identifier")}, responses={@RestResponse(responseCode=200, description="current event is in the body of response"), @RestResponse(responseCode=204, description="There is no current recording")})
    public Response currentRecording(@PathParam(value="agent") String agentId) throws UnauthorizedException {
        try {
            Opt current = this.service.getCurrentRecording(agentId);
            if (current.isNone()) {
                return Response.noContent().build();
            }
            return Response.ok((Object)MediaPackageParser.getAsXml((MediaPackage)((MediaPackage)current.get()))).build();
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to get the current recording for agent '{}'", (Object)agentId, (Object)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="upcomingRecording/{agent}")
    @Produces(value={"text/xml"})
    @RestQuery(name="upcomingrecording", description="Get the upcoming capture event as XML", returnDescription="The upcoming capture event as XML", pathParameters={@RestParameter(name="agent", isRequired=true, type=RestParameter.Type.STRING, description="The agent identifier")}, responses={@RestResponse(responseCode=200, description="upcoming event is in the body of response"), @RestResponse(responseCode=204, description="There is no upcoming recording")})
    public Response upcomingRecording(@PathParam(value="agent") String agentId) throws UnauthorizedException {
        try {
            Opt upcoming = this.service.getUpcomingRecording(agentId);
            if (upcoming.isNone()) {
                return Response.noContent().build();
            }
            return Response.ok((Object)MediaPackageParser.getAsXml((MediaPackage)((MediaPackage)upcoming.get()))).build();
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to get the upcoming recording for agent '{}'", (Object)agentId, (Object)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="eventCount")
    @Produces(value={"text/plain"})
    @RestQuery(name="eventcount", description="Get the number of scheduled events", returnDescription="The number of scheduled events", responses={@RestResponse(responseCode=200, description="The event count")})
    public Response eventCount() throws UnauthorizedException {
        try {
            return Response.ok((Object)("" + this.service.getEventCount())).build();
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to get the event count", (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="recordings.{type:xml|json}")
    @RestQuery(name="recordingsaslist", description="Searches recordings and returns result as XML or JSON", returnDescription="XML or JSON formated results", pathParameters={@RestParameter(name="type", isRequired=true, description="The media type of the response [xml|json]", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="agent", description="Search by device", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="startsfrom", description="Search by when does event start", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="startsto", description="Search by when does event start", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="endsfrom", description="Search by when does event finish", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="endsto", description="Search by when does event finish", isRequired=false, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=200, description="Search completed, results returned in body")})
    public Response getEventsAsList(@PathParam(value="type") String type, @QueryParam(value="agent") String device, @QueryParam(value="startsfrom") Long startsFromTime, @QueryParam(value="startsto") Long startsToTime, @QueryParam(value="endsfrom") Long endsFromTime, @QueryParam(value="endsto") Long endsToTime) throws UnauthorizedException {
        Date startsfrom = null;
        Date startsTo = null;
        Date endsFrom = null;
        Date endsTo = null;
        if (startsFromTime != null) {
            startsfrom = new DateTime((Object)startsFromTime).toDateTime(DateTimeZone.UTC).toDate();
        }
        if (startsToTime != null) {
            startsTo = new DateTime((Object)startsToTime).toDateTime(DateTimeZone.UTC).toDate();
        }
        if (endsFromTime != null) {
            endsFrom = new DateTime((Object)endsFromTime).toDateTime(DateTimeZone.UTC).toDate();
        }
        if (endsToTime != null) {
            endsTo = new DateTime((Object)endsToTime).toDateTime(DateTimeZone.UTC).toDate();
        }
        try {
            List events = this.service.search(Opt.nul((Object)StringUtils.trimToNull((String)device)), Opt.nul((Object)startsfrom), Opt.nul((Object)startsTo), Opt.nul((Object)endsFrom), Opt.nul((Object)endsTo));
            if ("json".equalsIgnoreCase(type)) {
                return Response.ok((Object)this.getEventListAsJsonString(events)).build();
            }
            return Response.ok((Object)MediaPackageParser.getArrayAsXml((List)events)).build();
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to perform search: {}", (Object)ExceptionUtils.getMessage((Throwable)e));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="conflicts.json")
    @RestQuery(name="conflictingrecordingsasjson", description="Searches for conflicting recordings based on parameters", returnDescription="Returns NO CONTENT if no recordings are in conflict within specified period or list of conflicting recordings in JSON", restParameters={@RestParameter(name="agent", description="Device identifier for which conflicts will be searched", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="start", description="Start time of conflicting period, in milliseconds", isRequired=true, type=RestParameter.Type.INTEGER), @RestParameter(name="end", description="End time of conflicting period, in milliseconds", isRequired=true, type=RestParameter.Type.INTEGER), @RestParameter(name="rrule", description="Rule for recurrent conflicting, specified as: \"FREQ=WEEKLY;BYDAY=day(s);BYHOUR=hour;BYMINUTE=minute\". FREQ is required. BYDAY may include one or more (separated by commas) of the following: SU,MO,TU,WE,TH,FR,SA.", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="duration", description="If recurrence rule is specified duration of each conflicting period, in milliseconds", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="timezone", description="The timezone of the capture device", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=204, description="No conflicting events found"), @RestResponse(responseCode=200, description="Found conflicting events, returned in body of response"), @RestResponse(responseCode=400, description="Missing or invalid parameters"), @RestResponse(responseCode=401, description="Not authorized to make this request"), @RestResponse(responseCode=500, description="A detailed stack track of the internal issue.")})
    public Response getConflictingEventsJson(@QueryParam(value="agent") String device, @QueryParam(value="rrule") String rrule, @QueryParam(value="start") Long startDate, @QueryParam(value="end") Long endDate, @QueryParam(value="duration") Long duration, @QueryParam(value="timezone") String timezone) throws UnauthorizedException {
        try {
            List<MediaPackage> events = this.getConflictingEvents(device, rrule, startDate, endDate, duration, timezone);
            if (!events.isEmpty()) {
                String eventsJsonString = this.getEventListAsJsonString(events);
                return Response.ok((Object)eventsJsonString).build();
            }
            return Response.noContent().build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to find conflicting events for {}, {}, {}, {}, {}:", new Object[]{device, rrule, startDate, endDate, duration, e});
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="conflicts.{type:xml|json}")
    @RestQuery(name="conflictingrecordings", description="Searches for conflicting recordings based on parameters and returns result as XML or JSON", returnDescription="Returns NO CONTENT if no recordings are in conflict within specified period or list of conflicting recordings in XML or JSON", pathParameters={@RestParameter(name="type", isRequired=true, description="The media type of the response [xml|json]", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="agent", description="Device identifier for which conflicts will be searched", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="start", description="Start time of conflicting period, in milliseconds", isRequired=true, type=RestParameter.Type.INTEGER), @RestParameter(name="end", description="End time of conflicting period, in milliseconds", isRequired=true, type=RestParameter.Type.INTEGER), @RestParameter(name="rrule", description="Rule for recurrent conflicting, specified as: \"FREQ=WEEKLY;BYDAY=day(s);BYHOUR=hour;BYMINUTE=minute\". FREQ is required. BYDAY may include one or more (separated by commas) of the following: SU,MO,TU,WE,TH,FR,SA.", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="duration", description="If recurrence rule is specified duration of each conflicting period, in milliseconds", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="timezone", description="The timezone of the capture device", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=204, description="No conflicting events found"), @RestResponse(responseCode=200, description="Found conflicting events, returned in body of response"), @RestResponse(responseCode=400, description="Missing or invalid parameters"), @RestResponse(responseCode=401, description="Not authorized to make this request"), @RestResponse(responseCode=500, description="A detailed stack track of the internal issue.")})
    public Response getConflicts(@PathParam(value="type") String type, @QueryParam(value="agent") String device, @QueryParam(value="rrule") String rrule, @QueryParam(value="start") Long startDate, @QueryParam(value="end") Long endDate, @QueryParam(value="duration") Long duration, @QueryParam(value="timezone") String timezone) throws UnauthorizedException {
        if (StringUtils.isBlank((CharSequence)timezone)) {
            timezone = DateTimeZone.getDefault().toString();
        }
        try {
            List<MediaPackage> events = this.getConflictingEvents(device, rrule, startDate, endDate, duration, timezone);
            if (!events.isEmpty()) {
                if ("json".equalsIgnoreCase(type)) {
                    return Response.ok((Object)this.getEventListAsJsonString(events)).build();
                }
                return Response.ok((Object)MediaPackageParser.getArrayAsXml(events)).build();
            }
            return Response.noContent().build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to find conflicting events for {}, {}, {}, {}, {}", new Object[]{device, rrule, startDate, endDate, duration, e});
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="{id}/recordingStatus")
    @RestQuery(name="updateRecordingState", description="Set the status of a given recording, registering it if it is new", pathParameters={@RestParameter(description="The ID of a given recording", isRequired=true, name="id", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(description="The state of the recording. Must be one of the following: unknown, capturing, capture_finished, capture_error, manifest, manifest_error, manifest_finished, compressing, compressing_error, uploading, upload_finished, upload_error.", isRequired=true, name="state", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="{id} set to {state}", responseCode=200), @RestResponse(description="{id} or state {state} is empty or the {state} is not known", responseCode=400), @RestResponse(description="Recording with {id} could not be found", responseCode=404)}, returnDescription="")
    public Response updateRecordingState(@PathParam(value="id") String id, @FormParam(value="state") String state) throws NotFoundException {
        if (StringUtils.isEmpty((CharSequence)id) || StringUtils.isEmpty((CharSequence)state)) {
            return Response.serverError().status(Response.Status.BAD_REQUEST).build();
        }
        try {
            if (this.service.updateRecordingState(id, state)) {
                return Response.ok((Object)(id + " set to " + state)).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (SchedulerException e) {
            logger.debug("Unable to set recording state of {}:", (Object)id, (Object)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{id}/recordingStatus")
    @RestQuery(name="getRecordingState", description="Return the state of a given recording", pathParameters={@RestParameter(description="The ID of a given recording", isRequired=true, name="id", type=RestParameter.Type.STRING)}, restParameters={}, responses={@RestResponse(description="Returns the state of the recording with the correct id", responseCode=200), @RestResponse(description="The recording with the specified ID does not exist", responseCode=404)}, returnDescription="")
    public Response getRecordingState(@PathParam(value="id") String id) throws NotFoundException {
        try {
            Recording rec = this.service.getRecordingState(id);
            return RestUtil.R.ok((Jsons.Obj)Jsons.obj((Jsons.Prop[])new Jsons.Prop[]{Jsons.p((String)"id", (String)rec.getID()), Jsons.p((String)"state", (String)rec.getState()), Jsons.p((String)"lastHeardFrom", (Number)rec.getLastCheckinTime())}));
        }
        catch (SchedulerException e) {
            logger.debug("Unable to get recording state of {}:", (Object)id, (Object)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="{id}/recordingStatus")
    @RestQuery(name="removeRecording", description="Remove record of a given recording", pathParameters={@RestParameter(description="The ID of a given recording", isRequired=true, name="id", type=RestParameter.Type.STRING)}, restParameters={}, responses={@RestResponse(description="{id} removed", responseCode=200), @RestResponse(description="{id} is empty", responseCode=400), @RestResponse(description="Recording with {id} could not be found", responseCode=404)}, returnDescription="")
    public Response removeRecording(@PathParam(value="id") String id) throws NotFoundException {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return Response.serverError().status(Response.Status.BAD_REQUEST).build();
        }
        try {
            this.service.removeRecording(id);
            return Response.ok((Object)(id + " removed")).build();
        }
        catch (SchedulerException e) {
            logger.debug("Unable to remove recording with id '{}':", (Object)id, (Object)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="recordingStatus")
    @RestQuery(name="getAllRecordings", description="Return all registered recordings and their state", pathParameters={}, restParameters={}, responses={@RestResponse(description="Returns all known recordings.", responseCode=200)}, returnDescription="")
    public Response getAllRecordings() {
        try {
            ArrayList<Jsons.Obj> update = new ArrayList<Jsons.Obj>();
            for (Map.Entry e : this.service.getKnownRecordings().entrySet()) {
                update.add(Jsons.obj((Jsons.Prop[])new Jsons.Prop[]{Jsons.p((String)"id", (String)((Recording)e.getValue()).getID()), Jsons.p((String)"state", (String)((Recording)e.getValue()).getState()), Jsons.p((String)"lastHeardFrom", (Number)((Recording)e.getValue()).getLastCheckinTime())}));
            }
            return RestUtil.R.ok((Object)Jsons.arr(update).toJson());
        }
        catch (SchedulerException e) {
            logger.debug("Unable to get all recordings:", (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="capture/{agent}")
    @Produces(value={"application/json"})
    @RestQuery(name="currentcapture", description="Get the current capture event catalog as JSON", returnDescription="The current capture event catalog as JSON", pathParameters={@RestParameter(name="agent", isRequired=true, type=RestParameter.Type.STRING, description="The agent identifier")}, responses={@RestResponse(responseCode=200, description="DublinCore of current capture event is in the body of response"), @RestResponse(responseCode=404, description="There is no ongoing recording"), @RestResponse(responseCode=503, description="The agent is not ready to communicate")})
    public Response currentCapture(@PathParam(value="agent") String agentId) throws NotFoundException {
        if (this.service == null || this.agentService == null) {
            return Response.serverError().status(Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Scheduler service is unavailable, please wait...").build();
        }
        try {
            Opt current = this.service.getCurrentRecording(agentId);
            if (current.isNone()) {
                logger.info("No recording to stop found for agent '{}'!", (Object)agentId);
                throw new NotFoundException("No recording to stop found for agent: " + agentId);
            }
            DublinCoreCatalog catalog = (DublinCoreCatalog)DublinCoreUtil.loadEpisodeDublinCore((Workspace)this.workspace, (MediaPackage)((MediaPackage)current.get())).get();
            return Response.ok((Object)catalog.toJson()).build();
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to get the immediate recording for agent '{}': {}", (Object)agentId, (Object)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="capture/{agent}/upcoming")
    @Produces(value={"application/json"})
    @RestQuery(name="upcomingcapture", description="Get the upcoming capture event catalog as JSON", returnDescription="The upcoming capture event catalog as JSON", pathParameters={@RestParameter(name="agent", isRequired=true, type=RestParameter.Type.STRING, description="The agent identifier")}, responses={@RestResponse(responseCode=200, description="DublinCore of the upcomfing capture event is in the body of response"), @RestResponse(responseCode=404, description="There is no upcoming recording"), @RestResponse(responseCode=503, description="The agent is not ready to communicate")})
    public Response upcomingCapture(@PathParam(value="agent") String agentId) throws NotFoundException {
        if (this.service == null || this.agentService == null) {
            return Response.serverError().status(Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Scheduler service is unavailable, please wait...").build();
        }
        try {
            Opt upcoming = this.service.getUpcomingRecording(agentId);
            if (upcoming.isNone()) {
                logger.info("No recording to stop found for agent '{}'!", (Object)agentId);
                throw new NotFoundException("No recording to stop found for agent: " + agentId);
            }
            DublinCoreCatalog catalog = (DublinCoreCatalog)DublinCoreUtil.loadEpisodeDublinCore((Workspace)this.workspace, (MediaPackage)((MediaPackage)upcoming.get())).get();
            return Response.ok((Object)catalog.toJson()).build();
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to get the immediate recording for agent '{}': {}", (Object)agentId, (Object)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    /*
     * Exception decompiling
     */
    @POST
    @Path(value="capture/{agent}")
    @RestQuery(name="startcapture", description="Create an immediate event", returnDescription="If events were successfully generated, status CREATED is returned", pathParameters={@RestParameter(name="agent", isRequired=true, type=RestParameter.Type.STRING, description="The agent identifier")}, restParameters={@RestParameter(name="workflowDefinitionId", isRequired=false, type=RestParameter.Type.STRING, description="The workflow definition id to use")}, responses={@RestResponse(responseCode=201, description="Recording started"), @RestResponse(responseCode=404, description="There is no such agent"), @RestResponse(responseCode=409, description="The agent is already recording"), @RestResponse(responseCode=401, description="You do not have permission to start this immediate capture. Maybe you need to authenticate."), @RestResponse(responseCode=503, description="The agent is not ready to communicate")})
    public Response startCapture(@PathParam(value="agent") String agentId, @FormParam(value="workflowDefinitionId") String wfId) throws NotFoundException, UnauthorizedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @DELETE
    @Path(value="capture/{agent}")
    @Produces(value={"text/plain"})
    @RestQuery(name="stopcapture", description="Stops an immediate capture.", returnDescription="OK if event were successfully stopped", pathParameters={@RestParameter(name="agent", isRequired=true, description="The agent identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Recording stopped"), @RestResponse(responseCode=304, description="The recording was already stopped"), @RestResponse(responseCode=404, description="There is no such agent"), @RestResponse(responseCode=401, description="You do not have permission to stop this immediate capture. Maybe you need to authenticate."), @RestResponse(responseCode=503, description="The agent is not ready to communicate")})
    public Response stopCapture(@PathParam(value="agent") String agentId) throws NotFoundException, UnauthorizedException {
        String eventId;
        DublinCoreCatalog eventCatalog;
        MediaPackage mp;
        if (this.service == null) return Response.serverError().status(Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Scheduler service is unavailable, please wait...").build();
        if (this.agentService == null) return Response.serverError().status(Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Scheduler service is unavailable, please wait...").build();
        if (this.prolongingService == null) {
            return Response.serverError().status(Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Scheduler service is unavailable, please wait...").build();
        }
        boolean isAdHoc = false;
        try {
            Agent agent = this.agentService.getAgent(agentId);
            String registrationType = (String)agent.getConfiguration().get("org.opencastproject.registration.type");
            isAdHoc = "ad-hoc".equals(registrationType);
        }
        catch (NotFoundException e) {
            logger.debug("Temporarily registered agent '{}' for ad-hoc recording already removed", (Object)agentId);
        }
        try {
            Opt current = this.service.getCurrentRecording(agentId);
            if (current.isNone()) {
                logger.info("No recording to stop found for agent '{}'!", (Object)agentId);
                Response response = Response.notModified().build();
                return response;
            }
            mp = (MediaPackage)current.get();
            eventCatalog = (DublinCoreCatalog)DublinCoreUtil.loadEpisodeDublinCore((Workspace)this.workspace, (MediaPackage)mp).get();
            eventId = mp.getIdentifier().toString();
        }
        catch (Exception e) {
            logger.error("Unable to get the immediate recording for agent '{}': {}", (Object)agentId, (Object)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        try {
            DCMIPeriod period = EncodingSchemeUtils.decodeMandatoryPeriod((String)eventCatalog.getFirst(DublinCore.PROPERTY_TEMPORAL));
            eventCatalog.set(DublinCore.PROPERTY_TEMPORAL, EncodingSchemeUtils.encodePeriod((DCMIPeriod)new DCMIPeriod(period.getStart(), new Date()), (Precision)Precision.Second));
            mp = this.addCatalog(this.workspace, IOUtils.toInputStream((String)eventCatalog.toXmlString(), (String)"UTF-8"), "dublincore.xml", MediaPackageElements.EPISODE, mp);
            this.service.updateEvent(eventId, Opt.none(), Opt.none(), Opt.none(), Opt.none(), Opt.some((Object)mp), Opt.none(), Opt.none());
            this.prolongingService.stop(agentId);
            return Response.ok().build();
        }
        catch (UnauthorizedException e) {
            throw e;
            catch (Exception e2) {
                logger.error("Unable to update the temporal of event '{}': {}", (Object)eventId, (Object)e2);
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        finally {
            if (isAdHoc) {
                this.agentService.removeAgent(agentId);
                logger.info("Removed temporary agent registration '{}'", (Object)agentId);
            }
        }
    }

    @PUT
    @Path(value="capture/{agent}/prolong")
    @Produces(value={"text/plain"})
    @RestQuery(name="prolongcapture", description="Prolong an immediate capture.", returnDescription="OK if event were successfully prolonged", pathParameters={@RestParameter(name="agent", isRequired=true, description="The agent identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Recording prolonged"), @RestResponse(responseCode=404, description="No recording found for prolonging"), @RestResponse(responseCode=401, description="You do not have permission to prolong this immediate capture. Maybe you need to authenticate."), @RestResponse(responseCode=503, description="The agent is not ready to communicate")})
    public Response prolongCapture(@PathParam(value="agent") String agentId) throws NotFoundException, UnauthorizedException {
        if (this.service == null || this.agentService == null || this.prolongingService == null) {
            return Response.serverError().status(Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Scheduler service is unavailable, please wait...").build();
        }
        try {
            MediaPackage event = this.prolongingService.getCurrentRecording(agentId);
            DublinCoreCatalog dc = (DublinCoreCatalog)DublinCoreUtil.loadEpisodeDublinCore((Workspace)this.workspace, (MediaPackage)event).get();
            this.prolongingService.prolongEvent(event, dc, agentId);
            return Response.ok().build();
        }
        catch (UnauthorizedException | NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to prolong the immediate recording for agent '{}': {}", (Object)agentId, (Object)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private List<MediaPackage> getConflictingEvents(String device, String rrule, Long startDate, Long endDate, Long duration, String timezone) throws IllegalArgumentException, UnauthorizedException, SchedulerException {
        List events = null;
        if (StringUtils.isBlank((CharSequence)device) || startDate == null || endDate == null) {
            logger.info("Either agent, start date or end date were not specified");
            throw new IllegalArgumentException();
        }
        RRule rule = null;
        if (StringUtils.isNotBlank((CharSequence)rrule)) {
            if (duration == null || StringUtils.isBlank((CharSequence)timezone)) {
                logger.info("Either duration or timezone were not specified");
                throw new IllegalArgumentException();
            }
            try {
                rule = new RRule(rrule);
                rule.validate();
            }
            catch (Exception e) {
                logger.info("Unable to parse rrule {}: {}", (Object)rrule, (Object)ExceptionUtils.getMessage((Throwable)e));
                throw new IllegalArgumentException();
            }
            if (!Arrays.asList(TimeZone.getAvailableIDs()).contains(timezone)) {
                logger.info("Unable to parse timezone: {}", (Object)timezone);
                throw new IllegalArgumentException();
            }
        }
        Date start = new DateTime((Object)startDate).toDateTime(DateTimeZone.UTC).toDate();
        Date end = new DateTime((Object)endDate).toDateTime(DateTimeZone.UTC).toDate();
        events = StringUtils.isNotBlank((CharSequence)rrule) ? this.service.findConflictingEvents(device, rule, start, end, duration.longValue(), TimeZone.getTimeZone(timezone)) : this.service.findConflictingEvents(device, start, end);
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaPackage addCatalog(Workspace workspace, InputStream in, String fileName, MediaPackageElementFlavor flavor, MediaPackage mediaPackage) throws IOException {
        Catalog[] catalogs = mediaPackage.getCatalogs(flavor);
        Catalog c = null;
        if (catalogs.length == 1) {
            c = catalogs[0];
        }
        if (c == null) {
            c = (Catalog)MediaPackageElementBuilderFactory.newInstance().newElementBuilder().newElement(MediaPackageElement.Type.Catalog, flavor);
            c.setIdentifier(UUID.randomUUID().toString());
            logger.info("Adding catalog with flavor {} to mediapackage {}", (Object)flavor, (Object)mediaPackage);
            mediaPackage.add(c);
        }
        try {
            URI catalogUrl = workspace.put(mediaPackage.getIdentifier().toString(), c.getIdentifier(), fileName, in);
            c.setURI(catalogUrl);
            c.setChecksum(null);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return mediaPackage;
    }

    private String serializeProperties(Map<String, String> properties) {
        StringBuilder wfPropertiesString = new StringBuilder();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            wfPropertiesString.append(entry.getKey() + "=" + entry.getValue() + "\n");
        }
        return wfPropertiesString.toString();
    }

    private Properties parseProperties(String serializedProperties) throws IOException {
        Properties caProperties = new Properties();
        logger.debug("properties: {}", (Object)serializedProperties);
        caProperties.load(new StringReader(serializedProperties));
        return caProperties;
    }

    public String getEventListAsJsonString(List<MediaPackage> mpList) throws SchedulerException {
        JSONParser parser = new JSONParser();
        JSONObject jsonObj = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        for (MediaPackage mp : mpList) {
            try {
                JSONObject mpJson = (JSONObject)parser.parse(MediaPackageParser.getAsJSON((MediaPackage)mp));
                mpJson = (JSONObject)mpJson.get((Object)"mediapackage");
                jsonArray.add((Object)mpJson);
            }
            catch (ParseException e) {
                logger.warn("Unexpected JSON parse exception for getAsJSON on mp {}", (Object)mp.getIdentifier().toString(), (Object)e);
                throw new SchedulerException((Throwable)e);
            }
        }
        jsonObj.put((Object)"totalCount", (Object)String.valueOf(mpList.size()));
        jsonObj.put((Object)"events", (Object)jsonArray);
        return jsonObj.toJSONString();
    }
}

