/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.scheduler.impl.persistence;

import com.entwinemedia.fn.data.Opt;
import com.google.gson.Gson;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.joda.time.DateTime;
import org.opencastproject.scheduler.impl.SchedulerServiceDatabase;
import org.opencastproject.scheduler.impl.SchedulerServiceDatabaseException;
import org.opencastproject.scheduler.impl.persistence.EventIdPK;
import org.opencastproject.scheduler.impl.persistence.ExtendedEventDto;
import org.opencastproject.scheduler.impl.persistence.LastModifiedDto;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.util.NotFoundException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={SchedulerServiceDatabase.class})
public class SchedulerServiceDatabaseImpl
implements SchedulerServiceDatabase {
    public static final String PERSISTENCE_UNIT = "org.opencastproject.scheduler.impl.persistence";
    private static final Logger logger = LoggerFactory.getLogger(SchedulerServiceDatabaseImpl.class);
    private EntityManagerFactory emf;
    private SecurityService securityService;
    private static final Gson gson = new Gson();

    @Reference(target="(osgi.unit.name=org.opencastproject.scheduler.impl.persistence)")
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Activate
    public void activate(ComponentContext cc) {
        logger.info("Activating persistence manager for scheduler");
    }

    @Override
    public synchronized void touchLastEntry(String agentId) throws SchedulerServiceDatabaseException {
        EntityTransaction tx = null;
        try (EntityManager em = null;){
            em = this.emf.createEntityManager();
            tx = em.getTransaction();
            tx.begin();
            LastModifiedDto entity = (LastModifiedDto)em.find(LastModifiedDto.class, (Object)agentId);
            if (entity == null) {
                entity = new LastModifiedDto();
                entity.setCaptureAgentId(agentId);
                entity.setLastModifiedDate(new Date());
                em.persist((Object)entity);
            } else {
                entity.setLastModifiedDate(new Date());
                em.merge((Object)entity);
            }
            tx.commit();
        }
    }

    @Override
    public Date getLastModified(String agentId) throws NotFoundException, SchedulerServiceDatabaseException {
        try (EntityManager em = null;){
            em = this.emf.createEntityManager();
            LastModifiedDto entity = (LastModifiedDto)em.find(LastModifiedDto.class, (Object)agentId);
            if (entity == null) {
                throw new NotFoundException("Agent with ID " + agentId + " does not exist");
            }
            Date date = entity.getLastModifiedDate();
            return date;
        }
    }

    @Override
    public Map<String, Date> getLastModifiedDates() throws SchedulerServiceDatabaseException {
        try (EntityManager em = null;){
            em = this.emf.createEntityManager();
            Query q = em.createNamedQuery("LastModified.findAll");
            List resultList = q.getResultList();
            HashMap<String, Date> dates = new HashMap<String, Date>();
            for (LastModifiedDto dto : resultList) {
                dates.put(dto.getCaptureAgentId(), dto.getLastModifiedDate());
            }
            HashMap<String, Date> hashMap = dates;
            return hashMap;
        }
    }

    @Override
    public void storeEvent(String mediapackageId, String organizationId, Opt<String> captureAgentId, Opt<Date> start, Opt<Date> end, Opt<String> source, Opt<String> recordingState, Opt<Long> recordingLastHeard, Opt<String> presenters, Opt<Date> lastModifiedDate, Opt<String> checksum, Opt<Map<String, String>> workflowProperties, Opt<Map<String, String>> caProperties) throws SchedulerServiceDatabaseException {
        EntityTransaction tx = null;
        try (EntityManager em = null;){
            em = this.emf.createEntityManager();
            tx = em.getTransaction();
            tx.begin();
            Opt<ExtendedEventDto> entityOpt = this.getExtendedEventDto(mediapackageId, organizationId, em);
            ExtendedEventDto entity = (ExtendedEventDto)entityOpt.getOr((Object)new ExtendedEventDto());
            entity.setMediaPackageId(mediapackageId);
            entity.setOrganization(organizationId);
            if (captureAgentId.isSome()) {
                entity.setCaptureAgentId((String)captureAgentId.get());
            }
            if (start.isSome()) {
                entity.setStartDate((Date)start.get());
            }
            if (end.isSome()) {
                entity.setEndDate((Date)end.get());
            }
            if (source.isSome()) {
                entity.setSource((String)source.get());
            }
            if (recordingState.isSome()) {
                entity.setRecordingState((String)recordingState.get());
            }
            if (recordingLastHeard.isSome()) {
                entity.setRecordingLastHeard((Long)recordingLastHeard.get());
            }
            if (presenters.isSome()) {
                entity.setPresenters((String)presenters.get());
            }
            if (lastModifiedDate.isSome()) {
                entity.setLastModifiedDate((Date)lastModifiedDate.get());
            }
            if (checksum.isSome()) {
                entity.setChecksum((String)checksum.get());
            }
            if (workflowProperties.isSome()) {
                entity.setWorkflowProperties(gson.toJson(workflowProperties.get()));
            }
            if (caProperties.isSome()) {
                entity.setCaptureAgentProperties(gson.toJson(caProperties.get()));
            }
            if (entityOpt.isNone()) {
                em.persist((Object)entity);
            } else {
                em.merge((Object)entity);
            }
            tx.commit();
        }
    }

    @Override
    public List<String> getEvents(String captureAgentId, Date start, Date end, int separationMillis) throws SchedulerServiceDatabaseException {
        Date extendedStart = Date.from(start.toInstant().minusMillis(separationMillis));
        Date extendedEnd = Date.from(end.toInstant().plusMillis(separationMillis));
        EntityManager em = this.emf.createEntityManager();
        Query query = em.createNamedQuery("ExtendedEvent.findEvents").setParameter("org", (Object)this.securityService.getOrganization().getId()).setParameter("ca", (Object)captureAgentId).setParameter("start", (Object)extendedStart).setParameter("end", (Object)extendedEnd);
        try {
            List list = query.getResultList();
            return list;
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
        finally {
            em.close();
        }
    }

    @Override
    public List<ExtendedEventDto> search(Opt<String> captureAgentId, Opt<Date> optStartsFrom, Opt<Date> optStartsTo, Opt<Date> optEndFrom, Opt<Date> optEndTo, Opt<Integer> limit) throws SchedulerServiceDatabaseException {
        EntityManager em = this.emf.createEntityManager();
        Date startsFrom = (Date)optStartsFrom.getOr((Object)new Date(0L));
        Date farIntoTheFuture = DateTime.now().plusYears(30).toDate();
        Date startsTo = (Date)optStartsTo.getOr((Object)farIntoTheFuture);
        Date endFrom = (Date)optEndFrom.getOr((Object)new Date(0L));
        Date endTo = (Date)optEndTo.getOr((Object)farIntoTheFuture);
        Query query = captureAgentId.isSome() ? em.createNamedQuery("ExtendedEvent.searchEventsCA").setParameter("org", (Object)this.securityService.getOrganization().getId()).setParameter("ca", captureAgentId.get()).setParameter("startFrom", (Object)startsFrom).setParameter("startTo", (Object)startsTo).setParameter("endFrom", (Object)endFrom).setParameter("endTo", (Object)endTo) : em.createNamedQuery("ExtendedEvent.searchEvents").setParameter("org", (Object)this.securityService.getOrganization().getId()).setParameter("startFrom", (Object)startsFrom).setParameter("startTo", (Object)startsTo).setParameter("endFrom", (Object)endFrom).setParameter("endTo", (Object)endTo);
        try {
            if (limit.isSome()) {
                List list = query.setMaxResults(((Integer)limit.get()).intValue()).getResultList();
                return list;
            }
            List list = query.getResultList();
            return list;
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
        finally {
            em.close();
        }
    }

    @Override
    public List<ExtendedEventDto> getKnownRecordings() throws SchedulerServiceDatabaseException {
        EntityManager em = this.emf.createEntityManager();
        Query query = em.createNamedQuery("ExtendedEvent.knownRecordings").setParameter("org", (Object)this.securityService.getOrganization().getId());
        try {
            List list = query.getResultList();
            return list;
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
        finally {
            em.close();
        }
    }

    @Override
    public void deleteEvent(String mediapackageId) throws NotFoundException, SchedulerServiceDatabaseException {
        EntityTransaction tx = null;
        try (EntityManager em = null;){
            em = this.emf.createEntityManager();
            tx = em.getTransaction();
            tx.begin();
            String orgId = this.securityService.getOrganization().getId();
            Opt<ExtendedEventDto> entity = this.getExtendedEventDto(mediapackageId, orgId, em);
            if (entity.isNone()) {
                throw new NotFoundException("Event with ID " + mediapackageId + " does not exist");
            }
            em.remove(entity.get());
            tx.commit();
        }
    }

    @Override
    public List<ExtendedEventDto> getEvents() throws SchedulerServiceDatabaseException {
        String organization = this.securityService.getOrganization().getId();
        try (EntityManager em = null;){
            em = this.emf.createEntityManager();
            TypedQuery query = em.createNamedQuery("ExtendedEvent.findAll", ExtendedEventDto.class).setParameter("org", (Object)organization);
            List list = query.getResultList();
            return list;
        }
    }

    @Override
    public Opt<ExtendedEventDto> getEvent(String mediapackageId, String orgId) throws SchedulerServiceDatabaseException {
        try (EntityManager em = null;){
            em = this.emf.createEntityManager();
            Opt<ExtendedEventDto> opt = this.getExtendedEventDto(mediapackageId, orgId, em);
            return opt;
        }
    }

    @Override
    public Opt<ExtendedEventDto> getEvent(String mediapackageId) throws SchedulerServiceDatabaseException {
        try {
            String orgId = this.securityService.getOrganization().getId();
            return this.getEvent(mediapackageId, orgId);
        }
        catch (SchedulerServiceDatabaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
    }

    @Override
    public void resetRecordingState(String mediapackageId) throws NotFoundException, SchedulerServiceDatabaseException {
        EntityTransaction tx = null;
        try (EntityManager em = null;){
            em = this.emf.createEntityManager();
            tx = em.getTransaction();
            tx.begin();
            String orgId = this.securityService.getOrganization().getId();
            Opt<ExtendedEventDto> entity = this.getExtendedEventDto(mediapackageId, orgId, em);
            if (entity.isNone()) {
                throw new NotFoundException("Event with ID " + mediapackageId + " does not exist");
            }
            ((ExtendedEventDto)entity.get()).setRecordingState(null);
            ((ExtendedEventDto)entity.get()).setRecordingLastHeard(null);
            em.merge((Object)((ExtendedEventDto)entity.get()));
            tx.commit();
        }
    }

    @Override
    public int countEvents() throws SchedulerServiceDatabaseException {
        EntityManager em = this.emf.createEntityManager();
        Query query = em.createNamedQuery("ExtendedEvent.countAll");
        try {
            Number total = (Number)query.getSingleResult();
            int n = total.intValue();
            return n;
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
        finally {
            em.close();
        }
    }

    private Opt<ExtendedEventDto> getExtendedEventDto(String id, String orgId, EntityManager em) {
        return Opt.nul((Object)((ExtendedEventDto)em.find(ExtendedEventDto.class, (Object)new EventIdPK(id, orgId))));
    }
}

