/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.search.remote;

import java.io.InputStream;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobParser;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.search.api.SearchException;
import org.opencastproject.search.api.SearchQuery;
import org.opencastproject.search.api.SearchResult;
import org.opencastproject.search.api.SearchResultImpl;
import org.opencastproject.search.api.SearchService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchServiceRemoteImpl
extends RemoteBase
implements SearchService {
    private static final Logger logger = LoggerFactory.getLogger(SearchServiceRemoteImpl.class);

    public SearchServiceRemoteImpl() {
        super("org.opencastproject.search");
    }

    public Job add(MediaPackage mediaPackage) throws SearchException {
        HttpPost post = new HttpPost("/add");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("mediapackage", MediaPackageParser.getAsXml((MediaPackage)mediaPackage)));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new SearchException("Unable to assemble a remote search request for mediapackage " + mediaPackage, (Throwable)e);
        }
        HttpResponse response = this.getResponse((HttpRequestBase)post);
        try {
            if (response != null) {
                Job job = JobParser.parseJob((InputStream)response.getEntity().getContent());
                logger.info("Publishing mediapackage '{}' using a remote search service", (Object)mediaPackage.getIdentifier());
                Job job2 = job;
                return job2;
            }
        }
        catch (Exception e) {
            throw new SearchException("Unable to publish " + mediaPackage.getIdentifier() + " using a remote search service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SearchException("Unable to publish " + mediaPackage.getIdentifier() + " using a remote search service");
    }

    public Job delete(String mediaPackageId) throws SearchException {
        HttpDelete del = new HttpDelete(mediaPackageId);
        HttpResponse response = this.getResponse((HttpRequestBase)del);
        try {
            if (response != null) {
                Job job = JobParser.parseJob((InputStream)response.getEntity().getContent());
                logger.info("Removing mediapackage '{}' from a remote search service", (Object)mediaPackageId);
                Job job2 = job;
                return job2;
            }
        }
        catch (Exception e) {
            throw new SearchException("Unable to remove " + mediaPackageId + " from a remote search service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SearchException("Unable to remove " + mediaPackageId + " from a remote search service");
    }

    public Job deleteSeries(String seriesId) throws SearchException {
        HttpDelete del = new HttpDelete("/deleteSeries/" + seriesId);
        HttpResponse response = this.getResponse((HttpRequestBase)del);
        try {
            if (response != null) {
                Job job = JobParser.parseJob((InputStream)response.getEntity().getContent());
                logger.info("Removing Series '{}' from a remote search service", (Object)seriesId);
                Job job2 = job;
                return job2;
            }
        }
        catch (Exception e) {
            throw new SearchException("Unable to remove " + seriesId + " from a remote search service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SearchException("Unable to remove " + seriesId + " from a remote search service");
    }

    public SearchResult getByQuery(SearchQuery q) throws SearchException {
        HttpGet get = new HttpGet(this.getSearchUrl(q, false));
        HttpResponse response = this.getResponse((HttpRequestBase)get);
        try {
            if (response != null) {
                SearchResultImpl searchResultImpl = SearchResultImpl.valueOf((InputStream)response.getEntity().getContent());
                return searchResultImpl;
            }
        }
        catch (Exception e) {
            throw new SearchException("Unable to parse results of a getByQuery request from remote search index: ", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SearchException("Unable to perform getByQuery from remote search index");
    }

    public SearchResult getForAdministrativeRead(SearchQuery q) throws SearchException, UnauthorizedException {
        HttpGet get = new HttpGet(this.getSearchUrl(q, true));
        HttpResponse response = this.getResponse((HttpRequestBase)get);
        try {
            if (response != null) {
                SearchResultImpl searchResultImpl = SearchResultImpl.valueOf((InputStream)response.getEntity().getContent());
                return searchResultImpl;
            }
        }
        catch (Exception e) {
            throw new SearchException("Unable to parse results of a getForAdministrativeRead request from remote search index: ", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SearchException("Unable to perform getForAdministrativeRead from remote search index");
    }

    public SearchResult getByQuery(String query, int limit, int offset) throws SearchException {
        ArrayList<BasicNameValuePair> queryStringParams = new ArrayList<BasicNameValuePair>();
        queryStringParams.add(new BasicNameValuePair("q", query));
        queryStringParams.add(new BasicNameValuePair("limit", Integer.toString(limit)));
        queryStringParams.add(new BasicNameValuePair("offset", Integer.toString(offset)));
        queryStringParams.add(new BasicNameValuePair("admin", Boolean.TRUE.toString()));
        HttpGet get = new HttpGet("/lucene.xml?" + URLEncodedUtils.format(queryStringParams, (String)"UTF-8"));
        logger.debug("Sending remote query '{}'", (Object)get.getRequestLine().toString());
        HttpResponse response = this.getResponse((HttpRequestBase)get);
        try {
            if (response != null) {
                SearchResultImpl searchResultImpl = SearchResultImpl.valueOf((InputStream)response.getEntity().getContent());
                return searchResultImpl;
            }
        }
        catch (Exception e) {
            throw new SearchException("Unable to parse getByQuery response from remote search index", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SearchException("Unable to perform getByQuery from remote search index");
    }

    private String getSearchUrl(SearchQuery q, boolean admin) {
        StringBuilder url = new StringBuilder();
        ArrayList<BasicNameValuePair> queryStringParams = new ArrayList<BasicNameValuePair>();
        queryStringParams.add(new BasicNameValuePair("sign", "false"));
        if (q.getId() != null || q.getSeriesId() != null || q.getElementFlavors() != null || q.getElementTags() != null) {
            url.append("/episode.xml?");
            if (q.getSeriesId() != null) {
                queryStringParams.add(new BasicNameValuePair("sid", q.getSeriesId()));
            }
            if (q.getElementFlavors() != null) {
                for (MediaPackageElementFlavor mediaPackageElementFlavor : q.getElementFlavors()) {
                    queryStringParams.add(new BasicNameValuePair("flavor", mediaPackageElementFlavor.toString()));
                }
            }
            if (q.getElementTags() != null) {
                for (String string : q.getElementTags()) {
                    queryStringParams.add(new BasicNameValuePair("tag", string));
                }
            }
        } else {
            url.append("/series.xml?");
            queryStringParams.add(new BasicNameValuePair("series", Boolean.toString(q.willIncludeSeries())));
            queryStringParams.add(new BasicNameValuePair("episodes", Boolean.toString(q.willIncludeEpisodes())));
        }
        if (q.getText() != null) {
            queryStringParams.add(new BasicNameValuePair("q", q.getText()));
        }
        if (q.getId() != null) {
            queryStringParams.add(new BasicNameValuePair("id", q.getId()));
        }
        if (admin) {
            queryStringParams.add(new BasicNameValuePair("admin", Boolean.TRUE.toString()));
        } else {
            queryStringParams.add(new BasicNameValuePair("admin", Boolean.FALSE.toString()));
        }
        queryStringParams.add(new BasicNameValuePair("limit", Integer.toString(q.getLimit())));
        queryStringParams.add(new BasicNameValuePair("offset", Integer.toString(q.getOffset())));
        url.append(URLEncodedUtils.format(queryStringParams, (String)"UTF-8"));
        return url.toString();
    }
}

