/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.jwt;

import com.auth0.jwk.JwkException;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.security.impl.jpa.JpaRole;
import org.opencastproject.security.impl.jpa.JpaUserReference;
import org.opencastproject.security.jwt.CachedJWT;
import org.opencastproject.security.jwt.GuavaCachedUrlJwkProvider;
import org.opencastproject.security.jwt.JWTLoginHandler;
import org.opencastproject.security.jwt.JWTRoleProvider;
import org.opencastproject.security.jwt.JWTVerifier;
import org.opencastproject.userdirectory.api.UserReferenceProvider;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class DynamicLoginHandler
implements InitializingBean,
JWTLoginHandler {
    private static final Logger logger = LoggerFactory.getLogger(DynamicLoginHandler.class);
    private UserDetailsService userDetailsService = null;
    private UserDirectoryService userDirectoryService = null;
    private UserReferenceProvider userReferenceProvider = null;
    private SecurityService securityService = null;
    private String jwksUrl = null;
    private int jwksCacheExpiresIn = 1440;
    private String secret = null;
    private List<String> expectedAlgorithms = null;
    private List<String> claimConstraints = null;
    private String usernameMapping = null;
    private String nameMapping = null;
    private String emailMapping = null;
    private List<String> roleMappings = null;
    private GuavaCachedUrlJwkProvider jwkProvider;
    private int jwtCacheSize = 500;
    private int jwtCacheExpiresIn = 60;
    private Cache<String, CachedJWT> cache;

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.userDetailsService, (String)"A UserDetailsService must be set");
        Assert.notNull((Object)this.userDirectoryService, (String)"A UserDirectoryService must be set");
        Assert.notNull((Object)this.userReferenceProvider, (String)"A UserReferenceProvider must be set");
        Assert.notNull((Object)this.securityService, (String)"A SecurityService must be set");
        Assert.isTrue((boolean)(StringUtils.isNotBlank((CharSequence)this.jwksUrl) ^ StringUtils.isNotBlank((CharSequence)this.secret)), (String)"Either a JWKS URL or a secret must be set");
        Assert.notEmpty(this.expectedAlgorithms, (String)"Expected algorithms must be set");
        Assert.notEmpty(this.claimConstraints, (String)"Claim constraints must be set");
        Assert.notNull((Object)this.usernameMapping, (String)"User name mapping must be set");
        Assert.notNull((Object)this.nameMapping, (String)"Name mapping must be set");
        Assert.notNull((Object)this.emailMapping, (String)"Email mapping must be set");
        Assert.notEmpty(this.roleMappings, (String)"Role mappings must be set");
        if (this.jwksUrl != null) {
            this.jwkProvider = new GuavaCachedUrlJwkProvider(this.jwksUrl, this.jwksCacheExpiresIn, TimeUnit.MINUTES);
        }
        this.userReferenceProvider.setRoleProvider((RoleProvider)new JWTRoleProvider(this.securityService, this.userReferenceProvider));
        this.cache = CacheBuilder.newBuilder().maximumSize((long)this.jwtCacheSize).expireAfterWrite((long)this.jwtCacheExpiresIn, TimeUnit.MINUTES).build();
    }

    @Override
    public String handleToken(String token) {
        try {
            String signature = this.extractSignature(token);
            CachedJWT cachedJwt = (CachedJWT)this.cache.getIfPresent((Object)signature);
            if (cachedJwt == null) {
                DecodedJWT jwt = this.decodeAndValidate(token);
                String username = this.extractUsername(jwt);
                try {
                    if (this.userDetailsService.loadUserByUsername(username) != null) {
                        this.existingUserLogin(username, jwt);
                    }
                }
                catch (UsernameNotFoundException e) {
                    this.newUserLogin(username, jwt);
                    this.userDirectoryService.invalidate(username);
                }
                this.cache.put((Object)jwt.getSignature(), (Object)new CachedJWT(jwt, username));
                return username;
            }
            if (cachedJwt.hasExpired()) {
                this.cache.invalidate((Object)signature);
                throw new JWTVerificationException("JWT token is not valid anymore");
            }
            logger.debug("Using decoded and validated JWT from cache");
            return cachedJwt.getUsername();
        }
        catch (JwkException | JWTVerificationException exception) {
            logger.error(exception.getMessage());
            return null;
        }
    }

    private DecodedJWT decodeAndValidate(String token) throws JwkException {
        DecodedJWT jwt = this.jwksUrl != null ? JWTVerifier.verify(token, this.jwkProvider, this.claimConstraints) : JWTVerifier.verify(token, this.secret, this.claimConstraints);
        if (!this.expectedAlgorithms.contains(jwt.getAlgorithm())) {
            throw new JWTVerificationException("JWT token was signed with an unexpected algorithm '" + jwt.getAlgorithm() + "'");
        }
        return jwt;
    }

    private String extractSignature(String token) {
        String[] parts = token.split("\\.");
        if (parts.length != 3) {
            throw new JWTDecodeException("Given token is not in a valid JWT format");
        }
        return parts[2];
    }

    private String extractUsername(DecodedJWT jwt) {
        String username = this.evaluateMapping(jwt, this.usernameMapping, false);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)username), (String)"Extracted username is blank");
        return username;
    }

    private String extractName(DecodedJWT jwt) {
        String name = this.evaluateMapping(jwt, this.nameMapping, true);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)name), (String)"Extracted name is blank");
        return name;
    }

    private String extractEmail(DecodedJWT jwt) {
        String email = this.evaluateMapping(jwt, this.emailMapping, true);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)email), (String)"Extracted email is blank");
        return email;
    }

    private Set<JpaRole> extractRoles(DecodedJWT jwt) {
        JpaOrganization organization = this.fromOrganization(this.securityService.getOrganization());
        HashSet<JpaRole> roles = new HashSet<JpaRole>();
        for (String mapping : this.roleMappings) {
            String role = this.evaluateMapping(jwt, mapping, false);
            if (!StringUtils.isNotBlank((CharSequence)role)) continue;
            roles.add(new JpaRole(role, organization));
        }
        Assert.notEmpty(roles, (String)"No roles could be extracted");
        return roles;
    }

    private String evaluateMapping(DecodedJWT jwt, String mapping, boolean ensureEncoding) {
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(mapping);
        String value = (String)exp.getValue((Object)jwt.getClaims(), String.class);
        if (ensureEncoding) {
            value = new String(value.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        }
        return value;
    }

    public void newUserLogin(String username, DecodedJWT jwt) {
        JpaUserReference userReference = new JpaUserReference(username, this.extractName(jwt), this.extractEmail(jwt), "jwt", new Date(), this.fromOrganization(this.securityService.getOrganization()), this.extractRoles(jwt));
        logger.debug("JWT user '{}' logged in for the first time", (Object)username);
        this.userReferenceProvider.addUserReference(userReference, "jwt");
    }

    public void existingUserLogin(String username, DecodedJWT jwt) {
        Organization organization = this.securityService.getOrganization();
        JpaUserReference userReference = this.userReferenceProvider.findUserReference(username, organization.getId());
        if (userReference == null) {
            throw new UsernameNotFoundException("User reference '" + username + "' was not found");
        }
        userReference.setName(this.extractName(jwt));
        userReference.setEmail(this.extractEmail(jwt));
        userReference.setLastLogin(new Date());
        userReference.setRoles(this.extractRoles(jwt));
        logger.debug("JWT user '{}' logged in", (Object)username);
        this.userReferenceProvider.updateUserReference(userReference);
    }

    private JpaOrganization fromOrganization(Organization org) {
        if (org instanceof JpaOrganization) {
            return (JpaOrganization)org;
        }
        return new JpaOrganization(org.getId(), org.getName(), org.getServers(), org.getAdminRole(), org.getAnonymousRole(), org.getProperties());
    }

    @Reference
    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserReferenceProvider(UserReferenceProvider userReferenceProvider) {
        this.userReferenceProvider = userReferenceProvider;
    }

    public void setJwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
    }

    public void setJwksCacheExpiresIn(int jwksCacheExpiresIn) {
        this.jwksCacheExpiresIn = jwksCacheExpiresIn;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setExpectedAlgorithms(List<String> expectedAlgorithms) {
        this.expectedAlgorithms = expectedAlgorithms;
    }

    public void setClaimConstraints(List<String> claimConstraints) {
        this.claimConstraints = claimConstraints;
    }

    public void setUsernameMapping(String usernameMapping) {
        this.usernameMapping = usernameMapping;
    }

    public void setNameMapping(String nameMapping) {
        this.nameMapping = nameMapping;
    }

    public void setEmailMapping(String emailMapping) {
        this.emailMapping = emailMapping;
    }

    public void setRoleMappings(List<String> roleMappings) {
        this.roleMappings = roleMappings;
    }

    public void setJwtCacheSize(int jwtCacheSize) {
        this.jwtCacheSize = jwtCacheSize;
    }

    public void setJwtCacheExpiresIn(int jwtCacheExpiresIn) {
        this.jwtCacheExpiresIn = jwtCacheExpiresIn;
    }
}

