/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.jwt;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.opencastproject.security.jwt.JWTLoginHandler;
import org.springframework.security.web.authentication.preauth.RequestHeaderAuthenticationFilter;
import org.springframework.util.Assert;

public class JWTRequestHeaderAuthenticationFilter
extends RequestHeaderAuthenticationFilter {
    private String principalPrefix = null;
    private JWTLoginHandler loginHandler = null;
    private boolean debug = false;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.loginHandler, (String)"A JWTLoginHandler must be set");
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        if (this.debug) {
            this.debug(request);
        }
        String username = null;
        String principal = (String)super.getPreAuthenticatedPrincipal(request);
        if (principal != null && !"".equals(principal.trim())) {
            if (this.principalPrefix != null) {
                if (!principal.startsWith(this.principalPrefix)) {
                    return null;
                }
                principal = principal.replace(this.principalPrefix, "");
            }
            username = this.loginHandler.handleToken(principal);
        }
        return username;
    }

    protected void debug(HttpServletRequest request) {
        Enumeration he = request.getHeaderNames();
        while (he.hasMoreElements()) {
            String headerName = (String)he.nextElement();
            StringBuilder builder = new StringBuilder(headerName).append(": ");
            Enumeration hv = request.getHeaders(headerName);
            boolean first = true;
            while (hv.hasMoreElements()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append((String)hv.nextElement());
                first = false;
            }
            this.logger.debug((Object)builder.toString());
        }
    }

    public void setPrincipalPrefix(String principalPrefix) {
        this.principalPrefix = principalPrefix;
    }

    public void setLoginHandler(JWTLoginHandler loginHandler) {
        this.loginHandler = loginHandler;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

