/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.jwt;

import javax.servlet.http.HttpServletRequest;
import org.opencastproject.security.jwt.JWTLoginHandler;
import org.opencastproject.security.jwt.Util;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedCredentialsNotFoundException;
import org.springframework.util.Assert;

public class JWTRequestParameterAuthenticationFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private String parameterName = null;
    private JWTLoginHandler loginHandler = null;
    private boolean exceptionIfParameterMissing = true;
    private boolean debug = false;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.parameterName, (String)"A parameter name must be set");
        Assert.notNull((Object)this.loginHandler, (String)"A JWTLoginHandler must be set");
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String token;
        if (this.debug) {
            Util.debug(this.logger, request);
        }
        if ((token = request.getParameter(this.parameterName)) == null && this.exceptionIfParameterMissing) {
            throw new PreAuthenticatedCredentialsNotFoundException(this.parameterName + " parameter not found in request.");
        }
        if (token == null || token.isBlank()) {
            return null;
        }
        return this.loginHandler.handleToken(token);
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setLoginHandler(JWTLoginHandler loginHandler) {
        this.loginHandler = loginHandler;
    }

    public void setExceptionIfParameterMissing(boolean exceptionIfParameterMissing) {
        this.exceptionIfParameterMissing = exceptionIfParameterMissing;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

