/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.jwt;

import com.auth0.jwk.JwkException;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.jwt.AlgorithmBuilder;
import org.opencastproject.security.jwt.GuavaCachedUrlJwkProvider;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public final class JWTVerifier {
    private JWTVerifier() {
    }

    public static DecodedJWT verify(String token, GuavaCachedUrlJwkProvider provider, List<String> claimConstraints) throws JwkException {
        Assert.notNull((Object)token, (String)"A token must be set");
        Assert.notNull((Object)((Object)provider), (String)"A JWKS provider must be set");
        DecodedJWT jwt = JWT.decode((String)token);
        List<Algorithm> algorithms = provider.getAlgorithms(jwt, false);
        try {
            return JWTVerifier.verify(jwt, claimConstraints, algorithms);
        }
        catch (JWTVerificationException e) {
            algorithms = provider.getAlgorithms(jwt, true);
            return JWTVerifier.verify(jwt, claimConstraints, algorithms);
        }
    }

    public static DecodedJWT verify(String token, String secret, List<String> claimConstraints) throws JWTVerificationException {
        Assert.notNull((Object)token, (String)"A token must be set");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)secret), (String)"A secret must be set");
        DecodedJWT jwt = JWT.decode((String)token);
        return JWTVerifier.verify(jwt, claimConstraints, AlgorithmBuilder.buildAlgorithm(jwt, secret));
    }

    public static DecodedJWT verify(DecodedJWT jwt, List<String> claimConstraints, List<Algorithm> algorithms) throws JWTVerificationException {
        return JWTVerifier.verify(jwt, claimConstraints, algorithms.toArray(new Algorithm[0]));
    }

    public static DecodedJWT verify(DecodedJWT jwt, List<String> claimConstraints, Algorithm ... algorithms) throws JWTVerificationException {
        Assert.notNull((Object)jwt, (String)"A decoded JWT must be set");
        Assert.notEmpty(claimConstraints, (String)"Claim constraints must be set");
        Assert.notEmpty((Object[])algorithms, (String)"Algorithms must be set");
        Assert.isTrue((boolean)JWTVerifier.algorithmsMatch(algorithms), (String)"Algorithms must be of same class");
        boolean verified = false;
        Throwable lastException = new JWTVerificationException("JWT could not be verified");
        for (Algorithm algorithm : algorithms) {
            try {
                JWT.require((Algorithm)algorithm).build().verify(jwt);
                SpelExpressionParser parser = new SpelExpressionParser();
                for (String constraint : claimConstraints) {
                    Expression exp = parser.parseExpression(constraint);
                    if (((Boolean)exp.getValue((Object)jwt.getClaims(), Boolean.class)).booleanValue()) continue;
                    throw new JWTVerificationException("The claims did not fulfill constraint '" + constraint + "'");
                }
                verified = true;
                break;
            }
            catch (JWTVerificationException | EvaluationException | ParseException e) {
                lastException = e;
            }
        }
        if (!verified) {
            throw new JWTVerificationException(lastException.getMessage());
        }
        return jwt;
    }

    private static boolean algorithmsMatch(Algorithm ... algorithms) {
        for (int i = 1; i < algorithms.length; ++i) {
            if (algorithms[i].getClass().equals(algorithms[0].getClass())) continue;
            return false;
        }
        return true;
    }
}

