/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.series.remote;

import com.entwinemedia.fn.data.Opt;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.json.simple.parser.JSONParser;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.series.api.Series;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="seriesservice", title="Series Service Remote", abstractText="This service creates, edits and retrieves and helps managing series.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(property={"service.description=Series Remote Service Proxy", "opencast.service.type=org.opencastproject.series", "opencast.service.path=/series", "opencast.service.publish=false"}, immediate=true, service={SeriesService.class, SeriesServiceRemoteImpl.class})
public class SeriesServiceRemoteImpl
extends RemoteBase
implements SeriesService {
    private static final Logger logger = LoggerFactory.getLogger(SeriesServiceRemoteImpl.class);
    private static final Gson gson = new Gson();
    private static final Type seriesListType = new TypeToken<ArrayList<Series>>(){}.getType();

    public SeriesServiceRemoteImpl() {
        super("org.opencastproject.series");
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient client) {
        super.setTrustedHttpClient(client);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry remoteServiceManager) {
        super.setRemoteServiceManager(remoteServiceManager);
    }

    public DublinCoreCatalog updateSeries(DublinCoreCatalog dc) throws SeriesException, UnauthorizedException {
        String seriesId = dc.getFirst(DublinCore.PROPERTY_IDENTIFIER);
        HttpPost post = new HttpPost("/");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("series", dc.toXmlString()));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new SeriesException("Unable to assemble a remote series request for updating series " + seriesId, (Throwable)e);
        }
        HttpResponse response = this.getResponse((HttpRequestBase)post, new Integer[]{204, 201, 401});
        try {
            if (response != null) {
                int statusCode = response.getStatusLine().getStatusCode();
                if (204 == statusCode) {
                    logger.info("Successfully updated series {} in the series service", (Object)seriesId);
                    DublinCoreCatalog dublinCoreCatalog = null;
                    return dublinCoreCatalog;
                }
                if (401 == statusCode) {
                    throw new UnauthorizedException("Not authorized to update series " + seriesId);
                }
                if (201 == statusCode) {
                    DublinCoreCatalog catalogImpl = DublinCores.read((InputStream)response.getEntity().getContent());
                    logger.info("Successfully created series {} in the series service", (Object)seriesId);
                    DublinCoreCatalog dublinCoreCatalog = catalogImpl;
                    return dublinCoreCatalog;
                }
            }
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SeriesException("Unable to update series " + seriesId + " using the remote series services: " + e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SeriesException("Unable to update series " + seriesId + " using the remote series services");
    }

    public boolean updateAccessControl(String seriesID, AccessControlList accessControl) throws NotFoundException, SeriesException, UnauthorizedException {
        return this.updateAccessControl(seriesID, accessControl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateAccessControl(String seriesID, AccessControlList accessControl, boolean overrideEpisodeAcl) throws NotFoundException, SeriesException, UnauthorizedException {
        HttpPost post = new HttpPost(seriesID + "/accesscontrol");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("seriesID", seriesID));
            params.add(new BasicNameValuePair("acl", AccessControlParser.toXml((AccessControlList)accessControl)));
            params.add(new BasicNameValuePair("overrideEpisodeAcl", Boolean.toString(overrideEpisodeAcl)));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new SeriesException("Unable to assemble a remote series request for updating an ACL " + accessControl, (Throwable)e);
        }
        HttpResponse response = this.getResponse((HttpRequestBase)post, new Integer[]{204, 201, 404, 401});
        try {
            if (response != null) {
                int status = response.getStatusLine().getStatusCode();
                if (404 == status) {
                    throw new NotFoundException("Series not found: " + seriesID);
                }
                if (204 == status) {
                    logger.info("Successfully updated ACL of {} to the series service", (Object)seriesID);
                    boolean bl = true;
                    return bl;
                }
                if (401 == status) {
                    throw new UnauthorizedException("Not authorized to update series ACL of " + seriesID);
                }
                if (201 == status) {
                    logger.info("Successfully created ACL of {} to the series service", (Object)seriesID);
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.closeConnection(response);
        }
        throw new SeriesException("Unable to update series ACL " + accessControl + " using the remote series services");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSeries(String seriesID) throws SeriesException, NotFoundException, UnauthorizedException {
        HttpDelete del = new HttpDelete(seriesID);
        HttpResponse response = this.getResponse((HttpRequestBase)del, new Integer[]{200, 404, 401});
        try {
            if (response != null) {
                int statusCode = response.getStatusLine().getStatusCode();
                if (404 == statusCode) {
                    throw new NotFoundException("Series not found: " + seriesID);
                }
                if (401 == statusCode) {
                    throw new UnauthorizedException("Not authorized to delete series " + seriesID);
                }
                if (200 == statusCode) {
                    logger.info("Successfully deleted {} from the remote series index", (Object)seriesID);
                    return;
                }
            }
        }
        finally {
            this.closeConnection(response);
        }
        throw new SeriesException("Unable to remove " + seriesID + " from a remote series index");
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{seriesID:.+}.json")
    public Response getSeriesJSON(@PathParam(value="seriesID") String seriesID) throws UnauthorizedException {
        logger.debug("Series Lookup: {}", (Object)seriesID);
        try {
            DublinCoreCatalog dc = this.getSeries(seriesID);
            return Response.ok((Object)dc.toJson()).build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not retrieve series: {}", (Object)e.getMessage());
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{seriesID:.+}/acl.json")
    public Response getSeriesAccessControlListJson(@PathParam(value="seriesID") String seriesID) {
        logger.debug("Series ACL lookup: {}", (Object)seriesID);
        try {
            AccessControlList acl = this.getSeriesAccessControl(seriesID);
            return Response.ok((Object)acl).build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (SeriesException e) {
            logger.error("Could not retrieve series ACL: {}", (Object)e.getMessage());
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public DublinCoreCatalog getSeries(String seriesID) throws SeriesException, NotFoundException, UnauthorizedException {
        HttpGet get = new HttpGet(seriesID + ".xml");
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 404, 401});
        try {
            if (response != null) {
                if (404 == response.getStatusLine().getStatusCode()) {
                    throw new NotFoundException("Series " + seriesID + " not found in remote series index!");
                }
                if (401 == response.getStatusLine().getStatusCode()) {
                    throw new UnauthorizedException("Not authorized to get series " + seriesID);
                }
                DublinCoreCatalog dublinCoreCatalog = DublinCores.read((InputStream)response.getEntity().getContent());
                logger.debug("Successfully received series {} from the remote series index", (Object)seriesID);
                DublinCoreCatalog dublinCoreCatalog2 = dublinCoreCatalog;
                return dublinCoreCatalog2;
            }
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SeriesException("Unable to parse series from remote series index: " + e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SeriesException("Unable to get series from remote series index");
    }

    public List<Series> getAllForAdministrativeRead(Date from, Optional<Date> to, int limit) throws SeriesException, UnauthorizedException {
        StringBuilder url = new StringBuilder();
        url.append("/allInRangeAdministrative.json?");
        ArrayList<BasicNameValuePair> queryParams = new ArrayList<BasicNameValuePair>();
        queryParams.add(new BasicNameValuePair("from", Long.toString(from.getTime())));
        queryParams.add(new BasicNameValuePair("limit", Integer.toString(limit)));
        if (to.isPresent()) {
            queryParams.add(new BasicNameValuePair("to", Long.toString(to.get().getTime())));
        }
        url.append(URLEncodedUtils.format(queryParams, (Charset)StandardCharsets.UTF_8));
        HttpGet get = new HttpGet(url.toString());
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 400, 401});
        try {
            if (response == null) {
                throw new SeriesException("Unable to get series from remote series index");
            }
            if (response.getStatusLine().getStatusCode() == 400) {
                throw new SeriesException("internal server error when fetching /allInRangeAdministrative.json");
            }
            if (response.getStatusLine().getStatusCode() == 401) {
                throw new UnauthorizedException("got UNAUTHORIZED when fetching /allInRangeAdministrative.json");
            }
            InputStreamReader reader = new InputStreamReader(response.getEntity().getContent(), "UTF-8");
            List list = (List)gson.fromJson((Reader)reader, seriesListType);
            return list;
        }
        catch (IOException e) {
            throw new SeriesException("failed to reader response body of /allInRangeAdministrative.json", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
    }

    public AccessControlList getSeriesAccessControl(String seriesID) throws NotFoundException, SeriesException {
        HttpGet get = new HttpGet(seriesID + "/acl.xml");
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 404});
        try {
            if (response != null) {
                if (404 == response.getStatusLine().getStatusCode()) {
                    throw new NotFoundException("Series ACL " + seriesID + " not found on remote series index!");
                }
                AccessControlList acl = AccessControlParser.parseAcl((InputStream)response.getEntity().getContent());
                logger.info("Successfully get series ACL {} from the remote series index", (Object)seriesID);
                AccessControlList accessControlList = acl;
                return accessControlList;
            }
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SeriesException("Unable to parse series ACL form remote series index: " + e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SeriesException("Unable to get series ACL from remote series index");
    }

    public int getSeriesCount() throws SeriesException {
        HttpGet get = new HttpGet("/count");
        HttpResponse response = this.getResponse((HttpRequestBase)get);
        try {
            if (response != null) {
                int count = Integer.parseInt(IOUtils.toString((InputStream)response.getEntity().getContent()));
                logger.info("Successfully get series dublin core catalog list from the remote series index");
                int n = count;
                return n;
            }
        }
        catch (Exception e) {
            throw new SeriesException("Unable to count series from remote series index: " + e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SeriesException("Unable to count series from remote series index");
    }

    public Map<String, String> getSeriesProperties(String seriesID) throws SeriesException, NotFoundException, UnauthorizedException {
        HttpGet get = new HttpGet(seriesID + "/properties.json");
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 404, 401});
        JSONParser parser = new JSONParser();
        try {
            if (response != null) {
                if (404 == response.getStatusLine().getStatusCode()) {
                    throw new NotFoundException("Series " + seriesID + " not found in remote series index!");
                }
                if (401 == response.getStatusLine().getStatusCode()) {
                    throw new UnauthorizedException("Not authorized to get series " + seriesID);
                }
                logger.debug("Successfully received series {} properties from the remote series index", (Object)seriesID);
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)response.getEntity().getContent(), (Writer)writer, (Charset)StandardCharsets.UTF_8);
                JSONArray jsonProperties = (JSONArray)parser.parse(writer.toString());
                TreeMap<String, String> properties = new TreeMap<String, String>();
                for (int i = 0; i < jsonProperties.length(); ++i) {
                    JSONObject property = (JSONObject)jsonProperties.get(i);
                    JSONArray names = property.names();
                    for (int j = 0; j < names.length(); ++j) {
                        properties.put(names.get(j).toString(), property.get(names.get(j).toString()).toString());
                    }
                }
                TreeMap<String, String> treeMap = properties;
                return treeMap;
            }
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SeriesException("Unable to parse series properties from remote series index: " + e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SeriesException("Unable to get series from remote series index");
    }

    public String getSeriesProperty(String seriesID, String propertyName) throws SeriesException, NotFoundException, UnauthorizedException {
        HttpGet get = new HttpGet(seriesID + "/property/" + propertyName + ".json");
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 404, 401});
        try {
            if (response != null) {
                if (404 == response.getStatusLine().getStatusCode()) {
                    throw new NotFoundException("Series " + seriesID + " not found in remote series index!");
                }
                if (401 == response.getStatusLine().getStatusCode()) {
                    throw new UnauthorizedException("Not authorized to get series " + seriesID);
                }
                logger.debug("Successfully received series {} property {} from the remote series index", (Object)seriesID, (Object)propertyName);
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)response.getEntity().getContent(), (Writer)writer, (Charset)StandardCharsets.UTF_8);
                String string = writer.toString();
                return string;
            }
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SeriesException("Unable to parse series from remote series index: " + e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SeriesException("Unable to get series from remote series index");
    }

    public void updateSeriesProperty(String seriesID, String propertyName, String propertyValue) throws SeriesException, NotFoundException, UnauthorizedException {
        HttpPost post = new HttpPost("/" + seriesID + "/property");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("name", propertyName));
            params.add(new BasicNameValuePair("value", propertyValue));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new SeriesException("Unable to assemble a remote series request for updating series " + seriesID + " series property " + propertyName + ":" + propertyValue, (Throwable)e);
        }
        HttpResponse response = this.getResponse((HttpRequestBase)post, new Integer[]{204, 201, 401});
        try {
            if (response != null) {
                int statusCode = response.getStatusLine().getStatusCode();
                if (204 == statusCode) {
                    logger.info("Successfully updated series {} with property name {} and value {} in the series service", new Object[]{seriesID, propertyName, propertyValue});
                    return;
                }
                if (401 == statusCode) {
                    throw new UnauthorizedException("Not authorized to update series " + seriesID);
                }
            }
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SeriesException("Unable to update series " + seriesID + " with property " + propertyName + ":" + propertyValue + " using the remote series services: ", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SeriesException("Unable to update series " + seriesID + " using the remote series services");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSeriesProperty(String seriesID, String propertyName) throws SeriesException, NotFoundException, UnauthorizedException {
        HttpDelete del = new HttpDelete("/" + seriesID + "/property/" + propertyName);
        HttpResponse response = this.getResponse((HttpRequestBase)del, new Integer[]{200, 404, 401});
        try {
            if (response != null) {
                int statusCode = response.getStatusLine().getStatusCode();
                if (404 == statusCode) {
                    throw new NotFoundException("Series not found: " + seriesID);
                }
                if (401 == statusCode) {
                    throw new UnauthorizedException("Not authorized to delete series " + seriesID);
                }
                if (200 == statusCode) {
                    logger.info("Successfully deleted {} from the remote series index", (Object)seriesID);
                    return;
                }
            }
        }
        finally {
            this.closeConnection(response);
        }
        throw new SeriesException("Unable to remove " + seriesID + " from a remote series index");
    }

    public boolean updateExtendedMetadata(String seriesId, String type, DublinCoreCatalog dc) throws SeriesException {
        HttpPut put = new HttpPut("/" + seriesId + "/extendedMetadata/" + type);
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("dc", dc.toXmlString()));
            put.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new SeriesException("Unable to assemble a remote series request for updating extended metadata of series " + seriesId, (Throwable)e);
        }
        HttpResponse response = this.getResponse((HttpRequestBase)put, new Integer[]{204, 201, 500});
        try {
            if (response == null) {
                throw new SeriesException(String.format("Error while updating extended metadata catalog of type '%s' for series '%s'", type, seriesId));
            }
            int statusCode = response.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 201: 
                case 204: {
                    boolean bl = true;
                    return bl;
                }
                case 500: {
                    throw new SeriesException(String.format("Error while updating extended metadata catalog of type '%s' for series '%s'", type, seriesId));
                }
            }
            throw new SeriesException(String.format("Unexpected status code", statusCode));
        }
        finally {
            this.closeConnection(response);
        }
    }

    /*
     * Exception decompiling
     */
    public Opt<Map<String, byte[]>> getSeriesElements(String seriesID) throws SeriesException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[SWITCH], 7[CASE]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Opt<byte[]> getSeriesElementData(String seriesID, String type) throws SeriesException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CASE], 4[SWITCH]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean updateSeriesElement(String seriesID, String type, byte[] data) throws SeriesException {
        HttpPut put = new HttpPut("/" + seriesID + "/elements/" + type);
        put.setEntity((HttpEntity)new ByteArrayEntity(data, ContentType.DEFAULT_BINARY));
        HttpResponse response = this.getResponse((HttpRequestBase)put, new Integer[]{201, 204, 500});
        try {
            if (response == null) {
                throw new SeriesException(String.format("Error while updating element of type '%s' in series '%s'", type, seriesID));
            }
            int statusCode = response.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 201: 
                case 204: {
                    boolean bl = true;
                    return bl;
                }
                case 500: {
                    throw new SeriesException(String.format("Error while updating element of type '%s' in series '%s'", type, seriesID));
                }
            }
            throw new SeriesException(String.format("Unexpected status code", statusCode));
        }
        finally {
            this.closeConnection(response);
        }
    }

    public boolean deleteSeriesElement(String seriesID, String type) throws SeriesException {
        if (StringUtils.isBlank((CharSequence)seriesID)) {
            throw new IllegalArgumentException("Series ID must not be blank");
        }
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new IllegalArgumentException("Element type must not be blank");
        }
        HttpDelete del = new HttpDelete("/" + seriesID + "/elements/" + type);
        HttpResponse response = this.getResponse((HttpRequestBase)del, new Integer[]{204, 404, 500});
        try {
            if (response == null) {
                throw new SeriesException("Unable to remove " + seriesID + " from a remote series index");
            }
            int statusCode = response.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 204: {
                    boolean bl = true;
                    return bl;
                }
                case 404: {
                    boolean bl = false;
                    return bl;
                }
                case 500: {
                    throw new SeriesException(String.format("Error while deleting element of type '%s' from series '%s'", type, seriesID));
                }
            }
            throw new SeriesException(String.format("Unexpected status code", statusCode));
        }
        finally {
            this.closeConnection(response);
        }
    }
}

