/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.silencedetection.impl;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.silencedetection.api.MediaSegment;
import org.opencastproject.silencedetection.api.MediaSegments;
import org.opencastproject.silencedetection.api.SilenceDetectionFailedException;
import org.opencastproject.silencedetection.api.SilenceDetectionService;
import org.opencastproject.silencedetection.ffmpeg.FFmpegSilenceDetector;
import org.opencastproject.smil.api.SmilException;
import org.opencastproject.smil.api.SmilResponse;
import org.opencastproject.smil.api.SmilService;
import org.opencastproject.smil.entity.api.Smil;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Silence Detection Service"}, immediate=true, service={SilenceDetectionService.class})
public class SilenceDetectionServiceImpl
extends AbstractJobProducer
implements SilenceDetectionService {
    private static final Logger logger = LoggerFactory.getLogger(SilenceDetectionServiceImpl.class);
    public static final String JOB_LOAD_KEY = "job.load.videoeditor.silencedetection";
    private static final float DEFAULT_JOB_LOAD = 0.2f;
    private float jobload = 0.2f;
    private Workspace workspace = null;
    private ServiceRegistry serviceRegistry;
    protected OrganizationDirectoryService organizationDirectoryService = null;
    protected SecurityService securityService = null;
    protected UserDirectoryService userDirectoryService = null;
    protected SmilService smilService = null;
    private Properties properties;

    public SilenceDetectionServiceImpl() {
        super("org.opencastproject.silencedetection");
    }

    public Job detect(Track sourceTrack) throws SilenceDetectionFailedException {
        return this.detect(sourceTrack, null);
    }

    public Job detect(Track sourceTrack, Track[] referenceTracks) throws SilenceDetectionFailedException {
        try {
            if (sourceTrack == null) {
                throw new SilenceDetectionFailedException("Source track is null!");
            }
            LinkedList<String> arguments = new LinkedList<String>();
            arguments.add(0, MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack));
            if (referenceTracks != null) {
                arguments.add(1, MediaPackageElementParser.getArrayAsXml(Arrays.asList(referenceTracks)));
            }
            return this.serviceRegistry.createJob(this.getJobType(), Operation.SILENCE_DETECTION.toString(), arguments, Float.valueOf(this.jobload));
        }
        catch (ServiceRegistryException ex) {
            throw new SilenceDetectionFailedException("Unable to create job! " + ex.getMessage());
        }
        catch (MediaPackageException ex) {
            throw new SilenceDetectionFailedException("Unable to serialize track!");
        }
    }

    protected String process(Job job) throws SilenceDetectionFailedException, SmilException, MediaPackageException {
        if (Operation.SILENCE_DETECTION.toString().equals(job.getOperation())) {
            String referenceTracksXml;
            String sourceTrackXml = StringUtils.trimToNull((String)((String)job.getArguments().get(0)));
            if (sourceTrackXml == null) {
                throw new SilenceDetectionFailedException("Track not set!");
            }
            Track sourceTrack = (Track)MediaPackageElementParser.getFromXml((String)sourceTrackXml);
            MediaSegments segments = this.runDetection(sourceTrack);
            List referenceTracks = null;
            if (job.getArguments().size() > 1 && (referenceTracksXml = StringUtils.trimToNull((String)((String)job.getArguments().get(1)))) != null) {
                referenceTracks = MediaPackageElementParser.getArrayFromXml((String)referenceTracksXml);
            }
            if (referenceTracks == null) {
                referenceTracks = Arrays.asList(sourceTrack);
            }
            try {
                return this.generateSmil(segments, referenceTracks).toXML();
            }
            catch (Exception ex) {
                throw new SmilException("Failed to create smil document.", (Throwable)ex);
            }
        }
        throw new SilenceDetectionFailedException("Can't handle this operation: " + job.getOperation());
    }

    protected MediaSegments runDetection(Track track) throws SilenceDetectionFailedException {
        try {
            FFmpegSilenceDetector silenceDetector = new FFmpegSilenceDetector(this.properties, track, this.workspace);
            return silenceDetector.getMediaSegments();
        }
        catch (Exception ex) {
            throw new SilenceDetectionFailedException(ex.getMessage());
        }
    }

    protected Smil generateSmil(MediaSegments segments, List<Track> referenceTracks) throws SmilException {
        SmilResponse smilResponse = this.smilService.createNewSmil();
        Track[] referenceTracksArr = referenceTracks.toArray(new Track[0]);
        for (MediaSegment segment : segments.getMediaSegments()) {
            smilResponse = this.smilService.addParallel(smilResponse.getSmil());
            String parId = smilResponse.getEntity().getId();
            smilResponse = this.smilService.addClips(smilResponse.getSmil(), parId, referenceTracksArr, segment.getSegmentStart(), segment.getSegmentStop() - segment.getSegmentStart());
        }
        return smilResponse.getSmil();
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    @Activate
    @Modified
    public void activate(BundleContext bundleContext, ComponentContext context) {
        logger.debug("Loading configuration");
        super.activate(context);
        this.properties = new Properties();
        if (bundleContext == null) {
            logger.info("No configuration available, using defaults");
            return;
        }
        FFmpegSilenceDetector.init(bundleContext);
        Dictionary properties = context.getProperties();
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            logger.debug("{} = {}", (Object)key, properties.get(key));
            this.properties.put(key, properties.get(key));
        }
        logger.debug("Properties updated!");
        this.jobload = LoadUtil.getConfiguredLoadValue((Dictionary)properties, (String)JOB_LOAD_KEY, (Float)Float.valueOf(0.2f), (ServiceRegistry)this.serviceRegistry);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        logger.debug("deactivating...");
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    @Reference
    public void setSmilService(SmilService smilService) {
        this.smilService = smilService;
    }

    private static enum Operation {
        SILENCE_DETECTION;

    }
}

