/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.statistics.endpoint;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opencastproject.statistics.api.DataResolution;
import org.opencastproject.statistics.api.StatisticsProvider;
import org.opencastproject.statistics.api.StatisticsService;
import org.opencastproject.statistics.api.TimeSeries;
import org.opencastproject.statistics.api.TimeSeriesProvider;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="statisticsservice", title="Statistics Service", abstractText="This service provides statistics.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
public class StatisticsRestService {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsRestService.class);
    private StatisticsService statisticsService;

    public void setService(StatisticsService statisticsService) {
        this.statisticsService = statisticsService;
    }

    public void activate(ComponentContext cc) {
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="writeDuration")
    @RestQuery(name="writeDuration", description="Writes a duration", returnDescription="", responses={@RestResponse(responseCode=204, description="Writing worked")})
    public Response writeDuration(@QueryParam(value="organizationId") String organizationId, @QueryParam(value="measurementName") String measurementName, @QueryParam(value="retentionPolicy") String retentionPolicy, @QueryParam(value="organizationIdResourceName") String organizationIdResourceName, @QueryParam(value="fieldName") String fieldName, @QueryParam(value="temporalResolution") String temporalResolution, @QueryParam(value="duration") String duration) {
        try {
            this.statisticsService.writeDuration(organizationId, measurementName, retentionPolicy, organizationIdResourceName, fieldName, TimeUnit.valueOf(temporalResolution), Duration.parse(duration));
            return Response.ok((Object)Response.Status.NO_CONTENT).build();
        }
        catch (Exception e) {
            logger.error("Could not retrieve providers: {}", (Object)e.getMessage());
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="providers.json")
    @RestQuery(name="getAllAsJson", description="Returns active providers", returnDescription="Returns the active providers JSON document", responses={@RestResponse(responseCode=200, description="The active providers.")})
    public Response getProviders() {
        try {
            return Response.ok((Object)StatisticsRestService.providersToJson(this.statisticsService.getProviders()).toJSONString()).build();
        }
        catch (Exception e) {
            logger.error("Could not retrieve providers: {}", (Object)e.getMessage());
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="timeseries/{providerId:.+}.json")
    @RestQuery(name="getTimeSeriesAsJson", description="Returns the time series data for the given providerId", returnDescription="Returns the time series data JSON document", pathParameters={@RestParameter(name="providerId", isRequired=true, description="The provider identifier", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="resourceId", description="The id of the resource to get the data for. E.g. episode id.", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="from", description="Start of the time series as ISO 8601 UTC date string", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="to", description="End of the time series as ISO 8601 UTC date string", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="resolution", description="Data aggregation level. Must be one of 'daily', 'weekly', 'monthly', 'yearly'", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="zoneId", description="The time zone id to use for calculations", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The time series data.")})
    public Response getTimeSeriesData(@PathParam(value="providerId") String providerId, @QueryParam(value="resourceId") String resourceId, @QueryParam(value="from") String from, @QueryParam(value="to") String to, @QueryParam(value="resolution") String resolution, @QueryParam(value="zoneId") String zoneId) {
        try {
            TimeSeries timeSeries = this.statisticsService.getTimeSeriesData((StatisticsProvider)this.statisticsService.getProvider(providerId).orElseThrow(NotFoundException::new), resourceId, Instant.parse(from), Instant.parse(to), DataResolution.fromString((String)resolution), ZoneId.of(zoneId));
            return Response.ok((Object)StatisticsRestService.timeSeriesToJson(timeSeries).toJSONString()).build();
        }
        catch (Exception e) {
            logger.error("Could not retrieve time series data for provider {}: {}", (Object)providerId, (Object)e.getMessage());
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private static JSONObject timeSeriesToJson(TimeSeries timeSeries) {
        JSONObject json = new JSONObject();
        JSONArray jsonLabels = new JSONArray();
        JSONArray jsonValues = new JSONArray();
        for (int i = 0; i < timeSeries.getValues().size(); ++i) {
            jsonLabels.add(timeSeries.getLabels().get(i));
            jsonValues.add(timeSeries.getValues().get(i));
        }
        json.put((Object)"labels", (Object)jsonLabels);
        json.put((Object)"values", (Object)jsonValues);
        if (timeSeries.getTotal().isPresent()) {
            json.put((Object)"total", (Object)timeSeries.getTotal().getAsDouble());
        }
        return json;
    }

    private static JSONArray providersToJson(Set<StatisticsProvider> providers) {
        JSONArray json = new JSONArray();
        for (StatisticsProvider provider : providers) {
            JSONObject jsonProvider = new JSONObject();
            JSONArray jsonResolutions = new JSONArray();
            jsonProvider.put((Object)"id", (Object)provider.getId());
            jsonProvider.put((Object)"title", (Object)provider.getTitle());
            jsonProvider.put((Object)"description", (Object)provider.getDescription());
            jsonProvider.put((Object)"resourceType", (Object)provider.getResourceType().name());
            if (provider instanceof TimeSeriesProvider) {
                for (DataResolution resolution : ((TimeSeriesProvider)provider).getDataResolutions()) {
                    jsonResolutions.add((Object)resolution.name());
                }
                jsonProvider.put((Object)"dataResolutions", (Object)jsonResolutions);
            }
            json.add((Object)jsonProvider);
        }
        return json;
    }
}

