/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.statistics.impl;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opencastproject.statistics.api.DataResolution;
import org.opencastproject.statistics.api.ResourceType;
import org.opencastproject.statistics.api.StatisticsCoordinator;
import org.opencastproject.statistics.api.StatisticsProvider;
import org.opencastproject.statistics.api.StatisticsService;
import org.opencastproject.statistics.api.StatisticsUtil;
import org.opencastproject.statistics.api.StatisticsWriter;
import org.opencastproject.statistics.api.TimeSeries;
import org.opencastproject.statistics.api.TimeSeriesProvider;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsServiceImpl
implements StatisticsService,
StatisticsCoordinator {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsServiceImpl.class);
    private Map<String, StatisticsProvider> providers = new ConcurrentHashMap<String, StatisticsProvider>();
    private final Map<String, StatisticsWriter> writers = new HashMap<String, StatisticsWriter>();

    public void activate(ComponentContext cc) {
        logger.info("Activating Statistics Service");
    }

    public void deactivate(ComponentContext cc) {
        logger.info("Deactivating Statistics Service");
    }

    public Set<StatisticsProvider> getProviders() {
        return new HashSet<StatisticsProvider>(this.providers.values());
    }

    public Set<StatisticsProvider> getProviders(ResourceType resourceType) {
        return this.providers.values().stream().filter(p -> p.getResourceType().equals((Object)resourceType)).collect(Collectors.toSet());
    }

    public Optional<StatisticsProvider> getProvider(String providerId) {
        return this.providers.values().stream().filter(p -> p.getId().equals(providerId)).findAny();
    }

    public TimeSeries getTimeSeriesData(StatisticsProvider provider, String resourceId, Instant from, Instant to, DataResolution resolution, ZoneId zoneId) {
        if (!(provider instanceof TimeSeriesProvider)) {
            throw new IllegalArgumentException("The given provider '" + provider.getTitle() + "' (" + provider.getId() + ") does not provide time series data");
        }
        List buckets = StatisticsUtil.getBuckets((Instant)from, (Instant)to, (DataResolution)resolution, (ZoneId)zoneId);
        return StatisticsServiceImpl.fill(((TimeSeriesProvider)provider).getValues(resourceId, from, to, resolution, zoneId), buckets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWriter(StatisticsWriter writer) {
        Map<String, StatisticsWriter> map = this.writers;
        synchronized (map) {
            this.writers.put(writer.getId(), writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriter(String id) {
        Map<String, StatisticsWriter> map = this.writers;
        synchronized (map) {
            this.writers.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDuration(String organizationId, String measurementName, String retentionPolicy, String organizationIdResourceName, String fieldName, TimeUnit temporalResolution, Duration duration) {
        Map<String, StatisticsWriter> map = this.writers;
        synchronized (map) {
            this.writers.values().forEach(writer -> writer.writeDuration(organizationId, measurementName, retentionPolicy, organizationIdResourceName, fieldName, temporalResolution, duration));
        }
    }

    public void addProvider(StatisticsProvider provider) {
        logger.info("Registering statistics provider: {}", (Object)provider.getId());
        this.providers.put(provider.getId(), provider);
    }

    public void removeProvider(StatisticsProvider provider) {
        logger.info("Unregistering statistics provider: {}", (Object)provider.getId());
        this.providers.remove(provider.getId());
    }

    private static TimeSeries fill(TimeSeries timeSeries, List<Instant> buckets) {
        ArrayList filledValues = new ArrayList();
        List labels = buckets.stream().map(Instant::toString).collect(Collectors.toList());
        for (String label : labels) {
            int labelIndex = timeSeries.getLabels().indexOf(label);
            if (labelIndex != -1) {
                filledValues.add(timeSeries.getValues().get(labelIndex));
                continue;
            }
            filledValues.add(0.0);
        }
        TimeSeries result = new TimeSeries(labels, filledValues);
        if (timeSeries.getTotal().isPresent()) {
            result.setTotal(Double.valueOf(timeSeries.getTotal().getAsDouble()));
        }
        return result;
    }
}

