/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.terminationstate.endpoint.impl;

import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.json.simple.JSONObject;
import org.opencastproject.terminationstate.api.TerminationStateService;
import org.opencastproject.terminationstate.endpoint.api.TerminationStateRestService;
import org.opencastproject.util.Log;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="terminationstateservice", title="Termination State Service", abstractText="When put into a termination 'wait' state, this service stops the node accepting further jobs, and once any running jobs complete will change termination to 'ready'. NOTE: The service does not actually shut down the node or instance.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/termination/)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
public class TerminationStateRestServiceImpl
implements TerminationStateRestService {
    private static final Log logger = new Log(LoggerFactory.getLogger(TerminationStateRestServiceImpl.class));
    private TerminationStateService service;

    @GET
    @Path(value="/state")
    @Produces(value={"application/json"})
    @RestQuery(name="stateasjson", description="Returns the Termination State as JSON.  Possible termination states are none, wait and ready.", returnDescription="A JSON representation of the termination state.", responses={@RestResponse(responseCode=200, description="A JSON representation of the termination state."), @RestResponse(responseCode=503, description="The Termination State Service is disabled or unavailable")})
    public Response getState() {
        if (this.service != null) {
            JSONObject json = new JSONObject();
            String state = this.service.getState().toString();
            json.put((Object)"state", (Object)state);
            return Response.ok((Object)json.toJSONString()).build();
        }
        logger.error("TerminationStateService is not available");
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }

    @PUT
    @Path(value="/state")
    @RestQuery(name="setstate", description="Set the termination state. The only permissable values are 'none', 'wait' or 'ready'", returnDescription="Whether the termination state was set successfully", restParameters={@RestParameter(name="state", type=RestParameter.Type.STRING, defaultValue="wait", description="The termination state, the only valid value is 'wait'", isRequired=true)}, responses={@RestResponse(responseCode=204, description="The node is preparing to terminate"), @RestResponse(responseCode=400, description="The state was not valid"), @RestResponse(responseCode=503, description="The Termination State Service is disabled or unavailable")})
    public Response setState(@FormParam(value="state") String state) {
        if (this.service != null) {
            TerminationStateService.TerminationState tState;
            switch (state) {
                case "none": {
                    tState = TerminationStateService.TerminationState.NONE;
                    break;
                }
                case "wait": {
                    tState = TerminationStateService.TerminationState.WAIT;
                    break;
                }
                case "ready": {
                    tState = TerminationStateService.TerminationState.READY;
                    break;
                }
                default: {
                    logger.error("state {} is invalid", new Object[]{state});
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
            this.service.setState(tState);
            return Response.noContent().build();
        }
        logger.error("AWS Autoscaling Termination State Serice is not available");
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }

    public void setService(TerminationStateService service) {
        this.service = service;
    }
}

