/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.terminationstate.impl;

import java.util.Dictionary;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.terminationstate.api.AbstractJobTerminationStateService;
import org.opencastproject.terminationstate.api.TerminationStateService;
import org.opencastproject.util.Log;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.OsgiUtil;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.LoggerFactory;

public final class TerminationStateServiceImpl
extends AbstractJobTerminationStateService {
    private static final Log logger = new Log(LoggerFactory.getLogger(TerminationStateServiceImpl.class));
    public static final String CONFIG_JOB_POLLING_PERIOD = "job.polling.period";
    private static final int DEFAULT_JOB_POLLING_PERIOD = 300;
    protected static final String SCHEDULE_GROUP = AbstractJobTerminationStateService.class.getSimpleName();
    private static final String SCHEDULE_JOB_POLLING = "JobPolling";
    protected static final String SCHEDULE_JOB_POLLING_TRIGGER = "TriggerJobPolling";
    private static final String SCHEDULE_JOB_PARAM_PARENT = "parent";
    private Scheduler scheduler;
    private int jobPollingPeriod = 300;

    protected void activate(ComponentContext componentContext) {
        try {
            this.configure(componentContext.getProperties());
        }
        catch (ConfigurationException e) {
            logger.error("Unable to read configuration, using defaults", new Object[]{e.getMessage()});
        }
        try {
            this.scheduler = new StdSchedulerFactory().getScheduler();
        }
        catch (SchedulerException e) {
            logger.error("Cannot create quartz scheduler", new Object[]{e.getMessage()});
        }
    }

    protected void configure(Dictionary config) throws ConfigurationException {
        this.jobPollingPeriod = (Integer)OsgiUtil.getOptCfgAsInt((Dictionary)config, (String)CONFIG_JOB_POLLING_PERIOD).getOrElse((Object)300);
    }

    public void setState(TerminationStateService.TerminationState state) {
        super.setState(state);
        if (this.getState() != TerminationStateService.TerminationState.NONE) {
            try {
                String host = this.getServiceRegistry().getRegistryHostname();
                this.getServiceRegistry().setMaintenanceStatus(host, true);
            }
            catch (ServiceRegistryException | NotFoundException e) {
                logger.error("Cannot put this host into maintenance", new Object[]{e});
            }
            this.startJobPolling();
        } else {
            try {
                String host = this.getServiceRegistry().getRegistryHostname();
                this.getServiceRegistry().setMaintenanceStatus(host, false);
            }
            catch (ServiceRegistryException | NotFoundException e) {
                logger.error("Cannot take this host out of maintenance", new Object[]{e});
            }
        }
    }

    protected void startJobPolling() {
        try {
            JobDetail job = new JobDetail(SCHEDULE_GROUP, SCHEDULE_JOB_POLLING, CheckTerminationState.class);
            job.getJobDataMap().put((Object)SCHEDULE_JOB_PARAM_PARENT, (Object)this);
            Trigger trigger = TriggerUtils.makeSecondlyTrigger((int)this.jobPollingPeriod);
            trigger.setGroup(SCHEDULE_GROUP);
            trigger.setName(SCHEDULE_JOB_POLLING_TRIGGER);
            this.scheduler.scheduleJob(job, trigger);
            this.scheduler.start();
            logger.info("Started polling if jobs are complete");
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    protected void stopJobPolling() {
        try {
            this.scheduler.deleteJob(SCHEDULE_GROUP, SCHEDULE_JOB_POLLING);
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    private void stop() {
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdown();
            }
        }
        catch (SchedulerException e) {
            logger.error("Failed to stop scheduler", new Object[]{e});
        }
    }

    public void deactivate() {
        this.stop();
    }

    protected void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public static class CheckTerminationState
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            TerminationStateServiceImpl parent = (TerminationStateServiceImpl)((Object)context.getJobDetail().getJobDataMap().get((Object)TerminationStateServiceImpl.SCHEDULE_JOB_PARAM_PARENT));
            if (parent.readyToTerminate()) {
                logger.info("No jobs running, sent complete Lifecycle action");
                parent.stopJobPolling();
            } else if (parent.getState() == TerminationStateService.TerminationState.WAIT) {
                logger.info("Jobs still running");
            }
        }
    }
}

