/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.textanalyzer.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import org.opencastproject.dictionary.api.DictionaryService;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.metadata.mpeg7.MediaTime;
import org.opencastproject.metadata.mpeg7.MediaTimeImpl;
import org.opencastproject.metadata.mpeg7.Mpeg7Catalog;
import org.opencastproject.metadata.mpeg7.Mpeg7CatalogImpl;
import org.opencastproject.metadata.mpeg7.Mpeg7CatalogService;
import org.opencastproject.metadata.mpeg7.SpatioTemporalDecomposition;
import org.opencastproject.metadata.mpeg7.TemporalDecomposition;
import org.opencastproject.metadata.mpeg7.Textual;
import org.opencastproject.metadata.mpeg7.Video;
import org.opencastproject.metadata.mpeg7.VideoSegment;
import org.opencastproject.metadata.mpeg7.VideoText;
import org.opencastproject.metadata.mpeg7.VideoTextImpl;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.textanalyzer.api.TextAnalyzerException;
import org.opencastproject.textanalyzer.api.TextAnalyzerService;
import org.opencastproject.textextractor.api.TextExtractor;
import org.opencastproject.textextractor.api.TextExtractorException;
import org.opencastproject.textextractor.api.TextFrame;
import org.opencastproject.textextractor.api.TextLine;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextAnalyzerServiceImpl
extends AbstractJobProducer
implements TextAnalyzerService,
ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(TextAnalyzerServiceImpl.class);
    public static final String COLLECTION_ID = "ocrtext";
    public static final float DEFAULT_ANALYSIS_JOB_LOAD = 0.2f;
    public static final String ANALYSIS_JOB_LOAD_KEY = "job.load.analysis";
    private float analysisJobLoad = 0.2f;
    private TextExtractor textExtractor = null;
    private ServiceRegistry serviceRegistry = null;
    private Workspace workspace = null;
    protected Mpeg7CatalogService mpeg7CatalogService;
    protected DictionaryService dictionaryService;
    protected SecurityService securityService = null;
    protected UserDirectoryService userDirectoryService = null;
    protected OrganizationDirectoryService organizationDirectoryService = null;

    public TextAnalyzerServiceImpl() {
        super("org.opencastproject.textanalyzer");
    }

    public void activate(ComponentContext cc) {
        logger.info("Activating Text analyser service");
        super.activate(cc);
    }

    public Job extract(Attachment image) throws TextAnalyzerException, MediaPackageException {
        try {
            return this.serviceRegistry.createJob("org.opencastproject.textanalyzer", Operation.Extract.toString(), Arrays.asList(MediaPackageElementParser.getAsXml((MediaPackageElement)image)), Float.valueOf(this.analysisJobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new TextAnalyzerException("Unable to create job", (Throwable)e);
        }
    }

    private Catalog extract(Job job, Attachment image) throws TextAnalyzerException, MediaPackageException {
        Attachment attachment = image;
        URI imageUrl = attachment.getURI();
        File imageFile = null;
        try {
            URI uri;
            InputStream in;
            Mpeg7CatalogImpl mpeg7 = Mpeg7CatalogImpl.newInstance();
            logger.info("Starting text extraction from {}", (Object)imageUrl);
            try {
                imageFile = this.workspace.get(imageUrl);
            }
            catch (NotFoundException e) {
                throw new TextAnalyzerException("Image " + imageUrl + " not found in workspace", (Throwable)e);
            }
            catch (IOException e) {
                throw new TextAnalyzerException("Unable to access " + imageUrl + " in workspace", (Throwable)e);
            }
            VideoText[] videoTexts = this.analyze(imageFile, image.getIdentifier());
            MediaTimeImpl mediaTime = new MediaTimeImpl(0L, 0L);
            Video avContent = mpeg7.addVideoContent(image.getIdentifier(), (MediaTime)mediaTime, null);
            TemporalDecomposition temporalDecomposition = avContent.getTemporalDecomposition();
            VideoSegment videoSegment = (VideoSegment)temporalDecomposition.createSegment("segment-0");
            videoSegment.setMediaTime((MediaTime)mediaTime);
            SpatioTemporalDecomposition spatioTemporalDecomposition = videoSegment.createSpatioTemporalDecomposition(true, false);
            for (VideoText videoText : videoTexts) {
                spatioTemporalDecomposition.addVideoText(videoText);
            }
            logger.info("Text extraction of {} finished, {} lines found", (Object)attachment.getURI(), (Object)videoTexts.length);
            try {
                in = this.mpeg7CatalogService.serialize((Mpeg7Catalog)mpeg7);
            }
            catch (IOException e) {
                throw new TextAnalyzerException("Error serializing mpeg7", (Throwable)e);
            }
            try {
                uri = this.workspace.putInCollection(COLLECTION_ID, job.getId() + ".xml", in);
            }
            catch (IOException e) {
                throw new TextAnalyzerException("Unable to put mpeg7 into the workspace", (Throwable)e);
            }
            Catalog catalog = (Catalog)MediaPackageElementBuilderFactory.newInstance().newElementBuilder().newElement(Catalog.TYPE, MediaPackageElements.TEXTS);
            catalog.setURI(uri);
            logger.debug("Created MPEG7 catalog for {}", (Object)imageUrl);
            Catalog catalog2 = catalog;
            return catalog2;
        }
        catch (Exception e) {
            logger.warn("Error extracting text from " + imageUrl, (Throwable)e);
            if (e instanceof TextAnalyzerException) {
                throw (TextAnalyzerException)e;
            }
            throw new TextAnalyzerException((Throwable)e);
        }
        finally {
            try {
                this.workspace.delete(imageUrl);
            }
            catch (Exception e) {
                logger.warn("Unable to delete temporary text analysis image {}: {}", (Object)imageUrl, (Object)e);
            }
        }
    }

    protected String process(Job job) throws Exception {
        Operation op = null;
        String operation = job.getOperation();
        List arguments = job.getArguments();
        try {
            op = Operation.valueOf(operation);
            switch (op) {
                case Extract: {
                    Attachment element = (Attachment)MediaPackageElementParser.getFromXml((String)((String)arguments.get(0)));
                    Catalog catalog = this.extract(job, element);
                    return MediaPackageElementParser.getAsXml((MediaPackageElement)catalog);
                }
            }
            throw new IllegalStateException("Don't know how to handle operation '" + operation + "'");
        }
        catch (IllegalArgumentException e) {
            throw new ServiceRegistryException("This service can't handle operations of type '" + (Object)((Object)op) + "'", (Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ServiceRegistryException("This argument list for operation '" + (Object)((Object)op) + "' does not meet expectations", (Throwable)e);
        }
        catch (Exception e) {
            throw new ServiceRegistryException("Error handling operation '" + (Object)((Object)op) + "'", (Throwable)e);
        }
    }

    protected VideoText[] analyze(File imageFile, String id) throws TextAnalyzerException {
        ArrayList<VideoTextImpl> videoTexts = new ArrayList<VideoTextImpl>();
        TextFrame textFrame = null;
        try {
            textFrame = this.textExtractor.extract(imageFile);
        }
        catch (IOException e) {
            logger.warn("Error reading image file {}: {}", (Object)imageFile, (Object)e.getMessage());
            throw new TextAnalyzerException((Throwable)e);
        }
        catch (TextExtractorException e) {
            logger.warn("Error extracting text from {}: {}", (Object)imageFile, (Object)e.getMessage());
            throw new TextAnalyzerException((Throwable)e);
        }
        int i = 1;
        for (TextLine line : textFrame.getLines()) {
            if (line.getText() == null) continue;
            VideoTextImpl videoText = new VideoTextImpl(id + "-" + i++);
            videoText.setBoundary(line.getBoundaries());
            Textual text = this.dictionaryService.cleanUpText(line.getText());
            if (text == null) continue;
            videoText.setText(text);
            videoTexts.add(videoText);
        }
        return videoTexts.toArray(new VideoText[videoTexts.size()]);
    }

    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected void setTextExtractor(TextExtractor textExtractor) {
        this.textExtractor = textExtractor;
    }

    protected void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    protected void setMpeg7CatalogService(Mpeg7CatalogService mpeg7CatalogService) {
        this.mpeg7CatalogService = mpeg7CatalogService;
    }

    protected void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectory) {
        this.organizationDirectoryService = organizationDirectory;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        this.analysisJobLoad = LoadUtil.getConfiguredLoadValue((Dictionary)properties, (String)ANALYSIS_JOB_LOAD_KEY, (Float)Float.valueOf(0.2f), (ServiceRegistry)this.serviceRegistry);
    }

    private static enum Operation {
        Extract;

    }
}

