/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory.ldap;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.JaxbUser;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.userdirectory.JpaGroupRoleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class OpencastLdapAuthoritiesPopulator
implements LdapAuthoritiesPopulator {
    public static final String ROLE_CLEAN_REGEXP = "[\\s_]+";
    public static final String ROLE_CLEAN_REPLACEMENT = "_";
    private Set<String> attributeNames;
    private String[] additionalAuthorities;
    private String prefix = "";
    private Set<String> excludedPrefixes = new HashSet<String>();
    private String groupCheckPrefix = null;
    private boolean applyAttributesAsRoles = true;
    private boolean applyAttributesAsGroups = true;
    private Map<String, String[]> ldapAssignmentRoleMap = new HashMap<String, String[]>();
    private Map<String, String[]> ldapAssignmentGroupMap = new HashMap<String, String[]>();
    private boolean uppercase = true;
    private Organization organization;
    private SecurityService securityService;
    private JpaGroupRoleProvider groupRoleProvider;
    private static final Logger logger = LoggerFactory.getLogger(OpencastLdapAuthoritiesPopulator.class);

    public OpencastLdapAuthoritiesPopulator(String attributeNames, String prefix, String[] aExcludedPrefixes, String groupCheckPrefix, boolean applyAttributesAsRoles, boolean applyAttributesAsGroups, Map<String, String[]> ldapAssignmentRoleMap, Map<String, String[]> ldapAssignmentGroupMap, boolean uppercase, Organization organization, SecurityService securityService, JpaGroupRoleProvider groupRoleProvider, String ... additionalAuthorities) {
        logger.debug("Creating new instance");
        if (attributeNames == null) {
            throw new IllegalArgumentException("The attribute list cannot be null");
        }
        if (securityService == null) {
            throw new IllegalArgumentException("The security service cannot be null");
        }
        this.securityService = securityService;
        if (organization == null) {
            throw new IllegalArgumentException("The organization cannot be null");
        }
        this.organization = organization;
        this.attributeNames = new HashSet<String>();
        for (String attributeName : attributeNames.split(",")) {
            String temp = attributeName.trim();
            if (temp.isEmpty()) continue;
            this.attributeNames.add(temp);
        }
        if (this.attributeNames.size() == 0) {
            throw new IllegalArgumentException("At least one valid attribute must be provided");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Roles will be read from the LDAP attributes:");
            for (String attribute : this.attributeNames) {
                logger.debug("\t* {}", (Object)attribute);
            }
        }
        if (groupRoleProvider == null) {
            logger.info("Provided GroupRoleProvider was null. Group roles will therefore not be expanded");
        }
        this.groupRoleProvider = groupRoleProvider;
        this.uppercase = uppercase;
        if (uppercase) {
            logger.debug("Roles will be converted to uppercase");
        } else {
            logger.debug("Roles will NOT be converted to uppercase");
        }
        this.prefix = this.roleCleanUpperCase(prefix, uppercase);
        logger.debug("Role prefix set to: {}", (Object)this.prefix);
        if (aExcludedPrefixes != null) {
            for (String origExcludedPrefix : aExcludedPrefixes) {
                String excludedPrefix = uppercase ? StringUtils.trimToEmpty((String)origExcludedPrefix).toUpperCase() : StringUtils.trimToEmpty((String)origExcludedPrefix);
                if (excludedPrefix.isEmpty()) continue;
                this.excludedPrefixes.add(excludedPrefix);
            }
        }
        if (groupCheckPrefix == null) {
            throw new IllegalArgumentException("The parameter groupCheckPrefix cannot be null");
        }
        this.groupCheckPrefix = groupCheckPrefix;
        if (uppercase) {
            this.groupCheckPrefix = this.groupCheckPrefix.toUpperCase();
        }
        this.applyAttributesAsRoles = applyAttributesAsRoles;
        this.applyAttributesAsGroups = applyAttributesAsGroups;
        if (ldapAssignmentRoleMap != null) {
            this.ldapAssignmentRoleMap = ldapAssignmentRoleMap;
        }
        if (ldapAssignmentGroupMap != null) {
            this.ldapAssignmentGroupMap = ldapAssignmentGroupMap;
        }
        this.additionalAuthorities = additionalAuthorities == null ? new String[0] : (String[])Arrays.stream(additionalAuthorities).map(x -> this.roleCleanUpperCase((String)x, uppercase)).toArray(String[]::new);
        if (logger.isDebugEnabled()) {
            StringBuilder additionalAuthoritiesAsStr = new StringBuilder();
            for (String role : this.additionalAuthorities) {
                additionalAuthoritiesAsStr.append(String.format("\n\t* %s", role));
            }
            logger.debug("Authenticated users will receive the following extra roles:{}", (Object)additionalAuthoritiesAsStr);
        }
    }

    public Collection<? extends GrantedAuthority> getGrantedAuthorities(DirContextOperations userData, String username) {
        logger.debug("user attributes for user {}:\n\t{}", (Object)username, (Object)userData.getAttributes());
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        for (String string : this.attributeNames) {
            logger.debug("Looking for attribute name '{}'", (Object)string);
            try {
                String[] attributeValues = userData.getStringAttributes(string);
                if (attributeValues != null) {
                    for (String attributeValue : attributeValues) {
                        String[] splitValue = attributeValue.split(",");
                        if (this.applyAttributesAsRoles) {
                            String[] roles = splitValue;
                            this.addAuthorities(authorities, roles, false, true);
                            if (this.applyAttributesAsGroups) {
                                String[] groups = (String[])Arrays.stream(splitValue).filter(x -> {
                                    String filter = this.roleCleanUpperCase((String)x, this.uppercase);
                                    return filter.startsWith(this.groupCheckPrefix);
                                }).toArray(String[]::new);
                                this.addAuthorities(authorities, groups, true, true);
                            }
                        }
                        String[] mappedRoles = (String[])Arrays.stream(splitValue).map(x -> this.roleCleanUpperCase((String)x, this.uppercase)).map(x -> this.ldapAssignmentRoleMap.get(x)).filter(x -> x != null).flatMap(x -> Arrays.stream(x)).toArray(String[]::new);
                        this.addAuthorities(authorities, mappedRoles, false, false);
                        String[] mappedGroups = (String[])Arrays.stream(splitValue).map(x -> this.roleCleanUpperCase((String)x, this.uppercase)).map(x -> this.ldapAssignmentGroupMap.get(x)).filter(x -> x != null).flatMap(x -> Arrays.stream(x)).toArray(String[]::new);
                        this.addAuthorities(authorities, mappedGroups, true, false);
                    }
                    continue;
                }
                logger.debug("Could not find any attribute named '{}' in user '{}'", (Object)string, (Object)userData.getDn());
            }
            catch (ClassCastException e) {
                logger.error("Specified attribute containing user roles ('{}') was not of expected type String", (Object)string, (Object)e);
            }
        }
        this.addAuthorities(authorities, this.additionalAuthorities, false, false);
        this.addAuthorities(authorities, (String[])Arrays.stream(this.additionalAuthorities).filter(x -> x.startsWith(this.groupCheckPrefix)).toArray(String[]::new), true, false);
        if (logger.isDebugEnabled()) {
            StringBuilder authorityListAsString = new StringBuilder();
            for (GrantedAuthority authority : authorities) {
                authorityListAsString.append(String.format("\n\t%s", authority));
            }
            logger.debug("Returning user {} with authorities:{}", (Object)username, (Object)authorityListAsString);
        }
        if (this.securityService.getOrganization().equals(this.organization) && (this.securityService.getUser() == null || this.securityService.getUser().getUsername().equals(username))) {
            HashSet<JaxbRole> roles = new HashSet<JaxbRole>();
            for (Role existingRole : this.securityService.getUser().getRoles()) {
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority(existingRole.getName()));
            }
            for (GrantedAuthority authority : authorities) {
                roles.add(new JaxbRole(authority.getAuthority(), JaxbOrganization.fromOrganization((Organization)this.organization)));
            }
            JaxbUser jaxbUser = new JaxbUser(username, "ldap", JaxbOrganization.fromOrganization((Organization)this.organization), roles.toArray(new JaxbRole[0]));
            this.securityService.setUser((User)jaxbUser);
        }
        return authorities;
    }

    public Collection<String> getAttributeNames() {
        return new HashSet<String>(this.attributeNames);
    }

    public String getRolePrefix() {
        return this.prefix;
    }

    public String[] getExcludePrefixes() {
        return this.excludedPrefixes.toArray(new String[0]);
    }

    public boolean getConvertToUpperCase() {
        return this.uppercase;
    }

    public String[] getAdditionalAuthorities() {
        return (String[])this.additionalAuthorities.clone();
    }

    private String roleCleanUpperCase(String rawRole, boolean toUpperCase) {
        if (toUpperCase) {
            return StringUtils.trimToEmpty((String)rawRole).replaceAll(ROLE_CLEAN_REGEXP, ROLE_CLEAN_REPLACEMENT).toUpperCase();
        }
        return StringUtils.trimToEmpty((String)rawRole).replaceAll(ROLE_CLEAN_REGEXP, ROLE_CLEAN_REPLACEMENT);
    }

    private void addAuthorities(Set<GrantedAuthority> authorities, String[] values, boolean addAsGroup, boolean addPrefix) {
        if (values != null) {
            Organization org = this.securityService.getOrganization();
            if (!this.organization.equals(org)) {
                throw new SecurityException(String.format("Current request belongs to the organization \"%s\". Expected \"%s\"", org.getId(), this.organization.getId()));
            }
            for (String value : values) {
                String authority = this.roleCleanUpperCase(value, this.uppercase);
                if (!authority.isEmpty()) {
                    List groupRoles = this.groupRoleProvider != null && addAsGroup ? this.groupRoleProvider.getRolesForGroup(authority) : Collections.emptyList();
                    String prefix = this.prefix;
                    if (addPrefix) {
                        if (!prefix.isEmpty()) {
                            boolean hasExcludePrefix = false;
                            for (String excludePrefix : this.excludedPrefixes) {
                                if (!authority.startsWith(excludePrefix)) continue;
                                hasExcludePrefix = true;
                                break;
                            }
                            if (hasExcludePrefix) {
                                prefix = "";
                            }
                        }
                    } else {
                        prefix = "";
                    }
                    authority = (prefix + authority).replaceAll(ROLE_CLEAN_REGEXP, ROLE_CLEAN_REPLACEMENT);
                    logger.debug("Parsed LDAP role \"{}\" to role \"{}\"", (Object)value, (Object)authority);
                    if (!groupRoles.isEmpty()) {
                        logger.debug("Found group for the group with group role \"{}\"", (Object)authority);
                        for (Role role : groupRoles) {
                            authorities.add((GrantedAuthority)new SimpleGrantedAuthority(role.getName()));
                            logger.debug("\tAdded role from role \"{}\"'s group: {}", (Object)authority, (Object)role);
                        }
                    }
                    authorities.add((GrantedAuthority)new SimpleGrantedAuthority(authority));
                    continue;
                }
                logger.debug("Found empty authority. Ignoring...");
            }
        }
    }

    public void setOrgDirectory(JpaGroupRoleProvider groupRoleProvider) {
        this.groupRoleProvider = groupRoleProvider;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

