/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory.ldap;

import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserProvider;
import org.opencastproject.userdirectory.JpaGroupRoleProvider;
import org.opencastproject.userdirectory.ldap.LdapUserProviderInstance;
import org.opencastproject.userdirectory.ldap.OpencastLdapAuthoritiesPopulator;
import org.opencastproject.util.NotFoundException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class LdapUserProviderFactory
implements ManagedServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(LdapUserProviderFactory.class);
    private static final String PID = "org.opencastproject.userdirectory.ldap";
    private static final String SEARCH_FILTER_KEY = "org.opencastproject.userdirectory.ldap.searchfilter";
    private static final String SEARCH_BASE_KEY = "org.opencastproject.userdirectory.ldap.searchbase";
    private static final String LDAP_URL_KEY = "org.opencastproject.userdirectory.ldap.url";
    private static final String ROLE_ATTRIBUTES_KEY = "org.opencastproject.userdirectory.ldap.roleattributes";
    private static final String ORGANIZATION_KEY = "org.opencastproject.userdirectory.ldap.org";
    private static final String SEARCH_USER_DN = "org.opencastproject.userdirectory.ldap.userDn";
    private static final String SEARCH_PASSWORD = "org.opencastproject.userdirectory.ldap.password";
    private static final String CACHE_SIZE = "org.opencastproject.userdirectory.ldap.cache.size";
    private static final String CACHE_EXPIRATION = "org.opencastproject.userdirectory.ldap.cache.expiration";
    private static final String ROLE_PREFIX_KEY = "org.opencastproject.userdirectory.ldap.roleprefix";
    private static final String EXCLUDE_PREFIXES_KEY = "org.opencastproject.userdirectory.ldap.exclude.prefixes";
    private static final String GROUP_CHECK_PREFIX_KEY = "org.opencastproject.userdirectory.ldap.groupcheckprefix";
    private static final String APPLY_ROLEATTRIBUTES_AS_ROLES_KEY = "org.opencastproject.userdirectory.ldap.roleattributes.applyasroles";
    private static final String APPLY_ROLEATTRIBUTES_AS_GROUPS_KEY = "org.opencastproject.userdirectory.ldap.roleattributes.applyasgroups";
    private static final String ATTRIBUTE_MAPPING_KEY_PREFIX = "org.opencastproject.userdirectory.ldap.map.";
    private static final String ATTRIBUTE_MAPPING_KEY_POSTFIX_VALUE = "value";
    private static final String ATTRIBUTE_MAPPING_KEY_POSTFIX_ROLES = "roles";
    private static final String ATTRIBUTE_MAPPING_KEY_POSTFIX_GROUPS = "groups";
    private static final String UPPERCASE_KEY = "org.opencastproject.userdirectory.ldap.uppercase";
    private static final String INSTANCE_ID_KEY = "org.opencastproject.userdirectory.ldap.id";
    private static final String EXTRA_ROLES_KEY = "org.opencastproject.userdirectory.ldap.extra.roles";
    private static final String INSTANCE_ID_SERVICE_PROPERTY_KEY = "instanceId";
    private Map<String, ServiceRegistration> providerRegistrations = new ConcurrentHashMap<String, ServiceRegistration>();
    private Map<String, ServiceRegistration> authoritiesPopulatorRegistrations = new ConcurrentHashMap<String, ServiceRegistration>();
    private BundleContext bundleContext = null;
    private OrganizationDirectoryService orgDirectory;
    private JpaGroupRoleProvider groupRoleProvider;
    private SecurityService securityService;

    public void setOrgDirectory(OrganizationDirectoryService orgDirectory) {
        this.orgDirectory = orgDirectory;
    }

    public void setGroupRoleProvider(JpaGroupRoleProvider groupRoleProvider) {
        this.groupRoleProvider = groupRoleProvider;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void activate(ComponentContext cc) {
        logger.debug("Activate LdapUserProviderFactory");
        this.bundleContext = cc.getBundleContext();
    }

    public String getName() {
        return PID;
    }

    private String getRequiredProperty(Dictionary properties, String key) throws ConfigurationException {
        String value = (String)properties.get(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new ConfigurationException(key, "missing configuration value");
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        void var25_30;
        logger.debug("Updating LdapUserProviderFactory");
        String searchBase = this.getRequiredProperty(properties, SEARCH_BASE_KEY);
        String searchFilter = this.getRequiredProperty(properties, SEARCH_FILTER_KEY);
        String url = this.getRequiredProperty(properties, LDAP_URL_KEY);
        String instanceId = this.getRequiredProperty(properties, INSTANCE_ID_KEY);
        String roleAttributes = this.getRequiredProperty(properties, ROLE_ATTRIBUTES_KEY);
        String organization = (String)properties.get(ORGANIZATION_KEY);
        String userDn = (String)properties.get(SEARCH_USER_DN);
        String password = (String)properties.get(SEARCH_PASSWORD);
        String rolePrefix = Objects.toString(properties.get(ROLE_PREFIX_KEY), "ROLE_");
        String[] excludePrefixes = StringUtils.split((String)((String)properties.get(EXCLUDE_PREFIXES_KEY)), (String)",");
        String groupCheckPrefix = Objects.toString(properties.get(GROUP_CHECK_PREFIX_KEY), "ROLE_GROUP_");
        boolean convertToUppercase = BooleanUtils.toBoolean((String)Objects.toString(properties.get(UPPERCASE_KEY), "true"));
        int cacheSize = NumberUtils.toInt((String)((String)properties.get(CACHE_SIZE)), (int)1000);
        int cacheExpiration = NumberUtils.toInt((String)((String)properties.get(CACHE_EXPIRATION)), (int)5);
        boolean applyRoleattributesAsRoles = BooleanUtils.toBoolean((String)Objects.toString(properties.get(APPLY_ROLEATTRIBUTES_AS_ROLES_KEY), "true"));
        boolean applyRoleattributesAsGroups = BooleanUtils.toBoolean((String)Objects.toString(properties.get(APPLY_ROLEATTRIBUTES_AS_GROUPS_KEY), "true"));
        if (applyRoleattributesAsGroups && !applyRoleattributesAsRoles) {
            throw new ConfigurationException(APPLY_ROLEATTRIBUTES_AS_GROUPS_KEY, "'org.opencastproject.userdirectory.ldap.roleattributes.applyasroles' needs to be 'true' to enable this option");
        }
        String[] extraRoles = StringUtils.split((String)Objects.toString(properties.get(EXTRA_ROLES_KEY), ""), (String)",");
        HashSet<String> extraRoleSet = new HashSet<String>(Arrays.asList(extraRoles));
        extraRoleSet.addAll(Arrays.asList("ROLE_ANONYMOUS", "ROLE_USER"));
        extraRoles = extraRoleSet.toArray(new String[extraRoles.length]);
        HashMap ldapAssignmentMappingsPreparation = new HashMap();
        Enumeration e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(ATTRIBUTE_MAPPING_KEY_PREFIX)) continue;
            String[] postfix = key.substring(ATTRIBUTE_MAPPING_KEY_PREFIX.length()).split("\\.");
            if (postfix.length != 2) {
                throw new ConfigurationException(key, "Invalid Configkey format, the following format is needed: org.opencastproject.userdirectory.ldap.map.<identifier>.<key>");
            }
            String string = postfix[0];
            String mappingKey = postfix[1];
            HashMap<String, String> keyValueMap = ldapAssignmentMappingsPreparation.getOrDefault(string, new HashMap());
            keyValueMap.put(mappingKey, (String)properties.get(key));
            ldapAssignmentMappingsPreparation.put(string, keyValueMap);
        }
        HashMap<String, String[]> ldapAssignmentRoleMap = new HashMap<String, String[]>();
        HashMap<String, String[]> ldapAssignmentGroupMap = new HashMap<String, String[]>();
        for (Map.Entry entry : ldapAssignmentMappingsPreparation.entrySet()) {
            HashMap mappingConf = (HashMap)entry.getValue();
            String value = StringUtils.trimToNull((String)((String)mappingConf.get(ATTRIBUTE_MAPPING_KEY_POSTFIX_VALUE)));
            String roles = StringUtils.trimToNull((String)((String)mappingConf.get(ATTRIBUTE_MAPPING_KEY_POSTFIX_ROLES)));
            String groups = StringUtils.trimToNull((String)((String)mappingConf.get(ATTRIBUTE_MAPPING_KEY_POSTFIX_GROUPS)));
            if (value == null) {
                throw new ConfigurationException(ATTRIBUTE_MAPPING_KEY_PREFIX + (String)entry.getKey() + ".*", "LDAP mapping incomplete, the key 'value' is needed");
            }
            if (roles == null && groups == null) {
                throw new ConfigurationException(ATTRIBUTE_MAPPING_KEY_PREFIX + (String)entry.getKey() + ".*", "LDAP mapping incomplete, one of the keys 'roles' or 'groups' is needed");
            }
            if (convertToUppercase) {
                value = value.toUpperCase();
            }
            if (roles != null) {
                if (convertToUppercase) {
                    roles = roles.toUpperCase();
                }
                ldapAssignmentRoleMap.put(value, (String[])ArrayUtils.addAll((Object[])ldapAssignmentRoleMap.getOrDefault(value, new String[0]), (Object[])((String[])Arrays.stream(roles.split(",")).map(r -> StringUtils.trimToNull((String)r)).filter(r -> r != null).toArray(String[]::new))));
            }
            if (groups == null) continue;
            if (convertToUppercase) {
                groups = groups.toUpperCase();
            }
            ldapAssignmentGroupMap.put(value, (String[])ArrayUtils.addAll((Object[])ldapAssignmentGroupMap.getOrDefault(value, new String[0]), (Object[])((String[])Arrays.stream(groups.split(",")).map(r -> StringUtils.trimToNull((String)r)).filter(r -> r != null).toArray(String[]::new))));
        }
        ServiceRegistration existingRegistration = this.providerRegistrations.remove(pid);
        if (existingRegistration != null) {
            existingRegistration.unregister();
        }
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{organization})) {
                Organization organization2 = this.orgDirectory.getOrganization(organization);
            } else {
                if (this.orgDirectory.getOrganizations().size() != 1) {
                    throw new NotFoundException("Multiple organizations exist but none is specified");
                }
                Organization organization3 = (Organization)this.orgDirectory.getOrganizations().get(0);
            }
        }
        catch (NotFoundException e2) {
            throw new ConfigurationException(ORGANIZATION_KEY, "no organization with configured id", (Throwable)e2);
        }
        Hashtable<String, String> dict = new Hashtable<String, String>();
        dict.put(INSTANCE_ID_SERVICE_PROPERTY_KEY, instanceId);
        LdapUserProviderInstance provider = new LdapUserProviderInstance(pid, (Organization)var25_30, searchBase, searchFilter, url, userDn, password, roleAttributes, convertToUppercase, cacheSize, cacheExpiration, this.securityService);
        this.providerRegistrations.put(pid, this.bundleContext.registerService(UserProvider.class.getName(), (Object)provider, null));
        OpencastLdapAuthoritiesPopulator authoritiesPopulator = new OpencastLdapAuthoritiesPopulator(roleAttributes, rolePrefix, excludePrefixes, groupCheckPrefix, applyRoleattributesAsRoles, applyRoleattributesAsGroups, ldapAssignmentRoleMap, ldapAssignmentGroupMap, convertToUppercase, (Organization)var25_30, this.securityService, this.groupRoleProvider, extraRoles);
        this.authoritiesPopulatorRegistrations.put(pid, this.bundleContext.registerService(LdapAuthoritiesPopulator.class.getName(), (Object)authoritiesPopulator, dict));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleted(String pid) {
        ServiceRegistration providerRegistration = null;
        ServiceRegistration authoritiesPopulatorRegistration = null;
        try {
            providerRegistration = this.providerRegistrations.remove(pid);
            authoritiesPopulatorRegistration = this.authoritiesPopulatorRegistrations.remove(pid);
            if (providerRegistration != null || authoritiesPopulatorRegistration != null) {
                try {
                    ManagementFactory.getPlatformMBeanServer().unregisterMBean(LdapUserProviderFactory.getObjectName(pid));
                }
                catch (Exception e) {
                    logger.warn("Unable to unregister mbean for pid='{}': {}", (Object)pid, (Object)e.getMessage());
                }
            }
        }
        finally {
            if (providerRegistration != null) {
                providerRegistration.unregister();
            }
            if (authoritiesPopulatorRegistration != null) {
                authoritiesPopulatorRegistration.unregister();
            }
        }
    }

    public static final ObjectName getObjectName(String pid) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(pid + ":type=LDAPRequests");
    }
}

