/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory.ldap;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.CachingUserProviderMXBean;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.JaxbUser;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserProvider;
import org.opencastproject.userdirectory.ldap.LdapUserProviderFactory;
import org.opencastproject.util.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.LdapUserDetailsMapper;
import org.springframework.security.ldap.userdetails.LdapUserDetailsService;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

public class LdapUserProviderInstance
implements UserProvider,
CachingUserProviderMXBean {
    private static final Logger logger = LoggerFactory.getLogger(LdapUserProviderInstance.class);
    public static final String PROVIDER_NAME = "ldap";
    private LdapUserDetailsService delegate = null;
    private Organization organization = null;
    private AtomicLong requests = null;
    private AtomicLong ldapLoads = null;
    private LoadingCache<String, Object> cache = null;
    protected Object nullToken = new Object();
    private SecurityService securityService;
    private String rolePrefix;
    private Set<GrantedAuthority> setExtraRoles = new HashSet<GrantedAuthority>();
    private Set<String> setExcludePrefixes = new HashSet<String>();

    LdapUserProviderInstance(String pid, Organization organization, String searchBase, String searchFilter, String url, String userDn, String password, String roleAttributesGlob, String rolePrefix, String[] extraRoles, String[] excludePrefixes, boolean convertToUppercase, int cacheSize, int cacheExpiration, SecurityService securityService) {
        this.organization = organization;
        this.securityService = securityService;
        logger.debug("Creating LdapUserProvider instance with pid=" + pid + ", and organization=" + organization + ", to LDAP server at url:  " + url);
        DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(url);
        if (StringUtils.isNotBlank((CharSequence)userDn)) {
            contextSource.setPassword(password);
            contextSource.setUserDn(userDn);
            contextSource.setAnonymousReadOnly(false);
        } else {
            contextSource.setAnonymousReadOnly(true);
        }
        try {
            contextSource.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to create a spring context source", (Throwable)e);
        }
        FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(searchBase, searchFilter, (BaseLdapPathContextSource)contextSource);
        userSearch.setReturningAttributes(roleAttributesGlob.split(","));
        this.delegate = new LdapUserDetailsService((LdapUserSearch)userSearch);
        if (StringUtils.isNotBlank((CharSequence)roleAttributesGlob)) {
            LdapUserDetailsMapper mapper = new LdapUserDetailsMapper();
            mapper.setConvertToUpperCase(convertToUppercase);
            mapper.setRoleAttributes(roleAttributesGlob.split(","));
            this.rolePrefix = convertToUppercase ? StringUtils.trimToEmpty((String)rolePrefix).toUpperCase() : StringUtils.trimToEmpty((String)rolePrefix);
            logger.debug("Role prefix set to: \"{}\"", (Object)this.rolePrefix);
            mapper.setRolePrefix("");
            this.delegate.setUserDetailsMapper((UserDetailsContextMapper)mapper);
            if (!this.rolePrefix.isEmpty() && excludePrefixes != null) {
                int n;
                String[] stringArray = excludePrefixes;
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    String excludePrefix = stringArray[n];
                    String cleanPrefix = excludePrefix.trim();
                    if (cleanPrefix.isEmpty()) continue;
                    if (convertToUppercase) {
                        this.setExcludePrefixes.add(cleanPrefix.toUpperCase());
                        continue;
                    }
                    this.setExcludePrefixes.add(cleanPrefix);
                }
                if (logger.isDebugEnabled()) {
                    if (this.setExcludePrefixes.size() > 0) {
                        logger.debug("Exclude prefixes set to:");
                        stringArray = excludePrefixes;
                        n2 = stringArray.length;
                        for (n = 0; n < n2; ++n) {
                            String prefix = stringArray[n];
                            logger.debug("\t* {}", (Object)prefix);
                        }
                    } else {
                        logger.debug("No exclude prefixes defined");
                    }
                }
            }
        }
        if (extraRoles != null) {
            for (String extraRole : extraRoles) {
                String finalRole = StringUtils.trimToEmpty((String)extraRole);
                if (finalRole.isEmpty()) continue;
                if (convertToUppercase) {
                    this.setExtraRoles.add((GrantedAuthority)new SimpleGrantedAuthority(finalRole.toUpperCase()));
                    continue;
                }
                this.setExtraRoles.add((GrantedAuthority)new SimpleGrantedAuthority(finalRole));
            }
        }
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).expireAfterWrite((long)cacheExpiration, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Object>(){

            public Object load(String id) throws Exception {
                User user = LdapUserProviderInstance.this.loadUserFromLdap(id);
                return user == null ? LdapUserProviderInstance.this.nullToken : user;
            }
        });
        this.registerMBean(pid);
    }

    public String getName() {
        return PROVIDER_NAME;
    }

    protected void registerMBean(String pid) {
        this.requests = new AtomicLong();
        this.ldapLoads = new AtomicLong();
        try {
            ObjectName name = LdapUserProviderFactory.getObjectName(pid);
            LdapUserProviderInstance mbean = this;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                mbs.unregisterMBean(name);
            }
            catch (InstanceNotFoundException e) {
                logger.debug(name + " was not registered");
            }
            mbs.registerMBean(mbean, name);
        }
        catch (Exception e) {
            logger.warn("Unable to register {} as an mbean: {}", (Object)this, (Object)e);
        }
    }

    public String getOrganization() {
        return this.organization.getId();
    }

    public User loadUser(String userName) {
        logger.debug("LdapUserProvider is loading user " + userName);
        this.requests.incrementAndGet();
        try {
            Object user = this.cache.getUnchecked((Object)userName);
            if (user == this.nullToken) {
                return null;
            }
            return (JaxbUser)user;
        }
        catch (UncheckedExecutionException e) {
            logger.warn("Exception while loading user " + userName, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User loadUserFromLdap(String userName) {
        if (this.delegate == null || this.cache == null) {
            throw new IllegalStateException("The LDAP user detail service has not yet been configured");
        }
        this.ldapLoads.incrementAndGet();
        UserDetails userDetails = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassloader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(LdapUserProviderFactory.class.getClassLoader());
            try {
                userDetails = this.delegate.loadUserByUsername(userName);
            }
            catch (UsernameNotFoundException e) {
                this.cache.put((Object)userName, this.nullToken);
                User user = null;
                currentThread.setContextClassLoader(originalClassloader);
                return user;
            }
            JaxbOrganization jaxbOrganization = JaxbOrganization.fromOrganization((Organization)this.organization);
            HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
            authorities.addAll(userDetails.getAuthorities());
            authorities.addAll(this.setExtraRoles);
            HashSet<JaxbRole> roles = new HashSet<JaxbRole>();
            for (GrantedAuthority authority : authorities) {
                Object strAuthority = authority.getAuthority();
                boolean hasExcludePrefix = false;
                for (String excludePrefix : this.setExcludePrefixes) {
                    if (!((String)strAuthority).startsWith(excludePrefix)) continue;
                    hasExcludePrefix = true;
                    break;
                }
                if (!hasExcludePrefix) {
                    strAuthority = this.rolePrefix + (String)strAuthority;
                }
                logger.debug("Adding role " + (String)strAuthority + " for user " + userName);
                roles.add(new JaxbRole((String)strAuthority, jaxbOrganization));
            }
            JaxbUser user = new JaxbUser(userDetails.getUsername(), PROVIDER_NAME, jaxbOrganization, roles);
            this.cache.put((Object)userName, (Object)user);
            JaxbUser jaxbUser = user;
            return jaxbUser;
        }
        finally {
            currentThread.setContextClassLoader(originalClassloader);
        }
    }

    public float getCacheHitRatio() {
        if (this.requests.get() == 0L) {
            return 0.0f;
        }
        return (float)(this.requests.get() - this.ldapLoads.get()) / (float)this.requests.get();
    }

    public Iterator<User> findUsers(String query, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        User currentUser = this.securityService.getUser();
        if (this.loadUser(currentUser.getUsername()) != null) {
            ArrayList<User> retVal = new ArrayList<User>();
            retVal.add(this.securityService.getUser());
            return retVal.iterator();
        }
        return Collections.emptyIterator();
    }

    public Iterator<User> getUsers() {
        User currentUser = this.securityService.getUser();
        if (this.loadUser(currentUser.getUsername()) != null) {
            ArrayList<User> retVal = new ArrayList<User>();
            retVal.add(this.securityService.getUser());
            return retVal.iterator();
        }
        return Collections.emptyIterator();
    }

    public long countUsers() {
        if (this.loadUser(this.securityService.getUser().getUsername()) != null) {
            return 1L;
        }
        return 0L;
    }

    public void invalidate(String userName) {
        this.cache.invalidate((Object)userName);
    }
}

