/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory.moodle;

import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Dictionary;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.UserProvider;
import org.opencastproject.userdirectory.moodle.MoodleUserProviderInstance;
import org.opencastproject.userdirectory.moodle.MoodleWebServiceImpl;
import org.opencastproject.util.NotFoundException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ManagedServiceFactory.class}, property={"service.pid=org.opencastproject.userdirectory.moodle", "service.description=Provides Moodle user directory instances"})
public class MoodleUserProviderFactory
implements ManagedServiceFactory {
    public static final String PID = "org.opencastproject.userdirectory.moodle";
    private static final Logger logger = LoggerFactory.getLogger(MoodleUserProviderFactory.class);
    private static final String ORGANIZATION_KEY = "org.opencastproject.userdirectory.moodle.org";
    private static final String MOODLE_URL_KEY = "org.opencastproject.userdirectory.moodle.url";
    private static final String MOODLE_TOKEN_KEY = "org.opencastproject.userdirectory.moodle.token";
    private static final String CACHE_SIZE = "org.opencastproject.userdirectory.moodle.cache.size";
    private static final String CACHE_EXPIRATION = "org.opencastproject.userdirectory.moodle.cache.expiration";
    private static final String GROUP_ROLES_KEY = "org.opencastproject.userdirectory.moodle.group.roles.enabled";
    private static final String COURSE_PATTERN_KEY = "org.opencastproject.userdirectory.moodle.course.pattern";
    private static final String USER_PATTERN_KEY = "org.opencastproject.userdirectory.moodle.user.pattern";
    private static final String GROUP_PATTERN_KEY = "org.opencastproject.userdirectory.moodle.group.pattern";
    private static final String LOWERCASE_USERNAME = "org.opencastproject.userdirectory.moodle.user.lowercase.conversion";
    private static final String CONTEXT_ROLE_PREFIX = "org.opencastproject.userdirectory.moodle.context.role.prefix";
    protected BundleContext bundleContext = null;
    private Map<String, ServiceRegistration> providerRegistrations = new ConcurrentHashMap<String, ServiceRegistration>();
    private OrganizationDirectoryService orgDirectory;

    public static ObjectName getObjectName(String pid) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(pid + ":type=MoodleRequests");
    }

    @Reference
    public void setOrgDirectory(OrganizationDirectoryService orgDirectory) {
        this.orgDirectory = orgDirectory;
    }

    @Activate
    public void activate(ComponentContext cc) {
        logger.debug("Activate MoodleUserProviderFactory");
        this.bundleContext = cc.getBundleContext();
    }

    public String getName() {
        return PID;
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        Organization org;
        URI url;
        logger.debug("updated MoodleUserProviderFactory");
        String adminUserName = StringUtils.trimToNull((String)this.bundleContext.getProperty("org.opencastproject.security.admin.user"));
        String organization = (String)properties.get(ORGANIZATION_KEY);
        if (StringUtils.isBlank((CharSequence)organization)) {
            throw new ConfigurationException(ORGANIZATION_KEY, "is not set");
        }
        String urlStr = (String)properties.get(MOODLE_URL_KEY);
        if (StringUtils.isBlank((CharSequence)urlStr)) {
            throw new ConfigurationException(MOODLE_URL_KEY, "is not set");
        }
        try {
            url = new URI(urlStr);
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException(MOODLE_URL_KEY, "not a URL");
        }
        String token = (String)properties.get(MOODLE_TOKEN_KEY);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new ConfigurationException(MOODLE_TOKEN_KEY, "is not set");
        }
        String groupRolesStr = (String)properties.get(GROUP_ROLES_KEY);
        boolean groupRoles = BooleanUtils.toBoolean((String)groupRolesStr);
        String coursePattern = (String)properties.get(COURSE_PATTERN_KEY);
        String userPattern = (String)properties.get(USER_PATTERN_KEY);
        String groupPattern = (String)properties.get(GROUP_PATTERN_KEY);
        boolean lowercaseUsername = BooleanUtils.toBoolean((String)((String)properties.get(LOWERCASE_USERNAME)));
        String contextRolePrefix = Objects.toString(properties.get(CONTEXT_ROLE_PREFIX), "");
        int cacheSize = 1000;
        try {
            if (properties.get(CACHE_SIZE) != null) {
                cacheSize = Integer.parseInt(properties.get(CACHE_SIZE).toString());
            }
        }
        catch (NumberFormatException e) {
            logger.warn("{} could not be loaded, default value is used: {}", (Object)CACHE_SIZE, (Object)cacheSize);
        }
        int cacheExpiration = 60;
        try {
            if (properties.get(CACHE_EXPIRATION) != null) {
                cacheExpiration = Integer.parseInt(properties.get(CACHE_EXPIRATION).toString());
            }
        }
        catch (NumberFormatException e) {
            logger.warn("{} could not be loaded, default value is used: {}", (Object)CACHE_EXPIRATION, (Object)cacheExpiration);
        }
        ServiceRegistration existingRegistration = this.providerRegistrations.remove(pid);
        if (existingRegistration != null) {
            existingRegistration.unregister();
        }
        try {
            org = this.orgDirectory.getOrganization(organization);
        }
        catch (NotFoundException e) {
            logger.warn("Organization {} not found!", (Object)organization);
            throw new ConfigurationException(ORGANIZATION_KEY, "not found");
        }
        logger.debug("creating new MoodleUserProviderInstance for pid=" + pid);
        MoodleUserProviderInstance provider = new MoodleUserProviderInstance(pid, new MoodleWebServiceImpl(url, token), org, coursePattern, userPattern, groupPattern, groupRoles, cacheSize, cacheExpiration, adminUserName, lowercaseUsername, contextRolePrefix);
        this.providerRegistrations.put(pid, this.bundleContext.registerService(UserProvider.class.getName(), (Object)provider, null));
        this.providerRegistrations.put(pid, this.bundleContext.registerService(RoleProvider.class.getName(), (Object)provider, null));
    }

    public void deleted(String pid) {
        logger.debug("delete MoodleUserProviderInstance for pid=" + pid);
        ServiceRegistration registration = this.providerRegistrations.remove(pid);
        if (registration != null) {
            registration.unregister();
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(MoodleUserProviderFactory.getObjectName(pid));
            }
            catch (Exception e) {
                logger.warn("Unable to unregister mbean for pid='{}': {}", (Object)pid, (Object)e.getMessage());
            }
        }
    }
}

