/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory.moodle;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.PatternSyntaxException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.CachingUserProviderMXBean;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.JaxbUser;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserProvider;
import org.opencastproject.userdirectory.moodle.MoodleUser;
import org.opencastproject.userdirectory.moodle.MoodleUserProviderFactory;
import org.opencastproject.userdirectory.moodle.MoodleWebService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoodleUserProviderInstance
implements UserProvider,
RoleProvider,
CachingUserProviderMXBean {
    private static final String PROVIDER_NAME = "moodle";
    private static final Logger logger = LoggerFactory.getLogger(MoodleUserProviderInstance.class);
    private static final String LEARNER_ROLE_SUFFIX = "Learner";
    private static final String INSTRUCTOR_ROLE_SUFFIX = "Instructor";
    private static final String GROUP_ROLE_PREFIX = "G";
    private static final String GROUP_ROLE_SUFFIX = "Learner";
    private MoodleWebService client;
    private Organization organization;
    private boolean groupRoles;
    private String coursePattern;
    private String userPattern;
    private String groupPattern;
    private final String contextRolePrefix;
    private LoadingCache<String, Object> cache;
    private Object nullToken = new Object();
    private AtomicLong loadUserRequests;
    private AtomicLong moodleWebServiceRequests;
    private final boolean lowercaseUsername;
    private final List<String> ignoredUsernames;

    public MoodleUserProviderInstance(String pid, MoodleWebService client, Organization organization, String coursePattern, String userPattern, String groupPattern, boolean groupRoles, int cacheSize, int cacheExpiration, String adminUserName, boolean lowercaseUsername, String contextRolePrefix) {
        this.client = client;
        this.organization = organization;
        this.groupRoles = groupRoles;
        this.coursePattern = coursePattern;
        this.userPattern = userPattern;
        this.groupPattern = groupPattern;
        this.lowercaseUsername = lowercaseUsername;
        this.contextRolePrefix = contextRolePrefix;
        this.ignoredUsernames = new ArrayList<String>();
        this.ignoredUsernames.add("");
        this.ignoredUsernames.add("anonymous");
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{adminUserName})) {
            this.ignoredUsernames.add(adminUserName);
        }
        logger.info("Creating new MoodleUserProviderInstance(pid={}, url={}, cacheSize={}, cacheExpiration={})", new Object[]{pid, client.getURL(), cacheSize, cacheExpiration});
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).expireAfterWrite((long)cacheExpiration, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Object>(){

            public Object load(String username) {
                User user = MoodleUserProviderInstance.this.loadUserFromMoodle(username);
                return user == null ? MoodleUserProviderInstance.this.nullToken : user;
            }
        });
        this.registerMBean(pid);
    }

    public float getCacheHitRatio() {
        if (this.loadUserRequests.get() == 0L) {
            return 0.0f;
        }
        return (float)(this.loadUserRequests.get() - this.moodleWebServiceRequests.get()) / (float)this.loadUserRequests.get();
    }

    private void registerMBean(String pid) {
        this.loadUserRequests = new AtomicLong();
        this.moodleWebServiceRequests = new AtomicLong();
        try {
            ObjectName name = MoodleUserProviderFactory.getObjectName(pid);
            MoodleUserProviderInstance mbean = this;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                mbs.unregisterMBean(name);
            }
            catch (InstanceNotFoundException e) {
                logger.debug("{} was not registered", (Object)name);
            }
            mbs.registerMBean(mbean, name);
        }
        catch (Exception e) {
            logger.error("Unable to register {} as an mbean: {}", (Object)this, (Object)e);
        }
    }

    public String getName() {
        return PROVIDER_NAME;
    }

    public Iterator<User> getUsers() {
        return Collections.emptyIterator();
    }

    public User loadUser(String userName) {
        this.loadUserRequests.incrementAndGet();
        try {
            Object user = this.cache.getUnchecked((Object)userName);
            if (user == this.nullToken) {
                logger.debug("Returning null user from cache");
                return null;
            }
            logger.debug("Returning user {} from cache", (Object)userName);
            return (User)user;
        }
        catch (ExecutionError e) {
            logger.warn("Exception while loading user {}", (Object)userName, (Object)e);
            return null;
        }
        catch (UncheckedExecutionException e) {
            logger.warn("Exception while loading user {}", (Object)userName, (Object)e);
            return null;
        }
    }

    public long countUsers() {
        return 0L;
    }

    public String getOrganization() {
        return this.organization.getId();
    }

    public Iterator<User> findUsers(String query, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        if (query.endsWith("%")) {
            query = query.substring(0, query.length() - 1);
        }
        if (query.isEmpty()) {
            return Collections.emptyIterator();
        }
        try {
            if (this.userPattern != null && !query.matches(this.userPattern)) {
                logger.debug("verify user {} failed regexp {}", (Object)query, (Object)this.userPattern);
                return Collections.emptyIterator();
            }
        }
        catch (PatternSyntaxException e) {
            logger.warn("Invalid regular expression for user pattern {} - disabling checks", (Object)this.userPattern);
            this.userPattern = null;
        }
        LinkedList<User> users = new LinkedList<User>();
        User user = this.loadUser(query);
        if (user != null) {
            users.add(user);
        }
        return users.iterator();
    }

    public void invalidate(String userName) {
        this.cache.invalidate((Object)userName);
    }

    public List<Role> getRolesForUser(String username) {
        LinkedList<Role> roles = new LinkedList<Role>();
        if (this.ignoredUsernames.stream().anyMatch(u -> u.equals(username))) {
            logger.debug("we don't answer for: {}", (Object)username);
            return roles;
        }
        User user = this.loadUser(username);
        if (user != null) {
            logger.debug("Returning cached role set for {}", (Object)username);
            return new ArrayList<Role>(user.getRoles());
        }
        logger.debug("Return empty role set for {} - not found in Moodle", (Object)username);
        return new LinkedList<Role>();
    }

    public Iterator<Role> findRoles(String query, Role.Target target, int offset, int limit) {
        String moodleId;
        if (target == Role.Target.USER) {
            return Collections.emptyIterator();
        }
        boolean exact = true;
        boolean ltirole = false;
        if (query.endsWith("%")) {
            exact = false;
            query = query.substring(0, query.length() - 1);
        }
        if (query.isEmpty()) {
            return Collections.emptyIterator();
        }
        if (!query.startsWith(this.contextRolePrefix)) {
            return Collections.emptyIterator();
        }
        if (exact && !query.endsWith("_Learner") && !query.endsWith("_Instructor") && !query.endsWith("_Learner")) {
            return Collections.emptyIterator();
        }
        String groupRolePrefix = this.contextRolePrefix + GROUP_ROLE_PREFIX;
        boolean findGroupRole = this.groupRoles && query.startsWith(groupRolePrefix);
        String string = moodleId = findGroupRole ? query.substring(groupRolePrefix.length()) : query;
        if (query.endsWith("_Learner")) {
            moodleId = query.substring(this.contextRolePrefix.length(), query.lastIndexOf("_Learner"));
            ltirole = true;
        } else if (query.endsWith("_Instructor")) {
            moodleId = query.substring(this.contextRolePrefix.length(), query.lastIndexOf("_Instructor"));
            ltirole = true;
        } else if (query.endsWith("_Learner")) {
            moodleId = query.substring(this.contextRolePrefix.length(), query.lastIndexOf("_Learner"));
            ltirole = true;
        }
        String pattern = findGroupRole ? this.groupPattern : this.coursePattern;
        try {
            if (pattern != null && !moodleId.matches(pattern)) {
                logger.debug("Verify Moodle ID {} failed regexp {}", (Object)moodleId, (Object)pattern);
                return Collections.emptyIterator();
            }
        }
        catch (PatternSyntaxException e) {
            logger.warn("Invalid regular expression for pattern {} - disabling checks", (Object)pattern);
            if (findGroupRole) {
                this.groupPattern = null;
            }
            this.coursePattern = null;
        }
        LinkedList<JaxbRole> roles = new LinkedList<JaxbRole>();
        JaxbOrganization jaxbOrganization = JaxbOrganization.fromOrganization((Organization)this.organization);
        if (ltirole) {
            roles.add(new JaxbRole(query, jaxbOrganization, "Moodle Site Role", Role.Type.EXTERNAL));
        } else if (findGroupRole) {
            roles.add(new JaxbRole(this.contextRolePrefix + GROUP_ROLE_PREFIX + moodleId + "_Learner", jaxbOrganization, "Moodle Group Learner Role", Role.Type.EXTERNAL));
        } else {
            roles.add(new JaxbRole(moodleId + "_Instructor", jaxbOrganization, "Moodle Course Instructor Role", Role.Type.EXTERNAL));
            roles.add(new JaxbRole(moodleId + "_Learner", jaxbOrganization, "Moodle Course Learner Role", Role.Type.EXTERNAL));
        }
        return roles.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User loadUserFromMoodle(String username) {
        if (this.lowercaseUsername) {
            username = username.toLowerCase();
        }
        logger.debug("loadUserFromMoodle({})", (Object)username);
        if (this.cache == null) {
            throw new IllegalStateException("The Moodle user detail service has not yet been configured");
        }
        if (this.ignoredUsernames.contains(username)) {
            logger.debug("We don't answer for: " + username);
            return null;
        }
        JaxbOrganization jaxbOrganization = JaxbOrganization.fromOrganization((Organization)this.organization);
        this.moodleWebServiceRequests.incrementAndGet();
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassloader = currentThread.getContextClassLoader();
        try {
            List<MoodleUser> moodleUsers = this.client.coreUserGetUsersByField(MoodleWebService.CoreUserGetUserByFieldFilters.username, Collections.singletonList(username));
            if (moodleUsers.isEmpty()) {
                logger.debug("User {} not found in Moodle system", (Object)username);
                User user = null;
                return user;
            }
            MoodleUser moodleUser = moodleUsers.get(0);
            List<String> courseIdsInstructor = this.client.toolOpencastGetCoursesForInstructor(username);
            List<String> courseIdsLearner = this.client.toolOpencastGetCoursesForLearner(username);
            List<String> groupIdsLearner = this.groupRoles ? this.client.toolOpencastGetGroupsForLearner(username) : Collections.emptyList();
            HashSet<JaxbRole> roles = new HashSet<JaxbRole>();
            roles.add(new JaxbRole("ROLE_GROUP_" + this.contextRolePrefix + "MOODLE", jaxbOrganization, "Moodle Users", Role.Type.EXTERNAL_GROUP));
            for (String courseId : courseIdsInstructor) {
                roles.add(this.contextRole(courseId, INSTRUCTOR_ROLE_SUFFIX, jaxbOrganization));
            }
            for (String courseId : courseIdsLearner) {
                roles.add(this.contextRole(courseId, "Learner", jaxbOrganization));
            }
            for (String groupId : groupIdsLearner) {
                roles.add(this.contextRole(GROUP_ROLE_PREFIX + groupId, "Learner", jaxbOrganization));
            }
            JaxbUser iterator = new JaxbUser(moodleUser.getUsername(), null, moodleUser.getFullname(), moodleUser.getEmail(), this.getName(), jaxbOrganization, roles);
            return iterator;
        }
        catch (Exception e) {
            logger.warn("Exception loading Moodle user {} at {}", (Object)username, (Object)this.client.getURL());
        }
        finally {
            currentThread.setContextClassLoader(originalClassloader);
        }
        return null;
    }

    private JaxbRole contextRole(String context, String contextRole, JaxbOrganization organization) {
        String name = this.contextRolePrefix + context + "_" + contextRole;
        String description = "Moodle Course " + contextRole + " Role";
        return new JaxbRole(name, organization, description, Role.Type.EXTERNAL);
    }
}

