/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory.moodle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.userdirectory.moodle.MoodleUser;
import org.opencastproject.userdirectory.moodle.MoodleUserProviderInstance;
import org.opencastproject.userdirectory.moodle.MoodleWebService;
import org.opencastproject.userdirectory.moodle.MoodleWebServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoodleWebServiceImpl
implements MoodleWebService {
    private static final Logger logger = LoggerFactory.getLogger(MoodleUserProviderInstance.class);
    private static final String OC_USERAGENT = "Opencast";
    private URI url;
    private String token;

    public MoodleWebServiceImpl(URI url, String token) {
        this.url = url;
        this.token = token;
    }

    @Override
    public List<MoodleUser> coreUserGetUsersByField(MoodleWebService.CoreUserGetUserByFieldFilters filter, List<String> values) throws URISyntaxException, IOException, MoodleWebServiceException, ParseException {
        logger.debug("coreUserGetUsersByField(({}, {}))", (Object)filter, values);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("field", filter.toString()));
        for (int i = 0; i < values.size(); ++i) {
            params.add((NameValuePair)new BasicNameValuePair("values[" + i + "]", values.get(i)));
        }
        Object resp = this.executeMoodleRequest("core_user_get_users_by_field", params);
        if (resp == null || !(resp instanceof JSONArray)) {
            throw new MoodleWebServiceException("Moodle responded in unexpected format");
        }
        JSONArray respArray = (JSONArray)resp;
        ArrayList<MoodleUser> users = new ArrayList<MoodleUser>(respArray.size());
        for (Object userObj : respArray) {
            if (!(userObj instanceof JSONObject)) {
                throw new MoodleWebServiceException("Moodle responded in unexpected format");
            }
            JSONObject userJsonObj = (JSONObject)userObj;
            MoodleUser user = new MoodleUser();
            if (userJsonObj.containsKey((Object)"id")) {
                user.setId(userJsonObj.get((Object)"id").toString());
            }
            if (userJsonObj.containsKey((Object)"username")) {
                user.setUsername(userJsonObj.get((Object)"username").toString());
            }
            if (userJsonObj.containsKey((Object)"fullname")) {
                user.setFullname(userJsonObj.get((Object)"fullname").toString());
            }
            if (userJsonObj.containsKey((Object)"idnumber")) {
                user.setIdnumber(userJsonObj.get((Object)"idnumber").toString());
            }
            if (userJsonObj.containsKey((Object)"email")) {
                user.setEmail(userJsonObj.get((Object)"email").toString());
            }
            if (userJsonObj.containsKey((Object)"auth")) {
                user.setAuth(userJsonObj.get((Object)"auth").toString());
            }
            users.add(user);
        }
        return users;
    }

    @Override
    public List<String> toolOpencastGetCoursesForInstructor(String username) throws URISyntaxException, IOException, MoodleWebServiceException, ParseException {
        logger.debug("toolOpencastGetCoursesForInstructor({})", (Object)username);
        List<BasicNameValuePair> params = Collections.singletonList(new BasicNameValuePair("username", username));
        return this.parseIdList(this.executeMoodleRequest("tool_opencast_get_courses_for_instructor", params));
    }

    @Override
    public List<String> toolOpencastGetCoursesForLearner(String username) throws URISyntaxException, IOException, MoodleWebServiceException, ParseException {
        logger.debug("toolOpencastGetCoursesForLearner({})", (Object)username);
        List<BasicNameValuePair> params = Collections.singletonList(new BasicNameValuePair("username", username));
        return this.parseIdList(this.executeMoodleRequest("tool_opencast_get_courses_for_learner", params));
    }

    @Override
    public List<String> toolOpencastGetGroupsForLearner(String username) throws URISyntaxException, IOException, MoodleWebServiceException, ParseException {
        logger.debug("toolOpencastGetGroupsForLearner({})", (Object)username);
        List<BasicNameValuePair> params = Collections.singletonList(new BasicNameValuePair("username", username));
        return this.parseIdList(this.executeMoodleRequest("tool_opencast_get_groups_for_learner", params));
    }

    @Override
    public String getURL() {
        return this.url.toString();
    }

    private List<String> parseIdList(Object resp) throws MoodleWebServiceException {
        if (resp == null) {
            return new LinkedList<String>();
        }
        if (!(resp instanceof JSONArray)) {
            throw new MoodleWebServiceException("Moodle responded in unexpected format");
        }
        JSONArray respArray = (JSONArray)resp;
        ArrayList<String> ids = new ArrayList<String>(respArray.size());
        for (Object courseObj : respArray) {
            if (!(courseObj instanceof JSONObject) || ((JSONObject)courseObj).get((Object)"id") == null) {
                throw new MoodleWebServiceException("Moodle responded in unexpected format");
            }
            ids.add(((JSONObject)courseObj).get((Object)"id").toString());
        }
        return ids;
    }

    private Object executeMoodleRequest(String function, List<NameValuePair> params) throws URISyntaxException, IOException, MoodleWebServiceException, ParseException {
        URIBuilder url = new URIBuilder(this.url);
        url.addParameters(params);
        url.addParameter("wstoken", this.token);
        url.addParameter("wsfunction", function);
        url.addParameter("moodlewsrestformat", "json");
        HttpGet get = new HttpGet(url.build());
        get.setHeader("User-Agent", OC_USERAGENT);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            Object object;
            block13: {
                CloseableHttpResponse resp = client.execute((HttpUriRequest)get);
                try {
                    JSONObject jObj;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(resp.getEntity().getContent()));
                    JSONParser parser = new JSONParser();
                    Object obj = parser.parse((Reader)reader);
                    if (obj instanceof JSONObject && ((jObj = (JSONObject)obj).containsKey((Object)"exception") || jObj.containsKey((Object)"errorcode"))) {
                        throw new MoodleWebServiceException("Moodle returned an error: " + jObj.toJSONString());
                    }
                    object = obj;
                    if (resp == null) break block13;
                }
                catch (Throwable throwable) {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resp.close();
            }
            return object;
        }
    }
}

