/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.endpoint;

import com.google.common.util.concurrent.Striped;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageImpl;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.mediapackage.MediaPackageSupport;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.LocalHashMap;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.SolrUtils;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowDefinitionImpl;
import org.opencastproject.workflow.api.WorkflowDefinitionSet;
import org.opencastproject.workflow.api.WorkflowException;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowInstanceImpl;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowParser;
import org.opencastproject.workflow.api.WorkflowParsingException;
import org.opencastproject.workflow.api.WorkflowQuery;
import org.opencastproject.workflow.api.WorkflowService;
import org.opencastproject.workflow.api.WorkflowSet;
import org.opencastproject.workflow.api.WorkflowStateException;
import org.opencastproject.workflow.api.WorkflowStatistics;
import org.opencastproject.workflow.impl.WorkflowServiceImpl;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="workflowservice", title="Workflow Service", abstractText="This service lists available workflows and starts, stops, suspends and resumes workflow instances.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
public class WorkflowRestService
extends AbstractJobProducerEndpoint {
    private static final int DEFAULT_LIMIT = 20;
    public static final String NEGATE_PREFIX = "-";
    public static final String DESCENDING_SUFFIX = "_DESC";
    private static final Logger logger = LoggerFactory.getLogger(WorkflowRestService.class);
    protected String serverUrl = "http://localhost:8080";
    protected String serviceUrl = this.serverUrl + "/workflow";
    private WorkflowService service;
    protected ServiceRegistry serviceRegistry = null;
    private Workspace workspace;
    private final Striped<Lock> lock = Striped.lazyWeakLock((int)1024);

    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setService(WorkflowService service) {
        this.service = service;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void activate(ComponentContext cc) {
        if (cc == null) {
            this.serverUrl = "http://localhost:8080";
        } else {
            String ccServerUrl = cc.getBundleContext().getProperty("org.opencastproject.server.url");
            logger.info("configured server url is {}", (Object)ccServerUrl);
            this.serverUrl = ccServerUrl == null ? "http://localhost:8080" : ccServerUrl;
            this.serviceUrl = (String)cc.getProperties().get("opencast.service.path");
        }
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/count")
    @RestQuery(name="count", description="Returns the number of workflow instances in a specific state and operation", returnDescription="Returns the number of workflow instances in a specific state and operation", restParameters={@RestParameter(name="state", isRequired=false, description="The workflow state", type=RestParameter.Type.STRING), @RestParameter(name="operation", isRequired=false, description="The current operation", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The number of workflow instances.")})
    public Response getCount(@QueryParam(value="state") WorkflowInstance.WorkflowState state, @QueryParam(value="operation") String operation) {
        try {
            Long count = this.service.countWorkflowInstances(state, operation);
            return Response.ok((Object)count).build();
        }
        catch (WorkflowDatabaseException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="/statistics.xml")
    @RestQuery(name="statisticsasxml", description="Returns the workflow statistics as XML", returnDescription="An XML representation of the workflow statistics.", responses={@RestResponse(responseCode=200, description="An XML representation of the workflow statistics.")})
    public WorkflowStatistics getStatisticsAsXml() throws WorkflowDatabaseException {
        return this.service.getStatistics();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/statistics.json")
    @RestQuery(name="statisticsasjson", description="Returns the workflow statistics as JSON", returnDescription="A JSON representation of the workflow statistics.", responses={@RestResponse(responseCode=200, description="A JSON representation of the workflow statistics.")})
    public WorkflowStatistics getStatisticsAsJson() throws WorkflowDatabaseException {
        return this.getStatisticsAsXml();
    }

    @GET
    @Path(value="definitions.json")
    @Produces(value={"application/json"})
    @RestQuery(name="definitions", description="List all available workflow definitions as JSON", returnDescription="Returns the workflow definitions as JSON", responses={@RestResponse(responseCode=200, description="The workflow definitions.")})
    public WorkflowDefinitionSet getWorkflowDefinitionsAsJson() throws Exception {
        return this.getWorkflowDefinitionsAsXml();
    }

    @GET
    @Path(value="definitions.xml")
    @Produces(value={"application/xml"})
    @RestQuery(name="definitions", description="List all available workflow definitions as XML", returnDescription="Returns the workflow definitions as XML", responses={@RestResponse(responseCode=200, description="The workflow definitions.")})
    public WorkflowDefinitionSet getWorkflowDefinitionsAsXml() throws Exception {
        List list = this.service.listAvailableWorkflowDefinitions();
        return new WorkflowDefinitionSet((Collection)list);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="definition/{id}.json")
    @RestQuery(name="definitionasjson", description="Returns a single workflow definition", returnDescription="Returns a JSON representation of the workflow definition with the specified identifier", pathParameters={@RestParameter(name="id", isRequired=true, description="The workflow definition identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The workflow definition."), @RestResponse(responseCode=404, description="Workflow definition not found.")})
    public Response getWorkflowDefinitionAsJson(@PathParam(value="id") String workflowDefinitionId) throws NotFoundException {
        WorkflowDefinition def;
        try {
            def = this.service.getWorkflowDefinitionById(workflowDefinitionId);
        }
        catch (WorkflowDatabaseException e) {
            throw new WebApplicationException((Throwable)e);
        }
        return Response.ok((Object)def).build();
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="definition/{id}.xml")
    @RestQuery(name="definitionasxml", description="Returns a single workflow definition", returnDescription="Returns an XML representation of the workflow definition with the specified identifier", pathParameters={@RestParameter(name="id", isRequired=true, description="The workflow definition identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The workflow definition."), @RestResponse(responseCode=404, description="Workflow definition not found.")})
    public Response getWorkflowDefinitionAsXml(@PathParam(value="id") String workflowDefinitionId) throws NotFoundException {
        return this.getWorkflowDefinitionAsJson(workflowDefinitionId);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="configurationPanel")
    @RestQuery(name="configpanel", description="Get the configuration panel for a specific workflow", returnDescription="The HTML workflow configuration panel", restParameters={@RestParameter(name="definitionId", isRequired=false, description="The workflow definition identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The workflow configuration panel.")})
    public Response getConfigurationPanel(@QueryParam(value="definitionId") String definitionId) throws NotFoundException {
        try {
            WorkflowDefinition def = this.service.getWorkflowDefinitionById(definitionId);
            String out = def.getConfigurationPanel();
            return Response.ok((Object)out).build();
        }
        catch (WorkflowDatabaseException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="instances.xml")
    @RestQuery(name="workflowsasxml", description="List all workflow instances matching the query parameters", returnDescription="An XML representation of the set of workflows matching these query parameters", restParameters={@RestParameter(name="state", isRequired=false, description="Filter results by workflows' current state", type=RestParameter.Type.STRING), @RestParameter(name="q", isRequired=false, description="Filter results by free text query", type=RestParameter.Type.STRING), @RestParameter(name="seriesId", isRequired=false, description="Filter results by series identifier", type=RestParameter.Type.STRING), @RestParameter(name="seriesTitle", isRequired=false, description="Filter results by series title", type=RestParameter.Type.STRING), @RestParameter(name="creator", isRequired=false, description="Filter results by the mediapackage's creator", type=RestParameter.Type.STRING), @RestParameter(name="contributor", isRequired=false, description="Filter results by the mediapackage's contributor", type=RestParameter.Type.STRING), @RestParameter(name="fromdate", isRequired=false, description="Filter results by workflow start date.", type=RestParameter.Type.STRING), @RestParameter(name="todate", isRequired=false, description="Filter results by workflow start date.", type=RestParameter.Type.STRING), @RestParameter(name="language", isRequired=false, description="Filter results by mediapackage's language.", type=RestParameter.Type.STRING), @RestParameter(name="license", isRequired=false, description="Filter results by mediapackage's license.", type=RestParameter.Type.STRING), @RestParameter(name="title", isRequired=false, description="Filter results by mediapackage's title.", type=RestParameter.Type.STRING), @RestParameter(name="subject", isRequired=false, description="Filter results by mediapackage's subject.", type=RestParameter.Type.STRING), @RestParameter(name="workflowdefinition", isRequired=false, description="Filter results by workflow definition.", type=RestParameter.Type.STRING), @RestParameter(name="mp", isRequired=false, description="Filter results by mediapackage identifier.", type=RestParameter.Type.STRING), @RestParameter(name="op", isRequired=false, description="Filter results by workflows' current operation.", type=RestParameter.Type.STRING), @RestParameter(name="sort", isRequired=false, description="The sort order.  May include any of the following: DATE_CREATED, TITLE, SERIES_TITLE, SERIES_ID, MEDIA_PACKAGE_ID, WORKFLOW_DEFINITION_ID, CREATOR, CONTRIBUTOR, LANGUAGE, LICENSE, SUBJECT.  Add '_DESC' to reverse the sort order (e.g. TITLE_DESC).", type=RestParameter.Type.STRING), @RestParameter(name="startPage", isRequired=false, description="The paging offset", type=RestParameter.Type.INTEGER), @RestParameter(name="count", isRequired=false, description="The number of results to return.", type=RestParameter.Type.INTEGER), @RestParameter(name="compact", isRequired=false, description="Whether to return a compact version of the workflow instance, with mediapackage elements, workflow and workflow operation configurations and non-current operations removed.", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="An XML representation of the workflow set."), @RestResponse(responseCode=400, description="Invalid data was provided in the request.")})
    public Response getWorkflowsAsXml(@QueryParam(value="state") List<String> states, @QueryParam(value="q") String text, @QueryParam(value="seriesId") String seriesId, @QueryParam(value="seriesTitle") String seriesTitle, @QueryParam(value="creator") String creator, @QueryParam(value="contributor") String contributor, @QueryParam(value="fromdate") String fromDate, @QueryParam(value="todate") String toDate, @QueryParam(value="language") String language, @QueryParam(value="license") String license, @QueryParam(value="title") String title, @QueryParam(value="subject") String subject, @QueryParam(value="workflowdefinition") String workflowDefinitionId, @QueryParam(value="mp") String mediapackageId, @QueryParam(value="op") List<String> currentOperations, @QueryParam(value="sort") String sort, @QueryParam(value="startPage") int startPage, @QueryParam(value="count") int count, @QueryParam(value="compact") boolean compact) throws Exception {
        if (count < 1) {
            count = 20;
        }
        WorkflowQuery q = new WorkflowQuery();
        q.withCount((long)count);
        q.withStartPage((long)startPage);
        if (states != null && states.size() > 0) {
            try {
                for (String state : states) {
                    if (StringUtils.isBlank((CharSequence)state)) continue;
                    if (state.startsWith(NEGATE_PREFIX)) {
                        q.withoutState(WorkflowInstance.WorkflowState.valueOf((String)state.substring(1).toUpperCase()));
                        continue;
                    }
                    q.withState(WorkflowInstance.WorkflowState.valueOf((String)state.toUpperCase()));
                }
            }
            catch (IllegalArgumentException e) {
                logger.debug("Unknown workflow state.", (Throwable)e);
            }
        }
        q.withText(text);
        q.withSeriesId(seriesId);
        q.withSeriesTitle(seriesTitle);
        q.withSubject(subject);
        q.withMediaPackage(mediapackageId);
        q.withCreator(creator);
        q.withContributor(contributor);
        try {
            q.withDateAfter(SolrUtils.parseDate((String)fromDate));
            q.withDateBefore(SolrUtils.parseDate((String)toDate));
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid date format").build();
        }
        q.withLanguage(language);
        q.withLicense(license);
        q.withTitle(title);
        q.withWorkflowDefintion(workflowDefinitionId);
        if (currentOperations != null && currentOperations.size() > 0) {
            for (String op : currentOperations) {
                if (StringUtils.isBlank((CharSequence)op)) continue;
                if (op.startsWith(NEGATE_PREFIX)) {
                    q.withoutCurrentOperation(op.substring(1));
                    continue;
                }
                q.withCurrentOperation(op);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sort)) {
            WorkflowQuery.Sort sortField = null;
            if (sort.endsWith(DESCENDING_SUFFIX)) {
                String enumKey = sort.substring(0, sort.length() - DESCENDING_SUFFIX.length()).toUpperCase();
                try {
                    sortField = WorkflowQuery.Sort.valueOf((String)enumKey);
                    q.withSort(sortField, false);
                }
                catch (IllegalArgumentException e) {
                    logger.debug("No sort enum matches '{}'", (Object)enumKey);
                }
            } else {
                try {
                    sortField = WorkflowQuery.Sort.valueOf((String)sort);
                    q.withSort(sortField);
                }
                catch (IllegalArgumentException e) {
                    logger.debug("No sort enum matches '{}'", (Object)sort);
                }
            }
        }
        WorkflowSet set = this.service.getWorkflowInstances(q);
        if (compact) {
            for (WorkflowInstance instance : set.getItems()) {
                WorkflowOperationInstance currentOperation = instance.getCurrentOperation();
                List operations = instance.getOperations();
                operations.clear();
                if (currentOperation != null) {
                    for (String key : currentOperation.getConfigurationKeys()) {
                        currentOperation.removeConfiguration(key);
                    }
                    operations.add(currentOperation);
                }
                instance.setOperations(operations);
                MediaPackage mediaPackage = instance.getMediaPackage();
                Long duration = instance.getMediaPackage().getDuration();
                for (MediaPackageElement element : mediaPackage.elements()) {
                    mediaPackage.remove(element);
                }
                mediaPackage.setDuration(duration);
            }
        }
        return Response.ok((Object)set).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="instances.json")
    @RestQuery(name="workflowsasjson", description="List all workflow instances matching the query parameters", returnDescription="A JSON representation of the set of workflows matching these query parameters", restParameters={@RestParameter(name="state", isRequired=false, description="Filter results by workflows' current state", type=RestParameter.Type.STRING), @RestParameter(name="q", isRequired=false, description="Filter results by free text query", type=RestParameter.Type.STRING), @RestParameter(name="seriesId", isRequired=false, description="Filter results by series identifier", type=RestParameter.Type.STRING), @RestParameter(name="seriesTitle", isRequired=false, description="Filter results by series title", type=RestParameter.Type.STRING), @RestParameter(name="creator", isRequired=false, description="Filter results by the mediapackage's creator", type=RestParameter.Type.STRING), @RestParameter(name="contributor", isRequired=false, description="Filter results by the mediapackage's contributor", type=RestParameter.Type.STRING), @RestParameter(name="fromdate", isRequired=false, description="Filter results by workflow start date.", type=RestParameter.Type.STRING), @RestParameter(name="todate", isRequired=false, description="Filter results by workflow start date.", type=RestParameter.Type.STRING), @RestParameter(name="language", isRequired=false, description="Filter results by mediapackage's language.", type=RestParameter.Type.STRING), @RestParameter(name="license", isRequired=false, description="Filter results by mediapackage's license.", type=RestParameter.Type.STRING), @RestParameter(name="title", isRequired=false, description="Filter results by mediapackage's title.", type=RestParameter.Type.STRING), @RestParameter(name="subject", isRequired=false, description="Filter results by mediapackage's subject.", type=RestParameter.Type.STRING), @RestParameter(name="workflowdefinition", isRequired=false, description="Filter results by workflow definition.", type=RestParameter.Type.STRING), @RestParameter(name="mp", isRequired=false, description="Filter results by mediapackage identifier.", type=RestParameter.Type.STRING), @RestParameter(name="op", isRequired=false, description="Filter results by workflows' current operation.", type=RestParameter.Type.STRING), @RestParameter(name="sort", isRequired=false, description="The sort order.  May include any of the following: DATE_CREATED, TITLE, SERIES_TITLE, SERIES_ID, MEDIA_PACKAGE_ID, WORKFLOW_DEFINITION_ID, CREATOR, CONTRIBUTOR, LANGUAGE, LICENSE, SUBJECT.  Add '_DESC' to reverse the sort order (e.g. TITLE_DESC).", type=RestParameter.Type.STRING), @RestParameter(name="startPage", isRequired=false, description="The paging offset", type=RestParameter.Type.INTEGER), @RestParameter(name="count", isRequired=false, description="The number of results to return.", type=RestParameter.Type.INTEGER), @RestParameter(name="compact", isRequired=false, description="Whether to return a compact version of the workflow instance, with mediapackage elements, workflow and workflow operation configurations and non-current operations removed.", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="A JSON representation of the workflow set.")})
    public Response getWorkflowsAsJson(@QueryParam(value="state") List<String> states, @QueryParam(value="q") String text, @QueryParam(value="seriesId") String seriesId, @QueryParam(value="seriesTitle") String seriesTitle, @QueryParam(value="creator") String creator, @QueryParam(value="contributor") String contributor, @QueryParam(value="fromdate") String fromDate, @QueryParam(value="todate") String toDate, @QueryParam(value="language") String language, @QueryParam(value="license") String license, @QueryParam(value="title") String title, @QueryParam(value="subject") String subject, @QueryParam(value="workflowdefinition") String workflowDefinitionId, @QueryParam(value="mp") String mediapackageId, @QueryParam(value="op") List<String> currentOperations, @QueryParam(value="sort") String sort, @QueryParam(value="startPage") int startPage, @QueryParam(value="count") int count, @QueryParam(value="compact") boolean compact) throws Exception {
        return this.getWorkflowsAsXml(states, text, seriesId, seriesTitle, creator, contributor, fromDate, toDate, language, license, title, subject, workflowDefinitionId, mediapackageId, currentOperations, sort, startPage, count, compact);
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="instance/{id}.xml")
    @RestQuery(name="workflowasxml", description="Get a specific workflow instance.", returnDescription="An XML representation of a workflow instance", pathParameters={@RestParameter(name="id", isRequired=true, description="The workflow instance identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="An XML representation of the workflow instance."), @RestResponse(responseCode=404, description="No workflow instance with that identifier exists.")})
    public WorkflowInstance getWorkflowAsXml(@PathParam(value="id") long id) throws WorkflowDatabaseException, NotFoundException, UnauthorizedException {
        return this.service.getWorkflowById(id);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="instance/{id}.json")
    @RestQuery(name="workflowasjson", description="Get a specific workflow instance.", returnDescription="A JSON representation of a workflow instance", pathParameters={@RestParameter(name="id", isRequired=true, description="The workflow instance identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="A JSON representation of the workflow instance."), @RestResponse(responseCode=404, description="No workflow instance with that identifier exists.")})
    public WorkflowInstance getWorkflowAsJson(@PathParam(value="id") long id) throws WorkflowDatabaseException, NotFoundException, UnauthorizedException {
        return this.getWorkflowAsXml(id);
    }

    @POST
    @Path(value="start")
    @Produces(value={"text/xml"})
    @RestQuery(name="start", description="Start a new workflow instance.", returnDescription="An XML representation of the new workflow instance", restParameters={@RestParameter(name="definition", isRequired=true, description="The workflow definition ID or an XML representation of a workflow definition", type=RestParameter.Type.TEXT, jaxbClass=WorkflowDefinitionImpl.class), @RestParameter(name="mediapackage", isRequired=true, description="The XML representation of a mediapackage", type=RestParameter.Type.TEXT, jaxbClass=MediaPackageImpl.class), @RestParameter(name="parent", isRequired=false, description="An optional parent workflow instance identifier", type=RestParameter.Type.STRING), @RestParameter(name="properties", isRequired=false, description="An optional set of key=value\\n properties", type=RestParameter.Type.TEXT)}, responses={@RestResponse(responseCode=200, description="An XML representation of the new workflow instance."), @RestResponse(responseCode=404, description="If the parent workflow does not exist")})
    public WorkflowInstanceImpl start(@FormParam(value="definition") String workflowDefinitionXmlOrId, @FormParam(value="mediapackage") MediaPackageImpl mp, @FormParam(value="parent") String parentWorkflowId, @FormParam(value="properties") LocalHashMap localMap) {
        WorkflowDefinition workflowDefinition;
        if (mp == null || StringUtils.isBlank((CharSequence)workflowDefinitionXmlOrId)) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            workflowDefinition = this.service.getWorkflowDefinitionById(workflowDefinitionXmlOrId);
        }
        catch (Exception e) {
            try {
                workflowDefinition = WorkflowParser.parseWorkflowDefinition((String)workflowDefinitionXmlOrId);
            }
            catch (WorkflowParsingException wpe) {
                throw new WebApplicationException((Throwable)wpe, Response.Status.BAD_REQUEST);
            }
        }
        return this.startWorkflow(workflowDefinition, mp, parentWorkflowId, localMap);
    }

    private WorkflowInstanceImpl startWorkflow(WorkflowDefinition workflowDefinition, MediaPackageImpl mp, String parentWorkflowId, LocalHashMap localMap) {
        Map properties = new HashMap();
        if (localMap != null) {
            properties = localMap.getMap();
        }
        Long parentIdAsLong = null;
        if (StringUtils.isNotEmpty((CharSequence)parentWorkflowId)) {
            try {
                parentIdAsLong = Long.parseLong(parentWorkflowId);
            }
            catch (NumberFormatException e) {
                throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
            }
        }
        try {
            return (WorkflowInstanceImpl)this.service.start(workflowDefinition, (MediaPackage)mp, parentIdAsLong, properties);
        }
        catch (WorkflowException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (NotFoundException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="stop")
    @Produces(value={"text/xml"})
    @RestQuery(name="stop", description="Stops a workflow instance.", returnDescription="An XML representation of the stopped workflow instance", restParameters={@RestParameter(name="id", isRequired=true, description="The workflow instance identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="An XML representation of the stopped workflow instance."), @RestResponse(responseCode=404, description="No running workflow instance with that identifier exists.")})
    public WorkflowInstance stop(@FormParam(value="id") long workflowInstanceId) throws WorkflowException, NotFoundException, UnauthorizedException {
        return this.service.stop(workflowInstanceId);
    }

    @DELETE
    @Path(value="remove/{id}")
    @Produces(value={"text/plain"})
    @RestQuery(name="remove", description="Danger! Permenantly removes a workflow instance including all its child jobs. In most circumstances, /stop is what you should use.", returnDescription="HTTP 204 No Content", pathParameters={@RestParameter(name="id", isRequired=true, description="The workflow instance identifier", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="force", isRequired=false, description="If the workflow status should be ignored and the workflow removed anyway", type=RestParameter.Type.BOOLEAN, defaultValue="false")}, responses={@RestResponse(responseCode=204, description="If workflow instance could be removed successfully, no content is returned"), @RestResponse(responseCode=404, description="No workflow instance with that identifier exists."), @RestResponse(responseCode=403, description="It's not allowed to remove other workflow instance statues than STOPPED, SUCCEEDED and FAILED (use force parameter to override AT YOUR OWN RISK).")})
    public Response remove(@PathParam(value="id") long workflowInstanceId, @QueryParam(value="force") boolean force) throws WorkflowException, NotFoundException, UnauthorizedException {
        try {
            this.service.remove(workflowInstanceId, force);
        }
        catch (WorkflowStateException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="suspend")
    @Produces(value={"text/xml"})
    @RestQuery(name="suspend", description="Suspends a workflow instance.", returnDescription="An XML representation of the suspended workflow instance", restParameters={@RestParameter(name="id", isRequired=true, description="The workflow instance identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="An XML representation of the suspended workflow instance."), @RestResponse(responseCode=404, description="No running workflow instance with that identifier exists.")})
    public Response suspend(@FormParam(value="id") long workflowInstanceId) throws NotFoundException, UnauthorizedException {
        try {
            WorkflowInstance workflow = this.service.suspend(workflowInstanceId);
            return Response.ok((Object)workflow).build();
        }
        catch (WorkflowException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="resume")
    @Produces(value={"text/xml"})
    @RestQuery(name="resume", description="Resumes a suspended workflow instance.", returnDescription="An XML representation of the resumed workflow instance", restParameters={@RestParameter(name="id", isRequired=true, description="The workflow instance identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="An XML representation of the resumed workflow instance."), @RestResponse(responseCode=409, description="Can not resume workflow not in paused state"), @RestResponse(responseCode=404, description="No suspended workflow instance with that identifier exists."), @RestResponse(responseCode=401, description="You do not have permission to resume. Maybe you need to authenticate.")})
    public Response resume(@FormParam(value="id") long workflowInstanceId, @FormParam(value="properties") LocalHashMap properties) throws NotFoundException, UnauthorizedException {
        return this.resume(workflowInstanceId, null, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="replaceAndresume")
    @Produces(value={"text/xml"})
    @RestQuery(name="replaceAndresume", description="Replaces a suspended workflow instance with an updated version, and resumes the workflow.", returnDescription="An XML representation of the updated and resumed workflow instance", restParameters={@RestParameter(name="id", isRequired=true, description="The workflow instance identifier", type=RestParameter.Type.STRING), @RestParameter(name="mediapackage", isRequired=false, description="The new Mediapackage", type=RestParameter.Type.TEXT), @RestParameter(name="properties", isRequired=false, description="Properties", type=RestParameter.Type.TEXT)}, responses={@RestResponse(responseCode=200, description="An XML representation of the updated and resumed workflow instance."), @RestResponse(responseCode=409, description="Can not resume workflow not in paused state"), @RestResponse(responseCode=404, description="No suspended workflow instance with that identifier exists."), @RestResponse(responseCode=401, description="You do not have permission to resume. Maybe you need to authenticate.")})
    public Response resume(@FormParam(value="id") long workflowInstanceId, @FormParam(value="mediapackage") String mediaPackage, @FormParam(value="properties") LocalHashMap properties) throws NotFoundException, UnauthorizedException {
        HashMap map = properties == null ? new HashMap() : properties.getMap();
        Lock lock = (Lock)this.lock.get((Object)workflowInstanceId);
        lock.lock();
        try {
            WorkflowInstance workflow = this.service.getWorkflowById(workflowInstanceId);
            if (!WorkflowInstance.WorkflowState.PAUSED.equals((Object)workflow.getState())) {
                logger.warn("Can not resume workflow '{}', not in state paused but {}", (Object)workflow, (Object)workflow.getState());
                Response response = Response.status((Response.Status)Response.Status.CONFLICT).build();
                return response;
            }
            if (mediaPackage != null) {
                MediaPackage newMp = MediaPackageParser.getFromXml((String)mediaPackage);
                MediaPackage oldMp = workflow.getMediaPackage();
                for (MediaPackageElement elem : oldMp.getElements()) {
                    if (MediaPackageSupport.contains((String)elem.getIdentifier(), (MediaPackage)newMp)) continue;
                    try {
                        this.workspace.delete(elem.getURI());
                        logger.info("Deleted removed mediapackge element {}", (Object)elem);
                    }
                    catch (NotFoundException e) {
                        logger.info("Removed mediapackage element {} is already deleted", (Object)elem);
                    }
                }
                workflow.setMediaPackage(newMp);
                this.service.update(workflow);
            }
            workflow = this.service.resume(workflowInstanceId, map);
            Response response = Response.ok((Object)workflow).build();
            return response;
        }
        catch (NotFoundException e) {
            Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            return response;
        }
        catch (UnauthorizedException e) {
            Response response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            return response;
        }
        catch (IllegalStateException e) {
            logger.warn(ExceptionUtils.getMessage((Throwable)e));
            Response response = Response.status((Response.Status)Response.Status.CONFLICT).build();
            return response;
        }
        catch (WorkflowException e) {
            logger.error(ExceptionUtils.getMessage((Throwable)e), (Throwable)e);
            Response response = Response.serverError().build();
            return response;
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getMessage((Throwable)e), (Throwable)e);
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            lock.unlock();
        }
    }

    @POST
    @Path(value="update")
    @RestQuery(name="update", description="Updates a workflow instance.", returnDescription="No content.", restParameters={@RestParameter(name="workflow", isRequired=true, description="The XML representation of the workflow instance.", type=RestParameter.Type.TEXT)}, responses={@RestResponse(responseCode=204, description="Workflow instance updated.")})
    public Response update(@FormParam(value="workflow") String workflowInstance) throws NotFoundException, UnauthorizedException {
        try {
            WorkflowInstanceImpl instance = WorkflowParser.parseWorkflowInstance((String)workflowInstance);
            this.service.update((WorkflowInstance)instance);
            return Response.noContent().build();
        }
        catch (WorkflowException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="handlers.json")
    @RestQuery(name="handlers", description="List all registered workflow operation handlers (implementations).", returnDescription="A JSON representation of the registered workflow operation handlers.", responses={@RestResponse(responseCode=200, description="A JSON representation of the registered workflow operation handlers")})
    public Response getOperationHandlers() {
        JSONArray jsonArray = new JSONArray();
        for (WorkflowServiceImpl.HandlerRegistration reg : ((WorkflowServiceImpl)this.service).getRegisteredHandlers()) {
            WorkflowOperationHandler handler = reg.getHandler();
            JSONObject jsonHandler = new JSONObject();
            jsonHandler.put((Object)"id", (Object)handler.getId());
            jsonHandler.put((Object)"description", (Object)handler.getDescription());
            jsonArray.add((Object)jsonHandler);
        }
        return Response.ok((Object)jsonArray.toJSONString()).header("Content-Type", (Object)"application/json").build();
    }

    @GET
    @Path(value="statemappings.json")
    @RestQuery(name="statemappings", description="Get all workflow state mappings", returnDescription="A JSON representation of the workflow state mappings.", responses={@RestResponse(responseCode=200, description="A JSON representation of the workflow state mappings")})
    public Response getStateMappings() {
        return Response.ok((Object)new JSONObject(this.service.getWorkflowStateMappings()).toJSONString()).header("Content-Type", (Object)"application/json").build();
    }

    @Path(value="/cleanup")
    @RestQuery(name="cleanup", description="Cleans up workflow instances", returnDescription="No return value", responses={@RestResponse(responseCode=200, description="Cleanup OK"), @RestResponse(responseCode=400, description="Couldn't parse given state"), @RestResponse(responseCode=401, description="You do not have permission to cleanup. Maybe you need to authenticate."), @RestResponse(responseCode=403, description="It's not allowed to delete other workflow instance statues than STOPPED, SUCCEEDED and FAILED")}, restParameters={@RestParameter(name="buffer", type=RestParameter.Type.INTEGER, defaultValue="30", isRequired=true, description="Lifetime (buffer) in days a workflow instance should live"), @RestParameter(name="state", type=RestParameter.Type.STRING, isRequired=true, description="Workflow instance state, only STOPPED, SUCCEEDED and FAILED are allowed values here")})
    public Response cleanup(@FormParam(value="buffer") int buffer, @FormParam(value="state") String stateParam) throws UnauthorizedException {
        WorkflowInstance.WorkflowState state;
        try {
            state = WorkflowInstance.WorkflowState.valueOf((String)stateParam);
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (state != WorkflowInstance.WorkflowState.SUCCEEDED && state != WorkflowInstance.WorkflowState.FAILED && state != WorkflowInstance.WorkflowState.STOPPED) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            this.service.cleanupWorkflowInstances(buffer, state);
            return Response.ok().build();
        }
        catch (WorkflowDatabaseException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public JobProducer getService() {
        if (this.service instanceof JobProducer) {
            return (JobProducer)this.service;
        }
        return null;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

