/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.impl;

import java.util.Dictionary;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.kernel.scanner.AbstractScanner;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.NeedleEye;
import org.opencastproject.util.data.Option;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.impl.AbstractWorkflowBufferScanner;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowCleanupScanner
extends AbstractWorkflowBufferScanner
implements ManagedService {
    private static final String SCANNER_NAME = "Workflow Cleanup Scanner";
    private static final Logger logger = LoggerFactory.getLogger(WorkflowCleanupScanner.class);
    private static final String JOB_NAME = "mh-workflow-cleanup-job";
    private static final String JOB_GROUP = "mh-workflow-cleanup-job-group";
    private static final String TRIGGER_NAME = "mh-workflow-cleanup-trigger";
    private static final String TRIGGER_GROUP = "mh-workflow-cleanup-trigger-group";
    private static final String PARAM_KEY_BUFFER_SUCCEEDED = "buffer.succeeded";
    private static final String PARAM_KEY_BUFFER_FAILED = "buffer.failed";
    private static final String PARAM_KEY_BUFFER_STOPPED = "buffer.stopped";
    private static final String PARAM_KEY_BUFFER_PARENTLESS = "buffer.parentless";
    protected static int bufferForSuccessfulJobs = -1;
    protected static int bufferForFailedJobs = -1;
    protected static int bufferForStoppedJobs = -1;
    protected static int bufferForParentlessJobs = -1;

    public WorkflowCleanupScanner() {
        try {
            this.quartz = new StdSchedulerFactory().getScheduler();
            this.quartz.start();
            JobDetail job = new JobDetail(this.getJobName(), this.getJobGroup(), Runner.class);
            job.setDurability(false);
            job.setVolatility(true);
            job.getJobDataMap().put((Object)"parent", (Object)this);
            this.quartz.addJob(job, true);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public String getJobGroup() {
        return JOB_GROUP;
    }

    public String getJobName() {
        return JOB_NAME;
    }

    public String getTriggerGroupName() {
        return TRIGGER_GROUP;
    }

    public String getTriggerName() {
        return TRIGGER_NAME;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        boolean enabled = false;
        this.unschedule();
        if (properties != null) {
            logger.debug("Updating configuration...");
            enabled = BooleanUtils.toBoolean((String)((String)properties.get("enabled")));
            this.setEnabled(enabled);
            logger.debug("enabled = {}", (Object)enabled);
            String cronExpression = (String)properties.get("cron-expression");
            if (StringUtils.isBlank((CharSequence)cronExpression)) {
                throw new ConfigurationException("cron-expression", "Cron expression must be valid");
            }
            this.setCronExpression(cronExpression);
            logger.debug("cronExpression = {}", (Object)cronExpression);
            try {
                bufferForSuccessfulJobs = Integer.valueOf((String)properties.get(PARAM_KEY_BUFFER_SUCCEEDED));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(PARAM_KEY_BUFFER_SUCCEEDED, "Buffer must be a valid integer", (Throwable)e);
            }
            logger.debug("bufferForSuccessfulJobs = {}", (Object)bufferForSuccessfulJobs);
            try {
                bufferForFailedJobs = Integer.valueOf((String)properties.get(PARAM_KEY_BUFFER_FAILED));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(PARAM_KEY_BUFFER_FAILED, "Buffer must be a valid integer", (Throwable)e);
            }
            logger.debug("bufferForFailedJobs = {}", (Object)bufferForFailedJobs);
            try {
                bufferForStoppedJobs = Integer.valueOf((String)properties.get(PARAM_KEY_BUFFER_STOPPED));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(PARAM_KEY_BUFFER_STOPPED, "Buffer must be a valid integer", (Throwable)e);
            }
            logger.debug("bufferForStoppedJobs = {}", (Object)bufferForStoppedJobs);
            try {
                bufferForParentlessJobs = Integer.valueOf((String)properties.get(PARAM_KEY_BUFFER_PARENTLESS));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(PARAM_KEY_BUFFER_PARENTLESS, "Buffer must be a valid integer", (Throwable)e);
            }
            logger.debug("bufferForParentlessJobs = {}", (Object)bufferForParentlessJobs);
        }
        this.schedule();
    }

    public void scan() {
        if (bufferForFailedJobs > 0) {
            try {
                this.getWorkflowService().cleanupWorkflowInstances(bufferForFailedJobs, WorkflowInstance.WorkflowState.FAILED);
            }
            catch (WorkflowDatabaseException e) {
                logger.error("Unable to cleanup failed jobs:", (Throwable)e);
            }
            catch (UnauthorizedException e) {
                logger.error("Workflow cleanup job doesn't have right to delete jobs!");
                throw new IllegalStateException(e);
            }
        }
        if (bufferForSuccessfulJobs > 0) {
            try {
                this.getWorkflowService().cleanupWorkflowInstances(bufferForSuccessfulJobs, WorkflowInstance.WorkflowState.SUCCEEDED);
            }
            catch (WorkflowDatabaseException e) {
                logger.error("Unable to cleanup successful jobs:", (Throwable)e);
            }
            catch (UnauthorizedException e) {
                logger.error("Workflow cleanup job doesn't have right to delete jobs!");
                throw new IllegalStateException(e);
            }
        }
        if (bufferForStoppedJobs > 0) {
            try {
                this.getWorkflowService().cleanupWorkflowInstances(bufferForStoppedJobs, WorkflowInstance.WorkflowState.STOPPED);
            }
            catch (WorkflowDatabaseException e) {
                logger.error("Unable to cleanup stopped jobs:", (Throwable)e);
            }
            catch (UnauthorizedException e) {
                logger.error("Workflow cleanup job doesn't have right to delete jobs!");
                throw new IllegalStateException(e);
            }
        }
        if (bufferForParentlessJobs > 0) {
            try {
                this.getServiceRegistry().removeParentlessJobs(bufferForParentlessJobs);
            }
            catch (ServiceRegistryException e) {
                logger.error("There was an error while removing parentless jobs: {}", (Object)e.getMessage());
            }
        }
    }

    public String getScannerName() {
        return SCANNER_NAME;
    }

    public static class Runner
    extends AbstractScanner.TypedQuartzJob<AbstractScanner> {
        private static final NeedleEye eye = new NeedleEye();

        public Runner() {
            super(Option.some((Object)eye));
        }

        protected void execute(AbstractScanner parameters, JobExecutionContext ctx) {
            logger.debug("Starting " + parameters.getScannerName() + " job.");
            for (Organization org : parameters.getOrganizationDirectoryService().getOrganizations()) {
                parameters.getAdminContextFor(org.getId()).runInContext(() -> ((AbstractScanner)parameters).scan());
            }
            logger.info("Finished " + parameters.getScannerName() + " job.");
        }
    }
}

