/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.User;
import org.opencastproject.util.ReadinessIndicator;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowIdentifier;
import org.opencastproject.workflow.api.WorkflowParser;
import org.opencastproject.workflow.api.WorkflowStateMapping;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Workflow Definition Scanner"}, immediate=true, service={ArtifactInstaller.class, WorkflowDefinitionScanner.class})
public class WorkflowDefinitionScanner
implements ArtifactInstaller {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowDefinitionScanner.class);
    protected Map<WorkflowIdentifier, WorkflowDefinition> installedWorkflows = new HashMap<WorkflowIdentifier, WorkflowDefinition>();
    protected Map<String, Set<WorkflowStateMapping>> workflowStateMappings = new HashMap<String, Set<WorkflowStateMapping>>();
    protected Map<File, WorkflowIdentifier> artifactIds = new HashMap<File, WorkflowIdentifier>();
    protected List<File> artifactsWithError = new ArrayList<File>();
    private BundleContext bundleCtx = null;
    private boolean isWFSinitialized = false;
    private WorkflowDefinition currentWFD = null;
    private OrganizationDirectoryService organizationDirectoryService;

    @Reference(name="index")
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    @Activate
    void activate(BundleContext ctx) {
        this.bundleCtx = ctx;
    }

    public void install(File artifact) {
        WorkflowDefinition def = this.currentWFD;
        if (def == null && (def = this.parseWorkflowDefinitionFile(artifact)) == null) {
            logger.warn("Unable to install workflow from '{}'", (Object)artifact.getName());
            this.artifactsWithError.add(artifact);
            return;
        }
        WorkflowIdentifier workflowIdentifier = new WorkflowIdentifier(def.getId(), def.getOrganization());
        for (Map.Entry<File, WorkflowIdentifier> fileWithIdentifier : this.artifactIds.entrySet()) {
            if (!fileWithIdentifier.getValue().equals((Object)workflowIdentifier) || fileWithIdentifier.getKey().equals(artifact)) continue;
            logger.warn("Workflow with identifier '{}' already registered in file '{}', ignoring", (Object)workflowIdentifier, (Object)fileWithIdentifier.getKey());
            this.artifactsWithError.add(artifact);
            return;
        }
        logger.debug("Installing workflow from file '{}'", (Object)artifact.getName());
        this.artifactsWithError.remove(artifact);
        this.artifactIds.put(artifact, workflowIdentifier);
        this.putWorkflowDefinition(workflowIdentifier, def);
        String[] filesInDirectory = artifact.getParentFile().list((arg0, name) -> name.endsWith(".xml"));
        if (filesInDirectory == null) {
            throw new RuntimeException("error retrieving files from directory \"" + artifact.getParentFile() + "\"");
        }
        logger.info("Workflow definition '{}' from file '{}' installed", (Object)workflowIdentifier, (Object)artifact.getName());
        if (filesInDirectory.length - this.artifactsWithError.size() == this.artifactIds.size() && !this.isWFSinitialized) {
            logger.info("{} Workflow definitions loaded, activating Workflow service", (Object)(filesInDirectory.length - this.artifactsWithError.size()));
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("artifact", "workflowdefinition");
            logger.debug("Indicating readiness of workflow definitions");
            this.bundleCtx.registerService(ReadinessIndicator.class.getName(), (Object)new ReadinessIndicator(), properties);
            this.isWFSinitialized = true;
        }
        this.workflowStateMappings.put(def.getId(), def.getStateMappings());
    }

    public void uninstall(File artifact) {
        WorkflowIdentifier identifier = this.artifactIds.remove(artifact);
        if (identifier != null) {
            this.removeWorkflowDefinition(identifier);
            logger.info("Uninstalling workflow definition '{}' from file '{}'", (Object)identifier, (Object)artifact.getName());
        }
    }

    public void update(File artifact) {
        this.currentWFD = this.parseWorkflowDefinitionFile(artifact);
        if (this.currentWFD != null) {
            this.uninstall(artifact);
            this.install(artifact);
            this.currentWFD = null;
        }
    }

    private boolean organizationExists(String organization) {
        return this.organizationDirectoryService.getOrganizations().stream().anyMatch(org -> org.getId().equals(organization));
    }

    public WorkflowDefinition parseWorkflowDefinitionFile(File artifact) {
        WorkflowDefinition workflowDefinition;
        FileInputStream stream = new FileInputStream(artifact);
        try {
            WorkflowDefinition def = WorkflowParser.parseWorkflowDefinition((InputStream)stream);
            if (def.getOperations().size() == 0) {
                logger.warn("Workflow '{}' has no operations", (Object)def.getId());
            }
            if (def.getOrganization() != null && !this.organizationExists(def.getOrganization())) {
                throw new RuntimeException("invalid organization '" + def.getOrganization() + "'");
            }
            workflowDefinition = def;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.warn("Unable to parse workflow from file '{}', {}", (Object)artifact.getName(), (Object)e.getMessage());
                return null;
            }
        }
        ((InputStream)stream).close();
        return workflowDefinition;
    }

    private boolean userCanAccessWorkflow(User user, WorkflowIdentifier wfi) {
        WorkflowDefinition wd = this.installedWorkflows.get(wfi);
        return this.userCanAccessWorkflowDefinition(user, wd);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean userCanAccessWorkflowDefinition(User user, WorkflowDefinition wd) {
        if (wd.getRoles().isEmpty()) return true;
        if (user.hasRole("ROLE_ADMIN")) return true;
        if (!wd.getRoles().stream().anyMatch(arg_0 -> ((User)user).hasRole(arg_0))) return false;
        return true;
    }

    public Stream<WorkflowDefinition> getAvailableWorkflowDefinitions(Organization organization, User user) {
        return this.installedWorkflows.keySet().stream().filter(wfi -> wfi.getOrganization() == null || wfi.getOrganization().equals(organization.getId())).filter(wfi -> this.userCanAccessWorkflow(user, (WorkflowIdentifier)wfi)).map(WorkflowIdentifier::getId).distinct().map(identifier -> this.getWorkflowDefinition(user, new WorkflowIdentifier(identifier, organization.getId())));
    }

    public WorkflowDefinition getWorkflowDefinition(User user, WorkflowIdentifier workflowIdentifier) {
        WorkflowDefinition result = this.installedWorkflows.get(workflowIdentifier);
        if (result != null && this.userCanAccessWorkflowDefinition(user, result)) {
            return result;
        }
        return this.installedWorkflows.get(new WorkflowIdentifier(workflowIdentifier.getId(), null));
    }

    public void putWorkflowDefinition(WorkflowIdentifier identifier, WorkflowDefinition wfd) {
        this.installedWorkflows.put(identifier, wfd);
    }

    public WorkflowDefinition removeWorkflowDefinition(WorkflowIdentifier identifier) {
        return this.installedWorkflows.remove(identifier);
    }

    public boolean canHandle(File artifact) {
        return "workflows".equals(artifact.getParentFile().getName()) && artifact.getName().endsWith(".xml");
    }
}

