/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.impl;

import java.util.Map;
import org.opencastproject.job.api.Incident;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.JobCanceledException;
import org.opencastproject.workflow.api.ResumableWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowException;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationAbortedException;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.conditionparser.WorkflowConditionInterpreter;
import org.opencastproject.workflow.impl.WorkflowServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WorkflowOperationWorker {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowOperationWorker.class);
    private WorkflowOperationHandler handler;
    private WorkflowInstance workflow;
    private WorkflowServiceImpl service;
    private Map<String, String> properties = null;

    private WorkflowOperationWorker(WorkflowOperationHandler handler, WorkflowInstance workflow, WorkflowServiceImpl service) {
        this.handler = handler;
        this.workflow = workflow;
        this.service = service;
    }

    WorkflowOperationWorker(WorkflowOperationHandler handler, WorkflowInstance workflow, Map<String, String> properties, WorkflowServiceImpl service) {
        this(handler, workflow, service);
        this.properties = properties;
    }

    public void setHandler(WorkflowOperationHandler operationHandler) {
        this.handler = operationHandler;
    }

    public WorkflowInstance execute() {
        WorkflowOperationInstance operation = this.workflow.getCurrentOperation();
        try {
            WorkflowOperationResult result;
            switch (operation.getState()) {
                case INSTANTIATED: 
                case RETRY: {
                    result = this.start();
                    break;
                }
                case PAUSED: {
                    result = this.resume();
                    break;
                }
                default: {
                    throw new IllegalStateException("Workflow operation '" + operation + "' is in unexpected state '" + operation.getState() + "'");
                }
            }
            if ((result == null || WorkflowOperationResult.Action.CONTINUE.equals((Object)result.getAction()) || WorkflowOperationResult.Action.SKIP.equals((Object)result.getAction())) && this.handler != null) {
                this.handler.destroy(this.workflow, null);
            }
            this.workflow = this.service.handleOperationResult(this.workflow, result);
            return this.workflow;
        }
        catch (JobCanceledException e) {
            logger.info("Workflow {} operation {} job cancelled: {}", new Object[]{this.workflow.getId(), operation, e.getMessage()});
            return this.workflow;
        }
        catch (WorkflowOperationAbortedException e) {
            logger.info("Workflow operation '" + operation + "' aborted by user");
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            if (t != null) {
                logger.error("Workflow operation '" + operation + "' failed", t);
            } else {
                logger.error("Workflow operation '" + operation + "' failed", (Throwable)e);
            }
            this.service.getServiceRegistry().incident().unhandledException(operation.getId().longValue(), Incident.Severity.FAILURE, (Throwable)e);
        }
        try {
            this.workflow = this.service.handleOperationException(this.workflow, operation);
        }
        catch (Exception e2) {
            logger.error("Error handling workflow operation '{}' failure: {}", new Object[]{operation, e2.getMessage(), e2});
        }
        return this.workflow;
    }

    public WorkflowOperationResult start() throws WorkflowOperationException, WorkflowException, UnauthorizedException {
        boolean execute;
        WorkflowOperationInstance operation = this.workflow.getCurrentOperation();
        String executionCondition = operation.getExecutionCondition();
        if (executionCondition == null) {
            execute = true;
        } else {
            try {
                execute = WorkflowConditionInterpreter.interpret((String)executionCondition);
            }
            catch (IllegalArgumentException e) {
                operation.setState(WorkflowOperationInstance.OperationState.FAILED);
                throw new WorkflowOperationException(String.format("Unable to parse execution condition '%s': %s", executionCondition, e.getMessage()));
            }
        }
        operation.setState(WorkflowOperationInstance.OperationState.RUNNING);
        this.service.update(this.workflow);
        try {
            WorkflowOperationResult result = null;
            if (execute) {
                if (this.handler == null) {
                    logger.warn("No handler available to execute operation '{}'", (Object)operation.getTemplate());
                    throw new IllegalStateException("Unable to find a workflow handler for '" + operation.getTemplate() + "'");
                }
                result = this.handler.start(this.workflow, null);
            } else if (this.handler != null) {
                result = this.handler.skip(this.workflow, null);
                result.setAction(WorkflowOperationResult.Action.SKIP);
            }
            return result;
        }
        catch (Exception e) {
            operation.setState(WorkflowOperationInstance.OperationState.FAILED);
            if (e instanceof WorkflowOperationException) {
                throw (WorkflowOperationException)e;
            }
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    public WorkflowOperationResult resume() throws WorkflowOperationException, WorkflowException, IllegalStateException, UnauthorizedException {
        WorkflowOperationInstance operation = this.workflow.getCurrentOperation();
        if (this.handler == null) {
            logger.warn("No handler available to resume operation '{}'", (Object)operation.getTemplate());
            throw new IllegalStateException("Unable to find a workflow handler for '" + operation.getTemplate() + "'");
        }
        if (!(this.handler instanceof ResumableWorkflowOperationHandler)) {
            throw new IllegalStateException("An attempt was made to resume a non-resumable operation");
        }
        ResumableWorkflowOperationHandler resumableHandler = (ResumableWorkflowOperationHandler)this.handler;
        operation.setState(WorkflowOperationInstance.OperationState.RUNNING);
        this.service.update(this.workflow);
        try {
            return resumableHandler.resume(this.workflow, null, this.properties);
        }
        catch (Exception e) {
            operation.setState(WorkflowOperationInstance.OperationState.FAILED);
            if (e instanceof WorkflowOperationException) {
                throw (WorkflowOperationException)e;
            }
            throw new WorkflowOperationException((Throwable)e);
        }
    }
}

