/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.impl;

import com.entwinemedia.fn.data.Opt;
import com.google.common.util.concurrent.Striped;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.management.ObjectInstance;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.util.WorkflowPropertiesUtil;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.elasticsearch.index.objects.event.EventIndexUtils;
import org.opencastproject.elasticsearch.index.rebuild.AbstractIndexProducer;
import org.opencastproject.elasticsearch.index.rebuild.IndexProducer;
import org.opencastproject.elasticsearch.index.rebuild.IndexRebuildException;
import org.opencastproject.elasticsearch.index.rebuild.IndexRebuildService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.mediapackage.MediaPackageSupport;
import org.opencastproject.metadata.api.MediaPackageMetadata;
import org.opencastproject.metadata.api.MediaPackageMetadataService;
import org.opencastproject.metadata.api.MetadataService;
import org.opencastproject.metadata.api.util.MediaPackageMetadataSupport;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.opencastproject.security.api.AccessControlUtil;
import org.opencastproject.security.api.AclScope;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.serviceregistry.api.UndispatchableJobException;
import org.opencastproject.util.Log;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.ReadinessIndicator;
import org.opencastproject.util.data.Collections;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.jmx.JmxUtil;
import org.opencastproject.workflow.api.ResumableWorkflowOperationHandler;
import org.opencastproject.workflow.api.RetryStrategy;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowException;
import org.opencastproject.workflow.api.WorkflowIdentifier;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowInstanceImpl;
import org.opencastproject.workflow.api.WorkflowListener;
import org.opencastproject.workflow.api.WorkflowOperationDefinition;
import org.opencastproject.workflow.api.WorkflowOperationDefinitionImpl;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationInstanceImpl;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.api.WorkflowOperationResultImpl;
import org.opencastproject.workflow.api.WorkflowParser;
import org.opencastproject.workflow.api.WorkflowParsingException;
import org.opencastproject.workflow.api.WorkflowQuery;
import org.opencastproject.workflow.api.WorkflowService;
import org.opencastproject.workflow.api.WorkflowSet;
import org.opencastproject.workflow.api.WorkflowStateException;
import org.opencastproject.workflow.api.WorkflowStateMapping;
import org.opencastproject.workflow.api.WorkflowStatistics;
import org.opencastproject.workflow.conditionparser.WorkflowConditionInterpreter;
import org.opencastproject.workflow.impl.WorkflowDefinitionScanner;
import org.opencastproject.workflow.impl.WorkflowOperationWorker;
import org.opencastproject.workflow.impl.WorkflowServiceIndex;
import org.opencastproject.workflow.impl.jmx.WorkflowsStatistics;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Workflow Service", "service.pid=org.opencastproject.workflow.impl.WorkflowServiceImpl"}, immediate=true, service={WorkflowService.class, WorkflowServiceImpl.class, IndexProducer.class})
public class WorkflowServiceImpl
extends AbstractIndexProducer
implements WorkflowService,
JobProducer,
ManagedService {
    private static final String RETRY_STRATEGY = "retryStrategy";
    private static final Log logger = new Log(LoggerFactory.getLogger(WorkflowServiceImpl.class));
    public static final String STATS_COLLECT_CONFIG_KEY = "workflowstats.collect";
    public static final Boolean DEFAULT_STATS_COLLECT_CONFIG = false;
    private static final String NULL_PARENT_ID = "-";
    private static final String JMX_WORKFLOWS_STATISTICS_TYPE = "WorkflowsStatistics";
    private static final float WORKFLOW_JOB_LOAD = 0.0f;
    private final List<ObjectInstance> jmxBeans = new ArrayList<ObjectInstance>();
    private WorkflowsStatistics workflowsStatistics;
    public static final String ERROR_RESOLUTION_HANDLER_ID = "error-resolution";
    protected ComponentContext componentContext = null;
    protected boolean workflowStatsCollect = DEFAULT_STATS_COLLECT_CONFIG;
    private SortedSet<MediaPackageMetadataService> metadataServices;
    protected WorkflowServiceIndex index;
    private final List<WorkflowListener> listeners = new CopyOnWriteArrayList<WorkflowListener>();
    protected ThreadPoolExecutor executorService;
    protected Workspace workspace = null;
    protected ServiceRegistry serviceRegistry = null;
    protected SecurityService securityService = null;
    protected AuthorizationService authorizationService = null;
    protected UserDirectoryService userDirectoryService = null;
    protected OrganizationDirectoryService organizationDirectoryService = null;
    protected SeriesService seriesService;
    protected AssetManager assetManager = null;
    private WorkflowDefinitionScanner workflowDefinitionScanner;
    private final List<Long> delayedWorkflows = new ArrayList<Long>();
    private final Striped<Lock> lock = Striped.lazyWeakLock((int)1024);
    private final Striped<Lock> updateLock = Striped.lazyWeakLock((int)1024);
    private final Striped<Lock> mediaPackageLocks = Striped.lazyWeakLock((int)1024);
    private ElasticsearchIndex elasticsearchIndex;

    public WorkflowServiceImpl() {
        this.metadataServices = new TreeSet<MediaPackageMetadataService>(Comparator.comparingInt(MetadataService::getPriority));
    }

    @Activate
    public void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.executorService = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        try {
            logger.info("Generating JMX workflow statistics");
            this.workflowsStatistics = new WorkflowsStatistics(this.getBeanStatistics(), this.getHoldWorkflows());
            this.jmxBeans.add(JmxUtil.registerMXBean((Object)this.workflowsStatistics, (String)JMX_WORKFLOWS_STATISTICS_TYPE));
        }
        catch (WorkflowDatabaseException e) {
            logger.error("Error registering JMX statistic beans", new Object[]{e});
        }
        logger.info("Activate Workflow service");
    }

    @Deactivate
    public void deactivate() {
        for (ObjectInstance mxbean : this.jmxBeans) {
            JmxUtil.unregisterMXBean((ObjectInstance)mxbean);
        }
    }

    public void addWorkflowListener(WorkflowListener listener) {
        this.listeners.add(listener);
    }

    public void removeWorkflowListener(WorkflowListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireListeners(WorkflowInstance oldWorkflowInstance, WorkflowInstance newWorkflowInstance) {
        User currentUser = this.securityService.getUser();
        Organization currentOrganization = this.securityService.getOrganization();
        for (WorkflowListener listener : this.listeners) {
            Runnable runnable;
            if (oldWorkflowInstance == null || !oldWorkflowInstance.getState().equals((Object)newWorkflowInstance.getState())) {
                runnable = () -> {
                    try {
                        this.securityService.setUser(currentUser);
                        this.securityService.setOrganization(currentOrganization);
                        listener.stateChanged(newWorkflowInstance);
                    }
                    finally {
                        this.securityService.setUser(null);
                        this.securityService.setOrganization(null);
                    }
                };
                this.executorService.execute(runnable);
            } else {
                logger.debug("Not notifying %s because the workflow state has not changed", new Object[]{listener});
            }
            if (newWorkflowInstance.getCurrentOperation() != null) {
                if (oldWorkflowInstance != null && oldWorkflowInstance.getCurrentOperation() != null && oldWorkflowInstance.getCurrentOperation().equals(newWorkflowInstance.getCurrentOperation())) continue;
                runnable = () -> {
                    try {
                        this.securityService.setUser(currentUser);
                        this.securityService.setOrganization(currentOrganization);
                        listener.operationChanged(newWorkflowInstance);
                    }
                    finally {
                        this.securityService.setUser(null);
                        this.securityService.setOrganization(null);
                    }
                };
                this.executorService.execute(runnable);
                continue;
            }
            logger.debug("Not notifying %s because the workflow operation has not changed", new Object[]{listener});
        }
    }

    public List<WorkflowDefinition> listAvailableWorkflowDefinitions() {
        return this.workflowDefinitionScanner.getAvailableWorkflowDefinitions(this.securityService.getOrganization(), this.securityService.getUser()).sorted().collect(Collectors.toList());
    }

    public boolean isRunnable(WorkflowDefinition workflowDefinition) {
        List<String> availableOperations = this.listAvailableOperationNames();
        ArrayList<WorkflowDefinition> checkedWorkflows = new ArrayList<WorkflowDefinition>();
        boolean runnable = this.isRunnable(workflowDefinition, availableOperations, checkedWorkflows);
        int wfCount = checkedWorkflows.size() - 1;
        if (runnable) {
            logger.info("Workflow %s, containing %d derived workflows, is runnable", new Object[]{workflowDefinition, wfCount});
        } else {
            logger.warn("Workflow %s, containing %d derived workflows, is not runnable", new Object[]{workflowDefinition, wfCount});
        }
        return runnable;
    }

    private boolean isRunnable(WorkflowDefinition workflowDefinition, List<String> availableOperations, List<WorkflowDefinition> checkedWorkflows) {
        if (checkedWorkflows.contains(workflowDefinition)) {
            return true;
        }
        for (WorkflowOperationDefinition op : workflowDefinition.getOperations()) {
            WorkflowDefinition catchWorkflowDefinition;
            if (!availableOperations.contains(op.getId())) {
                logger.info("%s is not runnable due to missing operation %s", new Object[]{workflowDefinition, op});
                return false;
            }
            String catchWorkflow = op.getExceptionHandlingWorkflow();
            if (catchWorkflow == null) continue;
            try {
                catchWorkflowDefinition = this.getWorkflowDefinitionById(catchWorkflow);
            }
            catch (NotFoundException e) {
                logger.info("%s is not runnable due to missing catch workflow %s on operation %s", new Object[]{workflowDefinition, catchWorkflow, op});
                return false;
            }
            if (this.isRunnable(catchWorkflowDefinition, availableOperations, checkedWorkflows)) continue;
            return false;
        }
        if (!checkedWorkflows.contains(workflowDefinition)) {
            checkedWorkflows.add(workflowDefinition);
        }
        return true;
    }

    public Set<HandlerRegistration> getRegisteredHandlers() {
        ServiceReference[] refs;
        HashSet<HandlerRegistration> set = new HashSet<HandlerRegistration>();
        try {
            refs = this.componentContext.getBundleContext().getServiceReferences(WorkflowOperationHandler.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e);
        }
        if (refs != null) {
            for (ServiceReference ref : refs) {
                WorkflowOperationHandler handler = (WorkflowOperationHandler)this.componentContext.getBundleContext().getService(ref);
                set.add(new HandlerRegistration((String)ref.getProperty("workflow.operation"), handler));
            }
        } else {
            logger.warn("No registered workflow operation handlers found");
        }
        return set;
    }

    protected WorkflowOperationHandler getWorkflowOperationHandler(String operationId) {
        for (HandlerRegistration reg : this.getRegisteredHandlers()) {
            if (!reg.operationName.equals(operationId)) continue;
            return reg.handler;
        }
        return null;
    }

    protected List<String> listAvailableOperationNames() {
        return this.getRegisteredHandlers().parallelStream().map(op -> op.operationName).collect(Collectors.toList());
    }

    public WorkflowInstanceImpl getWorkflowById(long id) throws NotFoundException, UnauthorizedException {
        try {
            Job job = this.serviceRegistry.getJob(id);
            if (Job.Status.DELETED.equals((Object)job.getStatus())) {
                throw new NotFoundException("Workflow '" + id + "' has been deleted");
            }
            if ("org.opencastproject.workflow".equals(job.getJobType()) && Operation.START_WORKFLOW.toString().equals(job.getOperation())) {
                WorkflowInstanceImpl workflow = WorkflowParser.parseWorkflowInstance((String)job.getPayload());
                this.assertPermission((WorkflowInstance)workflow, Permissions.Action.READ.toString(), job.getOrganization());
                return workflow;
            }
            throw new NotFoundException("'" + id + "' is a job identifier, but it is not a workflow identifier");
        }
        catch (WorkflowParsingException e) {
            throw new IllegalStateException("The workflow job payload is malformed");
        }
        catch (ServiceRegistryException e) {
            throw new IllegalStateException("Error loading workflow job from the service registry");
        }
    }

    public WorkflowInstance start(WorkflowDefinition workflowDefinition, MediaPackage mediaPackage) throws WorkflowDatabaseException {
        return this.start(workflowDefinition, mediaPackage, new HashMap<String, String>());
    }

    public WorkflowInstance start(WorkflowDefinition workflowDefinition, MediaPackage mediaPackage, Map<String, String> properties) throws WorkflowDatabaseException {
        try {
            return this.start(workflowDefinition, mediaPackage, null, properties);
        }
        catch (NotFoundException e) {
            throw new IllegalStateException("a null workflow ID caused a NotFoundException.  This is a programming error.");
        }
    }

    public WorkflowInstance start(WorkflowDefinition workflowDefinition, MediaPackage sourceMediaPackage, Long parentWorkflowId, Map<String, String> originalProperties) throws WorkflowDatabaseException, NotFoundException {
        String mediaPackageId = sourceMediaPackage.getIdentifier().toString();
        Map properties = null;
        if (originalProperties != null) {
            WorkflowPropertiesUtil.storeProperties((AssetManager)this.assetManager, (MediaPackage)sourceMediaPackage, originalProperties);
            properties = WorkflowPropertiesUtil.getLatestWorkflowProperties((AssetManager)this.assetManager, (String)mediaPackageId);
        }
        Lock lock = (Lock)this.mediaPackageLocks.get((Object)mediaPackageId);
        lock.lock();
        try {
            logger.startUnitOfWork();
            if (workflowDefinition == null) {
                throw new IllegalArgumentException("workflow definition must not be null");
            }
            Iterator iterator = MediaPackageSupport.sanityCheck((MediaPackage)sourceMediaPackage).iterator();
            if (iterator.hasNext()) {
                List errors = (List)iterator.next();
                throw new IllegalArgumentException("Insane media package cannot be processed: " + Collections.mkString((Collection)errors, (String)"; "));
            }
            if (parentWorkflowId != null) {
                try {
                    this.getWorkflowById(parentWorkflowId);
                }
                catch (UnauthorizedException e) {
                    throw new IllegalArgumentException("Parent workflow " + parentWorkflowId + " not visible to this user");
                }
            } else {
                WorkflowQuery wfq = new WorkflowQuery().withMediaPackage(mediaPackageId).isActive();
                WorkflowSet mpWorkflowInstances = this.getWorkflowInstances(wfq);
                if (mpWorkflowInstances.size() > 0L) {
                    throw new IllegalStateException(String.format("Can't start workflow '%s' for media package '%s' because another workflow is currently active.", workflowDefinition.getTitle(), sourceMediaPackage.getIdentifier().toString()));
                }
            }
            User currentUser = this.securityService.getUser();
            if (currentUser == null) {
                throw new SecurityException("Current user is unknown");
            }
            Organization organization = this.securityService.getOrganization();
            if (organization == null) {
                throw new SecurityException("Current organization is unknown");
            }
            WorkflowInstanceImpl workflowInstance = new WorkflowInstanceImpl(workflowDefinition, sourceMediaPackage, parentWorkflowId, currentUser, organization, properties);
            workflowInstance = this.updateConfiguration((WorkflowInstance)workflowInstance, properties);
            try {
                String workflowDefinitionXml = WorkflowParser.toXml((WorkflowDefinition)workflowDefinition);
                String workflowInstanceXml = WorkflowParser.toXml((WorkflowInstance)workflowInstance);
                String mediaPackageXml = MediaPackageParser.getAsXml((MediaPackage)sourceMediaPackage);
                ArrayList<String> arguments = new ArrayList<String>();
                arguments.add(workflowDefinitionXml);
                arguments.add(mediaPackageXml);
                if (parentWorkflowId != null || properties != null) {
                    String parentWorkflowIdString = parentWorkflowId != null ? parentWorkflowId.toString() : NULL_PARENT_ID;
                    arguments.add(parentWorkflowIdString);
                }
                if (properties != null) {
                    arguments.add(this.mapToString(properties));
                }
                Job job = this.serviceRegistry.createJob("org.opencastproject.workflow", Operation.START_WORKFLOW.toString(), arguments, workflowInstanceXml, false, null, Float.valueOf(0.0f));
                workflowInstance.setId(job.getId());
                this.update((WorkflowInstance)workflowInstance);
                WorkflowInstanceImpl workflowInstanceImpl = workflowInstance;
                return workflowInstanceImpl;
            }
            catch (Throwable t) {
                try {
                    workflowInstance.setState(WorkflowInstance.WorkflowState.FAILED);
                    this.update((WorkflowInstance)workflowInstance);
                }
                catch (Exception failureToFail) {
                    logger.warn((Throwable)failureToFail, "Unable to update workflow to failed state");
                }
                throw new WorkflowDatabaseException(t);
            }
        }
        finally {
            logger.endUnitOfWork();
            lock.unlock();
        }
    }

    protected WorkflowInstance updateConfiguration(WorkflowInstance instance, Map<String, String> properties) {
        try {
            if (properties != null) {
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    instance.setConfiguration(entry.getKey(), entry.getValue());
                }
            }
            HashMap<String, String> wfProperties = new HashMap<String, String>();
            for (String key2 : instance.getConfigurationKeys()) {
                wfProperties.put(key2, instance.getConfiguration(key2));
            }
            Function<String, String> function = key -> this.componentContext == null ? null : this.componentContext.getBundleContext().getProperty(key);
            if (instance.getOperations().stream().anyMatch(op -> op.getExecutionCondition() != null)) {
                instance = WorkflowParser.parseWorkflowInstance((String)WorkflowParser.toXml((WorkflowInstance)instance));
                instance.getOperations().stream().filter(op -> op.getExecutionCondition() != null).forEach(op -> op.setExecutionCondition(WorkflowConditionInterpreter.replaceVariables((String)op.getExecutionCondition(), (Function)systemVariableGetter, (Map)properties, (boolean)true)));
            }
            String xml = WorkflowConditionInterpreter.replaceVariables((String)WorkflowParser.toXml((WorkflowInstance)instance), function, wfProperties, (boolean)false);
            return WorkflowParser.parseWorkflowInstance((String)xml);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to replace workflow instance variables", e);
        }
    }

    protected WorkflowOperationHandler selectOperationHandler(WorkflowOperationInstance operation) {
        ArrayList<WorkflowOperationHandler> handlerList = new ArrayList<WorkflowOperationHandler>();
        for (HandlerRegistration handlerReg : this.getRegisteredHandlers()) {
            if (handlerReg.operationName == null || !handlerReg.operationName.equals(operation.getTemplate())) continue;
            handlerList.add(handlerReg.handler);
        }
        if (handlerList.size() > 1) {
            throw new IllegalStateException("Multiple operation handlers found for operation '" + operation.getTemplate() + "'");
        }
        if (handlerList.size() == 1) {
            return (WorkflowOperationHandler)handlerList.get(0);
        }
        logger.warn("No workflow operation handlers found for operation '%s'", new Object[]{operation.getTemplate()});
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Job runWorkflow(WorkflowInstance workflow) throws WorkflowException, UnauthorizedException {
        if (!WorkflowInstance.WorkflowState.INSTANTIATED.equals((Object)workflow.getState())) {
            if (!WorkflowInstance.WorkflowState.RUNNING.equals((Object)workflow.getState())) throw new IllegalStateException("Cannot start a workflow in state '" + workflow.getState() + "'");
            WorkflowOperationInstance currentOperation = workflow.getCurrentOperation();
            if (currentOperation == null) throw new IllegalStateException("Cannot start a workflow '" + workflow + "' with no current operation");
            if (currentOperation.getId() != null) {
                try {
                    Job operationJob = this.serviceRegistry.getJob(currentOperation.getId().longValue());
                    if (Job.Status.RUNNING.equals((Object)operationJob.getStatus())) {
                        logger.debug("Not starting workflow %s, it is already in running state", new Object[]{workflow});
                        return null;
                    }
                    logger.info("Scheduling next operation of workflow %s", new Object[]{workflow});
                    operationJob.setStatus(Job.Status.QUEUED);
                    operationJob.setDispatchable(true);
                    return this.serviceRegistry.updateJob(operationJob);
                }
                catch (Exception e) {
                    logger.warn("Error determining status of current workflow operation in {}: {}", new Object[]{workflow, e.getMessage()});
                    return null;
                }
            }
        }
        workflow.setState(WorkflowInstance.WorkflowState.RUNNING);
        this.update(workflow);
        WorkflowOperationInstance operation = workflow.getCurrentOperation();
        if (operation == null) {
            throw new IllegalStateException("Cannot start a workflow without a current operation");
        }
        if (operation.getPosition() != 0) {
            throw new IllegalStateException("Current operation expected to be first");
        }
        try {
            logger.info("Scheduling workflow %s for execution", new Object[]{workflow.getId()});
            Job job = this.serviceRegistry.createJob("org.opencastproject.workflow", Operation.START_OPERATION.toString(), java.util.Collections.singletonList(Long.toString(workflow.getId())), null, false, null, Float.valueOf(0.0f));
            operation.setId(Long.valueOf(job.getId()));
            this.update(workflow);
            job.setStatus(Job.Status.QUEUED);
            job.setDispatchable(true);
            return this.serviceRegistry.updateJob(job);
        }
        catch (ServiceRegistryException e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
        catch (NotFoundException e) {
            throw new IllegalStateException("Unable to find a job that was just created");
        }
    }

    protected WorkflowOperationInstance runWorkflowOperation(WorkflowInstance workflow, Map<String, String> properties) throws WorkflowException, UnauthorizedException {
        WorkflowOperationInstance processingOperation = workflow.getCurrentOperation();
        if (processingOperation == null) {
            throw new IllegalStateException("Workflow '" + workflow + "' has no operation to run");
        }
        WorkflowInstance.WorkflowState initialState = workflow.getState();
        WorkflowOperationHandler operationHandler = this.selectOperationHandler(processingOperation);
        WorkflowOperationWorker worker = new WorkflowOperationWorker(operationHandler, workflow, properties, this);
        workflow = worker.execute();
        int currentOperationPosition = processingOperation.getPosition();
        processingOperation = (WorkflowOperationInstance)workflow.getOperations().get(currentOperationPosition);
        Long currentOperationJobId = processingOperation.getId();
        try {
            this.updateOperationJob(currentOperationJobId, processingOperation.getState());
        }
        catch (NotFoundException e) {
            throw new IllegalStateException("Unable to find a job that has already been running");
        }
        catch (ServiceRegistryException e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
        WorkflowOperationInstance currentOperation = workflow.getCurrentOperation();
        if (currentOperation == null) {
            if (WorkflowInstance.WorkflowState.FAILING.equals((Object)workflow.getState())) {
                workflow.setState(WorkflowInstance.WorkflowState.FAILED);
            } else if (!WorkflowInstance.WorkflowState.FAILED.equals((Object)workflow.getState())) {
                workflow.setState(WorkflowInstance.WorkflowState.SUCCEEDED);
                for (WorkflowOperationInstance op : workflow.getOperations()) {
                    if (!op.getState().equals((Object)WorkflowOperationInstance.OperationState.FAILED) || !op.isFailWorkflowOnException()) continue;
                    workflow.setState(WorkflowInstance.WorkflowState.FAILED);
                    break;
                }
            }
            logger.debug("%s has %s", new Object[]{workflow, workflow.getState()});
            this.update(workflow);
        } else {
            WorkflowInstance.WorkflowState dbWorkflowState;
            try {
                dbWorkflowState = this.getWorkflowById(workflow.getId()).getState();
            }
            catch (NotFoundException e) {
                throw new IllegalStateException("The workflow with ID " + workflow.getId() + " can not be found in the database", e);
            }
            catch (UnauthorizedException e) {
                throw new IllegalStateException("The workflow with ID " + workflow.getId() + " can not be read", e);
            }
            if (!dbWorkflowState.equals((Object)initialState)) {
                logger.info("Workflow state for %s was changed to '%s' from the outside", new Object[]{workflow, dbWorkflowState});
                workflow.setState(dbWorkflowState);
            }
            switch (workflow.getState()) {
                case FAILED: {
                    this.update(workflow);
                    break;
                }
                case FAILING: 
                case RUNNING: {
                    try {
                        Job job = this.serviceRegistry.createJob("org.opencastproject.workflow", Operation.START_OPERATION.toString(), java.util.Collections.singletonList(Long.toString(workflow.getId())), null, false, null, Float.valueOf(0.0f));
                        currentOperation.setId(Long.valueOf(job.getId()));
                        this.update(workflow);
                        job.setStatus(Job.Status.QUEUED);
                        job.setDispatchable(true);
                        this.serviceRegistry.updateJob(job);
                        break;
                    }
                    catch (ServiceRegistryException e) {
                        throw new WorkflowDatabaseException((Throwable)e);
                    }
                    catch (NotFoundException e) {
                        throw new IllegalStateException("Unable to find a job that was just created");
                    }
                }
                case PAUSED: 
                case STOPPED: 
                case SUCCEEDED: {
                    this.update(workflow);
                    break;
                }
                case INSTANTIATED: {
                    this.update(workflow);
                    throw new IllegalStateException("Impossible workflow state found during processing");
                }
                default: {
                    throw new IllegalStateException("Unknown workflow state found during processing");
                }
            }
        }
        return processingOperation;
    }

    public WorkflowDefinition getWorkflowDefinitionById(String id) throws NotFoundException {
        WorkflowIdentifier workflowIdentifier = new WorkflowIdentifier(id, this.securityService.getOrganization().getId());
        WorkflowDefinition def = this.workflowDefinitionScanner.getWorkflowDefinition(this.securityService.getUser(), workflowIdentifier);
        if (def == null) {
            throw new NotFoundException("Workflow definition '" + workflowIdentifier + "' not found or inaccessible");
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowInstance stop(long workflowInstanceId) throws WorkflowException, NotFoundException, UnauthorizedException {
        Lock lock = (Lock)this.lock.get((Object)workflowInstanceId);
        lock.lock();
        try {
            WorkflowInstanceImpl instance = this.getWorkflowById(workflowInstanceId);
            if (instance.getState() != WorkflowInstance.WorkflowState.STOPPED) {
                instance.setState(WorkflowInstance.WorkflowState.STOPPED);
                this.update((WorkflowInstance)instance);
            }
            try {
                this.removeTempFiles((WorkflowInstance)instance);
            }
            catch (Exception e) {
                logger.warn("Cannot remove temp files for workflow instance {}: {}", new Object[]{workflowInstanceId, e.getMessage()});
            }
            WorkflowInstanceImpl workflowInstanceImpl = instance;
            return workflowInstanceImpl;
        }
        finally {
            lock.unlock();
        }
    }

    private void removeTempFiles(WorkflowInstance workflowInstance) {
        logger.info("Removing temporary files for workflow {}", new Object[]{workflowInstance});
        if (null == workflowInstance.getMediaPackage()) {
            logger.warn("Workflow instance {} does not have an media package set", new Object[]{workflowInstance.getId()});
            return;
        }
        for (MediaPackageElement elem : workflowInstance.getMediaPackage().getElements()) {
            if (null == elem.getURI()) {
                logger.warn("Mediapackage element {} from the media package {} does not have an URI set", new Object[]{elem.getIdentifier(), workflowInstance.getMediaPackage().getIdentifier().toString()});
                continue;
            }
            try {
                logger.debug("Removing temporary file {} for workflow {}", new Object[]{elem.getURI(), workflowInstance});
                this.workspace.delete(elem.getURI());
            }
            catch (IOException e) {
                logger.warn("Unable to delete mediapackage element", new Object[]{e});
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    public void remove(long workflowInstanceId) throws WorkflowDatabaseException, NotFoundException, UnauthorizedException, WorkflowParsingException, WorkflowStateException {
        this.remove(workflowInstanceId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long workflowInstanceId, boolean force) throws WorkflowDatabaseException, NotFoundException, UnauthorizedException, WorkflowParsingException, WorkflowStateException {
        block16: {
            Lock lock = (Lock)this.lock.get((Object)workflowInstanceId);
            lock.lock();
            try {
                WorkflowQuery query = new WorkflowQuery();
                query.withId(Long.toString(workflowInstanceId));
                WorkflowSet workflows = this.index.getWorkflowInstances(query, Permissions.Action.READ.toString(), false);
                if (workflows.size() == 1L) {
                    WorkflowInstance instance = workflows.getItems()[0];
                    WorkflowInstance.WorkflowState state = instance.getState();
                    if (state != WorkflowInstance.WorkflowState.SUCCEEDED && state != WorkflowInstance.WorkflowState.FAILED && state != WorkflowInstance.WorkflowState.STOPPED) {
                        if (!force) {
                            throw new WorkflowStateException("Workflow instance with state '" + state + "' cannot be removed. Only states SUCCEEDED, FAILED & STOPPED are allowed");
                        }
                        logger.info("Using force, removing workflow " + workflowInstanceId + " despite being in state " + state);
                    }
                    this.assertPermission(instance, Permissions.Action.WRITE.toString(), instance.getOrganizationId());
                    this.removeTempFiles(instance);
                    List operations = instance.getOperations();
                    ArrayList<Long> jobsToDelete = new ArrayList<Long>();
                    for (WorkflowOperationInstance op : operations) {
                        long workflowOpId;
                        if (op.getId() == null || (workflowOpId = op.getId().longValue()) == workflowInstanceId) continue;
                        jobsToDelete.add(workflowOpId);
                    }
                    try {
                        this.serviceRegistry.removeJobs(jobsToDelete);
                    }
                    catch (ServiceRegistryException e) {
                        logger.warn("Problems while removing jobs related to workflow operations '%s': %s", new Object[]{jobsToDelete, e.getMessage()});
                    }
                    catch (NotFoundException e) {
                        logger.debug("No jobs related to one of the workflow operations '%s' found in the service registry", new Object[]{jobsToDelete});
                    }
                    try {
                        this.serviceRegistry.removeJobs(java.util.Collections.singletonList(workflowInstanceId));
                        this.removeWorkflowInstanceFromIndex(instance, this.elasticsearchIndex);
                    }
                    catch (ServiceRegistryException e) {
                        logger.warn("Problems while removing workflow instance job '%d'", new Object[]{workflowInstanceId, e});
                    }
                    catch (NotFoundException e) {
                        logger.info("No workflow instance job '%d' found in the service registry", new Object[]{workflowInstanceId});
                    }
                    try {
                        this.index.remove(workflowInstanceId);
                    }
                    catch (NotFoundException e) {
                        logger.warn("Workflow instance could not be removed from index", new Object[]{e});
                    }
                    break block16;
                }
                if (workflows.size() == 0L) {
                    throw new NotFoundException("Workflow instance with id '" + Long.toString(workflowInstanceId) + "' could not be found");
                }
                throw new WorkflowDatabaseException("More than one workflow found with id: " + Long.toString(workflowInstanceId));
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowInstance suspend(long workflowInstanceId) throws WorkflowException, NotFoundException, UnauthorizedException {
        Lock lock = (Lock)this.lock.get((Object)workflowInstanceId);
        lock.lock();
        try {
            WorkflowInstanceImpl instance = this.getWorkflowById(workflowInstanceId);
            instance.setState(WorkflowInstance.WorkflowState.PAUSED);
            this.update((WorkflowInstance)instance);
            WorkflowInstanceImpl workflowInstanceImpl = instance;
            return workflowInstanceImpl;
        }
        finally {
            lock.unlock();
        }
    }

    public WorkflowInstance resume(long id) throws WorkflowException, NotFoundException, IllegalStateException, UnauthorizedException {
        return this.resume(id, null);
    }

    public WorkflowInstance resume(long workflowInstanceId, Map<String, String> properties) throws WorkflowException, NotFoundException, IllegalStateException, UnauthorizedException {
        WorkflowInstanceImpl workflowInstance = this.getWorkflowById(workflowInstanceId);
        if (!WorkflowInstance.WorkflowState.PAUSED.equals((Object)workflowInstance.getState())) {
            throw new IllegalStateException("Can not resume a workflow where the current state is not in paused");
        }
        workflowInstance = this.updateConfiguration((WorkflowInstance)workflowInstance, properties);
        this.update((WorkflowInstance)workflowInstance);
        WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
        if (currentOperation == null) {
            workflowInstance.setState(WorkflowInstance.WorkflowState.SUCCEEDED);
            for (WorkflowOperationInstance op : workflowInstance.getOperations()) {
                if (!op.getState().equals((Object)WorkflowOperationInstance.OperationState.FAILED) || !op.isFailWorkflowOnException()) continue;
                workflowInstance.setState(WorkflowInstance.WorkflowState.FAILED);
                break;
            }
            logger.debug("%s has %s", new Object[]{workflowInstance, workflowInstance.getState()});
            this.update((WorkflowInstance)workflowInstance);
            return workflowInstance;
        }
        if (WorkflowOperationInstance.OperationState.INSTANTIATED.equals((Object)currentOperation.getState())) {
            try {
                Job operationJob = this.serviceRegistry.createJob("org.opencastproject.workflow", Operation.START_OPERATION.toString(), java.util.Collections.singletonList(Long.toString(workflowInstanceId)), null, false, null, Float.valueOf(0.0f));
                workflowInstance.setState(WorkflowInstance.WorkflowState.RUNNING);
                currentOperation.setId(Long.valueOf(operationJob.getId()));
                this.update((WorkflowInstance)workflowInstance);
                operationJob.setStatus(Job.Status.QUEUED);
                operationJob.setDispatchable(true);
                this.serviceRegistry.updateJob(operationJob);
                return workflowInstance;
            }
            catch (ServiceRegistryException e) {
                throw new WorkflowDatabaseException((Throwable)e);
            }
        }
        Long operationJobId = workflowInstance.getCurrentOperation().getId();
        if (operationJobId == null) {
            throw new IllegalStateException("Can not resume a workflow where the current operation has no associated id");
        }
        try {
            Job workflowJob = this.serviceRegistry.getJob(workflowInstanceId);
            workflowJob.setStatus(Job.Status.RUNNING);
            workflowJob.setPayload(WorkflowParser.toXml((WorkflowInstance)workflowInstance));
            this.serviceRegistry.updateJob(workflowJob);
            Job operationJob = this.serviceRegistry.getJob(operationJobId.longValue());
            operationJob.setStatus(Job.Status.QUEUED);
            operationJob.setDispatchable(true);
            if (properties != null) {
                Properties props = new Properties();
                props.putAll(properties);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                props.store(out, null);
                ArrayList<String> newArguments = new ArrayList<String>(operationJob.getArguments());
                newArguments.add(new String(out.toByteArray(), StandardCharsets.UTF_8));
                operationJob.setArguments(newArguments);
            }
            this.serviceRegistry.updateJob(operationJob);
        }
        catch (ServiceRegistryException e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
        catch (IOException e) {
            throw new WorkflowParsingException("Unable to parse workflow and/or workflow properties");
        }
        return workflowInstance;
    }

    protected void assertPermission(WorkflowInstance workflow, String action, String workflowOrgId) throws UnauthorizedException {
        boolean authorized;
        Opt assetMediapackage;
        User currentUser = this.securityService.getUser();
        Organization currentOrg = this.securityService.getOrganization();
        String currentOrgAdminRole = currentOrg.getAdminRole();
        String currentOrgId = currentOrg.getId();
        MediaPackage mediapackage = workflow.getMediaPackage();
        WorkflowInstance.WorkflowState state = workflow.getState();
        if (state != WorkflowInstance.WorkflowState.INSTANTIATED && state != WorkflowInstance.WorkflowState.RUNNING && workflow.getState() != WorkflowInstance.WorkflowState.FAILING && (assetMediapackage = this.assetManager.getMediaPackage(mediapackage.getIdentifier().toString())).isSome()) {
            mediapackage = (MediaPackage)assetMediapackage.get();
        }
        User workflowCreator = this.userDirectoryService.loadUser(workflow.getCreatorName());
        boolean bl = authorized = currentUser.hasRole("ROLE_ADMIN") || currentUser.hasRole(currentOrgAdminRole) && currentOrgId.equals(workflowOrgId) || workflowCreator != null && currentUser.equals(workflowCreator) || this.authorizationService.hasPermission(mediapackage, action) && currentOrgId.equals(workflowOrgId);
        if (!authorized) {
            throw new UnauthorizedException(currentUser, action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(WorkflowInstance workflowInstance) throws WorkflowException, UnauthorizedException {
        Lock lock = (Lock)this.updateLock.get((Object)workflowInstance.getId());
        lock.lock();
        try {
            Job job;
            String xml;
            MediaPackage updatedMediaPackage;
            WorkflowInstanceImpl originalWorkflowInstance;
            block33: {
                originalWorkflowInstance = null;
                try {
                    originalWorkflowInstance = this.getWorkflowById(workflowInstance.getId());
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
                updatedMediaPackage = null;
                try {
                    updatedMediaPackage = workflowInstance.getMediaPackage();
                    this.populateMediaPackageMetadata(updatedMediaPackage);
                    String seriesId = updatedMediaPackage.getSeries();
                    if (seriesId == null || workflowInstance.getCurrentOperation() == null) break block33;
                    try {
                        AccessControlList acl = this.seriesService.getSeriesAccessControl(seriesId);
                        Tuple activeAcl = this.authorizationService.getAcl(updatedMediaPackage, AclScope.Series);
                        if (!AclScope.Series.equals(activeAcl.getB()) || !AccessControlUtil.equals((AccessControlList)((AccessControlList)activeAcl.getA()), (AccessControlList)acl)) {
                            this.authorizationService.setAcl(updatedMediaPackage, AclScope.Series, acl);
                        }
                    }
                    catch (NotFoundException e) {
                        logger.debug("Not updating series ACL on event {} since series {} has no ACL set", new Object[]{updatedMediaPackage, seriesId, e});
                    }
                }
                catch (SeriesException e) {
                    throw new WorkflowDatabaseException((Throwable)e);
                }
                catch (Exception e) {
                    logger.error("Metadata for mediapackage {} could not be updated", new Object[]{updatedMediaPackage, e});
                }
            }
            WorkflowInstance.WorkflowState workflowState = workflowInstance.getState();
            try {
                xml = WorkflowParser.toXml((WorkflowInstance)workflowInstance);
            }
            catch (Exception e) {
                throw new IllegalStateException("In-memory workflow instance could not be serialized", e);
            }
            try {
                job = this.serviceRegistry.getJob(workflowInstance.getId());
                job.setPayload(xml);
                switch (workflowState) {
                    case FAILED: {
                        job.setStatus(Job.Status.FAILED);
                        break;
                    }
                    case FAILING: {
                        break;
                    }
                    case INSTANTIATED: {
                        job.setDispatchable(true);
                        job.setStatus(Job.Status.QUEUED);
                        break;
                    }
                    case PAUSED: {
                        job.setStatus(Job.Status.PAUSED);
                        break;
                    }
                    case RUNNING: {
                        job.setStatus(Job.Status.RUNNING);
                        break;
                    }
                    case STOPPED: {
                        job.setStatus(Job.Status.CANCELLED);
                        break;
                    }
                    case SUCCEEDED: {
                        job.setStatus(Job.Status.FINISHED);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Found a workflow state that is not handled");
                    }
                }
            }
            catch (ServiceRegistryException e) {
                logger.error((Throwable)e, "Unable to read workflow job %s from service registry", new Object[]{workflowInstance.getId()});
                throw new WorkflowDatabaseException((Throwable)e);
            }
            catch (NotFoundException e) {
                logger.error("Job for workflow %s not found in service registry", new Object[]{workflowInstance.getId()});
                throw new WorkflowDatabaseException((Throwable)e);
            }
            DublinCoreCatalog episodeDublinCoreCatalog = this.getEpisodeDublinCoreCatalog(workflowInstance.getMediaPackage());
            AccessControlList accessControlList = (AccessControlList)this.authorizationService.getActiveAcl(updatedMediaPackage).getA();
            try {
                job = this.serviceRegistry.updateJob(job);
                WorkflowOperationInstance op = workflowInstance.getCurrentOperation();
                if (op == null || op.getState() != WorkflowOperationInstance.OperationState.RUNNING) {
                    this.updateWorkflowInstanceInIndex(workflowInstance, accessControlList, episodeDublinCoreCatalog, this.elasticsearchIndex);
                }
                this.index(workflowInstance);
            }
            catch (ServiceRegistryException e) {
                logger.error("Update of workflow job %s in the service registry failed, service registry and workflow index may be out of sync", new Object[]{workflowInstance.getId()});
                throw new WorkflowDatabaseException((Throwable)e);
            }
            catch (NotFoundException e) {
                logger.error("Job for workflow %s not found in service registry", new Object[]{workflowInstance.getId()});
                throw new WorkflowDatabaseException((Throwable)e);
            }
            catch (Exception e) {
                logger.error("Update of workflow job %s in the service registry failed, service registry and workflow index may be out of sync", new Object[]{job.getId()});
                throw new WorkflowException((Throwable)e);
            }
            if (this.workflowStatsCollect) {
                this.workflowsStatistics.updateWorkflow(this.getBeanStatistics(), this.getHoldWorkflows());
            }
            try {
                WorkflowInstanceImpl clone = WorkflowParser.parseWorkflowInstance((String)WorkflowParser.toXml((WorkflowInstance)workflowInstance));
                this.fireListeners((WorkflowInstance)originalWorkflowInstance, (WorkflowInstance)clone);
            }
            catch (Exception e) {
                throw new IllegalStateException("In-memory workflow instance could not be serialized", e);
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected void index(WorkflowInstance workflowInstance) throws WorkflowDatabaseException {
        this.index.update(workflowInstance);
    }

    public long countWorkflowInstances() throws WorkflowDatabaseException {
        return this.index.countWorkflowInstances(null, null);
    }

    public long countWorkflowInstances(WorkflowInstance.WorkflowState state, String operation) throws WorkflowDatabaseException {
        return this.index.countWorkflowInstances(state, operation);
    }

    public WorkflowStatistics getStatistics() throws WorkflowDatabaseException {
        return this.index.getStatistics();
    }

    public WorkflowSet getWorkflowInstances(WorkflowQuery query) throws WorkflowDatabaseException {
        return this.index.getWorkflowInstances(query, Permissions.Action.READ.toString(), true);
    }

    public WorkflowSet getWorkflowInstancesForAdministrativeRead(WorkflowQuery query) throws WorkflowDatabaseException, UnauthorizedException {
        User user = this.securityService.getUser();
        if (!user.hasRole("ROLE_ADMIN") && !user.hasRole(user.getOrganization().getAdminRole())) {
            throw new UnauthorizedException(user, ((Object)((Object)this)).getClass().getName() + ".getForAdministrativeRead");
        }
        return this.index.getWorkflowInstances(query, Permissions.Action.WRITE.toString(), false);
    }

    protected WorkflowInstance handleOperationException(WorkflowInstance workflow, WorkflowOperationInstance operation) {
        WorkflowOperationInstanceImpl currentOperation = (WorkflowOperationInstanceImpl)operation;
        int failedAttempt = currentOperation.getFailedAttempts() + 1;
        currentOperation.setFailedAttempts(failedAttempt);
        currentOperation.addToExecutionHistory(currentOperation.getId().longValue());
        if (ERROR_RESOLUTION_HANDLER_ID.equals(currentOperation.getTemplate()) && WorkflowOperationInstance.OperationState.FAILED.equals((Object)currentOperation.getState())) {
            int position = currentOperation.getPosition();
            if (workflow.getOperations().size() > position + 1) {
                currentOperation = (WorkflowOperationInstanceImpl)workflow.getOperations().get(position + 1);
                currentOperation.setState(WorkflowOperationInstance.OperationState.FAILED);
            }
            this.handleFailedOperation(workflow, (WorkflowOperationInstance)currentOperation);
        } else if (currentOperation.getMaxAttempts() != -1 && failedAttempt == currentOperation.getMaxAttempts()) {
            this.handleFailedOperation(workflow, (WorkflowOperationInstance)currentOperation);
        } else {
            switch (currentOperation.getRetryStrategy()) {
                case NONE: {
                    this.handleFailedOperation(workflow, (WorkflowOperationInstance)currentOperation);
                    break;
                }
                case RETRY: {
                    currentOperation.setState(WorkflowOperationInstance.OperationState.RETRY);
                    break;
                }
                case HOLD: {
                    currentOperation.setState(WorkflowOperationInstance.OperationState.RETRY);
                    List operations = workflow.getOperations();
                    WorkflowOperationDefinitionImpl errorResolutionDefinition = new WorkflowOperationDefinitionImpl(ERROR_RESOLUTION_HANDLER_ID, "Error Resolution Operation", "error", false);
                    WorkflowOperationInstanceImpl errorResolutionInstance = new WorkflowOperationInstanceImpl((WorkflowOperationDefinition)errorResolutionDefinition, currentOperation.getPosition());
                    errorResolutionInstance.setExceptionHandlingWorkflow(currentOperation.getExceptionHandlingWorkflow());
                    operations.add(currentOperation.getPosition(), errorResolutionInstance);
                    workflow.setOperations(operations);
                    break;
                }
            }
        }
        return workflow;
    }

    private void handleFailedOperation(WorkflowInstance workflow, WorkflowOperationInstance currentOperation) {
        String errorDefId = currentOperation.getExceptionHandlingWorkflow();
        if (currentOperation.isFailWorkflowOnException()) {
            if (StringUtils.isBlank((CharSequence)errorDefId)) {
                workflow.setState(WorkflowInstance.WorkflowState.FAILED);
            } else {
                workflow.setState(WorkflowInstance.WorkflowState.FAILING);
                int currentOperationPosition = workflow.getOperations().indexOf(currentOperation);
                ArrayList operations = new ArrayList(workflow.getOperations().subList(0, currentOperationPosition + 1));
                workflow.setOperations(operations);
                HashMap<String, String> configuration = new HashMap<String, String>();
                for (String configKey : workflow.getConfigurationKeys()) {
                    configuration.put(configKey, workflow.getConfiguration(configKey));
                }
                WorkflowDefinition errorDef = null;
                try {
                    errorDef = this.getWorkflowDefinitionById(errorDefId);
                    workflow.extend(errorDef);
                    workflow.setOperations(this.updateConfiguration(workflow, configuration).getOperations());
                }
                catch (NotFoundException notFoundException) {
                    throw new IllegalStateException("Unable to find the error workflow definition '" + errorDefId + "'");
                }
            }
        }
        currentOperation.setState(WorkflowOperationInstance.OperationState.FAILED);
    }

    protected WorkflowInstance handleOperationResult(WorkflowInstance workflow, WorkflowOperationResult result) throws WorkflowDatabaseException {
        WorkflowOperationInstanceImpl currentOperation = (WorkflowOperationInstanceImpl)workflow.getCurrentOperation();
        WorkflowOperationHandler handler = this.getWorkflowOperationHandler(currentOperation.getTemplate());
        if (result == null) {
            logger.warn("Handling a null operation result for workflow %s in operation %s", new Object[]{workflow.getId(), currentOperation.getTemplate()});
            result = new WorkflowOperationResultImpl(workflow.getMediaPackage(), null, WorkflowOperationResult.Action.CONTINUE, 0L);
        } else {
            MediaPackage mp = result.getMediaPackage();
            if (mp != null) {
                workflow.setMediaPackage(mp);
            }
        }
        WorkflowOperationResult.Action action = result.getAction();
        int currentOperationPosition = currentOperation.getPosition();
        workflow = this.updateConfiguration(workflow, result.getProperties());
        currentOperation = (WorkflowOperationInstanceImpl)workflow.getOperations().get(currentOperationPosition);
        currentOperation.setTimeInQueue(result.getTimeInQueue());
        switch (action) {
            case CONTINUE: {
                currentOperation.setState(WorkflowOperationInstance.OperationState.SUCCEEDED);
                break;
            }
            case PAUSE: {
                if (!(handler instanceof ResumableWorkflowOperationHandler)) {
                    throw new IllegalStateException("Operation " + currentOperation.getTemplate() + " is not resumable");
                }
                currentOperation.setContinuable(Boolean.valueOf(result.allowsContinue()));
                currentOperation.setAbortable(Boolean.valueOf(result.allowsAbort()));
                ResumableWorkflowOperationHandler resumableHandler = (ResumableWorkflowOperationHandler)handler;
                try {
                    String url = resumableHandler.getHoldStateUserInterfaceURL(workflow);
                    if (url != null) {
                        String holdActionTitle = resumableHandler.getHoldActionTitle();
                        currentOperation.setHoldActionTitle(holdActionTitle);
                        currentOperation.setHoldStateUserInterfaceUrl(url);
                    }
                }
                catch (WorkflowOperationException e) {
                    logger.warn((Throwable)e, "unable to replace workflow ID in the hold state URL");
                }
                workflow.setState(WorkflowInstance.WorkflowState.PAUSED);
                currentOperation.setState(WorkflowOperationInstance.OperationState.PAUSED);
                break;
            }
            case SKIP: {
                currentOperation.setState(WorkflowOperationInstance.OperationState.SKIPPED);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown action '" + action + "' returned");
            }
        }
        if (ERROR_RESOLUTION_HANDLER_ID.equals(currentOperation.getTemplate()) && result.getAction() == WorkflowOperationResult.Action.CONTINUE) {
            Map resultProperties = result.getProperties();
            if (resultProperties == null || StringUtils.isBlank((CharSequence)((CharSequence)resultProperties.get(RETRY_STRATEGY)))) {
                throw new WorkflowDatabaseException("Retry strategy not present in properties!");
            }
            RetryStrategy retryStrategy = RetryStrategy.valueOf((String)((String)resultProperties.get(RETRY_STRATEGY)));
            switch (retryStrategy) {
                case NONE: {
                    this.handleFailedOperation(workflow, workflow.getCurrentOperation());
                    break;
                }
                case RETRY: {
                    break;
                }
                default: {
                    throw new WorkflowDatabaseException("Retry strategy not implemented yet!");
                }
            }
        }
        return workflow;
    }

    protected void populateMediaPackageMetadata(MediaPackage mp) {
        if (this.metadataServices.size() == 0) {
            logger.warn("No metadata services are registered, so no media package metadata can be extracted from catalogs");
            return;
        }
        for (MediaPackageMetadataService metadataService : this.metadataServices) {
            MediaPackageMetadata metadata = (MediaPackageMetadata)metadataService.getMetadata(mp);
            MediaPackageMetadataSupport.populateMediaPackageMetadata((MediaPackage)mp, (MediaPackageMetadata)metadata);
        }
    }

    public boolean isReadyToAcceptJobs(String operation) {
        return true;
    }

    public boolean isReadyToAccept(Job job) throws UndispatchableJobException {
        WorkflowSet workflowInstances;
        String mediaPackageId;
        WorkflowInstanceImpl workflow;
        String operation = job.getOperation();
        if (!Operation.START_WORKFLOW.toString().equals(operation)) {
            return true;
        }
        if (job.getArguments().size() > 1 && job.getArguments().get(0) != null) {
            try {
                String firstOperationId;
                WorkflowOperationHandler handler;
                WorkflowDefinition workflowDef = WorkflowParser.parseWorkflowDefinition((String)((String)job.getArguments().get(0)));
                if (workflowDef.getOperations().size() > 0 && (handler = this.getWorkflowOperationHandler(firstOperationId = ((WorkflowOperationDefinition)workflowDef.getOperations().get(0)).getId())) instanceof ResumableWorkflowOperationHandler && ((ResumableWorkflowOperationHandler)handler).isAlwaysPause()) {
                    return true;
                }
            }
            catch (WorkflowParsingException e) {
                throw new UndispatchableJobException(job + " is not a proper job to start a workflow", (Throwable)e);
            }
        }
        try {
            workflow = this.getWorkflowById(job.getId());
            mediaPackageId = workflow.getMediaPackage().getIdentifier().toString();
            workflowInstances = this.getWorkflowInstances(new WorkflowQuery().withMediaPackage(workflow.getMediaPackage().getIdentifier().toString()).withState(WorkflowInstance.WorkflowState.RUNNING).withState(WorkflowInstance.WorkflowState.PAUSED).withState(WorkflowInstance.WorkflowState.FAILING));
        }
        catch (NotFoundException e) {
            logger.error("Trying to start workflow with id %s but no corresponding instance is available from the workflow service", new Object[]{job.getId()});
            throw new UndispatchableJobException((Throwable)e);
        }
        catch (UnauthorizedException e) {
            logger.error("Authorization denied while requesting to loading workflow instance %s: %s", new Object[]{job.getId(), e.getMessage()});
            throw new UndispatchableJobException((Throwable)e);
        }
        catch (WorkflowDatabaseException e) {
            logger.error("Error loading workflow instance %s: %s", new Object[]{job.getId(), e.getMessage()});
            return false;
        }
        boolean toomany = workflowInstances.size() > 1L;
        if (!(toomany |= workflowInstances.size() == 1L && workflow.getId() != workflowInstances.getItems()[0].getId())) {
            return true;
        }
        if (!this.delayedWorkflows.contains(workflow.getId())) {
            logger.info("Delaying start of workflow %s, another workflow on media package %s is still running", new Object[]{workflow.getId(), mediaPackageId});
            this.delayedWorkflows.add(workflow.getId());
        }
        return false;
    }

    public synchronized void acceptJob(Job job) throws ServiceRegistryException {
        User originalUser = this.securityService.getUser();
        Organization originalOrg = this.securityService.getOrganization();
        try {
            Organization organization = this.organizationDirectoryService.getOrganization(job.getOrganization());
            this.securityService.setOrganization(organization);
            User user = this.userDirectoryService.loadUser(job.getCreator());
            this.securityService.setUser(user);
            job.setStatus(Job.Status.RUNNING);
            job = this.serviceRegistry.updateJob(job);
            if (this.delayedWorkflows.contains(job.getId())) {
                this.delayedWorkflows.remove(job.getId());
                logger.info("Starting initially delayed workflow %s, %d more waiting", new Object[]{job.getId(), this.delayedWorkflows.size()});
            }
            this.executorService.submit(new JobRunner(job, this.serviceRegistry.getCurrentJob()));
        }
        catch (Exception e) {
            if (e instanceof ServiceRegistryException) {
                throw (ServiceRegistryException)((Object)e);
            }
            throw new ServiceRegistryException((Throwable)e);
        }
        finally {
            this.securityService.setUser(originalUser);
            this.securityService.setOrganization(originalOrg);
        }
    }

    protected String process(Job job) throws Exception {
        List arguments = job.getArguments();
        Operation op = null;
        WorkflowInstanceImpl workflowInstance = null;
        String operation = job.getOperation();
        try {
            try {
                op = Operation.valueOf(operation);
                switch (op) {
                    case START_WORKFLOW: {
                        workflowInstance = WorkflowParser.parseWorkflowInstance((String)job.getPayload());
                        logger.debug("Starting new workflow %s", new Object[]{workflowInstance});
                        this.runWorkflow((WorkflowInstance)workflowInstance);
                        break;
                    }
                    case RESUME: {
                        workflowInstance = this.getWorkflowById(Long.parseLong((String)arguments.get(0)));
                        HashMap<String, String> properties = null;
                        if (arguments.size() > 1) {
                            Properties props = new Properties();
                            props.load(IOUtils.toInputStream((String)((String)arguments.get(arguments.size() - 1)), (Charset)StandardCharsets.UTF_8));
                            properties = new HashMap<String, String>();
                            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                                properties.put(entry.getKey().toString(), entry.getValue().toString());
                            }
                        }
                        logger.debug("Resuming %s at %s", new Object[]{workflowInstance, workflowInstance.getCurrentOperation()});
                        workflowInstance.setState(WorkflowInstance.WorkflowState.RUNNING);
                        this.update((WorkflowInstance)workflowInstance);
                        this.runWorkflowOperation((WorkflowInstance)workflowInstance, properties);
                        break;
                    }
                    case START_OPERATION: {
                        workflowInstance = this.getWorkflowById(Long.parseLong((String)arguments.get(0)));
                        WorkflowOperationInstance wfo = workflowInstance.getCurrentOperation();
                        if (WorkflowOperationInstance.OperationState.RUNNING.equals((Object)wfo.getState()) || WorkflowOperationInstance.OperationState.PAUSED.equals((Object)wfo.getState())) {
                            logger.info("Reset operation state %s %s to INSTANTIATED due to job restart", new Object[]{workflowInstance, wfo});
                            wfo.setState(WorkflowOperationInstance.OperationState.INSTANTIATED);
                        }
                        wfo.setExecutionHost(job.getProcessingHost());
                        logger.debug("Running %s %s", new Object[]{workflowInstance, wfo});
                        wfo = this.runWorkflowOperation((WorkflowInstance)workflowInstance, null);
                        this.updateOperationJob(job.getId(), wfo.getState());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Don't know how to handle operation '" + operation + "'");
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new ServiceRegistryException("This service can't handle operations of type '" + op + "'", (Throwable)e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ServiceRegistryException("This argument list for operation '" + op + "' does not meet expectations", (Throwable)e);
            }
            catch (NotFoundException e) {
                logger.warn("Not found processing job {}: {}", new Object[]{job, e.getMessage()});
                this.updateOperationJob(job.getId(), WorkflowOperationInstance.OperationState.FAILED);
            }
            return null;
        }
        catch (Exception e) {
            logger.warn((Throwable)e, "Exception while accepting job " + job);
            try {
                if (workflowInstance != null) {
                    logger.warn("Marking job {} and workflow instance {} as failed", new Object[]{job, workflowInstance});
                    this.updateOperationJob(job.getId(), WorkflowOperationInstance.OperationState.FAILED);
                    workflowInstance.setState(WorkflowInstance.WorkflowState.FAILED);
                    this.update((WorkflowInstance)workflowInstance);
                } else {
                    logger.warn((Throwable)e, "Unable to parse workflow instance");
                }
            }
            catch (WorkflowDatabaseException e1) {
                throw new ServiceRegistryException((Throwable)e1);
            }
            if (e instanceof ServiceRegistryException) {
                throw e;
            }
            throw new ServiceRegistryException("Error handling operation '" + op + "'", (Throwable)e);
        }
    }

    private Job updateOperationJob(Long jobId, WorkflowOperationInstance.OperationState state) throws NotFoundException, ServiceRegistryException {
        if (jobId == null) {
            return null;
        }
        Job job = this.serviceRegistry.getJob(jobId.longValue());
        switch (state) {
            case FAILED: 
            case RETRY: {
                job.setStatus(Job.Status.FAILED);
                break;
            }
            case PAUSED: {
                job.setStatus(Job.Status.PAUSED);
                job.setOperation(Operation.RESUME.toString());
                break;
            }
            case SKIPPED: 
            case SUCCEEDED: {
                job.setStatus(Job.Status.FINISHED);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state '" + state + "' found");
            }
        }
        return this.serviceRegistry.updateJob(job);
    }

    public long countJobs(Job.Status status) throws ServiceRegistryException {
        return this.serviceRegistry.count("org.opencastproject.workflow", status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkflowStatistics getBeanStatistics() throws WorkflowDatabaseException {
        WorkflowStatistics stats = new WorkflowStatistics();
        long total = 0L;
        long failed = 0L;
        long failing = 0L;
        long instantiated = 0L;
        long paused = 0L;
        long running = 0L;
        long stopped = 0L;
        long finished = 0L;
        Organization organization = this.securityService.getOrganization();
        try {
            for (Organization org : this.organizationDirectoryService.getOrganizations()) {
                this.securityService.setOrganization(org);
                WorkflowStatistics statistics = this.getStatistics();
                total += statistics.getTotal();
                failed += statistics.getFailed();
                failing += statistics.getFailing();
                instantiated += statistics.getInstantiated();
                paused += statistics.getPaused();
                running += statistics.getRunning();
                stopped += statistics.getStopped();
                finished += statistics.getFinished();
            }
        }
        finally {
            this.securityService.setOrganization(organization);
        }
        stats.setTotal(total);
        stats.setFailed(failed);
        stats.setFailing(failing);
        stats.setInstantiated(instantiated);
        stats.setPaused(paused);
        stats.setRunning(running);
        stats.setStopped(stopped);
        stats.setFinished(finished);
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WorkflowInstance> getHoldWorkflows() throws WorkflowDatabaseException {
        ArrayList<WorkflowInstance> workflows = new ArrayList<WorkflowInstance>();
        Organization organization = this.securityService.getOrganization();
        try {
            for (Organization org : this.organizationDirectoryService.getOrganizations()) {
                this.securityService.setOrganization(org);
                WorkflowQuery workflowQuery = new WorkflowQuery().withState(WorkflowInstance.WorkflowState.PAUSED).withCount(Integer.MAX_VALUE);
                WorkflowSet workflowSet = this.getWorkflowInstances(workflowQuery);
                workflows.addAll(Arrays.asList(workflowSet.getItems()));
            }
        }
        finally {
            this.securityService.setOrganization(organization);
        }
        return workflows;
    }

    private String mapToString(Map<String, String> props) {
        if (props == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Reference(name="profilesReadyIndicator", target="(artifact=workflowdefinition)")
    protected void setProfilesReadyIndicator(ReadinessIndicator unused) {
    }

    @Reference(name="workspace")
    protected void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference(name="serviceRegistry")
    protected void setServiceRegistry(ServiceRegistry registry) {
        this.serviceRegistry = registry;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Reference(name="security-service")
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference(name="authorization")
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Reference(name="user-directory")
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference(name="orgDirectory")
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectory) {
        this.organizationDirectoryService = organizationDirectory;
    }

    @Reference(name="index")
    protected void setDao(WorkflowServiceIndex index) {
        this.index = index;
    }

    @Reference(name="series")
    public void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Reference(name="assetManager")
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Reference(name="metadata", cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="removeMetadataService")
    protected void addMetadataService(MediaPackageMetadataService service) {
        this.metadataServices.add(service);
    }

    protected void removeMetadataService(MediaPackageMetadataService service) {
        this.metadataServices.remove(service);
    }

    @Reference(name="scanner")
    protected void addWorkflowDefinitionScanner(WorkflowDefinitionScanner scanner) {
        this.workflowDefinitionScanner = scanner;
    }

    @Reference(name="elasticsearch-index")
    public void setIndex(ElasticsearchIndex index) {
        this.elasticsearchIndex = index;
    }

    public String getJobType() {
        return "org.opencastproject.workflow";
    }

    public void updated(Dictionary properties) {
        String workflowStatsConfiguration = StringUtils.trimToNull((String)((String)properties.get(STATS_COLLECT_CONFIG_KEY)));
        if (StringUtils.isNotEmpty((CharSequence)workflowStatsConfiguration)) {
            try {
                this.workflowStatsCollect = Boolean.parseBoolean(workflowStatsConfiguration);
                logger.info("Workflow statistics collection is set to %s", new Object[]{workflowStatsConfiguration});
            }
            catch (Exception e) {
                logger.warn("Workflow statistics collection flag '%s' is malformed, setting to %s", new Object[]{workflowStatsConfiguration, DEFAULT_STATS_COLLECT_CONFIG.toString()});
                this.workflowStatsCollect = DEFAULT_STATS_COLLECT_CONFIG;
            }
        }
    }

    public synchronized void cleanupWorkflowInstances(int buffer, WorkflowInstance.WorkflowState state) throws UnauthorizedException, WorkflowDatabaseException {
        logger.info("Start cleaning up workflow instances older than {} days with status '{}'", new Object[]{buffer, state});
        int instancesCleaned = 0;
        int cleaningFailed = 0;
        WorkflowQuery query = new WorkflowQuery().withState(state).withDateBefore(DateUtils.addDays((Date)new Date(), (int)(-buffer))).withCount(Integer.MAX_VALUE);
        for (WorkflowInstance workflowInstance : this.getWorkflowInstances(query).getItems()) {
            try {
                this.remove(workflowInstance.getId());
                ++instancesCleaned;
            }
            catch (UnauthorizedException | WorkflowDatabaseException e) {
                throw e;
            }
            catch (NotFoundException e) {
                logger.debug("Workflow instance '{}' could not be removed", new Object[]{workflowInstance.getId(), e});
            }
            catch (WorkflowParsingException | WorkflowStateException e) {
                logger.warn("Workflow instance '{}' could not be removed", new Object[]{workflowInstance.getId(), e});
                ++cleaningFailed;
            }
        }
        if (instancesCleaned == 0 && cleaningFailed == 0) {
            logger.info("No workflow instances found to clean up");
            return;
        }
        if (instancesCleaned > 0) {
            logger.info("Cleaned up '%d' workflow instances", new Object[]{instancesCleaned});
        }
        if (cleaningFailed > 0) {
            logger.warn("Cleaning failed for '%d' workflow instances", new Object[]{cleaningFailed});
            throw new WorkflowDatabaseException("Unable to clean all workflow instances, see logs!");
        }
    }

    public Map<String, Map<String, String>> getWorkflowStateMappings() {
        return this.workflowDefinitionScanner.workflowStateMappings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Set)e.getValue()).stream().collect(Collectors.toMap(m -> m.getState().name(), WorkflowStateMapping::getValue))));
    }

    public void repopulate(ElasticsearchIndex index) throws IndexRebuildException {
        int total;
        String startWorkflow = Operation.START_WORKFLOW.toString();
        try {
            total = this.serviceRegistry.getJobCount(startWorkflow);
        }
        catch (ServiceRegistryException e) {
            this.logIndexRebuildError(logger.getSlf4jLogger(), index.getIndexName(), e);
            throw new IndexRebuildException(index.getIndexName(), this.getService(), (Throwable)e);
        }
        int limit = 1000;
        if (total > 0) {
            this.logIndexRebuildBegin(logger.getSlf4jLogger(), index.getIndexName(), total, "workflows");
            int current = 0;
            int offset = 0;
            do {
                List workflows;
                try {
                    workflows = this.serviceRegistry.getJobPayloads(startWorkflow, 1000, offset);
                }
                catch (ServiceRegistryException e) {
                    this.logIndexRebuildError(logger.getSlf4jLogger(), index.getIndexName(), total, current, e);
                    throw new IndexRebuildException(index.getIndexName(), this.getService(), (Throwable)e);
                }
                logger.debug("Got {} workflows for re-indexing", new Object[]{workflows.size()});
                offset += 1000;
                for (String workflow : workflows) {
                    WorkflowInstanceImpl instance;
                    ++current;
                    if (StringUtils.isEmpty((CharSequence)workflow)) {
                        logger.warn("Skipping restore of workflow #{}: Payload is empty", new Object[]{current});
                        continue;
                    }
                    try {
                        instance = WorkflowParser.parseWorkflowInstance((String)workflow);
                    }
                    catch (WorkflowParsingException e) {
                        logger.warn("Skipping restore of workflow. Error parsing: {}", new Object[]{workflow, e});
                        continue;
                    }
                    Organization organization = null;
                    try {
                        organization = this.organizationDirectoryService.getOrganization(instance.getOrganizationId());
                    }
                    catch (NotFoundException e) {
                        logger.error("Found workflow with non-existing organization {}", new Object[]{instance.getOrganizationId()});
                        continue;
                    }
                    DublinCoreCatalog episodeDublinCoreCatalog = this.getEpisodeDublinCoreCatalog(instance.getMediaPackage());
                    AccessControlList accessControlList = instance.getState().isTerminated() ? new AccessControlList() : (AccessControlList)this.authorizationService.getActiveAcl(instance.getMediaPackage()).getA();
                    SecurityUtil.runAs((SecurityService)this.securityService, (Organization)organization, (User)SecurityUtil.createSystemUser((ComponentContext)this.componentContext, (Organization)organization), () -> this.lambda$repopulate$9((WorkflowInstance)instance, accessControlList, episodeDublinCoreCatalog, index));
                    this.logIndexRebuildProgress(logger.getSlf4jLogger(), index.getIndexName(), total, current);
                }
            } while (current < total);
        }
    }

    private DublinCoreCatalog getEpisodeDublinCoreCatalog(MediaPackage mediaPackage) {
        for (Catalog catalog : mediaPackage.getCatalogs(MediaPackageElements.EPISODE)) {
            try {
                return DublinCoreUtil.loadDublinCore((Workspace)this.workspace, (MediaPackageElement)catalog);
            }
            catch (Exception e) {
                logger.warn("Unable to load dublin core catalog for event '{}'", new Object[]{mediaPackage.getIdentifier(), e});
            }
        }
        return null;
    }

    public IndexRebuildService.Service getService() {
        return IndexRebuildService.Service.Workflow;
    }

    private void removeWorkflowInstanceFromIndex(WorkflowInstance workflowInstance, ElasticsearchIndex index) {
        long workflowInstanceId = workflowInstance.getId();
        String eventId = workflowInstance.getMediaPackage().getIdentifier().toString();
        String organization = this.securityService.getOrganization().getId();
        User user = this.securityService.getUser();
        try {
            logger.debug("Removing workflow instance {} of event {} from the {} index.", new Object[]{workflowInstanceId, eventId, index.getIndexName()});
            index.deleteWorkflow(organization, user, eventId, Long.valueOf(workflowInstanceId));
            logger.debug("Workflow instance {} of event {} removed from the {} index.", new Object[]{workflowInstanceId, eventId, index.getIndexName()});
        }
        catch (NotFoundException e) {
            logger.warn("Workflow instance {} of event {} not found for removal from the {} index.", new Object[]{workflowInstanceId, eventId, index.getIndexName()});
        }
        catch (SearchIndexException e) {
            logger.error("Error removing the workflow instance {} of event {} from the {} index.", new Object[]{workflowInstanceId, eventId, index.getIndexName(), e});
        }
    }

    private void updateWorkflowInstanceInIndex(WorkflowInstance workflowInstance, AccessControlList accessControlList, DublinCoreCatalog episodeDublincoreCatalog, ElasticsearchIndex index) {
        long workflowInstanceId = workflowInstance.getId();
        String eventId = workflowInstance.getMediaPackage().getIdentifier().toString();
        String organization = this.securityService.getOrganization().getId();
        User user = this.securityService.getUser();
        logger.debug("Updating workflow instance {} of event {} in the {} index.", new Object[]{workflowInstanceId, eventId, index.getIndexName()});
        Function<Optional, Optional> updateFunction = eventOpt -> {
            Event event = eventOpt.orElse(new Event(eventId, organization));
            event.setCreator(user.getName());
            event.setWorkflowId(Long.valueOf(workflowInstanceId));
            event.setWorkflowDefinitionId(workflowInstance.getTemplate());
            event.setWorkflowState(workflowInstance.getState());
            event.setAccessPolicy(AccessControlParser.toJsonSilent((AccessControlList)accessControlList));
            if (episodeDublincoreCatalog != null) {
                event = EventIndexUtils.updateEvent((Event)event, (DublinCore)episodeDublincoreCatalog);
            }
            event = EventIndexUtils.updateEvent((Event)event, (MediaPackage)workflowInstance.getMediaPackage());
            return Optional.of(event);
        };
        try {
            index.addOrUpdateEvent(eventId, updateFunction, organization, user);
            logger.debug("Workflow instance {} of event {} updated in the {} index.", new Object[]{workflowInstanceId, eventId, index.getIndexName()});
        }
        catch (SearchIndexException e) {
            logger.error("Error updating the workflow instance {} of event {} in the {} index.", new Object[]{workflowInstanceId, eventId, index.getIndexName(), e});
        }
    }

    private /* synthetic */ void lambda$repopulate$9(WorkflowInstance instance, AccessControlList accessControlList, DublinCoreCatalog episodeDublinCoreCatalog, ElasticsearchIndex index) {
        this.updateWorkflowInstanceInIndex(instance, accessControlList, episodeDublinCoreCatalog, index);
    }

    class JobRunner
    implements Callable<Void> {
        private Job job = null;
        private final Job currentJob;

        JobRunner(Job job, Job currentJob) {
            this.job = job;
            this.currentJob = currentJob;
        }

        @Override
        public Void call() throws Exception {
            Organization jobOrganization = WorkflowServiceImpl.this.organizationDirectoryService.getOrganization(this.job.getOrganization());
            try {
                WorkflowServiceImpl.this.serviceRegistry.setCurrentJob(this.currentJob);
                WorkflowServiceImpl.this.securityService.setOrganization(jobOrganization);
                User jobUser = WorkflowServiceImpl.this.userDirectoryService.loadUser(this.job.getCreator());
                WorkflowServiceImpl.this.securityService.setUser(jobUser);
                WorkflowServiceImpl.this.process(this.job);
            }
            finally {
                WorkflowServiceImpl.this.serviceRegistry.setCurrentJob(null);
                WorkflowServiceImpl.this.securityService.setUser(null);
                WorkflowServiceImpl.this.securityService.setOrganization(null);
            }
            return null;
        }
    }

    public static class HandlerRegistration {
        protected WorkflowOperationHandler handler;
        protected String operationName;

        public HandlerRegistration(String operationName, WorkflowOperationHandler handler) {
            if (operationName == null) {
                throw new IllegalArgumentException("Operation name cannot be null");
            }
            if (handler == null) {
                throw new IllegalArgumentException("Handler cannot be null");
            }
            this.operationName = operationName;
            this.handler = handler;
        }

        public WorkflowOperationHandler getHandler() {
            return this.handler;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.handler.hashCode();
            result = 31 * result + this.operationName.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HandlerRegistration other = (HandlerRegistration)obj;
            if (!this.handler.equals(other.handler)) {
                return false;
            }
            return this.operationName.equals(other.operationName);
        }
    }

    static enum Operation {
        START_WORKFLOW,
        RESUME,
        START_OPERATION;

    }
}

