/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.impl;

import com.entwinemedia.fn.Fn;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.ARecord;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.solr.SolrServerFactory;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.SolrUtils;
import org.opencastproject.util.data.Option;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowInstanceImpl;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowParser;
import org.opencastproject.workflow.api.WorkflowParsingException;
import org.opencastproject.workflow.api.WorkflowQuery;
import org.opencastproject.workflow.api.WorkflowSet;
import org.opencastproject.workflow.api.WorkflowStatistics;
import org.opencastproject.workflow.impl.WorkflowServiceImpl;
import org.opencastproject.workflow.impl.WorkflowServiceIndex;
import org.osgi.framework.ServiceException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Workflow Service Index", "synchronousIndexing=false"}, immediate=true, service={WorkflowServiceIndex.class})
public class WorkflowServiceSolrIndex
implements WorkflowServiceIndex {
    protected static final Logger logger = LoggerFactory.getLogger(WorkflowServiceSolrIndex.class);
    public static final String CONFIG_SOLR_URL = "org.opencastproject.workflow.solr.url";
    public static final String CONFIG_SOLR_ROOT = "org.opencastproject.workflow.solr.dir";
    protected SolrServer solrServer = null;
    protected String solrRoot = null;
    protected URL solrServerUrl = null;
    protected static final String OPERATION_KEY = "operation";
    protected static final String NO_OPERATION_KEY = "none";
    protected static final String WORKFLOW_DEFINITION_KEY = "templateid";
    protected static final String SERIES_ID_KEY = "seriesid";
    protected static final String SERIES_TITLE_KEY = "seriestitle";
    protected static final String ID_KEY = "id";
    private static final String STATE_KEY = "state";
    private static final String XML_KEY = "xml";
    private static final String CONTRIBUTOR_KEY = "contributor";
    private static final String LANGUAGE_KEY = "language";
    private static final String LICENSE_KEY = "license";
    private static final String TITLE_KEY = "title";
    private static final String MEDIAPACKAGE_KEY = "mediapackageid";
    private static final String CREATOR_KEY = "creator";
    private static final String CREATED_KEY = "created";
    private static final String SUBJECT_KEY = "subject";
    private static final String FULLTEXT_KEY = "fulltext";
    private static final String WORKFLOW_CREATOR_KEY = "oc_creator";
    private static final String ORG_KEY = "oc_org";
    private static final String ACL_KEY_PREFIX = "oc_acl_";
    private ServiceRegistry serviceRegistry = null;
    private AuthorizationService authorizationService = null;
    private OrganizationDirectoryService orgDirectory;
    private SecurityService securityService = null;
    private AssetManager assetManager = null;
    protected boolean synchronousIndexing = true;
    protected ExecutorService indexingExecutor;
    public static final Fn<Job, Boolean> operationIsStartWorkflow = new Fn<Job, Boolean>(){

        public Boolean apply(Job job) {
            return WorkflowServiceImpl.Operation.START_WORKFLOW.toString().equals(job.getOperation());
        }
    };

    @Activate
    public void activate(ComponentContext cc) {
        String solrServerUrlConfig = StringUtils.trimToNull((String)cc.getBundleContext().getProperty(CONFIG_SOLR_URL));
        if (solrServerUrlConfig != null) {
            try {
                this.solrServerUrl = new URL(solrServerUrlConfig);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Unable to connect to solr at " + solrServerUrlConfig, e);
            }
        } else {
            this.solrRoot = SolrServerFactory.getEmbeddedDir((ComponentContext)cc, (String)CONFIG_SOLR_ROOT, (String)"workflow");
        }
        Object syncIndexingConfig = cc.getProperties().get("synchronousIndexing");
        if (syncIndexingConfig != null && syncIndexingConfig instanceof Boolean) {
            this.synchronousIndexing = (Boolean)syncIndexingConfig;
        }
        if (this.synchronousIndexing) {
            logger.debug("Workflows will be added to the search index synchronously");
        } else {
            logger.debug("Workflows will be added to the search index asynchronously");
            this.indexingExecutor = Executors.newSingleThreadExecutor();
        }
        String systemUserName = cc.getBundleContext().getProperty("org.opencastproject.security.digest.user");
        this.activate(systemUserName);
    }

    private long count() throws WorkflowDatabaseException {
        try {
            QueryResponse response = this.solrServer.query((SolrParams)new SolrQuery("*:*"));
            return response.getResults().getNumFound();
        }
        catch (SolrServerException e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
    }

    public void activate(String systemUserName) {
        if (this.solrServerUrl != null) {
            this.solrServer = SolrServerFactory.newRemoteInstance((URL)this.solrServerUrl);
        } else {
            try {
                this.setupSolr(new File(this.solrRoot));
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to connect to solr at " + this.solrRoot, e);
            }
            catch (SolrServerException e) {
                throw new IllegalStateException("Unable to connect to solr at " + this.solrRoot, e);
            }
        }
        long instancesInSolr = 0L;
        try {
            instancesInSolr = this.count();
        }
        catch (WorkflowDatabaseException e) {
            throw new IllegalStateException(e);
        }
        if (instancesInSolr == 0L) {
            List workflowPayloads;
            logger.info("The workflow index is empty, looking for workflows to index");
            try {
                workflowPayloads = this.serviceRegistry.getJobPayloads(WorkflowServiceImpl.Operation.START_WORKFLOW.toString());
            }
            catch (ServiceRegistryException e) {
                logger.error("Unable to load the workflows jobs: {}", (Object)e.getMessage());
                throw new ServiceException(e.getMessage());
            }
            int total = workflowPayloads.size();
            if (total == 0) {
                logger.info("No workflows found. Repopulating index finished.");
                return;
            }
            logger.info("Populating the workflow index with {} workflows", (Object)total);
            int current = 0;
            for (String payload : workflowPayloads) {
                ++current;
                WorkflowInstanceImpl instance = null;
                try {
                    instance = WorkflowParser.parseWorkflowInstance((String)payload);
                    Organization organization = this.orgDirectory.getOrganization(instance.getOrganizationId());
                    this.securityService.setOrganization(organization);
                    this.securityService.setUser(SecurityUtil.createSystemUser((String)systemUserName, (Organization)organization));
                    this.index((WorkflowInstance)instance);
                }
                catch (NotFoundException | WorkflowDatabaseException | WorkflowParsingException e) {
                    logger.warn("Skipping restoring of workflow {}", (Object)payload, (Object)e);
                }
                if (current % 100 != 0) continue;
                logger.info("Indexing workflow {}/{} ({} percent done)", new Object[]{current, total, current * 100 / total});
            }
            logger.info("Finished populating the workflow search index");
        }
    }

    protected void setupSolr(File solrRoot) throws IOException, SolrServerException {
        File solrIndexDir;
        logger.debug("Setting up solr search index at {}", (Object)solrRoot);
        File solrConfigDir = new File(solrRoot, "conf");
        if (solrConfigDir.exists()) {
            logger.debug("solr search index found at {}", (Object)solrConfigDir);
        } else {
            logger.debug("solr config directory doesn't exist.  Creating {}", (Object)solrConfigDir);
            FileUtils.forceMkdir((File)solrConfigDir);
        }
        this.copyClasspathResourceToFile("/solr/conf/protwords.txt", solrConfigDir);
        this.copyClasspathResourceToFile("/solr/conf/schema.xml", solrConfigDir);
        this.copyClasspathResourceToFile("/solr/conf/scripts.conf", solrConfigDir);
        this.copyClasspathResourceToFile("/solr/conf/solrconfig.xml", solrConfigDir);
        this.copyClasspathResourceToFile("/solr/conf/stopwords.txt", solrConfigDir);
        this.copyClasspathResourceToFile("/solr/conf/synonyms.txt", solrConfigDir);
        File solrDataDir = new File(solrRoot, "data");
        if (!solrDataDir.exists()) {
            FileUtils.forceMkdir((File)solrDataDir);
        }
        if ((solrIndexDir = new File(solrDataDir, "index")).isDirectory() && solrIndexDir.list().length == 0) {
            FileUtils.deleteDirectory((File)solrIndexDir);
        }
        this.solrServer = SolrServerFactory.newEmbeddedInstance((File)solrRoot, (File)solrDataDir);
    }

    @Deactivate
    public void deactivate() {
        SolrServerFactory.shutdown((SolrServer)this.solrServer);
    }

    private void copyClasspathResourceToFile(String classpath, File dir) {
        InputStream in = null;
        FileOutputStream fos = null;
        try {
            in = WorkflowServiceSolrIndex.class.getResourceAsStream(classpath);
            File file = new File(dir, FilenameUtils.getName((String)classpath));
            logger.debug("copying " + classpath + " to " + file);
            fos = new FileOutputStream(file);
            IOUtils.copy((InputStream)in, (OutputStream)fos);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Error copying solr classpath resource to the filesystem", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(final WorkflowInstance instance) throws WorkflowDatabaseException {
        block6: {
            if (this.synchronousIndexing) {
                try {
                    SolrInputDocument doc = this.createDocument(instance);
                    SolrServer solrServer = this.solrServer;
                    synchronized (solrServer) {
                        this.solrServer.add(doc);
                        this.solrServer.commit();
                        break block6;
                    }
                }
                catch (Exception e) {
                    throw new WorkflowDatabaseException("Unable to index workflow", (Throwable)e);
                }
            }
            this.indexingExecutor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SolrInputDocument doc = WorkflowServiceSolrIndex.this.createDocument(instance);
                        SolrServer solrServer = WorkflowServiceSolrIndex.this.solrServer;
                        synchronized (solrServer) {
                            WorkflowServiceSolrIndex.this.solrServer.add(doc);
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Unable to index {}: {}", (Object)instance, (Object)e);
                    }
                }
            });
        }
    }

    protected SolrInputDocument createDocument(WorkflowInstance instance) throws Exception {
        AQueryBuilder query;
        AResult result;
        StringBuffer buf;
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField(ID_KEY, (Object)instance.getId());
        doc.addField(WORKFLOW_DEFINITION_KEY, (Object)instance.getTemplate());
        doc.addField(STATE_KEY, (Object)instance.getState().toString());
        String xml = WorkflowParser.toXml((WorkflowInstance)instance);
        doc.addField(XML_KEY, (Object)xml);
        WorkflowOperationInstance op = instance.getCurrentOperation();
        if (op == null) {
            doc.addField(OPERATION_KEY, (Object)NO_OPERATION_KEY);
        } else {
            doc.addField(OPERATION_KEY, (Object)op.getTemplate());
        }
        MediaPackage mp = instance.getMediaPackage();
        doc.addField(MEDIAPACKAGE_KEY, (Object)mp.getIdentifier().toString());
        if (mp.getSeries() != null) {
            doc.addField(SERIES_ID_KEY, (Object)mp.getSeries());
        }
        if (mp.getSeriesTitle() != null) {
            doc.addField(SERIES_TITLE_KEY, (Object)mp.getSeriesTitle());
        }
        if (mp.getDate() != null) {
            doc.addField(CREATED_KEY, (Object)mp.getDate());
        }
        if (mp.getTitle() != null) {
            doc.addField(TITLE_KEY, (Object)mp.getTitle());
        }
        if (mp.getLicense() != null) {
            doc.addField(LICENSE_KEY, (Object)mp.getLicense());
        }
        if (mp.getLanguage() != null) {
            doc.addField(LANGUAGE_KEY, (Object)mp.getLanguage());
        }
        if (mp.getContributors() != null && mp.getContributors().length > 0) {
            buf = new StringBuffer();
            for (String contributor : mp.getContributors()) {
                if (buf.length() > 0) {
                    buf.append("; ");
                }
                buf.append(contributor);
            }
            doc.addField(CONTRIBUTOR_KEY, (Object)buf.toString());
        }
        if (mp.getCreators() != null && mp.getCreators().length > 0) {
            buf = new StringBuffer();
            for (String creator : mp.getCreators()) {
                if (buf.length() > 0) {
                    buf.append("; ");
                }
                buf.append(creator);
            }
            doc.addField(CREATOR_KEY, (Object)buf.toString());
        }
        if (mp.getSubjects() != null && mp.getSubjects().length > 0) {
            buf = new StringBuffer();
            for (String subject : mp.getSubjects()) {
                if (buf.length() > 0) {
                    buf.append("; ");
                }
                buf.append(subject);
            }
            doc.addField(SUBJECT_KEY, (Object)buf.toString());
        }
        doc.addField(WORKFLOW_CREATOR_KEY, (Object)instance.getCreatorName());
        doc.addField(ORG_KEY, (Object)instance.getOrganizationId());
        MediaPackage aclMp = mp;
        if (instance.getState().isTerminated() && (result = (query = this.assetManager.createQuery()).select(new Target[]{query.snapshot()}).where(query.mediaPackageId(mp.getIdentifier().toString()).and(query.version().isLatest())).run()).getRecords().head().isSome()) {
            aclMp = ((Snapshot)((ARecord)result.getRecords().head().get()).getSnapshot().get()).getMediaPackage();
        }
        try {
            AccessControlList acl = (AccessControlList)this.authorizationService.getActiveAcl(aclMp).getA();
            this.addAuthorization(doc, acl);
        }
        catch (Exception e) {
            logger.warn("Could not find active acl for media package {}", (Object)mp, (Object)e);
        }
        return doc;
    }

    protected void addAuthorization(SolrInputDocument doc, AccessControlList acl) {
        HashMap permissions = new HashMap();
        ArrayList<String> reads = new ArrayList<String>();
        permissions.put(Permissions.Action.READ.toString(), reads);
        ArrayList<String> writes = new ArrayList<String>();
        permissions.put(Permissions.Action.WRITE.toString(), writes);
        String adminRole = this.securityService.getOrganization().getAdminRole();
        if (adminRole != null) {
            reads.add(adminRole);
            writes.add(adminRole);
        }
        for (AccessControlEntry accessControlEntry : acl.getEntries()) {
            if (!accessControlEntry.isAllow()) {
                logger.warn("Workflow service does not support denial via ACL, ignoring {}", (Object)accessControlEntry);
                continue;
            }
            ArrayList<String> actionPermissions = (ArrayList<String>)permissions.get(accessControlEntry.getAction());
            if (actionPermissions == null) {
                actionPermissions = new ArrayList<String>();
                permissions.put(accessControlEntry.getAction(), actionPermissions);
            }
            actionPermissions.add(accessControlEntry.getRole());
        }
        for (Map.Entry entry : permissions.entrySet()) {
            String fieldName = ACL_KEY_PREFIX + (String)entry.getKey();
            doc.setField(fieldName, entry.getValue());
        }
    }

    @Override
    public long countWorkflowInstances(WorkflowInstance.WorkflowState state, String operation) throws WorkflowDatabaseException {
        StringBuilder query = new StringBuilder();
        if (state != null) {
            query.append(STATE_KEY).append(":").append(ClientUtils.escapeQueryChars((String)state.toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)operation)) {
            if (query.length() > 0) {
                query.append(" AND ");
            }
            query.append(OPERATION_KEY).append(":").append(ClientUtils.escapeQueryChars((String)operation));
        }
        String orgId = this.securityService.getOrganization().getId();
        if (query.length() > 0) {
            query.append(" AND ");
        }
        query.append(ORG_KEY).append(":").append(ClientUtils.escapeQueryChars((String)orgId));
        this.appendSolrAuthFragment(query, Permissions.Action.READ.toString());
        try {
            QueryResponse response = this.solrServer.query((SolrParams)new SolrQuery(query.toString()));
            return response.getResults().getNumFound();
        }
        catch (SolrServerException e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
    }

    @Override
    public WorkflowStatistics getStatistics() throws WorkflowDatabaseException {
        long total = 0L;
        long paused = 0L;
        long failed = 0L;
        long failing = 0L;
        long instantiated = 0L;
        long running = 0L;
        long stopped = 0L;
        long succeeded = 0L;
        WorkflowStatistics stats = new WorkflowStatistics();
        try {
            String orgId = this.securityService.getOrganization().getId();
            StringBuilder queryString = new StringBuilder().append(ORG_KEY).append(":").append(ClientUtils.escapeQueryChars((String)orgId));
            this.appendSolrAuthFragment(queryString, Permissions.Action.WRITE.toString());
            SolrQuery solrQuery = new SolrQuery(queryString.toString());
            solrQuery.addFacetField(new String[]{WORKFLOW_DEFINITION_KEY});
            solrQuery.addFacetField(new String[]{OPERATION_KEY});
            solrQuery.setFacetMinCount(0);
            solrQuery.setFacet(true);
            QueryResponse response = this.solrServer.query((SolrParams)solrQuery);
            FacetField templateFacet = response.getFacetField(WORKFLOW_DEFINITION_KEY);
            FacetField operationFacet = response.getFacetField(OPERATION_KEY);
            if (templateFacet != null && templateFacet.getValues() != null) {
                for (FacetField.Count template : templateFacet.getValues()) {
                    WorkflowStatistics.WorkflowDefinitionReport templateReport = new WorkflowStatistics.WorkflowDefinitionReport();
                    templateReport.setId(template.getName());
                    long templateTotal = 0L;
                    long templatePaused = 0L;
                    long templateFailed = 0L;
                    long templateFailing = 0L;
                    long templateInstantiated = 0L;
                    long templateRunning = 0L;
                    long templateStopped = 0L;
                    long templateSucceeded = 0L;
                    if (operationFacet != null && operationFacet.getValues() != null) {
                        for (FacetField.Count operation : operationFacet.getValues()) {
                            WorkflowStatistics.WorkflowDefinitionReport.OperationReport operationReport = new WorkflowStatistics.WorkflowDefinitionReport.OperationReport();
                            operationReport.setId(operation.getName());
                            StringBuilder baseSolrQuery = new StringBuilder().append(ORG_KEY).append(":").append(ClientUtils.escapeQueryChars((String)orgId));
                            this.appendSolrAuthFragment(baseSolrQuery, Permissions.Action.WRITE.toString());
                            solrQuery = new SolrQuery(baseSolrQuery.toString());
                            solrQuery.addFacetField(new String[]{STATE_KEY});
                            solrQuery.addFacetQuery("state:" + WorkflowInstance.WorkflowState.FAILED);
                            solrQuery.addFacetQuery("state:" + WorkflowInstance.WorkflowState.FAILING);
                            solrQuery.addFacetQuery("state:" + WorkflowInstance.WorkflowState.INSTANTIATED);
                            solrQuery.addFacetQuery("state:" + WorkflowInstance.WorkflowState.PAUSED);
                            solrQuery.addFacetQuery("state:" + WorkflowInstance.WorkflowState.RUNNING);
                            solrQuery.addFacetQuery("state:" + WorkflowInstance.WorkflowState.STOPPED);
                            solrQuery.addFacetQuery("state:" + WorkflowInstance.WorkflowState.SUCCEEDED);
                            solrQuery.addFilterQuery(new String[]{"templateid:" + template.getName()});
                            solrQuery.addFilterQuery(new String[]{"operation:" + operation.getName()});
                            solrQuery.setFacetMinCount(0);
                            solrQuery.setFacet(true);
                            response = this.solrServer.query((SolrParams)solrQuery);
                            FacetField stateFacet = response.getFacetField(STATE_KEY);
                            block13: for (FacetField.Count stateValue : stateFacet.getValues()) {
                                WorkflowInstance.WorkflowState state = WorkflowInstance.WorkflowState.valueOf((String)stateValue.getName().toUpperCase());
                                templateTotal += stateValue.getCount();
                                total += stateValue.getCount();
                                switch (state) {
                                    case FAILED: {
                                        operationReport.setFailed(stateValue.getCount());
                                        templateFailed += stateValue.getCount();
                                        failed += stateValue.getCount();
                                        continue block13;
                                    }
                                    case FAILING: {
                                        operationReport.setFailing(stateValue.getCount());
                                        templateFailing += stateValue.getCount();
                                        failing += stateValue.getCount();
                                        continue block13;
                                    }
                                    case INSTANTIATED: {
                                        operationReport.setInstantiated(stateValue.getCount());
                                        templateInstantiated += stateValue.getCount();
                                        instantiated += stateValue.getCount();
                                        continue block13;
                                    }
                                    case PAUSED: {
                                        operationReport.setPaused(stateValue.getCount());
                                        templatePaused += stateValue.getCount();
                                        paused += stateValue.getCount();
                                        continue block13;
                                    }
                                    case RUNNING: {
                                        operationReport.setRunning(stateValue.getCount());
                                        templateRunning += stateValue.getCount();
                                        running += stateValue.getCount();
                                        continue block13;
                                    }
                                    case STOPPED: {
                                        operationReport.setStopped(stateValue.getCount());
                                        templateStopped += stateValue.getCount();
                                        stopped += stateValue.getCount();
                                        continue block13;
                                    }
                                    case SUCCEEDED: {
                                        operationReport.setFinished(stateValue.getCount());
                                        templateSucceeded += stateValue.getCount();
                                        succeeded += stateValue.getCount();
                                        continue block13;
                                    }
                                }
                                throw new IllegalStateException("State '" + state + "' is not handled");
                            }
                            templateReport.getOperations().add(operationReport);
                        }
                    }
                    templateReport.setTotal(templateTotal);
                    templateReport.setFailed(templateFailed);
                    templateReport.setFailing(templateFailing);
                    templateReport.setInstantiated(templateInstantiated);
                    templateReport.setPaused(templatePaused);
                    templateReport.setRunning(templateRunning);
                    templateReport.setStopped(templateStopped);
                    templateReport.setFinished(templateSucceeded);
                    stats.getDefinitions().add(templateReport);
                }
            }
        }
        catch (SolrServerException e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
        stats.setTotal(total);
        stats.setFailed(failed);
        stats.setFailing(failing);
        stats.setInstantiated(instantiated);
        stats.setPaused(paused);
        stats.setRunning(running);
        stats.setStopped(stopped);
        stats.setFinished(succeeded);
        return stats;
    }

    private StringBuilder append(StringBuilder sb, String key, String value, boolean toLowerCase) {
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)value)) {
            return sb;
        }
        if (sb.length() > 0) {
            sb.append(" AND ");
        }
        sb.append(key);
        sb.append(":");
        if (toLowerCase) {
            sb.append(ClientUtils.escapeQueryChars((String)value.toLowerCase()));
        } else {
            sb.append(ClientUtils.escapeQueryChars((String)value));
        }
        return sb;
    }

    private StringBuilder appendFuzzy(StringBuilder sb, String key, String value) {
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)value)) {
            return sb;
        }
        if (sb.length() > 0) {
            sb.append(" AND ");
        }
        sb.append("(");
        sb.append(key).append(":").append(ClientUtils.escapeQueryChars((String)value.toLowerCase()));
        sb.append(" OR ");
        sb.append(key).append(":*").append(ClientUtils.escapeQueryChars((String)value.toLowerCase())).append("*");
        sb.append(")");
        return sb;
    }

    private StringBuilder append(StringBuilder sb, String key, Date startDate, Date endDate) {
        if (StringUtils.isBlank((CharSequence)key) || startDate == null && endDate == null) {
            return sb;
        }
        if (sb.length() > 0) {
            sb.append(" AND ");
        }
        if (startDate == null) {
            startDate = new Date(0L);
        }
        if (endDate == null) {
            endDate = new Date(Long.MAX_VALUE);
        }
        sb.append(key);
        sb.append(":");
        sb.append(SolrUtils.serializeDateRange((Option)Option.option((Object)startDate), (Option)Option.option((Object)endDate)));
        return sb;
    }

    protected String createQuery(WorkflowQuery query, String action, boolean applyPermissions) throws WorkflowDatabaseException {
        String orgId = this.securityService.getOrganization().getId();
        StringBuilder sb = new StringBuilder().append(ORG_KEY).append(":").append(ClientUtils.escapeQueryChars((String)orgId));
        this.append(sb, ID_KEY, query.getId(), false);
        this.append(sb, MEDIAPACKAGE_KEY, query.getMediaPackageId(), false);
        this.append(sb, SERIES_ID_KEY, query.getSeriesId(), false);
        this.appendFuzzy(sb, SERIES_TITLE_KEY, query.getSeriesTitle());
        this.appendFuzzy(sb, FULLTEXT_KEY, query.getText());
        this.append(sb, WORKFLOW_DEFINITION_KEY, query.getWorkflowDefinitionId(), false);
        this.append(sb, CREATED_KEY, query.getFromDate(), query.getToDate());
        this.appendFuzzy(sb, CREATOR_KEY, query.getCreator());
        this.appendFuzzy(sb, CONTRIBUTOR_KEY, query.getContributor());
        this.appendFuzzy(sb, LANGUAGE_KEY, query.getLanguage());
        this.appendFuzzy(sb, LICENSE_KEY, query.getLicense());
        this.appendFuzzy(sb, TITLE_KEY, query.getTitle());
        this.appendFuzzy(sb, SUBJECT_KEY, query.getSubject());
        this.appendMap(sb, OPERATION_KEY, query.getCurrentOperations());
        this.appendMap(sb, STATE_KEY, query.getStates());
        if (applyPermissions) {
            this.appendSolrAuthFragment(sb, action);
        }
        logger.debug(sb.toString());
        return sb.toString();
    }

    protected void appendSolrAuthFragment(StringBuilder sb, String action) throws WorkflowDatabaseException {
        User user = this.securityService.getUser();
        if (!user.hasRole("ROLE_ADMIN") && !user.hasRole(user.getOrganization().getAdminRole())) {
            sb.append(" AND ").append(ORG_KEY).append(":").append(ClientUtils.escapeQueryChars((String)this.securityService.getOrganization().getId()));
            Set roles = user.getRoles();
            if (roles.size() > 0) {
                sb.append(" AND (").append(WORKFLOW_CREATOR_KEY).append(":").append(ClientUtils.escapeQueryChars((String)user.getUsername()));
                for (Role role : roles) {
                    sb.append(" OR ");
                    sb.append(ACL_KEY_PREFIX).append(action).append(":").append(ClientUtils.escapeQueryChars((String)role.getName()));
                }
                sb.append(")");
            }
        }
    }

    protected String getSortField(WorkflowQuery.Sort sort) {
        switch (sort) {
            case TITLE: {
                return TITLE_KEY;
            }
            case CONTRIBUTOR: {
                return CONTRIBUTOR_KEY;
            }
            case DATE_CREATED: {
                return CREATED_KEY;
            }
            case CREATOR: {
                return CREATOR_KEY;
            }
            case LANGUAGE: {
                return LANGUAGE_KEY;
            }
            case LICENSE: {
                return LICENSE_KEY;
            }
            case MEDIA_PACKAGE_ID: {
                return MEDIAPACKAGE_KEY;
            }
            case SERIES_ID: {
                return SERIES_ID_KEY;
            }
            case SERIES_TITLE: {
                return SERIES_TITLE_KEY;
            }
            case SUBJECT: {
                return SUBJECT_KEY;
            }
            case WORKFLOW_DEFINITION_ID: {
                return WORKFLOW_DEFINITION_KEY;
            }
        }
        throw new IllegalArgumentException("No mapping found between sort field and index");
    }

    protected StringBuilder appendMap(StringBuilder sb, String key, List<WorkflowQuery.QueryTerm> queryTerms) {
        if (queryTerms == null || queryTerms.isEmpty()) {
            return sb;
        }
        if (sb.length() > 0) {
            sb.append(" AND ");
        }
        boolean positiveTerm = false;
        sb.append("(");
        for (int i = 0; i < queryTerms.size(); ++i) {
            WorkflowQuery.QueryTerm term = queryTerms.get(i);
            if (i > 0) {
                if (term.isInclude()) {
                    sb.append(" OR ");
                } else {
                    sb.append(" AND ");
                }
            }
            if (term.isInclude()) {
                positiveTerm = true;
            } else {
                sb.append("-");
            }
            sb.append(key);
            sb.append(":");
            sb.append(ClientUtils.escapeQueryChars((String)term.getValue().toLowerCase()));
        }
        if (!positiveTerm) {
            sb.append(" AND *:*");
        }
        sb.append(")");
        return sb;
    }

    /*
     * Exception decompiling
     */
    @Override
    public WorkflowSet getWorkflowInstances(WorkflowQuery query, String action, boolean applyPermissions) throws WorkflowDatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(long id) throws WorkflowDatabaseException, NotFoundException {
        try {
            SolrServer solrServer = this.solrServer;
            synchronized (solrServer) {
                this.solrServer.deleteById(Long.toString(id));
                this.solrServer.commit();
            }
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
    }

    @Override
    public void update(WorkflowInstance instance) throws WorkflowDatabaseException {
        this.index(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws WorkflowDatabaseException {
        try {
            SolrServer solrServer = this.solrServer;
            synchronized (solrServer) {
                this.solrServer.deleteByQuery("*:*");
                this.solrServer.commit();
            }
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
    }

    @Reference(name="serviceregistry")
    protected void setServiceRegistry(ServiceRegistry registry) {
        this.serviceRegistry = registry;
    }

    @Reference(name="orgDirectory")
    protected void setOrgDirectory(OrganizationDirectoryService orgDirectory) {
        this.orgDirectory = orgDirectory;
    }

    @Reference(name="authorization")
    protected void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Reference(name="security")
    protected void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference(name="assetManager")
    protected void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }
}

