/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.impl.jmx;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import org.opencastproject.util.jmx.JmxUtil;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowStatistics;
import org.opencastproject.workflow.impl.jmx.WorkflowsStatisticsMXBean;

public class WorkflowsStatistics
extends NotificationBroadcasterSupport
implements WorkflowsStatisticsMXBean {
    private static final String DELIMITER = ";";
    private long sequenceNumber = 1L;
    private Map<String, Long> workflowCounts = new HashMap<String, Long>();
    private WorkflowStatistics workflowStatistics;

    public WorkflowsStatistics(WorkflowStatistics workflowStatistics, List<WorkflowInstance> workflows) {
        this.updateWorkflow(workflowStatistics, workflows);
    }

    public void updateWorkflow(WorkflowStatistics workflowStatistics, List<WorkflowInstance> workflows) {
        this.workflowStatistics = workflowStatistics;
        for (WorkflowInstance wf : workflows) {
            Long count = this.workflowCounts.get(wf.getTemplate());
            if (count == null) {
                this.workflowCounts.put(wf.getTemplate(), 1L);
                continue;
            }
            Long l = count;
            Long l2 = count = Long.valueOf(count + 1L);
            this.workflowCounts.put(wf.getTemplate(), l);
        }
        this.sendNotification(JmxUtil.createUpdateNotification((Object)this, (long)this.sequenceNumber++, (String)"Workflow updated"));
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"org.opencastproject.update"};
        String name = Notification.class.getName();
        String description = "An update was executed";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, name, description);
        return new MBeanNotificationInfo[]{info};
    }

    @Override
    public int getTotal() {
        return (int)this.workflowStatistics.getTotal();
    }

    @Override
    public int getInstantiated() {
        return (int)this.workflowStatistics.getInstantiated();
    }

    @Override
    public int getRunning() {
        return (int)this.workflowStatistics.getRunning();
    }

    @Override
    public int getOnHold() {
        return (int)this.workflowStatistics.getPaused();
    }

    @Override
    public int getStopped() {
        return (int)this.workflowStatistics.getStopped();
    }

    @Override
    public int getFinished() {
        return (int)this.workflowStatistics.getFinished();
    }

    @Override
    public int getFailing() {
        return (int)this.workflowStatistics.getFailing();
    }

    @Override
    public int getFailed() {
        return (int)this.workflowStatistics.getFailed();
    }

    @Override
    public String[] getWorkflowsOnHold() {
        ArrayList<CallSite> operationList = new ArrayList<CallSite>();
        for (Map.Entry<String, Long> entry : this.workflowCounts.entrySet()) {
            operationList.add((CallSite)((Object)(entry.getKey() + DELIMITER + entry.getValue())));
        }
        return operationList.toArray(new String[operationList.size()]);
    }

    @Override
    public String[] getAverageWorkflowProcessingTime() {
        return new String[0];
    }

    @Override
    public String[] getAverageWorkflowQueueTime() {
        return new String[0];
    }

    @Override
    public String[] getAverageWorkflowHoldTime() {
        return new String[0];
    }
}

