/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.Fraction;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.VideoStream;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.mediapackage.track.TrackImpl;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Analyze Tracks Operation Handler", "workflow.operation=analyze-tracks"})
public class AnalyzeTracksWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    static final String OPT_SOURCE_FLAVOR = "source-flavor";
    static final String OPT_VIDEO_ASPECT = "aspect-ratio";
    static final String OPT_FAIL_NO_TRACK = "fail-no-track";
    private static final Logger logger = LoggerFactory.getLogger(AnalyzeTracksWorkflowOperationHandler.class);

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.info("Running analyze-tracks workflow operation on workflow {}", (Object)workflowInstance.getId());
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        HashMap<CallSite, String> properties = new HashMap<CallSite, String>();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.one, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none);
        MediaPackageElementFlavor singleSourceFlavor = tagsAndFlavors.getSingleSrcFlavor();
        TrackSelector trackSelector = new TrackSelector();
        trackSelector.addFlavor(singleSourceFlavor);
        Collection tracks = trackSelector.select(mediaPackage, false);
        if (tracks.size() <= 0) {
            if (BooleanUtils.toBoolean((String)this.getConfig(workflowInstance, OPT_FAIL_NO_TRACK, "false"))) {
                throw new WorkflowOperationException("No matching tracks for flavor " + singleSourceFlavor.toString());
            }
            logger.info("No tracks with specified flavors ({}) to analyse.", (Object)singleSourceFlavor.toString());
            return this.createResult(mediaPackage, properties, WorkflowOperationResult.Action.CONTINUE, 0L);
        }
        List<Fraction> aspectRatios = this.getAspectRatio(this.getConfig(workflowInstance, OPT_VIDEO_ASPECT, ""));
        for (Track track : tracks) {
            String varName = AnalyzeTracksWorkflowOperationHandler.toVariableName(track.getFlavor());
            properties.put((CallSite)((Object)(varName + "_media")), "true");
            properties.put((CallSite)((Object)(varName + "_video")), Boolean.toString(track.hasVideo()));
            properties.put((CallSite)((Object)(varName + "_audio")), Boolean.toString(track.hasAudio()));
            properties.put((CallSite)((Object)(varName + "_subtitle")), Boolean.toString(track.hasSubtitle()));
            if (!track.hasVideo()) continue;
            for (VideoStream video : ((TrackImpl)track).getVideo()) {
                properties.put((CallSite)((Object)(varName + "_resolution_x")), video.getFrameWidth().toString());
                properties.put((CallSite)((Object)(varName + "_resolution_y")), video.getFrameHeight().toString());
                Fraction trackAspect = Fraction.getReducedFraction((int)video.getFrameWidth(), (int)video.getFrameHeight());
                properties.put((CallSite)((Object)(varName + "_aspect")), trackAspect.toString());
                properties.put((CallSite)((Object)(varName + "_framerate")), video.getFrameRate().toString());
                if (aspectRatios.isEmpty()) continue;
                trackAspect = this.getNearestAspectRatio(trackAspect, aspectRatios);
                properties.put((CallSite)((Object)(varName + "_aspect_snap")), trackAspect.toString());
            }
        }
        logger.info("Finished analyze-tracks workflow operation adding the properties: {}", properties);
        return this.createResult(mediaPackage, properties, WorkflowOperationResult.Action.CONTINUE, 0L);
    }

    Fraction getNearestAspectRatio(Fraction videoAspect, List<Fraction> aspects) {
        Fraction nearestAspect = aspects.get(0);
        for (Fraction aspect : aspects) {
            if (videoAspect.subtract(nearestAspect).abs().compareTo(videoAspect.subtract(aspect).abs()) <= 0) continue;
            nearestAspect = aspect;
        }
        return nearestAspect;
    }

    List<Fraction> getAspectRatio(String aspectConfig) {
        ArrayList<Fraction> aspectRatios = new ArrayList<Fraction>();
        for (String aspect : aspectConfig.split(" *, *")) {
            if (!StringUtils.isNotBlank((CharSequence)aspect)) continue;
            aspectRatios.add(Fraction.getFraction((String)aspect).reduce());
        }
        return aspectRatios;
    }

    private static String toVariableName(MediaPackageElementFlavor flavor) {
        return flavor.getType() + "_" + flavor.getSubtype();
    }
}

