/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.util.stream.Collectors;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.conditionparser.WorkflowConditionInterpreter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Assertion Workflow Operation Handler", "workflow.operation=assert"})
public class AssertWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(AssertWorkflowOperationHandler.class);
    public static final String THAT_PREFIX = "that-";
    public static final String TRUE_PREFIX = "true-";
    public static final String FALSE_PREFIX = "false-";

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
        for (String key : currentOperation.getConfigurationKeys().stream().filter(x -> x.startsWith(THAT_PREFIX) || x.startsWith(TRUE_PREFIX) || x.startsWith(FALSE_PREFIX)).sorted().collect(Collectors.toList())) {
            String assertion = currentOperation.getConfiguration(key);
            boolean result = false;
            try {
                result = WorkflowConditionInterpreter.interpret((String)assertion.trim());
                logger.debug("Evaluate assertion {}: {}, result: {}", new Object[]{key, assertion, result});
            }
            catch (IllegalArgumentException e) {
                logger.error("Invalid assertion {}: {}", (Object)key, (Object)assertion);
                throw new WorkflowOperationException(String.format("Invalid assertion %s: %s", key, assertion), (Throwable)e);
            }
            boolean expectedResult = !key.startsWith(FALSE_PREFIX);
            if (result == expectedResult) continue;
            logger.error("Assertion {} [{}] failed.", (Object)key, (Object)assertion);
            currentOperation.setState(WorkflowOperationInstance.OperationState.FAILED);
            throw new WorkflowOperationException(String.format("Assertion %s [%s] failed.", key, assertion));
        }
        return this.createResult(WorkflowOperationResult.Action.CONTINUE);
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

