/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageSupport;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.handler.workflow.CloneWorkflowOperationHandler;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Change Type Workflow Operation Handler", "workflow.operation=changetype"})
public class ChangeTypeWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(CloneWorkflowOperationHandler.class);
    public static final String OPT_SOURCE_FLAVOR = "source-flavors";
    public static final String OPT_SOURCE_TAGS = "source-tags";
    public static final String OPT_TARGET_FLAVOR = "target-flavor";
    public static final String TARGET_TYPE = "target-type";

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running change type workflow operation on workflow {}", (Object)workflowInstance.getId());
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.one);
        List sourceTagsOption = tagsAndFlavors.getSrcTags();
        List sourceFlavorOptionList = tagsAndFlavors.getSrcFlavors();
        String targetFlavorOption = StringUtils.trimToNull((String)currentOperation.getConfiguration(OPT_TARGET_FLAVOR));
        String targetTypeOption = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(TARGET_TYPE));
        MediaPackageElement.Type type = null;
        if (!targetTypeOption.isEmpty()) {
            for (MediaPackageElement.Type t : MediaPackageElement.Type.values()) {
                if (!t.name().equalsIgnoreCase(targetTypeOption)) continue;
                type = t;
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("The given type '%s' for mediapackage %s was illegal. Pleasecheck the operations' configuration keys.", type, mediaPackage.getIdentifier()));
            }
        } else {
            throw new IllegalArgumentException(String.format("The given type '%s' for mediapackage %s was illegal. Pleasecheck the operations' configuration keys.", type, mediaPackage.getIdentifier()));
        }
        SimpleElementSelector elementSelector = new SimpleElementSelector();
        if (sourceTagsOption.isEmpty() && sourceFlavorOptionList.isEmpty()) {
            logger.info("No source tags or flavors have been specified, not matching anything. Operation will be skipped.");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        for (MediaPackageElementFlavor sourceFlavor : sourceFlavorOptionList) {
            elementSelector.addFlavor(sourceFlavor);
        }
        if (sourceFlavorOptionList.isEmpty()) {
            elementSelector.addFlavor(new MediaPackageElementFlavor("*", "*"));
        }
        for (String tag : sourceTagsOption) {
            elementSelector.addTag(tag);
        }
        Collection elements = elementSelector.select(mediaPackage, true);
        if (elements.size() == 0) {
            logger.debug("No matching elements found, skipping operation.");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        logger.debug("Copy" + elements.size() + " elements to new flavor: {}", (Object)targetFlavorOption);
        MediaPackageElementFlavor targetFlavor = MediaPackageElementFlavor.parseFlavor((String)targetFlavorOption);
        for (MediaPackageElement element : elements) {
            MediaPackageElementFlavor flavor = targetFlavor.applyTo(element.getFlavor());
            MediaPackageElementBuilder mpeBuilder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
            MediaPackageElement newElement = mpeBuilder.newElement(type, flavor);
            newElement.setIdentifier(element.getIdentifier());
            newElement.setURI(element.getURI());
            newElement.setElementDescription(element.getElementDescription());
            newElement.setMimeType(element.getMimeType());
            newElement.setReference(element.getReference());
            newElement.setSize(element.getSize());
            newElement.setChecksum(element.getChecksum());
            for (String tag : element.getTags()) {
                newElement.addTag(tag);
            }
            MediaPackageSupport.updateElement((MediaPackage)mediaPackage, (MediaPackageElement)newElement);
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

