/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.security.api.TrustedHttpClientException;
import org.opencastproject.serviceregistry.api.ServiceRegistration;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Cleanup Workflow Operation Handler", "workflow.operation=cleanup"})
public class CleanupWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(CleanupWorkflowOperationHandler.class);
    public static final String PRESERVE_FLAVOR_PROPERTY = "preserve-flavors";
    public static final String DELETE_EXTERNAL = "delete-external";
    public static final String DELAY = "delay";
    protected Workspace workspace;
    protected TrustedHttpClient client = null;

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient client) {
        this.client = client;
    }

    public void cleanUpJobArgument(WorkflowInstance workflowInstance) {
        List operationInstances = workflowInstance.getOperations();
        for (WorkflowOperationInstance operationInstance : operationInstances) {
            logger.debug("Delete job arguments for jobs related to workflow operation {}", (Object)operationInstance.getId());
            Long operationInstanceId = null;
            try {
                operationInstanceId = operationInstance.getId();
                if (operationInstanceId == null) continue;
                Job operationInstanceJob = this.serviceRegistry.getJob(operationInstanceId.longValue());
                operationInstanceJob.setArguments(Collections.emptyList());
                this.serviceRegistry.updateJob(operationInstanceJob);
                List jobs = this.serviceRegistry.getChildJobs(operationInstanceId.longValue());
                for (Job job : jobs) {
                    if (job.getStatus() != Job.Status.FINISHED) continue;
                    logger.debug("Deleting job arguments: {}", (Object)job.getArguments());
                    job.setArguments(Collections.emptyList());
                    this.serviceRegistry.updateJob(job);
                }
            }
            catch (ServiceRegistryException | NotFoundException ex) {
                logger.error("Deleting job arguments failed for job {}", (Object)operationInstanceId, (Object)ex);
            }
        }
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        this.cleanUpJobArgument(workflowInstance);
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
        String flavors = currentOperation.getConfiguration(PRESERVE_FLAVOR_PROPERTY);
        ArrayList<MediaPackageElementFlavor> flavorsToPreserve = new ArrayList<MediaPackageElementFlavor>();
        boolean deleteExternal = BooleanUtils.toBoolean((String)currentOperation.getConfiguration(DELETE_EXTERNAL));
        String delayStr = currentOperation.getConfiguration(DELAY);
        int delay = 1;
        if (delayStr != null) {
            try {
                delay = Integer.parseInt(delayStr);
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid value '{}' for delay in workflow operation configuration (should be integer)", (Object)delayStr);
            }
        }
        if (delay > 0) {
            try {
                logger.debug("Sleeping {}s before removing workflow files", (Object)delay);
                Thread.sleep((long)delay * 1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        for (MediaPackageElement[] flavor : this.asList(flavors)) {
            flavorsToPreserve.add(MediaPackageElementFlavor.parseFlavor((String)flavor));
        }
        ArrayList<MediaPackageElement> elementsToRemove = new ArrayList<MediaPackageElement>();
        for (MediaPackageElement element : mediaPackage.getElements()) {
            if (element.getURI() == null || this.isPreserved(element, flavorsToPreserve)) continue;
            elementsToRemove.add(element);
        }
        List<String> externalBaseUrls = null;
        if (deleteExternal) {
            externalBaseUrls = this.getAllWorkingFileRepositoryUrls();
            externalBaseUrls.remove(this.workspace.getBaseUri().toString());
        }
        for (MediaPackageElement elementToRemove : elementsToRemove) {
            if (deleteExternal) {
                for (String repository : externalBaseUrls) {
                    logger.debug("Removing {} from repository {}", (Object)elementToRemove.getURI(), (Object)repository);
                    try {
                        this.removeElementFromRepository(elementToRemove, repository);
                    }
                    catch (TrustedHttpClientException ex) {
                        logger.debug("Removing media package element {} from repository {} failed: {}", new Object[]{elementToRemove.getURI(), repository, ex.getMessage()});
                    }
                }
            }
            logger.debug("Removing {} from the workspace", (Object)elementToRemove.getURI());
            try {
                mediaPackage.remove(elementToRemove);
                this.workspace.delete(elementToRemove.getURI());
            }
            catch (NotFoundException ex) {
                logger.debug("Workspace doesn't contain element with Id '{}' from media package '{}': {}", new Object[]{elementToRemove.getIdentifier(), mediaPackage.getIdentifier().toString(), ex.getMessage()});
            }
            catch (IOException ex) {
                logger.warn("Unable to remove element with Id '{}' from the media package '{}': {}", new Object[]{elementToRemove.getIdentifier(), mediaPackage.getIdentifier().toString(), ex.getMessage()});
            }
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    private boolean isPreserved(MediaPackageElement element, List<MediaPackageElementFlavor> flavorsToPreserve) {
        if (MediaPackageElement.Type.Publication == element.getElementType()) {
            return true;
        }
        for (MediaPackageElementFlavor flavor : flavorsToPreserve) {
            if (!flavor.matches(element.getFlavor())) continue;
            return true;
        }
        return false;
    }

    private List<String> getAllWorkingFileRepositoryUrls() {
        ArrayList<String> wfrBaseUrls = new ArrayList<String>();
        try {
            for (ServiceRegistration reg : this.serviceRegistry.getServiceRegistrationsByType("org.opencastproject.files")) {
                wfrBaseUrls.add(UrlSupport.concat((String)reg.getHost(), (String)reg.getPath()));
            }
        }
        catch (ServiceRegistryException e) {
            logger.warn("Unable to load services of type {} from service registry: {}", (Object)"org.opencastproject.files", (Object)e.getMessage());
        }
        return wfrBaseUrls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeElementFromRepository(MediaPackageElement elementToRemove, String repositoryBaseUrl) throws TrustedHttpClientException {
        String deleteUri;
        if (elementToRemove == null || elementToRemove.getURI() == null || StringUtils.isBlank((CharSequence)repositoryBaseUrl)) {
            return;
        }
        String elementUri = elementToRemove.getURI().toString();
        if (StringUtils.containsIgnoreCase((CharSequence)elementUri, (CharSequence)UrlSupport.concat((String[])new String[]{"/mediapackage/", elementToRemove.getMediaPackage().getIdentifier().toString(), elementToRemove.getIdentifier()}))) {
            deleteUri = UrlSupport.concat((String[])new String[]{repositoryBaseUrl, "/mediapackage/", elementToRemove.getMediaPackage().getIdentifier().toString(), elementToRemove.getIdentifier()});
        } else if (StringUtils.containsIgnoreCase((CharSequence)elementUri, (CharSequence)"/collection/")) {
            deleteUri = UrlSupport.concat((String[])new String[]{repositoryBaseUrl, "/collection/", StringUtils.substringAfter((String)elementToRemove.getURI().getPath(), (String)"/collection/")});
        } else {
            logger.info("Unable to handle URI {} for deletion from repository {}", (Object)elementUri, (Object)repositoryBaseUrl);
            return;
        }
        HttpDelete delete = new HttpDelete(deleteUri);
        HttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)delete);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 204 || statusCode == 200) {
                logger.info("Successfully deleted external URI {}", (Object)delete.getURI());
            } else if (statusCode == 404) {
                logger.info("External URI {} has already been deleted", (Object)delete.getURI());
            } else {
                logger.info("Unable to delete external URI {}, status code '{}' returned", (Object)delete.getURI(), (Object)statusCode);
            }
        }
        finally {
            try {
                this.client.close(response);
            }
            catch (IOException iOException) {}
        }
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

