/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import com.entwinemedia.fn.Fn2;
import com.entwinemedia.fn.Stream;
import java.util.HashMap;
import java.util.Map;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.api.WorkflowService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Include Operation Handler", "workflow.operation=include"})
public final class IncludeWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(IncludeWorkflowOperationHandler.class);
    public static final String WORKFLOW_CFG = "workflow-id";
    private WorkflowService workflowService = null;

    @Activate
    public void activate(ComponentContext componentContext) {
        super.activate(componentContext);
    }

    public WorkflowOperationResult start(final WorkflowInstance wi, JobContext context) throws WorkflowOperationException {
        String workflowDefinitionId = this.getConfig(wi, WORKFLOW_CFG);
        this.insertWorkflow(wi, workflowDefinitionId);
        Map props = (Map)Stream.$((Iterable)wi.getConfigurationKeys()).foldl(new HashMap(), (Fn2)new Fn2<HashMap<String, String>, String, HashMap<String, String>>(){

            public HashMap<String, String> apply(HashMap<String, String> sum, String key) {
                sum.put(key, wi.getConfiguration(key));
                return sum;
            }
        });
        return this.createResult(wi.getMediaPackage(), props, WorkflowOperationResult.Action.CONTINUE, 0L);
    }

    public void insertWorkflow(WorkflowInstance wi, String workflowDefinitionId) throws WorkflowOperationException {
        try {
            WorkflowDefinition definition = this.workflowService.getWorkflowDefinitionById(workflowDefinitionId);
            if (definition != null) {
                logger.info("Insert workflow {} into the current workflow instance", (Object)workflowDefinitionId);
                wi.insert(definition, wi.getCurrentOperation());
            } else {
                logger.warn("Workflow definition {} cannot be found", (Object)workflowDefinitionId);
            }
        }
        catch (Exception e) {
            throw new WorkflowOperationException("Error inserting workflow " + workflowDefinitionId, (Throwable)e);
        }
    }

    @Reference
    public void setWorkflowService(WorkflowService service) {
        this.workflowService = service;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

