/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.selector.AttachmentSelector;
import org.opencastproject.mediapackage.selector.CatalogSelector;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=move publication elements to workspace", "workflow.operation=publication-channel-to-workspace"})
public class PublicationChannelToWorkspace
extends AbstractWorkflowOperationHandler {
    static final String OPT_SOURCE_PUBLICATION_CHANNEL = "source-channel";
    private static final Logger logger = LoggerFactory.getLogger(PublicationChannelToWorkspace.class);

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.info("Copying artifacts from published media package {} to workspace", (Object)workflowInstance.getId());
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many);
        List configuredSourceFlavors = tagsAndFlavors.getSrcFlavors();
        List configuredSourceTags = tagsAndFlavors.getSrcTags();
        List configuredTargetTags = tagsAndFlavors.getTargetTags();
        String publicationChannel = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(OPT_SOURCE_PUBLICATION_CHANNEL));
        if (publicationChannel.isEmpty()) {
            logger.error("No source publication-channel set.");
            throw new WorkflowOperationException("No source Publication channel set.");
        }
        Optional<Publication> publication = Arrays.stream(mediaPackage.getPublications()).filter(channel -> channel.getChannel().equals(publicationChannel)).findFirst();
        if (publication.isEmpty()) {
            logger.warn("The media package '{}' contains no publications on channel '{}', skipping.", (Object)mediaPackage.getIdentifier(), (Object)publicationChannel);
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        TrackSelector trackSelector = new TrackSelector();
        for (MediaPackageElementFlavor flavor : configuredSourceFlavors) {
            trackSelector.addFlavor(flavor);
        }
        for (String tag : configuredSourceTags) {
            trackSelector.addTag(tag);
        }
        Collection tracks = trackSelector.select(mediaPackage, publicationChannel, false);
        if (!configuredTargetTags.isEmpty()) {
            tracks.forEach(track -> configuredTargetTags.forEach(targetTag -> track.addTag(targetTag.toString())));
        }
        tracks.forEach(arg_0 -> ((MediaPackage)mediaPackage).add(arg_0));
        AttachmentSelector attachmentSelector = new AttachmentSelector();
        for (MediaPackageElementFlavor flavor : configuredSourceFlavors) {
            attachmentSelector.addFlavor(flavor);
        }
        for (String tag : configuredSourceTags) {
            attachmentSelector.addTag(tag);
        }
        Collection attachments = attachmentSelector.select(mediaPackage, publicationChannel, false);
        if (!configuredTargetTags.isEmpty()) {
            attachments.forEach(attachment -> configuredTargetTags.forEach(targetTag -> attachment.addTag(targetTag.toString())));
        }
        attachments.forEach(arg_0 -> ((MediaPackage)mediaPackage).add(arg_0));
        CatalogSelector catalogSelector = new CatalogSelector();
        for (MediaPackageElementFlavor flavor : configuredSourceFlavors) {
            catalogSelector.addFlavor(flavor);
        }
        for (String tag : configuredSourceTags) {
            catalogSelector.addTag(tag);
        }
        Collection catalogs = catalogSelector.select(mediaPackage, publicationChannel, false);
        if (!configuredTargetTags.isEmpty()) {
            catalogs.forEach(catalog -> configuredTargetTags.forEach(targetTag -> catalog.addTag(targetTag.toString())));
        }
        catalogs.forEach(arg_0 -> ((MediaPackage)mediaPackage).add(arg_0));
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, 0L);
    }
}

